/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.oma;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Event;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.IdentityGroup;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SyncStep;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.net.crypto.SealedString;
import com.sas.scheduler.api.deployjob.DataStepProgramDeployer;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedFlow;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.EventListItem;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.oma.TimeEvent;
import com.sas.scheduler.api.oma.TriggerEvent;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.SchedulerIMPL;
import com.sas.scheduler.model.DateList;
import com.sas.scheduler.model.FlowHistory;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.IRecurrenceInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.InvalidCredentialsException;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.CurrentPackage.NoContext;

public class BatchJob {
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(BatchJob.class);
    private static JobFactory m_JobFactory = new BatchJobFactory();
    private DeployedJob m_dJob;
    private DeployedFlow m_dFlow;
    private String m_deployDir = null;
    private Tree m_folder;
    private Scheduler m_scheduler;
    private boolean m_ValidJob;
    private boolean m_IsComplex;
    public static final int Job_Success = 0;
    public static final int Job_Already_Created = 1;
    public static final int Job_Missing_BatchServerComponent = 2;
    public static final int Job_Invalid_State = 3;
    public static final int Job_Missing_Credentials = 4;
    public static final int Job_Scheduler_Login_Failed = 5;
    public static final int Job_Scheduler_Connection_Failed = 6;
    public static final int Job_Cannot_DeployJob = 8;
    public static final int Job_Missing_SchedulerServerComponent = 9;
    public static final int Job_Cannot_Make_Job = 11;
    public static final int Job_No_ExistingJob = 12;
    public static final int Job_Schedule_Failed = 13;
    public static final int Job_Cannot_DeployFlow = 14;
    public static final int Job_Cannot_Add_TimeEvent = 15;
    public static final int Job_Missing_Transformation = 16;
    public static final int Job_Flow_Does_Not_Exist = 18;
    public static final int Job_Scheduled = 19;
    public static final int Job_Not_Scheduled = 20;
    public static final int Job_Missing_Name = 21;
    public static final int Job_Already_Exists = 22;
    public static final int Job_Flow_Already_Exists = 23;
    public static final int Job_Missing_SchedulerInfo = 24;
    public static final int Job_Cannot_Remove_Job_From_Flow = 25;
    public static final int Job_Cannot_Delete_Job = 26;
    public static final int Job_Cannot_Delete_Flow = 27;
    public static final int Job_Not_Authenticated = 29;
    public static final int Job_Schedule_Remove_Failed = 30;
    public static final int Job_Missing_TimeEvent = 31;
    public static final int Job_Incompatible_SchedulerServerComponent = 32;
    public static final int Job_Unable_To_Create_JCL = 33;
    public static final String BRIDGE_JOB_TRANSFORM_ROLE = "SCHEDULER_BRIDGE_JOB";

    public BatchJob() {
        this.m_dJob = null;
        this.m_dFlow = null;
        this.m_scheduler = null;
        this.m_ValidJob = false;
        this.m_IsComplex = false;
    }

    public BatchJob(String ID, MdStore store, String repos) throws MdException, RemoteException {
        this(ID, (MdObjectStore)store, repos);
    }

    public BatchJob(String filename, MdFactory factory, String reposid, ServerComponent batchserver, ServerComponent schedulerComponent) throws RemoteException, MdException, SchedulerException {
        this(filename, factory, reposid, batchserver, schedulerComponent, (UserContextInterface)null);
    }

    public BatchJob(String filename, String host, String port, String metaUser, String metaPasswd, String reposid, String batchserverId, String schedulerComponentId) throws RemoteException, MdException, SchedulerException {
        MdFactoryImpl factory = new MdFactoryImpl();
        factory.makeOMRConnection(host, port, metaUser, metaPasswd);
        MdObjectStore store = factory.createObjectStore(null, "BatchJob");
        String repos = reposid.length() > 8 ? reposid.substring(9) : reposid;
        ServerComponent bserver = MetaUtilities.getBatchServerComponent(batchserverId, (MdStore)store, reposid);
        ServerComponent sserver = MetaUtilities.getSchedulerServer(schedulerComponentId, (MdStore)store, reposid);
        Scheduler scheduler = MetaUtilities.getSchedulingServer(sserver);
        UserContextInterface user = null;
        SessionContextInterface session = MetaUtilities.getSessionContext();
        if (session != null) {
            user = session.getUserContext();
        }
        this._setup(filename, user, store, (MdFactory)factory, repos, bserver, scheduler);
    }

    public BatchJob(String filename, MdFactory factory, String reposid, ServerComponent batchserver, ServerComponent schedulerComponent, UserContextInterface user) throws RemoteException, MdException, SchedulerException {
        MdObjectStore store = factory.createObjectStore(null, "BatchJob");
        String repos = reposid.length() > 8 ? reposid.substring(9) : reposid;
        ServerComponent mybatchserver = (ServerComponent)MetaUtilities.createDupRemoteObject((Root)batchserver, factory, store);
        ServerComponent myschedulerComponent = (ServerComponent)MetaUtilities.createDupRemoteObject((Root)schedulerComponent, factory, store);
        Scheduler scheduler = MetaUtilities.getSchedulingServer(myschedulerComponent);
        this._setup(filename, user, store, factory, repos, mybatchserver, scheduler);
    }

    public BatchJob(String filename, MdFactory factory, String reposid, ServerComponent batchserver, Scheduler scheduler, UserContextInterface user) throws RemoteException, MdException, SchedulerException {
        MdObjectStore store = factory.createObjectStore(null, "BatchJob");
        String repos = reposid.length() > 8 ? reposid.substring(9) : reposid;
        ServerComponent mybatchserver = (ServerComponent)MetaUtilities.createDupRemoteObject((Root)batchserver, factory, store);
        this._setup(filename, user, store, factory, repos, mybatchserver, scheduler);
    }

    @Deprecated
    public BatchJob(String filename, String host, String port, String metaUser, String metaPasswd, String reposid, String batchserverId, String schedulerComponentId, String userName, String password) throws RemoteException, MdException, SchedulerException {
        new BatchJob(filename, host, port, metaUser, metaPasswd, reposid, batchserverId, schedulerComponentId, userName, password != null ? new SealedString(password) : null);
    }

    public BatchJob(String filename, String host, String port, String metaUser, String metaPasswd, String reposid, String batchserverId, String schedulerComponentId, String userName, SealedString password) throws RemoteException, MdException, SchedulerException {
        MdFactoryImpl factory = new MdFactoryImpl();
        factory.makeOMRConnection(host, port, metaUser, metaPasswd);
        MdObjectStore store = factory.createObjectStore(null, "BatchJob");
        String repos = reposid.length() > 8 ? reposid.substring(9) : reposid;
        ServerComponent bserver = MetaUtilities.getBatchServerComponent(batchserverId, (MdStore)store, reposid);
        ServerComponent sserver = MetaUtilities.getSchedulerServer(schedulerComponentId, (MdStore)store, reposid);
        Scheduler scheduler = MetaUtilities.getSchedulingServer(sserver);
        this._setup2(filename, store, (MdFactory)factory, repos, bserver, scheduler, userName, password);
    }

    @Deprecated
    public BatchJob(String filename, MdFactory factory, String reposid, ServerComponent batchserver, ServerComponent schedulerComponent, String userName, String password) throws RemoteException, MdException, SchedulerException {
        new BatchJob(filename, factory, reposid, batchserver, schedulerComponent, userName, password != null ? new SealedString(password) : null);
    }

    public BatchJob(String filename, MdFactory factory, String reposid, ServerComponent batchserver, ServerComponent schedulerComponent, String userName, SealedString password) throws RemoteException, MdException, SchedulerException {
        this(filename, factory, reposid, batchserver, MetaUtilities.getSchedulingServer(schedulerComponent), userName, password);
    }

    @Deprecated
    public BatchJob(String filename, MdFactory factory, String reposid, ServerComponent batchserver, Scheduler scheduler, String userName, String password) throws RemoteException, MdException, SchedulerException {
        new BatchJob(filename, factory, reposid, batchserver, scheduler, userName, password != null ? new SealedString(password) : null);
    }

    public BatchJob(String filename, MdFactory factory, String reposid, ServerComponent batchserver, Scheduler scheduler, String userName, SealedString password) throws RemoteException, MdException, SchedulerException {
        MdObjectStore store = factory.createObjectStore(null, "BatchJob");
        String repos = reposid.length() > 8 ? reposid.substring(9) : reposid;
        this._setup2(filename, store, factory, repos, batchserver, scheduler, userName, password);
    }

    public BatchJob(String ID, MdObjectStore store, String repos) throws MdException, RemoteException {
        try {
            JFJob jfjob = MetaUtilities.getJFJob(ID, "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)store, repos);
            this.m_dFlow = new DeployedFlow(jfjob, store);
            this.m_dJob = (DeployedJob)this.m_dFlow.getJobs().get(0);
            this.m_scheduler = this.m_dFlow.getSchedulingServer();
            this.m_IsComplex = BatchJob.isComplex(this.m_dFlow);
            this.m_ValidJob = true;
        }
        catch (IndexOutOfBoundsException ex) {
            if (MetaUtilities.isDebug()) {
                ex.printStackTrace();
            }
            this.m_ValidJob = false;
        }
        catch (SchedulerException se) {
            if (MetaUtilities.isDebug()) {
                se.printStackTrace();
            }
            this.m_ValidJob = false;
        }
    }

    public BatchJob(String jobid, String host, String port, String metaUser, String metaPasswd, String reposid, String user, String passwd, String schedulerId) throws MdException, RemoteException, SchedulerException {
        MdFactoryImpl factory = new MdFactoryImpl();
        factory.makeOMRConnection(host, port, metaUser, metaPasswd);
        MdObjectStore store = factory.createObjectStore(null, "BatchJob");
        ServerComponent sserver = MetaUtilities.getSchedulerServer(schedulerId, (MdStore)store, reposid);
        Scheduler scheduler = MetaUtilities.getSchedulingServer(sserver);
        JFJob jfjob = MetaUtilities.getJFJob(jobid, "<Templates><JFJob><JobActivities/><ComputeLocations/><Properties/><Trees/><Steps/></JFJob><TransformationActivity><Steps/></TransformationActivity><SyncStep><SuccessorDependencies/><PredecessorDependencies/><TriggeredEvents/><TriggeringEvents/></SyncStep><Event><Properties/></Event><TransformationStep><Properties/><SuccessorDependencies/><PredecessorDependencies/><Transformations/></TransformationStep></Templates>", (MdStore)store, reposid);
        try {
            this.m_dFlow = new DeployedFlow(jfjob, store);
            this.m_dJob = (DeployedJob)this.m_dFlow.getJobs().get(0);
            this.m_scheduler = this.m_dFlow.getSchedulingServer();
            this.m_IsComplex = BatchJob.isComplex(this.m_dFlow);
            this.m_ValidJob = true;
        }
        catch (IndexOutOfBoundsException ex) {
            this.m_ValidJob = false;
        }
        int status = this.setSchedulerInfo(scheduler, user, passwd != null ? new SealedString(passwd) : null);
        if (status != 0) {
            throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("BatchJob.ErrorMsg.UnableToConnectToScheduler.fmt"), String.valueOf(status)), BatchJob.class, "BatchJob.ErrorMsg.UnableToConnectToScheduler.fmt", new Object[]{String.valueOf(status)});
        }
    }

    protected BatchJob(DeployedJob dJob, DeployedFlow dFlow) throws RemoteException, MdException {
        this();
        if (dJob == null) {
            return;
        }
        this.m_dJob = dJob;
        this.m_dFlow = dFlow;
        this.m_IsComplex = false;
        if (this.m_dFlow != null) {
            this.m_IsComplex = BatchJob.isComplex(dFlow);
        }
        this.m_ValidJob = true;
    }

    private void _setup(String filename, UserContextInterface user, MdObjectStore store, MdFactory factory, String repos, ServerComponent batchserver, Scheduler scheduler) throws RemoteException, MdException, SchedulerException {
        String fileName;
        this.m_IsComplex = false;
        int targetOS = CommandUtilities.getTargetOSForBatchServer(batchserver);
        char pathsep = CommandUtilities.getPathSeparator(targetOS);
        String normFilename = CommandUtilities.normalizeFullPath(filename, targetOS);
        int index = normFilename.lastIndexOf(pathsep);
        String baseName = fileName = normFilename.substring(++index);
        index = fileName.lastIndexOf(".");
        if (index != -1) {
            baseName = fileName.substring(0, index);
        }
        String name = DeployedFlow.genValidFlowName(baseName);
        Directory dir = null;
        List<Object> dirs = MetaUtilities.getDirectoriesFromBatchServer(batchserver);
        if (dirs != null && dirs.size() > 0) {
            try {
                index = normFilename.lastIndexOf(pathsep);
                String fileLoc = normFilename.substring(0, index);
                int numDirs = dirs.size();
                for (int i = 0; i < numDirs; ++i) {
                    Directory tempdir = (Directory)dirs.get(i);
                    String dirName = CommandUtilities.normalizePath(tempdir.getDirectoryName(), targetOS);
                    if (dirName.compareTo(fileLoc) != 0) continue;
                    dir = tempdir;
                    break;
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                dir = null;
            }
        }
        if (dir == null) {
            InvalidParameterException mde = new InvalidParameterException(MetaUtilities.messageString(m_bundle.getString("BatchJob.FileNotInDeploymentDir.fmt"), filename, batchserver));
            throw mde;
        }
        this.m_dJob = DataStepProgramDeployer.BuildMetaObjects(name, filename, dir, batchserver, user, factory, store, repos);
        Job job = this.m_dJob.getJobObject();
        if (job != null) {
            File fileObj = MetaUtilities.createSourceCodeObject(filename, dir, store, repos);
            fileObj.setFileName(baseName);
            if (fileName.indexOf(".") >= 0) {
                fileObj.setFileExtension(fileName.substring(fileName.lastIndexOf(46) + 1));
            }
            fileObj.getDirectories().add(dir);
        }
        if (!this.m_dJob.commitChanges()) {
            throw new SchedulerException(m_bundle.getString("BatchJob.ErrorMsg.UnableToWrite.txt"), BatchJob.class, "BatchJob.ErrorMsg.UnableToWrite.txt", null);
        }
        ArrayList<DeployedJob> jlist = new ArrayList<DeployedJob>();
        jlist.add(this.m_dJob);
        this.m_dFlow = new DeployedFlow(name, store, repos, scheduler, jlist);
        try {
            this.setFolder(MetaUtilities.getDefaultFolder(store, repos));
        }
        catch (NotFound e) {
            e.printStackTrace();
        }
        catch (NoContext e) {
            e.printStackTrace();
        }
        this.m_ValidJob = this.m_dFlow.commitChanges();
        if (user != null) {
            SealedString password;
            String domain = MetaUtilities.getDomain(scheduler.getServerComponent());
            UserIdentityInterface uId = user.getIdentityByDomain(domain != null ? domain : "");
            String userName = uId != null ? uId.getPrincipal().toString() : null;
            SealedString sealedString = password = uId != null ? new SealedString(uId.getCredential().toString()) : null;
            if (userName != null && password != null) {
                this.setSchedulerInfo(scheduler, userName, password);
            }
        }
    }

    private void _setup2(String filename, MdObjectStore store, MdFactory factory, String repos, ServerComponent batchserver, Scheduler scheduler, String userName, SealedString password) throws RemoteException, MdException, SchedulerException {
        UserContextInterface user = null;
        this._setup(filename, user, store, factory, repos, batchserver, scheduler);
        if (this.m_ValidJob) {
            int rc = this.setSchedulerInfo(scheduler, userName, password);
            if (rc != 0) {
                throw new SchedulerException(MetaUtilities.messageString(m_bundle.getString("BatchJob.ErrorMsg.UnableToConnectToScheduler.fmt"), String.valueOf(rc)), BatchJob.class, "BatchJob.ErrorMsg.UnableToConnectToScheduler.fmt", new Object[]{String.valueOf(rc)});
            }
        } else {
            throw new SchedulerException(m_bundle.getString("BatchJob.ErrorMsg.UnableToWrite.txt"), BatchJob.class, "BatchJob.ErrorMsg.UnableToWrite.txt", null);
        }
    }

    public static Transformation refreshJob(Transformation transformation) throws RemoteException, MdException {
        MdObjectStore store = (MdObjectStore)transformation.getObjectStore();
        store.refreshObjectFromServer((CMetadata)transformation, false, true);
        Job job = null;
        if (transformation instanceof Job) {
            job = (Job)transformation;
        } else {
            AssociationList aList = transformation.getSourceTransformations(true);
            for (Object o : aList) {
                Transformation t;
                if (!(o instanceof Transformation) || !(t = (Transformation)o).getTransformRole().equals(BRIDGE_JOB_TRANSFORM_ROLE)) continue;
                job = (Job)t;
                break;
            }
        }
        if (job != null) {
            AssociationList deployedJobList = job.getJFJobs(true);
            for (JFJob jfJob : deployedJobList) {
                store.refreshObjectFromServer((CMetadata)jfJob, false, true);
                for (TransformationStep step : jfJob.getSteps(true)) {
                    store.refreshObjectFromServer((CMetadata)step, false, true);
                    TransformationActivity ta = null;
                    try {
                        ta = (TransformationActivity)step.getActivities(true).get(0);
                        AssociationList list = ta.getJobs();
                        if (list.size() <= 0) continue;
                        JFJob flow = (JFJob)list.get(0);
                        store.refreshObjectFromServer((CMetadata)flow, false, true);
                        for (TransformationStep tstep : flow.getSteps()) {
                            if (!(tstep instanceof SyncStep)) continue;
                            store.refreshObjectFromServer((CMetadata)tstep, false, true);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ab) {
                    }
                }
            }
        }
        return transformation;
    }

    public String getErrorDescription(int errorCode) {
        String description = null;
        switch (errorCode) {
            case 0: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Success.txt");
                break;
            }
            case 1: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Already_Created.txt");
                break;
            }
            case 2: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Missing_BatchServerComponent.txt");
                break;
            }
            case 3: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Invalid_State.txt");
                break;
            }
            case 4: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Missing_Credentials.txt");
                break;
            }
            case 5: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Scheduler_Login_Failed.txt");
                break;
            }
            case 6: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Scheduler_Connection_Failed.txt");
                break;
            }
            case 9: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Missing_SchedulerServerComponent.txt");
                break;
            }
            case 11: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Cannot_Make_Job.txt");
                break;
            }
            case 12: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_No_ExistingJob.txt");
                break;
            }
            case 13: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Schedule_Failed.txt");
                break;
            }
            case 15: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Cannot_Add_TimeEvent.txt");
                break;
            }
            case 16: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Missing_Transformation.txt");
                break;
            }
            case 18: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Flow_Does_Not_Exist.txt");
                break;
            }
            case 19: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Scheduled.txt");
                break;
            }
            case 20: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Not_Scheduled.txt");
                break;
            }
            case 21: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Missing_Name.txt");
                break;
            }
            case 22: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Already_Exists.txt");
                break;
            }
            case 23: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Flow_Already_Exists.txt");
                break;
            }
            case 24: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Missing_SchedulerInfo.txt");
                break;
            }
            case 25: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Cannot_Remove_Job_From_Flow.txt");
                break;
            }
            case 26: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Cannot_Delete_Job.txt");
                break;
            }
            case 27: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Cannot_Delete_Flow.txt");
                break;
            }
            case 29: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Not_Authenticated.txt");
                break;
            }
            case 30: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Schedule_Remove_Failed.txt");
                break;
            }
            case 31: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Missing_TimeEvent.txt");
                break;
            }
            case 32: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Incompatible_SchedulerServerComponent.txt");
                break;
            }
            case 33: {
                description = m_bundle.getString("BatchJob.ExitcodeDescription.Job_Unable_To_Create_JCL.txt");
            }
        }
        return description;
    }

    public void refresh() throws RemoteException, MdException, SchedulerException {
        if (this.m_dJob != null) {
            this.m_dJob.refresh();
        }
        if (this.m_dFlow != null) {
            this.m_dFlow.refresh();
        }
        try {
            this.m_scheduler = this.m_dFlow != null ? this.m_dFlow.getSchedulingServer() : null;
            this.m_IsComplex = BatchJob.isComplex(this.m_dFlow);
            this.m_ValidJob = true;
        }
        catch (IndexOutOfBoundsException ex) {
            this.m_ValidJob = false;
        }
    }

    public boolean isComplex() {
        return this.m_IsComplex;
    }

    public int createJob(Transformation transformation, ServerComponent batchServerComponent, String batchJobName, String jobArgs, String hiddenJobArgs, ResponsibleParty responsibleParty) throws RemoteException, MdException {
        this.m_deployDir = MetaUtilities.getProperty((Root)batchServerComponent, "JCLDir");
        return this._createJob(transformation, batchServerComponent, batchJobName, jobArgs, hiddenJobArgs, null, responsibleParty);
    }

    public int createJob(Transformation transformation, ServerComponent batchServerComponent, String batchJobName, String jobArgs, String hiddenJobArgs, UserContextInterface user) throws RemoteException, MdException {
        return this.createJob(transformation, batchServerComponent, batchJobName, jobArgs, hiddenJobArgs, user, MetaUtilities.getProperty((Root)batchServerComponent, "JCLDir"));
    }

    public int createJob(Transformation transformation, ServerComponent batchServerComponent, String batchJobName, String jobArgs, String hiddenJobArgs, UserContextInterface user, String deployDir) throws RemoteException, MdException {
        this.m_deployDir = deployDir;
        return this._createJob(transformation, batchServerComponent, batchJobName, jobArgs, hiddenJobArgs, user, null);
    }

    private int _createJob(Transformation transformation, ServerComponent batchServerComponent, String batchJobName, String jobArgs, String hiddenJobArgs, UserContextInterface user, ResponsibleParty responsibleParty) throws RemoteException, MdException {
        if (this.m_ValidJob) {
            return 1;
        }
        if (batchServerComponent == null) {
            return 2;
        }
        if (transformation == null) {
            return 16;
        }
        if (batchJobName == null) {
            return 21;
        }
        Job job = BatchJob.makeJobFromTransformation(transformation, true);
        if (job == null) {
            return 11;
        }
        AssociationList deployedJobList = job.getJFJobs();
        for (JFJob jfJob : deployedJobList) {
            ServerComponent tempBatchServerComponent;
            if (!jfJob.getAssociatedJob().getId().equals(job.getId()) || !jfJob.getName().equals(batchJobName) || (tempBatchServerComponent = CommandUtilities.getServerComponentForJob(jfJob)) == null || !batchServerComponent.getId().equals(tempBatchServerComponent.getId())) continue;
            return 22;
        }
        String tempJobArgs = jobArgs;
        if (tempJobArgs == null) {
            tempJobArgs = "";
        }
        this.m_dJob = new DeployedJob(job, batchServerComponent, user, tempJobArgs, this.m_deployDir);
        this.m_dJob.setEncodedJobArgsProperty(hiddenJobArgs);
        this.m_dJob.getDeployedJobObject().setName(batchJobName);
        if (this.m_folder != null) {
            this.m_dJob.setFolder(this.m_folder);
        }
        if (responsibleParty != null) {
            AssociationList responsibleParties = this.m_dJob.getDeployedJobObject().getResponsibleParties();
            responsibleParties.add((Object)responsibleParty);
        }
        this.m_ValidJob = this.m_dJob.commitChangesWithNoValidation();
        if (this.m_ValidJob) {
            return 0;
        }
        return 8;
    }

    public Tree getFolder() throws RemoteException, MdException {
        if (this.m_folder != null) {
            return this.m_folder;
        }
        if (this.m_dFlow != null) {
            return this.m_dFlow.getFolder();
        }
        if (this.m_dJob != null) {
            return this.m_dJob.getFolder();
        }
        return null;
    }

    public boolean setFolder(Tree folder) throws RemoteException, MdException {
        this.m_folder = folder;
        if (this.m_dJob == null || this.m_dFlow == null) {
            return true;
        }
        if (this.m_dJob.setFolder(folder)) {
            return this.m_dFlow.setFolder(folder);
        }
        return false;
    }

    public static int findBatchJobs(Transformation transformation, ServerComponent batchServerComponent, ServerComponent schedulerServerComponent, boolean includeComplexJobs, List<BatchJob> results) throws RemoteException, MdException, SchedulerException {
        int rc = BatchJob.findBatchJobs(transformation, batchServerComponent, schedulerServerComponent != null ? schedulerServerComponent.getId() : null, includeComplexJobs, results, m_JobFactory);
        return rc;
    }

    public static int findBatchJobs(Transformation transformation, ServerComponent batchServerComponent, Scheduler schedulerServer, boolean includeComplexJobs, List<BatchJob> results) throws RemoteException, MdException, SchedulerException {
        int rc = BatchJob.findBatchJobs(transformation, batchServerComponent, schedulerServer != null ? schedulerServer.getServerComponent().getId() : null, includeComplexJobs, results, m_JobFactory);
        return rc;
    }

    public static int findBatchJobs(Transformation transformation, ServerComponent batchServerComponent, SchedulerServerInfo schedulerServer, boolean includeComplexJobs, List<BatchJob> results) throws RemoteException, MdException, SchedulerException {
        int rc = BatchJob.findBatchJobs(transformation, batchServerComponent, schedulerServer != null ? schedulerServer.getId() : null, includeComplexJobs, results, m_JobFactory);
        return rc;
    }

    public boolean isValid() {
        return this.m_ValidJob;
    }

    public String getHiddenArgValue(String argName) throws RemoteException, MdException {
        String commandLine = this.getHiddenCommandLineArgs();
        if (commandLine == null) {
            return null;
        }
        String argValue = BatchJob.getArgValue(commandLine, argName);
        return argValue;
    }

    public DeployedJob getDeployedJob() {
        return this.m_dJob;
    }

    public String getArgValue(String argName) throws RemoteException, MdException {
        String commandLine = this.getCommandLineArgs();
        if (commandLine == null) {
            return null;
        }
        String argValue = BatchJob.getArgValue(commandLine, argName);
        return argValue;
    }

    @Deprecated
    protected int privateSetSchedulerCredentials(ServerComponent schedulerComponent, String userName, String password) {
        return this.privateSetSchedulerCredentials(userName, password != null ? new SealedString(password) : null);
    }

    protected int privateSetSchedulerCredentials(ServerComponent schedulerComponent, String userName, SealedString password) {
        return this.privateSetSchedulerCredentials(userName, password);
    }

    @Deprecated
    protected int privateSetSchedulerCredentials(String userName, String password) {
        return this.privateSetSchedulerCredentials(userName, password != null ? new SealedString(password) : null);
    }

    protected int privateSetSchedulerCredentials(String userName, SealedString password) {
        if (!this.m_ValidJob) {
            return 3;
        }
        if (this.m_scheduler == null) {
            return 24;
        }
        if (userName == null || password == null) {
            return 4;
        }
        try {
            int success = this.m_scheduler.makeConnection(userName, password);
            if (success != 1) {
                return 6;
            }
        }
        catch (SchedulerException e) {
            return 5;
        }
        return 0;
    }

    public int setSchedulerInfo(SchedulerServerInfo info, MdObjectStore store, String userName, String password) throws IllegalArgumentException, RemoteException, MdException, SchedulerException {
        return this.setSchedulerInfo(MetaUtilities.getSchedulingServer(info, store), userName, password != null ? new SealedString(password) : null);
    }

    @Deprecated
    public int setSchedulerInfo(ServerComponent schedulerComponent, String userName, String password) throws IllegalArgumentException, RemoteException, MdException, SchedulerException {
        return this.setSchedulerInfo(schedulerComponent, userName, password != null ? new SealedString(password) : null);
    }

    public int setSchedulerInfo(ServerComponent schedulerComponent, String userName, SealedString password) throws IllegalArgumentException, RemoteException, MdException, SchedulerException {
        return this.setSchedulerInfo(MetaUtilities.getSchedulingServer(schedulerComponent), userName, password);
    }

    @Deprecated
    public int setSchedulerInfo(Scheduler scheduler, String userName, String password) throws IllegalArgumentException, RemoteException, MdException {
        return this.setSchedulerInfo(scheduler, userName, password != null ? new SealedString(password) : null);
    }

    public int setSchedulerInfo(Scheduler scheduler, String userName, SealedString password) throws IllegalArgumentException, RemoteException, MdException {
        if (!this.m_ValidJob) {
            return 3;
        }
        if (userName == null || password == null) {
            return 4;
        }
        if (scheduler == null) {
            return 9;
        }
        if (this.m_dFlow != null) {
            Scheduler currentScheduler = this.m_dFlow.getSchedulingServer();
            if (currentScheduler == null) {
                this.m_dFlow.setScheduleServer(scheduler);
                if (!this.m_dFlow.commitChangesWithNoValidation()) {
                    return 14;
                }
            } else if (!scheduler.getServerComponent().getId().equals(currentScheduler.getServerComponent().getId())) {
                return 32;
            }
        }
        this.m_scheduler = scheduler;
        return this.privateSetSchedulerCredentials(userName, password);
    }

    public int setSchedulerInfo(Scheduler scheduler) throws IllegalArgumentException, RemoteException, MdException {
        if (!this.m_ValidJob) {
            return 3;
        }
        if (scheduler == null) {
            return 24;
        }
        if (!scheduler.isConnected()) {
            return 29;
        }
        if (scheduler.getServerComponent() == null) {
            return 9;
        }
        if (this.m_dFlow != null) {
            ServerComponent currentComponent = this.m_dFlow.getSchedulerComponent();
            if (!scheduler.getServerComponent().getId().equals(currentComponent.getId())) {
                return 32;
            }
        }
        this.m_scheduler = scheduler;
        return 0;
    }

    public int setSchedulerCredentials(String userName, String password) throws IllegalArgumentException, RemoteException, MdException {
        if (!this.m_ValidJob) {
            return 3;
        }
        if (this.m_scheduler == null) {
            return 24;
        }
        int status = 0;
        status = this.m_scheduler != null ? this.setSchedulerInfo(this.m_scheduler, userName, password != null ? new SealedString(password) : null) : 9;
        return status;
    }

    public boolean isAuthenticated() {
        boolean isAuth = this.m_scheduler != null && this.m_scheduler.isConnected();
        return isAuth;
    }

    public Scheduler getScheduler() throws SchedulerException {
        if (this.m_scheduler != null) {
            return this.m_scheduler;
        }
        if (this.m_dFlow != null) {
            return this.m_dFlow.getSchedulingServer();
        }
        return null;
    }

    public int setTimeEvent(String hours, String minutes, int duration) throws RemoteException, MdException, SchedulerException {
        GregorianCalendar date = new GregorianCalendar(Locale.getDefault());
        DateList once = new DateList();
        once.addDate((Calendar)date);
        return this.setTimeEvent((IRecurrenceInfo)once, hours, minutes, duration);
    }

    public int setTimeEventFromXML(String xml) throws RemoteException, MdException, SchedulerException {
        TimeEvent te = new TimeEvent();
        te.initFromXML(xml, this.m_scheduler);
        IRecurrenceInfo recurrence = te.getInfo().getRecurrence();
        if (recurrence != null) {
            String hours = te.getHours();
            String minutes = te.getMinutes();
            int duration = te.getDuration();
            return this.setTimeEvent(recurrence, hours, minutes, duration);
        }
        return 15;
    }

    public int setTimeEvent(String definition) throws RemoteException, MdException, SchedulerException {
        TimeEvent te = new TimeEvent();
        te.initFromDefinition(this.m_scheduler, definition);
        IRecurrenceInfo recurrence = te.getInfo().getRecurrence();
        if (recurrence != null) {
            String hours = te.getHours();
            String minutes = te.getMinutes();
            int duration = te.getDuration();
            return this.setTimeEvent(recurrence, hours, minutes, duration);
        }
        return 15;
    }

    public int setTimeEvent(IRecurrenceInfo recurrence, String hours, String minutes, int duration) throws RemoteException, MdException, SchedulerException {
        int status = this.lazyCreateFlow();
        if (status != 0) {
            return status;
        }
        status = this.checkSchedulerOperationStatus();
        if (status == 29 && (this.m_scheduler == null || this.m_scheduler.isConnectionNeededForTimeEvents()) || status != 0 && status != 29) {
            return status;
        }
        com.sas.scheduler.api.servers.Calendar cal = this.m_scheduler.getCalendar(recurrence);
        if (cal == null) {
            cal = this.m_scheduler.createCalendar(recurrence);
        }
        TimeEvent event = new TimeEvent(this.m_scheduler);
        event.setHours(hours);
        event.setMinutes(minutes);
        event.setCalendar(cal);
        event.setUser(cal.getOwner());
        event.setDuration(duration);
        event.setDescription(event.generateDefinition());
        int rc = this.removeTimeEvents();
        if (rc != 0) {
            return rc;
        }
        this.m_dFlow.setTriggerEventList(Collections.EMPTY_LIST);
        TriggerEvent createdEvent = this.m_dFlow.addTriggerTimeEvent(event);
        if (createdEvent == null) {
            return 15;
        }
        if (this.m_dFlow.commitChangesWithNoValidation()) {
            return 0;
        }
        return 14;
    }

    public int removeTimeEvents() throws RemoteException, MdException {
        int status = this.checkSchedulerOperationStatus();
        if (status != 0) {
            return status;
        }
        List<EventListItem> evList = this.m_dFlow.getEvents(this.m_dJob, true);
        for (EventListItem ev : evList) {
            Event event = ev.getEvent();
            String role = event.getEventRole();
            if (role.compareToIgnoreCase("TimeEvent") != 0) continue;
            this.m_dFlow.deleteEvent(this.m_dJob, ev);
        }
        if (this.m_dFlow.commitChangesWithNoValidation()) {
            return 0;
        }
        return 14;
    }

    public int runManually() throws RemoteException, MdException, SchedulerException {
        int status = this.lazyCreateFlow();
        if (status != 0) {
            return status;
        }
        status = this.checkSchedulerOperationStatus();
        if (status != 0) {
            return status;
        }
        TriggerEvent trigger = new TriggerEvent(this.m_scheduler, this.m_dFlow.getName(), "Manual");
        return this.scheduleHelper(trigger);
    }

    public int runRecurring() throws RemoteException, MdException, SchedulerException {
        int status = this.lazyCreateFlow();
        if (status != 0) {
            return status;
        }
        status = this.checkSchedulerOperationStatus();
        if (status != 0) {
            return status;
        }
        TriggerEvent trigger = null;
        trigger = this.m_dFlow.getTriggerEvent();
        if (trigger == null) {
            return 31;
        }
        return this.scheduleHelper(trigger);
    }

    public int runNow() throws RemoteException, MdException, SchedulerException {
        int status = this.lazyCreateFlow();
        if (status != 0) {
            return status;
        }
        status = this.checkSchedulerOperationStatus();
        if (status != 0) {
            return status;
        }
        return this.scheduleNowHelper();
    }

    public int cancelJob() throws SchedulerException {
        int status = this.checkSchedulerOperationStatus();
        if (status != 0) {
            return status;
        }
        if (this.m_scheduler.isFlowScheduled(this.m_dFlow.getInfo())) {
            if (this.m_dFlow.unschedule()) {
                this.m_scheduler = null;
                return 0;
            }
            return 30;
        }
        return 20;
    }

    /*
     * Exception decompiling
     */
    public int deleteJob() throws RemoteException, MdException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getId() throws RemoteException {
        if (this.m_dFlow != null) {
            return this.m_dFlow.getId();
        }
        return null;
    }

    public String getJobName() throws RemoteException {
        if (!this.m_ValidJob) {
            return null;
        }
        return this.m_dJob.getDeployedJobObject().getName();
    }

    public com.sas.scheduler.api.servers.FlowHistory getJobHistory() {
        if (!this.m_ValidJob) {
            return new NullHistory(-2, 4);
        }
        if (this.m_scheduler == null) {
            return new NullHistory(-2, 1);
        }
        if (!this.isAuthenticated()) {
            return new NullHistory(-2, 3);
        }
        try {
            if (this.m_dFlow != null) {
                com.sas.scheduler.api.servers.FlowHistory hist = this.m_scheduler.getFlowHistory(this.m_dFlow.getInfo());
                if (hist != null) {
                    return hist;
                }
                return new NullHistory(-1, 0);
            }
            return new NullHistory(-2, 5);
        }
        catch (SchedulerException e) {
            return new NullHistory(-2, 2);
        }
    }

    public List<?> getJobHistoryList() {
        if (this.m_ValidJob && this.m_scheduler != null && this.isAuthenticated() && this.m_dFlow != null) {
            try {
                return this.m_scheduler.getFlowHistoryList(this.m_dFlow.getInfo());
            }
            catch (SchedulerException e) {
                return new ArrayList();
            }
        }
        return new ArrayList();
    }

    public List<?> getJobHistoryList(int count) {
        if (this.m_ValidJob && this.m_scheduler != null && this.isAuthenticated() && this.m_dFlow != null) {
            try {
                return this.m_scheduler.getFlowHistoryList(this.m_dFlow.getInfo(), count);
            }
            catch (SchedulerException e) {
                return new ArrayList();
            }
        }
        return new ArrayList();
    }

    public static List<com.sas.scheduler.api.servers.FlowHistory> getJobHistoryList(List jobs, ServerComponent schedulerComponent, String schedulerUserName, String schedulerPassword, int count) throws IllegalArgumentException, SchedulerException {
        return BatchJob.getJobHistoryList(jobs, BatchJob.getScheduler(schedulerComponent, schedulerUserName, schedulerPassword), schedulerUserName, count);
    }

    public static List<com.sas.scheduler.api.servers.FlowHistory> getJobHistoryList(List<BatchJob> jobs, Scheduler scheduler, String schedulerUserName, String schedulerPassword, int count) throws IllegalArgumentException, SchedulerException {
        if (scheduler == null) {
            throw new IllegalArgumentException(m_bundle.getString("BatchJob.MissingSchedulingServerInformation.txt"));
        }
        if (scheduler.makeConnection(schedulerUserName, schedulerPassword != null ? new SealedString(schedulerPassword) : null) != 1) {
            return new ArrayList<com.sas.scheduler.api.servers.FlowHistory>();
        }
        return BatchJob.getJobHistoryList(jobs, scheduler, schedulerUserName, count);
    }

    public static List<com.sas.scheduler.api.servers.FlowHistory> getJobHistoryList(List<BatchJob> jobs, Scheduler scheduler, String schedulerUserName, int count) throws SchedulerException {
        if (scheduler == null || !scheduler.isConnected() || jobs == null) {
            return new ArrayList<com.sas.scheduler.api.servers.FlowHistory>();
        }
        ArrayList<FlowInfo> flowList = new ArrayList<FlowInfo>();
        for (BatchJob rJob : jobs) {
            DeployedFlow flow = rJob.getFlow();
            if (flow == null) continue;
            flowList.add(flow.getInfo());
        }
        return scheduler.getFlowHistoryList(schedulerUserName, flowList, count);
    }

    public List<?> getJobHistoryList(String userid, int count) {
        if (this.m_scheduler == null || !this.isAuthenticated()) {
            return new ArrayList();
        }
        try {
            return this.m_scheduler.getFlowHistoryList(userid, count);
        }
        catch (SchedulerException e) {
            return new ArrayList();
        }
    }

    public int isScheduled() throws SchedulerException {
        int status = this.checkSchedulerOperationStatus();
        if (status != 0) {
            return status;
        }
        int scheduled = 20;
        scheduled = this.m_scheduler.isFlowScheduled(this.m_dFlow.getInfo()) ? 19 : 20;
        return scheduled;
    }

    public TimeEvent getTimeEvent() throws RemoteException, MdException, SchedulerException {
        int status = this.checkSchedulerOperationStatus();
        if (status == 29 && (this.m_scheduler == null || this.m_scheduler.isConnectionNeededForTimeEvents()) || status != 0 && status != 29) {
            return null;
        }
        TriggerEvent trigger = this.m_dFlow.getTriggerEvent();
        if (trigger == null) {
            return null;
        }
        TimeEvent timeEvent = trigger.getTimeEvent();
        if (timeEvent != null) {
            timeEvent.setSchedulerInstance(this.m_scheduler);
        }
        return timeEvent;
    }

    public static Transformation findTransformationFromPath(MdStore store, String repos, String path) throws MdException, RemoteException {
        String transformPath;
        MdFactory factory = store.getFactory();
        Vector<String> pathList = BatchJob.makePathList(path);
        Iterator<String> pathListI = pathList.iterator();
        Transformation transformation = null;
        String transformName = "";
        String transformTree = "";
        String selectXML = "";
        StringBuffer buf = new StringBuffer();
        if (pathListI.hasNext()) {
            buf.append("<XMLSELECT search=\"Transformation");
            transformName = pathListI.next();
            buf.append("[@Name='");
            buf.append(transformName);
            buf.append("']");
            if (pathListI.hasNext()) {
                transformTree = pathListI.next();
                buf.append("[Trees/Tree[@Name='");
                buf.append(transformTree);
                buf.append("']");
                while (pathListI.hasNext()) {
                    String pathElement = pathListI.next();
                    buf.append("/ParentTree/Tree[@Name='");
                    buf.append(pathElement);
                    buf.append("']");
                }
                buf.append("]");
            }
            buf.append("\" />");
            selectXML = buf.toString();
        }
        int flags = 8600;
        List mdList = null;
        try {
            mdList = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Transformation", flags, selectXML);
        }
        catch (OutOfMemoryError error) {
            flags = 8584;
            mdList = factory.getOMIUtil().getMetadataObjectsSubset(store, repos, "Transformation", flags, selectXML);
        }
        Iterator mdI = mdList.iterator();
        while (mdI.hasNext() && !(transformPath = BatchJob.findPathFromTransformation(transformation = (Transformation)mdI.next())).equals(path)) {
            transformation = null;
        }
        return transformation;
    }

    public static Transformation findTransformationFromTreePath(MdObjectStore store, String repos, String treePath, boolean allowCreate) throws RemoteException, MdException {
        MdFactory factory = store.getFactory();
        Vector<String> treePathList = BatchJob.makePathList(treePath);
        Iterator<String> treePathListI = treePathList.iterator();
        Job job = null;
        Tree treeElement = null;
        String selectXML = "";
        StringBuffer buf = new StringBuffer();
        if (treePathListI.hasNext()) {
            buf.append("<XMLSELECT search=\"Tree");
            String pathElement = treePathListI.next();
            buf.append("[@Name='");
            buf.append(pathElement);
            buf.append("']");
            if (treePathListI.hasNext()) {
                pathElement = treePathListI.next();
                buf.append("[ParentTree/Tree[@Name='");
                buf.append(pathElement);
                buf.append("']");
                while (treePathListI.hasNext()) {
                    pathElement = treePathListI.next();
                    buf.append("/ParentTree/Tree[@Name='");
                    buf.append(pathElement);
                    buf.append("']");
                }
                buf.append("]");
            }
            buf.append("\" />");
            selectXML = buf.toString();
        }
        int flags = 8600;
        List mdList = null;
        try {
            mdList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "Tree", flags, selectXML);
        }
        catch (OutOfMemoryError error) {
            flags = 8584;
            mdList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "Tree", flags, selectXML);
        }
        Iterator mdI = mdList.iterator();
        if (mdI.hasNext()) {
            treeElement = (Tree)mdI.next();
        }
        if (treeElement != null) {
            job = BatchJob.makeJobFromTree(treeElement, store, allowCreate);
        }
        return job;
    }

    public static String findPathFromTransformation(Transformation transformation) throws MdException, RemoteException {
        Vector<String> pathList = BatchJob.makePathList(transformation);
        Iterator<String> pathListI = pathList.iterator();
        String path = "";
        StringBuffer buf = new StringBuffer();
        if (pathListI.hasNext()) {
            buf.append(pathListI.next());
        }
        while (pathListI.hasNext()) {
            buf.insert(0, "/");
            buf.insert(0, pathListI.next());
        }
        path = buf.toString();
        return path;
    }

    public String getCommandLineArgs() throws RemoteException, MdException {
        String args = null;
        if (this.m_ValidJob) {
            args = this.m_dJob.getJobArgs();
        }
        return args;
    }

    public String getHiddenCommandLineArgs() throws RemoteException, MdException {
        String args = null;
        if (this.m_ValidJob) {
            args = this.m_dJob.getEncodedJobArgsProperty();
        }
        return args;
    }

    public static String createUniqueName(Transformation job, String userName) throws RemoteException {
        return BatchJob.createUniqueName(job, userName, null);
    }

    public static String createUniqueName(Transformation job, String userName, Scheduler scheduler) throws RemoteException {
        int cutPosition = userName.lastIndexOf(92);
        int nameStartPos = 0;
        int nameEndPos = 0;
        if (cutPosition < 0) {
            cutPosition = userName.lastIndexOf(64);
            nameStartPos = 0;
            nameEndPos = cutPosition;
        } else {
            nameStartPos = cutPosition + 1;
            nameEndPos = userName.length();
        }
        String localUserName = userName;
        if (cutPosition >= 0) {
            localUserName = userName.substring(nameStartPos, nameEndPos);
        }
        int len = localUserName.length();
        localUserName = localUserName.substring(0, Math.min(18, len));
        String jobName = job.getName();
        len = jobName.length();
        jobName = jobName.substring(0, Math.min(30, len));
        String codeString = null;
        String seedString = localUserName + '_' + jobName + '_' + System.currentTimeMillis();
        codeString = scheduler == null ? MetaUtilities.makeValidBatchJobName(seedString) : scheduler.makeValidFlowname(seedString);
        return codeString;
    }

    public boolean setCommandLineArgs(String newArgs) throws RemoteException, MdException {
        if (!this.m_ValidJob) {
            return false;
        }
        boolean success = this.m_dJob.setJobArgs(newArgs);
        if (success) {
            return this.m_dJob.commitChangesWithNoValidation();
        }
        return success;
    }

    public boolean setHiddenCommandLineArgs(String newArgs) throws RemoteException, MdException {
        return this.setHiddenCommandLineArgs(newArgs, null);
    }

    public boolean setHiddenCommandLineArgs(String newArgs, IdentityGroup adminGroup) throws RemoteException, MdException {
        if (!this.m_ValidJob) {
            return false;
        }
        boolean success = false;
        success = adminGroup != null ? this.m_dJob.setEncodedJobArgsProperty(newArgs, adminGroup) : this.m_dJob.setEncodedJobArgsProperty(newArgs);
        if (success) {
            return this.m_dJob.commitChangesWithNoValidation();
        }
        return success;
    }

    public DeployedFlow getFlow() {
        return this.m_dFlow;
    }

    public static Scheduler getScheduler(ServerComponent schedulerComponent, String userName, String password) throws SchedulerException {
        int rc = 0;
        if (schedulerComponent == null) {
            rc = 9;
        } else {
            try {
                Scheduler scheduler = MetaUtilities.getSchedulingServer(schedulerComponent);
                if (scheduler == null) {
                    rc = 32;
                } else {
                    if (scheduler.makeConnection(userName, password != null ? new SealedString(password) : null) == 1) {
                        return scheduler;
                    }
                    rc = 6;
                }
            }
            catch (RemoteException e) {
                rc = -1;
            }
        }
        RuntimeException ex = new RuntimeException(MetaUtilities.messageString(m_bundle.getString("BatchJob.ErrorMsg.UnableToConnectToScheduler.fmt"), String.valueOf(rc)));
        ex.printStackTrace();
        return null;
    }

    protected static int findBatchJobs(Transformation transformation, ServerComponent batchServerComponent, String schedulerId, boolean includeComplexJobs, List<BatchJob> results, JobFactory factory) throws RemoteException, MdException, SchedulerException {
        results.clear();
        if (transformation == null) {
            return 16;
        }
        MdObjectStore store = (MdObjectStore)transformation.getObjectStore();
        Job job = BatchJob.makeJobFromTransformation(transformation, false);
        if (job == null) {
            return 12;
        }
        AssociationList deployedJobList = job.getJFJobs();
        for (JFJob jfJob : deployedJobList) {
            try {
                ServerComponent tempBatchServerComponent;
                if (!jfJob.getAssociatedJob().getId().equals(job.getId()) || (tempBatchServerComponent = CommandUtilities.getServerComponentForJob(jfJob)) == null || batchServerComponent != null && !batchServerComponent.getId().equals(tempBatchServerComponent.getId())) continue;
                DeployedJob tempDeployedJob = new DeployedJob(jfJob);
                List<JFJob> containingFlows = tempDeployedJob.getListofFlows();
                if (containingFlows.size() == 0) {
                    BatchJob batchJob = factory.createJob(tempDeployedJob, null);
                    results.add(batchJob);
                    continue;
                }
                for (JFJob flow : containingFlows) {
                    try {
                        ServerComponent currentSchedulerComponent = DeployedFlow.getSchedulerComponent(flow);
                        if (schedulerId != null && (currentSchedulerComponent == null || !schedulerId.equals(currentSchedulerComponent.getId()))) continue;
                        DeployedFlow tempDeployedFlow = new DeployedFlow(flow, store);
                        boolean acceptableJob = true;
                        if (!includeComplexJobs) {
                            boolean bl = acceptableJob = !BatchJob.isComplex(tempDeployedFlow);
                        }
                        if (!acceptableJob) continue;
                        BatchJob batchJob = factory.createJob(tempDeployedJob, tempDeployedFlow);
                        results.add(batchJob);
                    }
                    catch (RuntimeException e) {
                        store.getFactory().getUtil().printOutputln(e.toString());
                        store.getFactory().getUtil().printOutputln(e.getLocalizedMessage());
                    }
                }
            }
            catch (RuntimeException e) {
                store.getFactory().getUtil().printOutputln(e.toString());
                store.getFactory().getUtil().printOutputln(e.getLocalizedMessage());
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int lazyCreateFlow() throws IllegalArgumentException, RemoteException, MdException, SchedulerException {
        int status;
        block15: {
            if (!this.m_ValidJob) {
                return 3;
            }
            if (this.m_scheduler == null) {
                return 24;
            }
            if (!this.isAuthenticated()) {
                return 29;
            }
            status = 0;
            try {
                if (this.m_dFlow != null) break block15;
                ArrayList<DeployedJob> jlist = new ArrayList<DeployedJob>();
                jlist.add(this.m_dJob);
                String jobName = this.getJobName();
                List<JFJob> existingFlowList = MetaUtilities.getJFJobList(jobName, true, this.m_dJob.getDeployedJobObject().getObjectStore(), "A0000001." + this.m_dJob.getDeployedJobObject().getRepositoryID());
                if (existingFlowList.size() > 0) {
                    for (JFJob flow : existingFlowList) {
                        DeployedFlow tempFlow = new DeployedFlow(flow, (MdObjectStore)this.m_dJob.getDeployedJobObject().getObjectStore());
                        List<Object> jobs = tempFlow.getJobs();
                        if (jobs.size() != 0) continue;
                        this.m_dFlow = tempFlow;
                        this.m_dFlow.addJobToFlow(this.m_dJob);
                        if (this.m_folder == null) break;
                        this.setFolder(this.m_folder);
                        break;
                    }
                    if (this.m_dFlow == null) {
                        int iter = 23;
                        return iter;
                    }
                    break block15;
                }
                MdObjectStore store = (MdObjectStore)this.m_dJob.getDeployedJobObject().getObjectStore();
                String repos = this.m_dJob.getDeployedJobObject().getRepositoryID();
                this.m_dFlow = new DeployedFlow(MetaUtilities.makeValidFlowName(jobName), store, repos, this.m_scheduler.getServerComponent(), jlist);
                try {
                    if (this.m_folder != null) {
                        this.setFolder(this.m_folder);
                        break block15;
                    }
                    this.setFolder(MetaUtilities.getDefaultFolder(store, repos));
                }
                catch (NotFound e) {
                    e.printStackTrace();
                }
                catch (NoContext e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (this.m_dJob != null && !this.m_dJob.commitChangesWithNoValidation()) {
                    status = 8;
                }
            }
        }
        return status;
    }

    public static Job makeJobFromTransformation(Transformation transformation, boolean allowCreate) throws RemoteException, MdException {
        return BatchJob.makeJobFromTransformation(transformation, allowCreate, null);
    }

    public static Job makeJobFromTransformation(Transformation transformation, boolean allowCreate, Scheduler scheduler) throws RemoteException, MdException {
        MdObjectStore store = (MdObjectStore)transformation.getObjectStore();
        MdFactory factory = store.getFactory();
        Job job = null;
        String reposID = transformation.getRepositoryID();
        if (transformation instanceof Job) {
            job = (Job)transformation;
        } else {
            AssociationList aList = transformation.getSourceTransformations();
            for (Object o : aList) {
                Transformation t;
                if (!(o instanceof Transformation) || !(t = (Transformation)o).getTransformRole().equals(BRIDGE_JOB_TRANSFORM_ROLE)) continue;
                job = (Job)t;
            }
            if (job == null && allowCreate) {
                String name = transformation.getName();
                job = MetaUtilities.createJobObject(scheduler != null ? scheduler.makeValidFlowname(name) : MetaUtilities.makeValidFlowName(name), store, reposID);
                job.setDesc(transformation.getDesc());
                job.setTransformRole(BRIDGE_JOB_TRANSFORM_ROLE);
                aList = job.getTransformationSources();
                aList.add((Object)transformation);
                job.setTransformationSources(aList);
                AssociationList properties = transformation.getProperties();
                int numprops = properties.size();
                for (int i = 0; i < numprops; ++i) {
                    Property property;
                    Property sprop = (Property)properties.get(i);
                    if (sprop.getPropertyName().equalsIgnoreCase("CommonArgs")) {
                        property = (Property)factory.createComplexMetadataObject(store, null, "CommonArgs", "Property", reposID, null);
                        property.setPropertyName("CommonArgs");
                        property.setDefaultValue(sprop.getDefaultValue());
                        property.setSQLType(12);
                        job.getProperties().add((Object)property);
                        continue;
                    }
                    if (!sprop.getPropertyName().equalsIgnoreCase("CmdArgs")) continue;
                    property = (Property)factory.createComplexMetadataObject(store, null, "CmdArgs", "Property", reposID, null);
                    property.setPropertyName("CmdArgs");
                    property.setDefaultValue(sprop.getDefaultValue());
                    property.setSQLType(12);
                    job.getProperties().add((Object)property);
                }
                job.updateMetadataAll();
            }
        }
        return job;
    }

    public static Job makeJobFromTree(Tree tree, MdObjectStore store, boolean allowCreate) throws RemoteException, MdException {
        return BatchJob.makeJobFromTree(tree, store, allowCreate, null);
    }

    public static Job makeJobFromTree(Tree tree, MdObjectStore store, boolean allowCreate, Scheduler scheduler) throws RemoteException, MdException {
        Job job = null;
        if (tree != null) {
            String reposID = tree.getRepositoryID();
            AssociationList aList = tree.getSourceTransformations();
            for (Object o : aList) {
                Transformation t;
                if (!(o instanceof Transformation) || !(t = (Transformation)o).getTransformRole().equals(BRIDGE_JOB_TRANSFORM_ROLE)) continue;
                job = (Job)t;
            }
            if (job == null && allowCreate) {
                String name = tree.getName();
                job = MetaUtilities.createJobObject(scheduler != null ? scheduler.makeValidFlowname(name) : MetaUtilities.makeValidFlowName(name), store, reposID);
                job.setDesc(tree.getDesc());
                job.setTransformRole(BRIDGE_JOB_TRANSFORM_ROLE);
                aList = job.getTransformationSources();
                aList.add((Object)tree);
                job.setTransformationSources(aList);
                job.updateMetadataAll();
            }
        }
        return job;
    }

    private static Vector<String> makePathList(Transformation transformation) throws MdException, RemoteException {
        Vector<String> pathList = new Vector<String>();
        pathList.add(transformation.getName());
        AssociationList list = transformation.getAssociatedObjects("Trees");
        if (list.size() > 0) {
            Tree tree = (Tree)list.get(0);
            Tree node = null;
            if (tree != null) {
                pathList.add(tree.getName());
                node = tree.getParentTree();
            }
            while (node != null) {
                String name = node.getName();
                node = node.getParentTree();
                pathList.add(name);
            }
        }
        return pathList;
    }

    private static Vector<String> makePathList(String path) {
        String lastSegment = path.substring(path.lastIndexOf(47) + 1);
        String folderPath = path.substring(0, path.lastIndexOf(47));
        Vector<String> pathList = new Vector<String>();
        pathList.add(lastSegment);
        while (folderPath != null) {
            int slashPos = folderPath.lastIndexOf(47);
            if (slashPos > 0) {
                pathList.add(folderPath.substring(slashPos + 1));
                folderPath = folderPath.substring(0, folderPath.lastIndexOf(47));
                continue;
            }
            pathList.add(folderPath);
            folderPath = null;
        }
        return pathList;
    }

    private void checkMainframe() throws SchedulerException, RemoteException, MdException {
        SessionContextInterface session;
        this.m_dJob.checkJCLGeneration();
        UserContextInterface user = this.m_dJob.getUserContext();
        if (user == null && (session = MetaUtilities.getSessionContext()) != null) {
            user = session.getUserContext();
        }
        if (user != null) {
            ((SchedulerIMPL)this.m_scheduler).setAlternativeUserContext(user, MetaUtilities.getDomain(this.m_dJob.getBatchServer()));
        }
    }

    private int scheduleNowHelper() throws SchedulerException, RemoteException, MdException {
        int rc = 13;
        boolean scheduled = false;
        this.checkMainframe();
        FlowInfo info = this.m_dFlow.getInfo();
        scheduled = this.m_scheduler.scheduleFlowNow(info);
        this.m_dFlow.updateInfoAfterScheduled(info);
        boolean written = this.m_dFlow.commitChangesWithNoValidation();
        return scheduled ? (written ? 0 : 14) : rc;
    }

    private int scheduleHelper(TriggerEvent trigger) throws RemoteException, MdException, SchedulerException {
        int rc = 13;
        boolean scheduled = false;
        this.checkMainframe();
        this.m_dFlow.setTriggerEvent(trigger);
        FlowInfo info = this.m_dFlow.getInfo();
        if (this.m_scheduler.isFlowScheduled(info)) {
            try {
                boolean errorOnDelete = false;
                scheduled = this.m_scheduler.rescheduleFlow(info, errorOnDelete) != 2;
            }
            catch (UnsupportedOperationException ex) {
                scheduled = true;
            }
        } else {
            scheduled = this.m_scheduler.scheduleFlow(info);
        }
        this.m_dFlow.updateInfoAfterScheduled(info);
        boolean written = this.m_dFlow.commitChangesWithNoValidation();
        return scheduled ? (written ? 0 : 27) : rc;
    }

    private static boolean isComplex(DeployedFlow flow) throws RemoteException, MdException {
        int jobCount = flow.getNumofJobs();
        if (jobCount > 1) {
            return true;
        }
        if (jobCount == 0) {
            return false;
        }
        DeployedJob dJob = (DeployedJob)flow.getJobs().get(0);
        List events = flow.getFileEvents(dJob, true);
        return events.size() > 0;
    }

    private int checkSchedulerOperationStatus() {
        if (!this.m_ValidJob) {
            return 3;
        }
        if (this.m_dFlow == null) {
            return 18;
        }
        if (this.m_scheduler == null) {
            return 24;
        }
        if (!this.isAuthenticated()) {
            return 29;
        }
        return 0;
    }

    protected static String getArgValue(String commandLineString, String argName) {
        String commandLine = commandLineString;
        if (commandLine == null) {
            return null;
        }
        String argumentName = argName.trim();
        if (argumentName.length() == 0) {
            return null;
        }
        String argValue = null;
        int argIndex = commandLine.indexOf(argumentName);
        if (argIndex >= 0) {
            int index;
            char optionChar = argumentName.charAt(0);
            argValue = "";
            char currentChar = '\u0000';
            for (index = argIndex + argumentName.length(); index < commandLine.length() && Character.isWhitespace(currentChar = commandLine.charAt(index)); ++index) {
            }
            if (index < commandLine.length() && currentChar != optionChar) {
                if (currentChar == '\"') {
                    int endQuote = commandLine.indexOf(34, index + 1);
                    if (endQuote >= 0) {
                        argValue = commandLine.substring(index + 1, endQuote);
                    }
                } else {
                    int endIndex;
                    for (endIndex = index + 1; endIndex < commandLine.length() && !Character.isWhitespace(currentChar = commandLine.charAt(endIndex)); ++endIndex) {
                    }
                    argValue = commandLine.substring(index, endIndex);
                }
            }
        }
        return argValue;
    }

    @Deprecated
    public String getLogFile(String repos, String workspacehost, int workspaceport, String user, String password) throws RemoteException, MdException {
        return this.getLogFile(repos, workspacehost, workspaceport, user, password != null ? new SealedString(password) : null);
    }

    public String getLogFile(String repos, String workspacehost, int workspaceport, String user, SealedString password) throws RemoteException, MdException {
        String lastFile = null;
        DeployedJob dJob = this.getDeployedJob();
        MdStore store = dJob.getStore();
        try {
            JFJob jfJob = MetaUtilities.getJFJob(dJob.getId(), store, repos);
            AssociationList steps = jfJob.getSteps();
            if (steps.size() > 0) {
                TransformationStep step = (TransformationStep)steps.get(0);
                IWorkspaceServer workspace = new IWorkspaceServer(null, "440196D4-90F0-11D0-9F41-00A024BB830C", workspacehost, workspaceport);
                workspace.makeConnection(user, password);
                lastFile = dJob.getLogFile(step, workspace.getWorkspace());
            }
        }
        catch (SchedulerException schedulerException) {
        }
        catch (InvalidCredentialsException invalidCredentialsException) {
        }
        catch (ConnectionFactoryException connectionFactoryException) {
            // empty catch block
        }
        return lastFile;
    }

    public List<?> getLogFileList() {
        return this.getDeployedJob().getLogFileList();
    }

    public int getState() throws RemoteException, MdException, SchedulerException, GeneralSecurityException {
        DeployedFlow flow = this.getFlow();
        Scheduler scheduler = this.getScheduler();
        long flowid = flow.getScheduleID();
        if (flowid == -2L) {
            flowid = this.m_scheduler.getFlowInstance(flow.getInfo());
        }
        if (flowid == -1L) {
            GeneralSecurityException ex = new GeneralSecurityException("Not Owner");
            throw ex;
        }
        if (flowid == -2L) {
            return -1;
        }
        flow.setScheduleID(flowid);
        return scheduler.getState(flowid);
    }

    protected static interface JobFactory {
        public BatchJob createJob(DeployedJob var1, DeployedFlow var2) throws RemoteException, MdException, SchedulerException;
    }

    private static class NullHistory
    extends FlowHistory
    implements com.sas.scheduler.api.servers.FlowHistory {
        private static final long serialVersionUID = 1L;

        public NullHistory(int state, int error) {
            super(state, error);
        }

        @Override
        public Date getStartTime() {
            return super.getStart().getTime();
        }

        @Override
        public Date getFinishTime() {
            return super.getFinish().getTime();
        }
    }

    private static class BatchJobFactory
    implements JobFactory {
        private BatchJobFactory() {
        }

        @Override
        public BatchJob createJob(DeployedJob dJob, DeployedFlow dFlow) throws RemoteException, MdException {
            return new BatchJob(dJob, dFlow);
        }
    }
}

