/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.deployjob;

import com.sas.iom.SAS.IFileService;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.JFJob;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Tree;
import com.sas.scheduler.api.deployjob.DataStepProgramDeployer;
import com.sas.scheduler.api.deployjob.DeployedJobCodeGenerationInterface;
import com.sas.scheduler.api.deployjob.DeployedJobDialog;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.FolderNode;
import com.sas.scheduler.api.oma.FolderTree;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.IWorkspaceServer;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.visuals.swing.DeployJobPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.services.user.UserContextInterface;
import java.awt.Cursor;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.CurrentPackage.NoContext;

public class RedeployedJobDialog
extends DeployedJobDialog {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle = MetaUtilities.getMyResourceBundle(RedeployedJobDialog.class);
    private List<DeployedJob> m_deployedJobObjects = new Vector<DeployedJob>();

    public RedeployedJobDialog(Frame owner, JobInfo djob, UserContextInterface userContext, String name, MdObjectStore store, String repos, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, name, djob, userContext, null, m_bundle.getString("RedeployedJobDialog.Title.txt"), djob.getBatchServerType(), djob.getBatchServerSubtype(), false, store, repos, null, jobFileContent);
    }

    public RedeployedJobDialog(Frame owner, JobInfo djob, UserContextInterface userContext, String name, DeployedJobCodeGenerationInterface callback, MdObjectStore store, String repos, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, name, djob, userContext, callback, m_bundle.getString("RedeployedJobDialog.Title.txt"), djob.getBatchServerType(), djob.getBatchServerSubtype(), false, store, repos, null, jobFileContent);
    }

    public RedeployedJobDialog(Frame owner, JobInfo djob, UserContextInterface userContext, String name, int batchtype, int batchsubtype, DeployedJobCodeGenerationInterface callback, MdObjectStore store, String repos, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, name, djob, userContext, callback, m_bundle.getString("RedeployedJobDialog.Title.txt"), batchtype, batchsubtype, true, store, repos, null, jobFileContent);
    }

    public RedeployedJobDialog(Frame owner, List<?> djobs, UserContextInterface userContext, DeployedJobCodeGenerationInterface callback, MdObjectStore store, String repos, Tree folder, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, djobs, userContext, callback, m_bundle.getString("RedeployedJobDialog.Title.txt"), store, repos, folder, jobFileContent);
    }

    public RedeployedJobDialog(Frame owner, List<?> djobs, UserContextInterface userContext, DeployedJobCodeGenerationInterface callback, String title, MdObjectStore store, String repos, Tree folder, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, null, djobs, userContext, callback, title, 1, 0, true, store, repos, folder, jobFileContent);
    }

    public RedeployedJobDialog(Frame owner, List<?> djobs, UserContextInterface userContext, int batchtype, int batchsubtype, DeployedJobCodeGenerationInterface callback, String title, MdObjectStore store, String repos, Tree folder, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        this(owner, null, djobs, userContext, callback, title, batchtype, batchsubtype, true, store, repos, folder, jobFileContent);
    }

    protected RedeployedJobDialog(Frame owner, String name, Object djobs, UserContextInterface userContext, DeployedJobCodeGenerationInterface callback, String title, int batchtype, int batchsubtype, boolean preservation, MdObjectStore store, String repos, Tree folder, String jobFileContent) throws RemoteException, MdException, SchedulerException {
        super(owner, userContext, RedeployedJobDialog.determineJobName(name, djobs), title, batchtype, batchsubtype, callback, preservation, store, repos, folder, jobFileContent);
        this.m_codegen = callback;
        this.m_multiselect = false;
        if (djobs instanceof JobInfo) {
            ArrayList<JobInfo> list = new ArrayList<JobInfo>();
            list.add((JobInfo)djobs);
            this.initialize(list);
        } else if (((List)djobs).size() > 0) {
            this.initialize((List)djobs);
        } else {
            throw new InvalidParameterException();
        }
    }

    private static String determineJobName(String nameStr, Object jobs) throws RemoteException {
        if (nameStr != null) {
            return nameStr;
        }
        if (jobs instanceof JobInfo) {
            return ((JobInfo)jobs).getName();
        }
        StringBuffer name = new StringBuffer();
        List joblist = (List)jobs;
        int numJobs = joblist.size();
        if (numJobs <= 0) {
            return null;
        }
        name.append(((JobInfo)joblist.get(0)).getName());
        for (int i = 1; i < numJobs; ++i) {
            name.append(";");
            name.append(((JobInfo)joblist.get(i)).getName());
        }
        return name.toString();
    }

    private void initialize(List<JobInfo> jinfos) throws SchedulerException {
        String names = null;
        String jobs = null;
        DirectoryInfo dinfo = null;
        BatchServerInfo bsinfo = null;
        String folderName = null;
        PropertyChangeListener filenameListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (RedeployedJobDialog.this.m_jobpanel.isJobNameVisible()) {
                    String filename = RedeployedJobDialog.this.m_jobpanel.getFilename();
                    String[] files = filename.split(";");
                    String names = null;
                    for (int y = 0; y < files.length; ++y) {
                        filename = files[y];
                        if (filename.length() > 0) {
                            try {
                                String name = null;
                                int index = filename.lastIndexOf("\\");
                                if (index == -1) {
                                    index = filename.lastIndexOf("/");
                                }
                                if ((index = (name = index >= 0 ? filename.substring(index + 1) : filename).lastIndexOf(46)) > 0) {
                                    name = name.substring(0, index);
                                }
                                name = RedeployedJobDialog.this.uniqueName(MetaUtilities.makeValidJobName(name), names);
                                names = names == null ? name : names + ";" + name;
                            }
                            catch (RemoteException ex) {
                                RedeployedJobDialog.this.m_jobpanel.setJobName("");
                            }
                            catch (MdException ex) {
                                RedeployedJobDialog.this.m_jobpanel.setJobName("");
                            }
                            catch (RuntimeException ex) {
                                RedeployedJobDialog.this.m_jobpanel.setJobName("");
                            }
                        }
                        RedeployedJobDialog.this.m_jobpanel.setJobName(names);
                    }
                }
            }
        };
        this.m_jobpanel.resetFilenameListener(filenameListener);
        try {
            for (int i = 0; i < jinfos.size(); ++i) {
                JobInfo jinfo = jinfos.get(i);
                DeployedJob djob = new DeployedJob(jinfo, this.m_store, this.m_repos);
                this.m_deployedJobObjects.add(djob);
                if (i == 0) {
                    folderName = jinfo.getLocation();
                    bsinfo = jinfo.getBatchServer();
                    JFJob jfjob = djob.getDeployedJobObject();
                    for (Object obj : jfjob.getSourceCodes()) {
                        File targetfile;
                        AssociationList dirs;
                        if (!(obj instanceof File) || (dirs = (targetfile = (File)obj).getDirectories(true)).size() <= 0) continue;
                        this.m_dir = (Directory)dirs.get(0);
                        if (this.m_dir == null) continue;
                        dinfo = new DirectoryInfo(this.m_dir.getName(), this.m_dir.getDirectoryName());
                    }
                }
                boolean notFound = true;
                String jobname = djob.getName();
                Job job = djob.getJobObject();
                if (job != null) {
                    jobname = job.getName();
                    Iterator srcs = job.getSourceCodes().iterator();
                    while (notFound && srcs.hasNext()) {
                        Object obj = srcs.next();
                        if (!(obj instanceof File)) continue;
                        notFound = false;
                        File srcfile = (File)obj;
                        String name = srcfile.getFileName();
                        String ext = srcfile.getFileExtension();
                        if (ext != null && ext.length() > 0) {
                            name = name + "." + ext;
                        }
                        String path = null;
                        AssociationList dirs = srcfile.getDirectories(true);
                        if (dirs.size() > 0) {
                            Directory dir = (Directory)dirs.get(0);
                            String string = path = dir != null ? dir.getDirectoryName() : null;
                        }
                        if (path != null) {
                            ServerComponent batchserver = djob.getBatchServer();
                            this.m_fullname = CommandUtilities.createFullPath(path, name, CommandUtilities.getTargetOSForBatchServer(batchserver));
                            continue;
                        }
                        this.m_fullname = name;
                    }
                }
                if (notFound) {
                    this.m_fullname = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.MissingSourceFile.fmt"), jobname);
                }
                names = names == null ? this.m_fullname : names + ";" + this.m_fullname;
                jobs = jobs == null ? jinfo.getName() : jobs + ";" + jinfo.getName();
            }
        }
        catch (RemoteException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            throw se;
        }
        catch (MdException ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            throw se;
        }
        if (!this.m_preserve) {
            this.m_jobpanel.setSelectedServer(bsinfo);
        }
        if (dinfo != null) {
            this.m_jobpanel.setSelectedDirectory(dinfo);
        }
        if (names != null) {
            this.m_jobpanel.setFilename(names);
        }
        if (jobs != null) {
            this.m_jobpanel.setJobName(jobs);
        }
        if (!this.m_preserve) {
            try {
                CMetadata repository = MetaUtilities.getRepository(this.m_factory, this.m_repos);
                ArrayList<CMetadata> reposList = new ArrayList<CMetadata>();
                reposList.add(repository);
                FolderTree folderTree = new FolderTree(null, this.m_store, reposList);
                this.m_folder = MetaUtilities.getFolder(folderName, this.m_store, this.m_reposId);
                FolderNode folderNode = MetaUtilities.findNode(folderTree.getRootNode(), this.m_folder);
                if (folderNode != null) {
                    this.m_folder = (Tree)folderNode.getUserObject();
                }
                this.m_jobpanel.setFolder(MetaUtilities.getFolderLocation(this.m_folder));
            }
            catch (RemoteException e) {
                this.m_jobpanel.setFolder(folderName);
            }
            catch (NotFound e) {
                this.m_jobpanel.setFolder(folderName);
            }
            catch (NoContext e) {
                if (e.getCause() instanceof NotFound) {
                    this.m_jobpanel.setFolder(folderName);
                }
                try {
                    if (folderName != null && folderName.indexOf("/") == -1) {
                        String defaultName = "/Shared Data".substring("/Shared Data".lastIndexOf("/") + 1);
                        if (folderName.compareTo(defaultName) == 0) {
                            folderName = "/Shared Data";
                            CMetadata repository = MetaUtilities.getRepository(this.m_factory, this.m_repos);
                            ArrayList<CMetadata> reposList = new ArrayList<CMetadata>();
                            reposList.add(repository);
                            FolderTree folderTree = new FolderTree(null, this.m_store, reposList);
                            this.m_folder = MetaUtilities.getFolder(folderName, this.m_store, this.m_reposId);
                            FolderNode folderNode = MetaUtilities.findNode(folderTree.getRootNode(), this.m_folder);
                            if (folderNode != null) {
                                this.m_folder = (Tree)folderNode.getUserObject();
                            }
                            this.m_jobpanel.setFolder(MetaUtilities.getFolderLocation(this.m_folder));
                        } else {
                            this.m_jobpanel.setFolder(folderName);
                        }
                    }
                    this.m_jobpanel.setFolder(folderName);
                }
                catch (RemoteException e1) {
                    this.m_jobpanel.setFolder(folderName);
                }
                catch (MdException e1) {
                    this.m_jobpanel.setFolder(folderName);
                }
                catch (NotFound e1) {
                    this.m_jobpanel.setFolder(folderName);
                }
                catch (NoContext e1) {
                    this.m_jobpanel.setFolder(folderName);
                }
            }
            catch (MdException e) {
                this.m_jobpanel.setFolder(folderName);
            }
        }
    }

    @Override
    protected boolean onOK() throws SchedulerException {
        this.m_eReturnValue = 64;
        boolean rc = true;
        this.setCursor(Cursor.getPredefinedCursor(3));
        BatchServerInfo bsinfo = this.m_jobpanel.getSelectedServer();
        try {
            switch (bsinfo.getType()) {
                case 1: {
                    rc = this.processDataStepBatchJobs(bsinfo);
                    break;
                }
                case 2: {
                    rc = this.processJavaBatchJobs(bsinfo);
                    break;
                }
                default: {
                    rc = false;
                }
            }
            this.m_eReturnValue = 1;
        }
        catch (RemoteException e) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)e.getLocalizedMessage(), (String)this.m_title, (int)0, (int)-1);
            rc = false;
        }
        catch (RuntimeException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)this.m_title, (int)0, (int)-1);
            rc = false;
        }
        this.setCursor(Cursor.getDefaultCursor());
        return rc;
    }

    private boolean processDataStepBatchJobs(BatchServerInfo bsinfo) throws RemoteException {
        boolean rc = true;
        this.m_eReturnValue = 64;
        String file = this.m_jobpanel.getFilename();
        String[] names = this.m_jobpanel.getJobName().split(";");
        boolean preserveServer = false;
        if (bsinfo.getName().compareTo(DeployJobPanel.BATCHSERVER_PRESERVE_PREVIOUS_VALUE) == 0) {
            preserveServer = true;
        }
        StringBuffer okMessage = new StringBuffer();
        StringBuffer failedMessage = new StringBuffer();
        int success = 0;
        int failed = 0;
        String spacer = "   ";
        String[] files = file.split(";");
        int total = files.length;
        if (total == 1) {
            spacer = "";
        }
        if (names.length != total) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnmatchedFilesToJobs.fmt"), String.valueOf(total), String.valueOf(names.length)), (String)this.m_title, (int)0, (int)-1);
            return false;
        }
        for (int z = 0; z < total; ++z) {
            boolean thisOkay = false;
            try {
                String message;
                boolean copyfile;
                String jclDirPath;
                Job job;
                DeployedJob djob;
                String jcl;
                block51: {
                    String message2;
                    int connectRC;
                    file = files[z];
                    this.m_name = names[z];
                    if (!DeployedJob.isValidName(this.m_name)) {
                        String newname = MetaUtilities.makeValidJobName(this.m_name);
                        int response = MessageUtil.displayMessage((Frame)this.m_frame, (String)MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.Warning.InvalidJobName.fmt"), this.m_name, newname), (String)this.m_title, (int)2, (int)2);
                        if (response == 2) {
                            this.m_name = newname;
                        }
                    }
                    jcl = this.m_jobpanel.getJCL();
                    djob = this.m_deployedJobObjects.get(z);
                    job = djob.getJobObject();
                    if (!MetaUtilities.isRedeployable(job, this.m_codegen != null)) {
                        String message3 = MetaUtilities.NotRedeployableReason(job, this.m_codegen != null);
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message3));
                        failedMessage.append("\n");
                        continue;
                    }
                    if (preserveServer) {
                        bsinfo = MetaUtilities.getBatchServer(djob.getBatchServer());
                    }
                    ServerComponent mdSC = MetaUtilities.getBatchServerComponent(bsinfo, (MdStore)this.m_store, this.m_reposId);
                    if (this.m_codegen != null) {
                        this.m_codegen.setAppServer(IWorkspaceServer.getServerContext(mdSC));
                    }
                    if ((connectRC = this.checkConnectionToServer(mdSC)) != 1) {
                        String message4 = null;
                        message4 = connectRC == 2 ? m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToConnectToAppServer.UserAbort.txt") : m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToConnectToAppServer.txt");
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message4));
                        failedMessage.append("\n");
                        continue;
                    }
                    IFileService rio = this.m_iworkspace.FileService();
                    jclDirPath = null;
                    if (preserveServer) {
                        AssociationList directories;
                        File jclsource;
                        File source = djob.getSourceCode();
                        if (source != null) {
                            AssociationList directories2 = source.getDirectories();
                            if (directories2 != null && !directories2.isEmpty()) {
                                this.m_dir = (Directory)directories2.get(0);
                            }
                        } else if (BatchServerInfo.requiresSourceFile((BatchServerInfo)bsinfo)) {
                            String message5 = m_bundle.getString("RedeployedJobDialog.ErrorMsg.MissingRequiredSource.txt");
                            rc = false;
                            ++failed;
                            failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message5));
                            failedMessage.append("\n");
                            continue;
                        }
                        if (BatchServerInfo.requiresJCLFile((BatchServerInfo)bsinfo) && (jclsource = djob.getJCL()) != null && (directories = jclsource.getDirectories()) != null && !directories.isEmpty()) {
                            jclDirPath = ((Directory)directories.get(0)).getDirectoryName();
                        }
                    } else {
                        this.m_dir = MetaUtilities.getDirectory(bsinfo, this.m_jobpanel.getSelectedDirectory(), (MdStore)this.m_store, this.m_reposId);
                        if (this.m_dir == null) {
                            String message6 = null;
                            message6 = this.m_jobpanel.getNumDirectories() == 0 ? m_bundle.getString("RedeployedJobDialog.ErrorMsg.NoDeploymentDirs.txt") : m_bundle.getString("RedeployedJobDialog.ErrorMsg.MissingDeploymentDir.txt");
                            rc = false;
                            ++failed;
                            failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message6));
                            failedMessage.append("\n");
                            continue;
                        }
                        if (BatchServerInfo.requiresJCLFile((BatchServerInfo)bsinfo)) {
                            jclDirPath = this.m_jobpanel.getSelectedJCLDirectory().getPath();
                        }
                    }
                    copyfile = false;
                    try {
                        if (this.m_codegen == null) {
                            if (this.setFilePaths(file, bsinfo)) {
                                copyfile = true;
                            } else if (this.m_srcpath == null || this.m_srcpath.compareTo(this.m_dir.getDirectoryName()) != 0) {
                                copyfile = true;
                            }
                        } else {
                            this.setFilePaths(file, bsinfo);
                        }
                        if (this.m_fileContent == null) break block51;
                        try {
                            CommandUtilities.saveToRemoteFile(rio, file, bsinfo.getOperatingSystem(), this.m_fileContent);
                            break block51;
                        }
                        catch (GenericError ex) {
                            message2 = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWriteContent.fmt"), file);
                            rc = false;
                            ++failed;
                            failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message2));
                            failedMessage.append("\n");
                        }
                    }
                    catch (GenericError ex) {
                        message2 = ex.getLocalizedMessage();
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message2));
                        failedMessage.append("\n");
                    }
                    catch (RuntimeException ex) {
                        message2 = ex.getLocalizedMessage();
                        if (message2 == null || message2.length() == 0) {
                            message2 = ex.toString();
                        }
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message2));
                        failedMessage.append("\n");
                    }
                    continue;
                }
                String msg = null;
                msg = total == 1 ? m_bundle.getString("RedeployedJobDialog.BuildMetadataProgressIndicator.Message.txt") : MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.BuildMetadataProgressIndicator.Message.fmt"), djob.getName(), String.valueOf(z + 1), String.valueOf(total));
                ProgressIndicator request = new ProgressIndicator(this.m_frame, msg, this.m_title);
                request.setDelayBeforeProgressCancelDialog(200);
                cRunnable updateMetadata = new cRunnable(djob, bsinfo, copyfile, jcl, jclDirPath);
                request.execute((Runnable)updateMetadata);
                this.m_djob = updateMetadata.getDeployedJob();
                this.m_dir = updateMetadata.getDeployedDirectory();
                if (!updateMetadata.isSuccessful()) {
                    SchedulerException ex = updateMetadata.getSchedulerException();
                    if (ex != null) {
                        ex.printStackTrace();
                    }
                    message = updateMetadata.getErrorMessage();
                    rc = false;
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message));
                    failedMessage.append("\n");
                    continue;
                }
                thisOkay = true;
                String folder = this.m_jobpanel.getFolder();
                if (folder.compareTo(DeployJobPanel.FOLDER_PRESERVE_PREVIOUS_VALUE) != 0) {
                    if (this.m_folder != null) {
                        if (this.m_djob != null) {
                            this.m_djob.setFolder(this.m_folder);
                            this.m_djob.commitChangesWithNoValidation();
                        }
                    } else {
                        message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.NoFolderAssignedToDeployedJob.txt");
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message));
                        failedMessage.append("\n");
                        continue;
                    }
                }
                if (!thisOkay) continue;
                message = null;
                String jobName = "";
                String djobName = "";
                String dirName = "";
                if (this.m_djob != null) {
                    djobName = this.m_djob.getName();
                    job = this.m_djob.getJobObject();
                    if (job != null) {
                        jobName = job.getName();
                    }
                }
                if (this.m_dir != null) {
                    dirName = this.m_dir.getDirectoryName();
                }
                message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeploySucc.fmt"), spacer, jobName, djobName, dirName);
                ++success;
                okMessage.append(message);
                okMessage.append("\n");
                continue;
            }
            catch (MdException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
                continue;
            }
            catch (RemoteException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
                continue;
            }
            catch (RuntimeException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
            }
        }
        StringBuffer summary = new StringBuffer();
        if (success > 0) {
            summary.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.Success.Header.fmt"), String.valueOf(success), String.valueOf(total), this.m_dir != null ? this.m_dir.getDirectoryName() : ""));
            summary.append("\n\n");
            summary.append(okMessage);
            summary.append("\n\n");
        }
        if (failed > 0) {
            summary.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.Failed.Header.fmt"), String.valueOf(failed), String.valueOf(total)));
            summary.append("\n\n");
            summary.append(failedMessage);
            summary.append("\n\n");
        }
        if (total == 1) {
            if (success == 1) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)okMessage.toString(), (String)this.m_title, (int)1, (int)-1);
            } else if (failed == 1) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)failedMessage.toString(), (String)this.m_title, (int)0, (int)-1);
            } else {
                MessageUtil.displayScrollableMessage((Frame)this.m_frame, (String)summary.toString(), (String)this.m_title, (int)1, (int)-1);
            }
        } else {
            MessageUtil.displayScrollableMessage((Frame)this.m_frame, (String)summary.toString(), (String)this.m_title, (int)(failed == 0 ? 1 : 0), (int)-1);
        }
        return rc;
    }

    private boolean processJavaBatchJobs(BatchServerInfo bsinfo) {
        boolean rc = true;
        this.m_eReturnValue = 64;
        String[] names = this.m_jobpanel.getJobName().split(";");
        StringBuffer okMessage = new StringBuffer();
        StringBuffer failedMessage = new StringBuffer();
        int success = 0;
        int failed = 0;
        String spacer = "   ";
        int total = names.length;
        if (total == 1) {
            spacer = "";
        }
        for (int z = 0; z < total; ++z) {
            boolean thisOkay = false;
            try {
                String message;
                DeployedJob djob;
                Job job;
                this.m_name = names[z];
                if (!DeployedJob.isValidName(this.m_name)) {
                    String newname = MetaUtilities.makeValidJobName(this.m_name);
                    int response = MessageUtil.displayMessage((Frame)this.m_frame, (String)MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.Warning.InvalidJobName.fmt"), this.m_name, newname), (String)this.m_title, (int)2, (int)2);
                    if (response == 2) {
                        this.m_name = newname;
                    }
                }
                if (!MetaUtilities.isRedeployable(job = (djob = this.m_deployedJobObjects.get(z)).getJobObject(), false)) {
                    String message2 = MetaUtilities.NotRedeployableReason(job, false);
                    rc = false;
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message2));
                    failedMessage.append("\n");
                    continue;
                }
                if (bsinfo.getName().compareTo(DeployJobPanel.BATCHSERVER_PRESERVE_PREVIOUS_VALUE) == 0) {
                    bsinfo = MetaUtilities.getBatchServer(djob.getBatchServer());
                }
                String msg = null;
                msg = total == 1 ? m_bundle.getString("RedeployedJobDialog.BuildMetadataProgressIndicator.Message.txt") : MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.BuildMetadataProgressIndicator.Message.fmt"), djob.getName(), String.valueOf(z + 1), String.valueOf(total));
                ProgressIndicator request = new ProgressIndicator(this.m_frame, msg, this.m_title);
                request.setDelayBeforeProgressCancelDialog(200);
                cRunnableJava updateMetadata = new cRunnableJava(djob, bsinfo);
                request.execute((Runnable)updateMetadata);
                this.m_djob = updateMetadata.getDeployedJob();
                if (!updateMetadata.isSuccessful()) {
                    SchedulerException ex = updateMetadata.getSchedulerException();
                    if (ex != null) {
                        ex.printStackTrace();
                    }
                    message = updateMetadata.getErrorMessage();
                    rc = false;
                    ++failed;
                    failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message));
                    failedMessage.append("\n");
                    continue;
                }
                thisOkay = true;
                String folder = this.m_jobpanel.getFolder();
                if (folder.compareTo(DeployJobPanel.FOLDER_PRESERVE_PREVIOUS_VALUE) != 0) {
                    if (this.m_folder != null) {
                        if (this.m_djob != null) {
                            this.m_djob.setFolder(this.m_folder);
                            this.m_djob.commitChangesWithNoValidation();
                        }
                    } else {
                        message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.NoFolderAssignedToDeployedJob.txt");
                        rc = false;
                        ++failed;
                        failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, djob.getName(), message));
                        failedMessage.append("\n");
                        continue;
                    }
                }
                if (!thisOkay) continue;
                message = null;
                String jobName = "";
                String djobName = "";
                if (this.m_djob != null) {
                    djobName = this.m_djob.getName();
                    job = this.m_djob.getJobObject();
                    if (job != null) {
                        jobName = job.getName();
                    }
                }
                message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeploySucc.fmt"), spacer, jobName, djobName, this.m_folder.toString());
                ++success;
                okMessage.append(message);
                okMessage.append("\n");
                continue;
            }
            catch (MdException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
                continue;
            }
            catch (RemoteException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
                continue;
            }
            catch (RuntimeException e) {
                rc = false;
                ++failed;
                failedMessage.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.DeployFail.fmt"), spacer, this.m_name, e.getLocalizedMessage()));
                failedMessage.append("\n");
            }
        }
        StringBuffer summary = new StringBuffer();
        if (success > 0) {
            summary.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.Success.Header.fmt"), String.valueOf(success), String.valueOf(total), ""));
            summary.append("\n\n");
            summary.append(okMessage);
            summary.append("\n\n");
        }
        if (failed > 0) {
            summary.append(MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.Failed.Header.fmt"), String.valueOf(failed), String.valueOf(total)));
            summary.append("\n\n");
            summary.append(failedMessage);
            summary.append("\n\n");
        }
        if (total == 1) {
            if (success == 1) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)okMessage.toString(), (String)this.m_title, (int)1, (int)-1);
            } else if (failed == 1) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)failedMessage.toString(), (String)this.m_title, (int)0, (int)-1);
            } else {
                MessageUtil.displayScrollableMessage((Frame)this.m_frame, (String)summary.toString(), (String)this.m_title, (int)1, (int)-1);
            }
        } else {
            MessageUtil.displayScrollableMessage((Frame)this.m_frame, (String)summary.toString(), (String)this.m_title, (int)(failed == 0 ? 1 : 0), (int)-1);
        }
        return rc;
    }

    private class cRunnable
    implements Runnable {
        private DeployedJob mc_job = null;
        private BatchServerInfo mc_bsinfo = null;
        private boolean mc_copy = true;
        private String mc_jcl = null;
        private String mc_jclDir = null;
        private boolean mc_rc = false;
        private String mc_message = null;
        private SchedulerException mc_schexc = null;

        public cRunnable(DeployedJob djob, BatchServerInfo bsinfo, boolean copy, String jcl, String jclDirPath) {
            this.mc_job = djob;
            this.mc_bsinfo = bsinfo;
            this.mc_copy = copy;
            this.mc_jcl = jcl;
            this.mc_jclDir = jclDirPath;
        }

        public DeployedJob getDeployedJob() {
            return this.mc_job;
        }

        public boolean isSuccessful() {
            return this.mc_rc;
        }

        public String getErrorMessage() {
            if (this.mc_rc) {
                return null;
            }
            return this.mc_message;
        }

        public Directory getDeployedDirectory() {
            return RedeployedJobDialog.this.m_dir;
        }

        public SchedulerException getSchedulerException() {
            return this.mc_schexc;
        }

        @Override
        public void run() {
            String codegen_filename;
            IFileService rio;
            block46: {
                rio = RedeployedJobDialog.this.m_iworkspace.FileService();
                codegen_filename = null;
                try {
                    if (!this.mc_copy) break block46;
                    String filename = RedeployedJobDialog.this.m_srcname;
                    if (RedeployedJobDialog.this.m_srcpath != null) {
                        filename = CommandUtilities.createFullPath(RedeployedJobDialog.this.m_srcpath, RedeployedJobDialog.this.m_srcname, this.mc_bsinfo.getOperatingSystem());
                    }
                    StringBuffer contents = CommandUtilities.readFromRemoteFile(rio, filename, this.mc_bsinfo.getOperatingSystem());
                    try {
                        if (!CommandUtilities.saveToRemoteFile(rio, RedeployedJobDialog.this.m_fullname, this.mc_bsinfo.getOperatingSystem(), contents.toString())) {
                            this.mc_rc = false;
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.SavingFile.fmt"), RedeployedJobDialog.this.m_fullname);
                            this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.SavingFile.fmt", new Object[]{RedeployedJobDialog.this.m_fullname});
                            return;
                        }
                    }
                    catch (GenericError ge) {
                        this.mc_rc = false;
                        this.mc_message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.SavingFile2.fmt"), RedeployedJobDialog.this.m_fullname != null ? RedeployedJobDialog.this.m_fullname : RedeployedJobDialog.this.m_srcname, ge.getLocalizedMessage());
                        this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.SavingFile2.fmt", new Object[]{RedeployedJobDialog.this.m_fullname != null ? RedeployedJobDialog.this.m_fullname : RedeployedJobDialog.this.m_srcname, ge.getLocalizedMessage()});
                        return;
                    }
                }
                catch (GenericError e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    this.mc_schexc = new SchedulerException(e.getMessage());
                    return;
                }
                catch (RuntimeException e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    if (this.mc_message == null || this.mc_message.length() == 0) {
                        this.mc_message = e.toString();
                    }
                    this.mc_schexc = new SchedulerException(this.mc_message);
                    return;
                }
            }
            if (this.mc_jcl != null) {
                try {
                    String jclName = RedeployedJobDialog.this.m_basename + ".jcl";
                    String strFullName = null;
                    try {
                        String dirString = "./";
                        Directory dir = MetaUtilities.getDirectory(this.mc_bsinfo, this.mc_jclDir, (MdStore)RedeployedJobDialog.this.m_store, RedeployedJobDialog.this.m_reposId);
                        if (dir != null) {
                            dirString = dir.getDirectoryName();
                        }
                        strFullName = CommandUtilities.createFullPath(dirString, jclName, this.mc_bsinfo.getOperatingSystem());
                        String runas = this.mc_job.getRunAs();
                        this.mc_jcl = DataStepProgramDeployer.GenerateJCLFromTemplate(RedeployedJobDialog.this.m_fullname, runas, this.mc_jcl);
                        if (!CommandUtilities.saveToRemoteFile(rio, strFullName, this.mc_bsinfo.getOperatingSystem(), this.mc_jcl)) {
                            this.mc_rc = false;
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.SavingFile.fmt"), strFullName);
                            this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.SavingFile.fmt", new Object[]{strFullName});
                            return;
                        }
                    }
                    catch (GenericError ge) {
                        this.mc_rc = false;
                        this.mc_message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.SavingFile2.fmt"), strFullName, ge.getLocalizedMessage());
                        this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.SavingFile2.fmt", new Object[]{strFullName, ge.getLocalizedMessage()});
                        return;
                    }
                }
                catch (MdException e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    if (this.mc_message == null) {
                        this.mc_message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                    }
                    this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                    this.mc_schexc.initCause((Throwable)e);
                    return;
                }
                catch (RemoteException e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    this.mc_schexc = new SchedulerException(e.getMessage());
                    return;
                }
                catch (RuntimeException e) {
                    this.mc_rc = false;
                    this.mc_message = e.getLocalizedMessage();
                    if (this.mc_message == null || this.mc_message.length() == 0) {
                        this.mc_message = e.toString();
                    }
                    this.mc_schexc = new SchedulerException(this.mc_message);
                    return;
                }
            }
            try {
                if (RedeployedJobDialog.this.m_sc == null || RedeployedJobDialog.this.m_preserve) {
                    RedeployedJobDialog.this.m_sc = MetaUtilities.getBatchServerComponent(this.mc_bsinfo, (MdStore)RedeployedJobDialog.this.m_store, RedeployedJobDialog.this.m_reposId);
                }
                JFJob jfjob = this.mc_job.getDeployedJobObject();
                Job job = this.mc_job.getJobObject();
                File jcl = null;
                File destfile = null;
                for (Object obj : jfjob.getSourceCodes()) {
                    if (!(obj instanceof File)) continue;
                    destfile = (File)obj;
                    destfile.setName(RedeployedJobDialog.this.m_basename);
                    destfile.setFileName(RedeployedJobDialog.this.m_targetname);
                    destfile.getDirectories().clear();
                    destfile.getDirectories().add((Object)RedeployedJobDialog.this.m_dir);
                    break;
                }
                if (RedeployedJobDialog.this.m_codegen == null) {
                    File srcfile = null;
                    for (Object obj : job.getSourceCodes()) {
                        if (!(obj instanceof File)) continue;
                        srcfile = (File)obj;
                        MetaUtilities.setFileSource(srcfile, RedeployedJobDialog.this.m_srcname, RedeployedJobDialog.this.m_srcpath, RedeployedJobDialog.this.m_store, RedeployedJobDialog.this.m_reposId);
                        break;
                    }
                    for (Object obj : job.getSourceSpecifications()) {
                        if (!(obj instanceof File)) continue;
                        jcl = (File)obj;
                        jcl.setName(RedeployedJobDialog.this.m_basename);
                        jcl.setFileName(RedeployedJobDialog.this.m_basename + ".jcl");
                        jcl.getDirectories().clear();
                        Directory dir = MetaUtilities.getDirectory(this.mc_bsinfo, RedeployedJobDialog.this.m_jobpanel.getSelectedJCLDirectory(), (MdStore)RedeployedJobDialog.this.m_store, RedeployedJobDialog.this.m_reposId);
                        jcl.getDirectories().add((Object)dir);
                        break;
                    }
                }
                if (RedeployedJobDialog.this.m_codegen != null) {
                    String name = destfile != null ? destfile.getFileName() : null;
                    String ext = destfile != null ? destfile.getFileExtension() : null;
                    boolean b_extensionInName = false;
                    if (name != null && name.lastIndexOf(".") > -1 && name.substring(name.lastIndexOf(".") + 1).equalsIgnoreCase(ext)) {
                        b_extensionInName = true;
                    }
                    if (ext != null && ext.length() > 0) {
                        if (ext.startsWith(".")) {
                            name = name + ext.substring(1);
                        } else if (!b_extensionInName) {
                            name = name + "." + ext;
                        }
                    }
                    String path = RedeployedJobDialog.this.m_dir != null ? RedeployedJobDialog.this.m_dir.getDirectoryName() : null;
                    codegen_filename = path != null ? CommandUtilities.createFullPath(path, name, this.mc_bsinfo.getOperatingSystem()) : name;
                    try {
                        if (!CommandUtilities.saveToRemoteFile(rio, codegen_filename, this.mc_bsinfo.getOperatingSystem(), "VERIFYING WRITE TO FILE")) {
                            this.mc_rc = false;
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.SavingFile.fmt"), codegen_filename);
                            this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.SavingFile.fmt", new Object[]{codegen_filename});
                            return;
                        }
                    }
                    catch (GenericError ge) {
                        this.mc_rc = false;
                        this.mc_message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.SavingFile2.fmt"), codegen_filename != null ? codegen_filename : RedeployedJobDialog.this.m_srcname, ge.getLocalizedMessage());
                        this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.SavingFile2.fmt", new Object[]{codegen_filename != null ? codegen_filename : RedeployedJobDialog.this.m_srcname, ge.getLocalizedMessage()});
                        return;
                    }
                }
                if (RedeployedJobDialog.this.m_codegen != null) {
                    RedeployedJobDialog.this.m_codegen.setAppServer(IWorkspaceServer.getServerContext(RedeployedJobDialog.this.m_sc));
                    RedeployedJobDialog.this.m_codegen.setJob(job);
                    String fileContent = RedeployedJobDialog.this.m_codegen.generateSource();
                    try {
                        if (!CommandUtilities.saveToRemoteFile(rio, codegen_filename, this.mc_bsinfo.getOperatingSystem(), fileContent)) {
                            this.mc_rc = false;
                            this.mc_message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.SavingFile.fmt"), codegen_filename);
                            this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.SavingFile.fmt", new Object[]{codegen_filename});
                            return;
                        }
                    }
                    catch (GenericError ge) {
                        this.mc_rc = false;
                        this.mc_message = MetaUtilities.messageString(m_bundle.getString("RedeployedJobDialog.ErrorMsg.SavingFile.Codegen.fmt"), RedeployedJobDialog.this.m_dir.getDirectoryName(), ge.getLocalizedMessage());
                        this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.SavingFile.Codegen.fmt", new Object[]{RedeployedJobDialog.this.m_dir.getDirectoryName(), ge.getLocalizedMessage()});
                        return;
                    }
                }
                this.mc_job = DataStepProgramDeployer.UpdateMetaObjects(job, jfjob, destfile, jcl, RedeployedJobDialog.this.m_dir, RedeployedJobDialog.this.m_sc, RedeployedJobDialog.this.m_userContext, RedeployedJobDialog.this.m_factory, RedeployedJobDialog.this.m_store, RedeployedJobDialog.this.m_repos);
                this.mc_job.getDeployedJobObject().setName(RedeployedJobDialog.this.m_name);
                if (!this.mc_job.commitChangesWithNoValidation()) {
                    this.mc_rc = false;
                    this.mc_message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                    this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                    return;
                }
            }
            catch (SchedulerException ex) {
                this.mc_rc = false;
                this.mc_message = ex.getLocalizedMessage();
                this.mc_schexc = ex;
                return;
            }
            catch (MdException e) {
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            catch (RemoteException e) {
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            catch (RuntimeException e) {
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            this.mc_rc = true;
        }
    }

    private class cRunnableJava
    implements Runnable {
        private DeployedJob mc_job = null;
        private BatchServerInfo mc_bsinfo = null;
        private boolean mc_rc = false;
        private String mc_message = null;
        private SchedulerException mc_schexc = null;

        public cRunnableJava(DeployedJob djob, BatchServerInfo bsinfo) {
            this.mc_job = djob;
            this.mc_bsinfo = bsinfo;
        }

        public DeployedJob getDeployedJob() {
            return this.mc_job;
        }

        public boolean isSuccessful() {
            return this.mc_rc;
        }

        public String getErrorMessage() {
            if (this.mc_rc) {
                return null;
            }
            return this.mc_message;
        }

        public SchedulerException getSchedulerException() {
            return this.mc_schexc;
        }

        @Override
        public void run() {
            try {
                if (RedeployedJobDialog.this.m_sc == null) {
                    RedeployedJobDialog.this.m_sc = MetaUtilities.getBatchServerComponent(this.mc_bsinfo, (MdStore)RedeployedJobDialog.this.m_store, RedeployedJobDialog.this.m_reposId);
                }
                JFJob jfjob = this.mc_job.getDeployedJobObject();
                Job job = this.mc_job.getJobObject();
                this.mc_job = DataStepProgramDeployer.UpdateMetaObjects(job, jfjob, RedeployedJobDialog.this.m_sc, RedeployedJobDialog.this.m_userContext, RedeployedJobDialog.this.m_factory, RedeployedJobDialog.this.m_store, RedeployedJobDialog.this.m_repos);
                this.mc_job.getDeployedJobObject().setName(RedeployedJobDialog.this.m_name);
                if (!this.mc_job.commitChangesWithNoValidation()) {
                    this.mc_rc = false;
                    this.mc_message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                    this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                    return;
                }
            }
            catch (SchedulerException ex) {
                this.mc_rc = false;
                this.mc_message = ex.getLocalizedMessage();
                this.mc_schexc = ex;
                return;
            }
            catch (MdException e) {
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            catch (RemoteException e) {
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            catch (RuntimeException e) {
                this.mc_rc = false;
                this.mc_message = e.getLocalizedMessage();
                if (this.mc_message == null) {
                    this.mc_message = m_bundle.getString("RedeployedJobDialog.ErrorMsg.UnableToWrite.txt");
                }
                this.mc_schexc = new SchedulerException(this.mc_message, RedeployedJobDialog.class, "RedeployedJobDialog.ErrorMsg.UnableToWrite.txt", null);
                this.mc_schexc.initCause((Throwable)e);
                return;
            }
            this.mc_rc = true;
        }
    }
}

