/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.deployjob;

import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class DirectoryPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private static final int TEXT_FIELD_LENGTH = 20;
    private JTextField m_fldDirectoryName;
    private JTextField m_fldDirectory;
    private Directory m_oDirectory;
    private JButton m_btnBrowse;
    private Frame m_frame;
    private MdObjectStore m_store;
    private String m_repos;
    private boolean m_bNewDirectory;

    public DirectoryPanel(Frame frame, MdObjectStore store, String repos) throws RemoteException {
        this.m_frame = frame;
        this.m_store = store;
        this.m_repos = repos;
        this.m_oDirectory = MetaUtilities.createDirectoryObject(m_bundle.getString("DirectoryPanel.NewDirectory.Metadata.Object.Name.txt"), this.m_store, this.m_repos);
        this.m_bNewDirectory = true;
        this.__initialize();
    }

    public DirectoryPanel(Directory directory, Frame frame, String repos) {
        this.m_oDirectory = directory;
        this.m_frame = frame;
        this.m_repos = repos;
        this.m_bNewDirectory = false;
        this.__initialize();
    }

    public void saveSettingsAndCleanUp() {
        this.m_fldDirectoryName = null;
        this.m_fldDirectory = null;
        this.m_btnBrowse = null;
        this.m_frame = null;
        this.m_store = null;
        this.m_repos = null;
    }

    public Directory getDirectory() {
        return this.m_oDirectory;
    }

    public void addBrowseListener(ActionListener acl) {
        this.m_btnBrowse.addActionListener(acl);
    }

    public void setDirectoryText(String text) {
        this.m_fldDirectory.setText(text);
    }

    private void __initialize() {
        this.m_fldDirectoryName = new JTextField(20);
        JLabel lblDirectoryName = new JLabel();
        String dirnameText = m_bundle.getString("DirectoryPanel.DirectoryName.txt");
        lblDirectoryName.setText(Util.getLabelWithoutMnemonic((String)dirnameText));
        lblDirectoryName.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)dirnameText));
        lblDirectoryName.setLabelFor(this.m_fldDirectoryName);
        this.m_fldDirectory = new JTextField(20);
        JLabel lblDirectory = new JLabel();
        String dirText = m_bundle.getString("DirectoryPanel.Directory.txt");
        lblDirectory.setText(Util.getLabelWithoutMnemonic((String)dirText));
        lblDirectory.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)dirText));
        lblDirectory.setLabelFor(this.m_fldDirectory);
        String browseText = m_bundle.getString("DirectoryPanel.Browse.txt");
        this.m_btnBrowse = new JButton(Util.getLabelWithoutMnemonic((String)browseText));
        this.m_btnBrowse.setMnemonic(Util.getDisplayedMnemonic((String)browseText));
        this.m_btnBrowse.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)browseText));
        this.setLayout(new GridBagLayout());
        this.add(lblDirectoryName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(lblDirectory, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_fldDirectoryName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.m_fldDirectory, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_btnBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.8, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
    }

    public boolean moveViewToData() {
        try {
            this.m_oDirectory.setName(this.m_fldDirectoryName.getText());
            this.m_oDirectory.setDirectoryName(this.m_fldDirectory.getText());
        }
        catch (RemoteException ex) {
            return false;
        }
        return true;
    }

    public boolean moveDataToView() {
        try {
            if (!this.m_bNewDirectory) {
                this.m_fldDirectoryName.setText(this.m_oDirectory.getName());
                this.m_fldDirectory.setText(this.m_oDirectory.getDirectoryName());
            }
        }
        catch (RemoteException ex) {
            return false;
        }
        return true;
    }

    public boolean validateData() {
        String strDirectoryName = this.m_fldDirectoryName.getText().trim();
        if (0 == strDirectoryName.length()) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("DirectoryPanel.BlankDirectoryName.txt"), (String)m_bundle.getString("DirectoryPanel.ErrorMsg.Title.txt"), (int)0, (int)-1);
            this.m_fldDirectoryName.grabFocus();
            return false;
        }
        if (this.m_bNewDirectory && !this.uniqueName(strDirectoryName)) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("DirectoryPanel.DupDirectoryName.txt"), (String)m_bundle.getString("DirectoryPanel.ErrorMsg.Title.txt"), (int)0, (int)-1);
            this.m_fldDirectoryName.grabFocus();
            return false;
        }
        String strDirectory = this.m_fldDirectory.getText().trim();
        if (0 == strDirectory.length()) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("DirectoryPanel.BlankDirectory.txt"), (String)m_bundle.getString("DirectoryPanel.ErrorMsg.Title.txt"), (int)0, (int)-1);
            this.m_fldDirectory.grabFocus();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uniqueName(String name) {
        boolean rc = true;
        MdObjectStore tempStore = null;
        List<?> list = null;
        try {
            MdFactory factory = null;
            factory = this.m_store != null ? this.m_store.getFactory() : MetaUtilities.getMdFactory(false);
            tempStore = factory.createObjectStore();
            list = MetaUtilities.getDirectoryList(name, (MdStore)tempStore, this.m_repos);
            if (list.size() > 0) {
                rc = false;
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (tempStore != null) {
                try {
                    tempStore.dispose();
                }
                catch (RemoteException remoteException) {}
                tempStore = null;
            }
            if (list != null) {
                list.clear();
                list = null;
            }
        }
        return rc;
    }

    static {
        String strClassName = DirectoryPanel.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

