/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.api.build;

import com.sas.iom.SAS.IDataService;
import com.sas.iom.SAS.IDataServicePackage.InvalidEngine;
import com.sas.iom.SAS.IDataServicePackage.LibraryInUse;
import com.sas.iom.SAS.IDataServicePackage.NoLibrary;
import com.sas.iom.SAS.IDataServicePackage.NoWorkDeassign;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.ILibref;
import com.sas.iom.SAS.ITextStream;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.InvalidLName;
import com.sas.iom.SAS.InvalidPName;
import com.sas.iom.SAS.LNameNoAssign;
import com.sas.iom.SAS.NoAccessMethod;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.scheduler.api.build.ImportFlowFromFile;
import com.sas.scheduler.api.build.ImportFlowInterface;
import com.sas.scheduler.api.oma.CommandUtilities;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.sasprocs.submitSAS;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.Vector;
import org.omg.CORBA.StringHolder;

public class ImportFlowFromSAS
extends submitSAS
implements ImportFlowInterface {
    private String m_indir = null;
    private FlowInfo m_flow = null;
    private MdObjectStore m_store = null;
    private String m_repos = null;
    private String m_name = null;

    public ImportFlowFromSAS(String sasfile, IWorkspace workspace, MdObjectStore store, String repos) {
        super(workspace);
        this.m_indir = CommandUtilities.getDirnameForBatchServer(sasfile, null);
        this.m_name = CommandUtilities.getBasenameForBatchServer(sasfile, null);
        this.m_store = store;
        this.m_repos = repos;
    }

    @Override
    public FlowInfo getFlowInfo() {
        return this.m_flow;
    }

    @Override
    public boolean setName(String name) {
        this.m_name = name;
        return true;
    }

    @Override
    public String getName() {
        return this.m_flow != null ? this.m_flow.getName() : this.m_name;
    }

    @Override
    public boolean parse(int maxPredecessors) throws InvalidParameterException, SchedulerException, RemoteException {
        SchedulerException se;
        if (this.m_workspace == null) {
            return false;
        }
        IFileService rio_file = this.m_workspace.FileService();
        String fileref = "tempSAS";
        String accessMethodOrDevice = "TEMP";
        String physicalName = "";
        String hostOptions = "encoding='UTF8'";
        StringHolder assignedName = new StringHolder(fileref);
        ITextStream file = null;
        IFileref fileRef = null;
        IDataService rio_data = this.m_workspace.DataService();
        String libref = "schedule";
        ILibref libRef = null;
        try {
            fileRef = rio_file.AssignFileref(fileref, accessMethodOrDevice, physicalName, hostOptions, assignedName);
            libRef = rio_data.AssignLibref(libref, "", this.m_indir, "");
        }
        catch (GenericError ge) {
            return false;
        }
        catch (NoLibrary ex) {
            return false;
        }
        catch (InvalidEngine ex) {
            return false;
        }
        catch (NoAccessMethod ex) {
            return false;
        }
        catch (LNameNoAssign ex) {
            return false;
        }
        catch (InvalidLName ex) {
            return false;
        }
        catch (InvalidPName ex) {
            return false;
        }
        StringBuffer sascode = new StringBuffer();
        StringBuffer sascode2 = new StringBuffer();
        sascode.append("options validvarname=any;\n");
        sascode.append("data _null_;\n");
        sascode.append("  set " + libRef.Name().trim() + "." + this.m_name.toLowerCase() + ";\n");
        sascode.append("  file " + fileref + " LRECL=1024 PAD;\n");
        sascode.append("  length line $1024.;\n");
        Vector vars = FlowInfo.getColumns((boolean)false);
        Iterator i = vars.iterator();
        int position = 0;
        sascode2.append("  line = ");
        while (i.hasNext()) {
            String var = i.next().toString();
            String varname = MetaUtilities.replaceInvalidCharacters(var);
            if (position == 0) {
                sascode2.append("trim(" + varname + ")");
            } else {
                sascode2.append(" || ',' || trim(" + varname + ")");
            }
            ++position;
        }
        sascode2.append(";\n");
        sascode.append(sascode2.toString());
        sascode.append("  put line $CHAR1024.;\n");
        sascode.append("run;\n");
        this.m_store.getFactory().getUtil().printOutputln(sascode.toString());
        this.submitStatements(sascode);
        try {
            file = fileRef.OpenTextStream(StreamOpenMode.StreamOpenModeForReading, Short.MAX_VALUE);
            this.m_flow = ImportFlowFromFile.processFlow(this.m_name, file, vars, maxPredecessors, this.m_store, this.m_repos);
            file.Close();
        }
        catch (GenericError ge) {
            if (file != null) {
                try {
                    file.Close();
                }
                catch (GenericError varname) {
                    // empty catch block
                }
                file = null;
            }
            se = new SchedulerException(ge.toString());
            se.initCause((Throwable)ge);
            throw se;
        }
        catch (RuntimeException rte) {
            if (MetaUtilities.isDebug()) {
                rte.printStackTrace();
            }
            se = new SchedulerException(rte.toString());
            se.initCause((Throwable)rte);
            throw se;
        }
        try {
            rio_file.DeassignFileref(fileref);
        }
        catch (GenericError ge) {
            this.m_store.getFactory().getUtil().printOutputln(ge.getMessage());
        }
        catch (RuntimeException rte) {
            this.m_store.getFactory().getUtil().printOutputln(rte.toString());
        }
        try {
            rio_data.DeassignLibref(libref);
        }
        catch (LNameNoAssign lnna) {
            this.m_store.getFactory().getUtil().printOutputln(lnna.getMessage());
        }
        catch (NoWorkDeassign nwd) {
            this.m_store.getFactory().getUtil().printOutputln(nwd.getMessage());
        }
        catch (LibraryInUse liu) {
            this.m_store.getFactory().getUtil().printOutputln(liu.getMessage());
        }
        catch (GenericError ge) {
            this.m_store.getFactory().getUtil().printOutputln(ge.getMessage());
        }
        catch (RuntimeException rte) {
            this.m_store.getFactory().getUtil().printOutputln(rte.toString());
        }
        return true;
    }
}

