/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.pfd.JobPort;
import com.sas.scheduler.pfd.PropertyAction;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.scheduler.visuals.swing.SubflowPropertiesPanel;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Subflow
extends PFDCompositeNode {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JobInfo m_info;
    private transient Frame m_frame;

    public Subflow(JobInfo flow, Frame frame) {
        this.m_info = flow;
        this.m_frame = frame;
        this.setTitleText(flow.getName());
        this.setContentText(flow.getDescription());
        this.setNodeType("Subflow");
        this.setNodeType("Subflow");
        this.setSupportedFromNodeTypes(new String[]{"File", "Time", "Job", "Gate", "Subflow"});
        this.setToolTipText(flow.getName());
        this.setNodeStyleContext("NodeStyle1");
        this.setNodeIcon((Icon)IconUtil.getIcon((String)FlowInfo.getIconName((boolean)false, (boolean)false)));
        this.removeAllInputPorts();
        this.removeAllOutputPorts();
        JobPort inPort = new JobPort();
        inPort.setMaxNumLinks(1);
        this.addInputPort(inPort);
        JobPort outPort = new JobPort();
        outPort.setMaxNumLinks(Integer.MAX_VALUE);
        this.addOutputPort(outPort);
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public JobInfo getInfo() {
        return this.m_info;
    }

    public boolean setInfo(JobInfo info) {
        this.m_info = info;
        return true;
    }

    public void customize(PFDView view) {
        SubflowPropertiesPanel panel = new SubflowPropertiesPanel(this.m_info);
        panel.setNameEditable(false);
        StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("Subflow.Properties.Title.txt"), true);
        dlg.setMainPanel((StandardPanel)panel);
        dlg.setHelpProduct("scheduler");
        dlg.setHelpTopic("window_job_properties");
        dlg.makeVisible();
    }

    public List<JComponent> getMenuItems() {
        List supers = super.getMenuItems();
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>(supers.size() + 2);
        menuItems.addAll(supers);
        menuItems.add(new JPopupMenu.Separator());
        PropertyAction action = new PropertyAction((PFDAbstractNode)this, null);
        JMenuItem item = new JMenu().add(action);
        item.setToolTipText(null);
        menuItems.add(item);
        return menuItems;
    }

    public Object cloneObject(Hashtable table) {
        return null;
    }

    static {
        String strClassName = Subflow.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

