/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.pfd.JobPort;
import com.sas.scheduler.pfd.PropertyAction;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.JobPropertiesPanel;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Job
extends PFDCompositeNode {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private JobInfo m_info;
    private transient Frame m_frame;
    private transient ActionListener m_jobPropertiesListener;

    public Job(JobInfo job, Frame frame) {
        this.m_info = job;
        this.m_frame = frame;
        this.m_jobPropertiesListener = null;
        this.setTitleText(job.getName());
        this.setContentText(job.getDescription());
        this.setNodeType("Job");
        this.setSupportedFromNodeTypes(new String[]{"File", "Time", "Job", "Gate", "Subflow"});
        this.setToolTipText(job.getName());
        this.setNodeStyleContext("NodeStyle1");
        this.setNodeIcon((Icon)IconUtil.getIcon((String)job.getIconName()));
        this.removeAllInputPorts();
        this.removeAllOutputPorts();
        JobPort inPort = new JobPort();
        inPort.setMaxNumLinks(1);
        this.addInputPort(inPort);
        JobPort outPort = new JobPort();
        outPort.setMaxNumLinks(Integer.MAX_VALUE);
        this.addOutputPort(outPort);
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public void setPropertiesListener(ActionListener actL) {
        this.m_jobPropertiesListener = actL;
    }

    public JobInfo getInfo() {
        return this.m_info;
    }

    public boolean setInfo(JobInfo info) {
        this.m_info = info;
        return true;
    }

    public void customize(PFDView view) {
        if (this.m_jobPropertiesListener != null) {
            this.m_jobPropertiesListener.actionPerformed(new ActionEvent((Object)this, 1001, null));
        } else {
            JobPropertiesPanel panel = new JobPropertiesPanel(this.m_info);
            StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("Job.Properties.Title.txt"), true);
            dlg.setMainPanel((StandardPanel)panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_job_properties");
            dlg.makeVisible();
            this.setTitleText(this.m_info.getName());
        }
    }

    public List<JComponent> getMenuItems() {
        List supers = super.getMenuItems();
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>(supers.size() + 2);
        menuItems.addAll(supers);
        menuItems.add(new JPopupMenu.Separator());
        PropertyAction action = new PropertyAction((PFDAbstractNode)this, null);
        JMenuItem item = new JMenu().add(action);
        item.setToolTipText(null);
        menuItems.add(item);
        return menuItems;
    }

    public Object cloneObject(Hashtable table) {
        return null;
    }

    static {
        String strClassName = Job.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

