/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.pfd.FlowPort;
import com.sas.scheduler.pfd.PropertyAction;
import com.sas.scheduler.visuals.swing.FileEventPanel;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class File
extends PFDCompositeNode {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private FileEventInfo m_info;
    private transient Frame m_frame;
    private transient ActionListener m_filePropertiesListener;

    public File(FileEventInfo file, Frame frame) {
        this.m_info = file;
        this.m_frame = frame;
        this.setTitleText(file.toString());
        this.setNodeType("File");
        this.setSupportedFromNodeTypes(new String[0]);
        this.setToolTipText(file.toString());
        this.setNodeStyleContext("NodeStyle1");
        this.setNodeIcon((Icon)IconUtil.getIcon((String)file.getIconName()));
        this.getInputPort().setValidToPort(false);
        this.removeAllOutputPorts();
        this.addOutputPort(new FlowPort());
    }

    public void setPropertiesListener(ActionListener actL) {
        this.m_filePropertiesListener = actL;
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public FileEventInfo getInfo() {
        return this.m_info;
    }

    public void setInfo(FileEventInfo info) {
        this.m_info = info;
        this.setTitleText(this.m_info.toString());
        try {
            PFDLink link = (PFDLink)this.getOutputPort().getFromLinks().get(0);
            if (link != null) {
                link.setMiddleLabel(this.m_info.toString());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void updateInfo(FileEventInfo info) {
        if (!this.m_info.equals(info)) {
            this.m_info.setName(info.getName());
            this.m_info.setFileName(info.getFileName());
            this.m_info.setEventType(info.getEventType());
            this.m_info.setOperator(info.getOperator());
            this.m_info.setValue(info.getValue());
            this.m_info.setScheduler(info.getScheduler());
            this.m_info.setDescription(info.getDescription());
        }
        this.setTitleText(this.m_info.toString());
        try {
            PFDLink link = (PFDLink)this.getOutputPort().getFromLinks().get(0);
            if (link != null) {
                link.setMiddleLabel(this.m_info.toString());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void customize(PFDView view) {
        if (this.m_filePropertiesListener != null) {
            this.m_filePropertiesListener.actionPerformed(new ActionEvent((Object)this, 1001, null));
        } else {
            FileEventPanel panel = new FileEventPanel(this.m_info);
            StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("File.Properties.Title.txt"), true);
            dlg.setMainPanel((StandardPanel)panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_new_file_event");
            dlg.makeVisible();
            this.setInfo(panel.getEvent());
        }
    }

    public List<JComponent> getMenuItems() {
        List supers = super.getMenuItems();
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>(supers.size() + 2);
        menuItems.addAll(supers);
        menuItems.add(new JPopupMenu.Separator());
        PropertyAction action = new PropertyAction((PFDAbstractNode)this, null);
        JMenuItem item = new JMenu().add(action);
        item.setToolTipText(null);
        menuItems.add(item);
        return menuItems;
    }

    public Object cloneObject(Hashtable table) {
        FileEventInfo i = new FileEventInfo(this.m_info.getFileName(), this.m_info.getEventType(), this.m_info.getOperator(), this.m_info.getValue());
        File clone = new File(i, this.m_frame);
        clone.setPropertiesListener(this.m_filePropertiesListener);
        table.put(this, clone);
        this.copyObject(clone);
        FlowPort oldPort = (FlowPort)this.getOutputPort();
        FlowPort newPort = (FlowPort)((Object)oldPort.cloneObject(table));
        clone.setOutputPort(newPort);
        return clone;
    }

    static {
        String strClassName = File.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

