/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDCompositeNode;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.visuals.swing.FindNodePanel;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ActionFindNode
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private transient Frame m_frame;
    private FlowPFDView m_panel;
    private FlowInfo m_flow;

    public ActionFindNode(Frame frame, FlowPFDView panel, FlowInfo flow) {
        this.m_frame = frame;
        this.m_panel = panel;
        this.m_flow = flow;
        String nameString = m_bundle.getString("ActionFindNode.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_Find));
        this.putValue("ShortDescription", m_bundle.getString("ActionFindNode.ShortDescription.txt"));
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    public boolean setInfo(FlowInfo flow) {
        this.m_flow = flow;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        FindNodePanel panel = new FindNodePanel();
        StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("ActionFindNode.Title.txt"), true);
        dlg.setMainPanel((StandardPanel)panel);
        dlg.setHelpProduct("scheduler");
        dlg.setHelpTopic("window_findnode");
        this.m_panel.clearSelections();
        dlg.makeVisible();
        String nodeName = panel.getNodeName();
        if (nodeName != null) {
            List<Object> nodes = this.m_panel.getJobs();
            for (int i = 0; i < nodes.size(); ++i) {
                PFDCompositeNode node = (PFDCompositeNode)nodes.get(i);
                if (node.getTitleText().compareToIgnoreCase(nodeName) != 0) continue;
                this.m_panel.moveToNode((PFDAbstractNode)node);
            }
            if (this.m_panel.getSelectedPrimitives().length < 1) {
                String title = m_bundle.getString("ActionFindNode.Title.txt");
                Object[] args = new Object[]{nodeName};
                String message = MessageFormat.format(m_bundle.getString("ActionFindNode.NoNodeFound.Msg.fmt"), args);
                MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)title, (int)1, (int)-1);
            }
        }
    }

    static {
        String strClassName = ActionFindNode.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

