/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.pfd.Job;
import com.sas.scheduler.visuals.swing.AddJobPanel;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ActionAddJob
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private transient Frame m_frame;
    private FlowPFDView m_panel;
    private FlowInfo m_flow;
    private List<?> m_jobList;
    private ActionListener m_jobPropertiesListener;

    public ActionAddJob(Frame frame, FlowPFDView panel, FlowInfo flow, List<?> allAvailableJobs, ActionListener jobPropertiesListener) {
        this.m_frame = frame;
        this.m_panel = panel;
        this.m_flow = flow;
        this.m_jobList = allAvailableJobs;
        this.m_jobPropertiesListener = jobPropertiesListener;
        String nameString = m_bundle.getString("ActionAddJob.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.NODE_Job));
        this.putValue("ShortDescription", m_bundle.getString("ActionAddJob.ShortDescription.txt"));
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    public boolean setInfo(FlowInfo flow) {
        this.m_flow = flow;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        AddJobPanel panel = new AddJobPanel(this.m_frame, this.m_flow, this.m_jobList);
        panel.setPropertiesListener(this.m_jobPropertiesListener);
        StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("ActionAddJob.Title.txt"), true);
        dlg.setMainPanel((StandardPanel)panel);
        dlg.setHelpProduct("scheduler");
        dlg.setHelpTopic("window_addjob");
        dlg.makeVisible();
        List addedJobs = panel.getAddedJobs();
        if (addedJobs != null && addedJobs.size() > 0) {
            for (int i = 0; i < addedJobs.size(); ++i) {
                JobInfo job = (JobInfo)addedJobs.get(i);
                Job jnode = new Job(job, this.m_frame);
                if (this.m_jobPropertiesListener != null) {
                    jnode.setPropertiesListener(this.m_jobPropertiesListener);
                }
                this.m_panel.addNode((PFDAbstractNode)jnode);
                this.m_jobList.remove(job);
            }
        }
    }

    static {
        String strClassName = ActionAddJob.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

