/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.GroupingEventInfo;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.pfd.Gate;
import com.sas.scheduler.visuals.swing.GroupingPanel;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ActionAddGroupingEvent
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private transient Frame m_frame;
    private FlowPFDView m_panel;
    private FlowInfo m_flow;

    public ActionAddGroupingEvent(Frame frame, FlowPFDView panel, FlowInfo flow) {
        this.m_frame = frame;
        this.m_panel = panel;
        this.m_flow = flow;
        String nameString = m_bundle.getString("ActionAddGroupingEvent.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.NODE_Grouping));
        this.putValue("ShortDescription", m_bundle.getString("ActionAddGroupingEvent.ShortDescription.txt"));
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    public boolean setInfo(FlowInfo flow) {
        this.m_flow = flow;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        GroupingEventInfo gei = null;
        if (this.m_flow.getScheduler() != null && !this.m_flow.getScheduler().isORGateSupported()) {
            gei = new GroupingEventInfo(null, 0);
        } else {
            GroupingPanel panel = new GroupingPanel(1);
            StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("ActionAddGroupingEvent.Title.txt"), true);
            dlg.setMainPanel((StandardPanel)panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_grouping_node");
            dlg.makeVisible();
            if (1 == dlg.getReturnValue()) {
                switch (panel.getGroupingType()) {
                    case 31: {
                        gei = new GroupingEventInfo(null, 0);
                        break;
                    }
                    case 32: {
                        gei = new GroupingEventInfo(null, 1);
                    }
                }
            }
        }
        if (gei != null) {
            this.m_panel.addNode((PFDAbstractNode)new Gate(gei, this.m_frame));
        }
    }

    static {
        String strClassName = ActionAddGroupingEvent.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

