/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.pfd.File;
import com.sas.scheduler.pfd.FlowEventActionListener;
import com.sas.scheduler.pfd.FlowPFDView;
import com.sas.scheduler.visuals.swing.FileEventPanel;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;

public class ActionAddFileEvent
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle m_bundle;
    private transient Frame m_frame;
    private FlowPFDView m_panel;
    private FlowInfo m_flow;
    private ActionListener m_filePropertiesListener;
    private FlowEventActionListener m_fileEventListener;

    public ActionAddFileEvent(Frame frame, FlowPFDView panel, FlowInfo flow, FlowEventActionListener fileEventListener, ActionListener filePropertiesListener) {
        this.m_frame = frame;
        this.m_panel = panel;
        this.m_flow = flow;
        this.m_fileEventListener = fileEventListener;
        this.m_filePropertiesListener = filePropertiesListener;
        String nameString = m_bundle.getString("ActionAddFileEvent.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameString));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameString));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.NODE_FileEvent));
        this.putValue("ShortDescription", m_bundle.getString("ActionAddFileEvent.ShortDescription.txt"));
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public FlowInfo getInfo() {
        return this.m_flow;
    }

    public boolean setInfo(FlowInfo flow) {
        this.m_flow = flow;
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        FileEventInfo file = new FileEventInfo();
        file.setScheduler(this.m_flow.getScheduler());
        File node = null;
        if (this.m_fileEventListener != null) {
            node = new File(file, this.m_frame);
            this.m_fileEventListener.actionPerformed(new ActionEvent((Object)node, 1001, null));
            if (this.m_fileEventListener.getReturnValue() == 1) {
                node.setPropertiesListener(this.m_filePropertiesListener);
                this.m_panel.addNode((PFDAbstractNode)node);
            }
        } else {
            FileEventPanel panel = new FileEventPanel(file);
            StandardDialog dlg = new StandardDialog(this.m_frame, m_bundle.getString("ActionAddFileEvent.Title.txt"), true);
            dlg.setMainPanel((StandardPanel)panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_new_file_event");
            dlg.makeVisible();
            if (dlg.getReturnValue() == 1) {
                file = panel.getEvent();
                node = new File(file, this.m_frame);
                this.m_panel.addNode((PFDAbstractNode)node);
            }
        }
    }

    static {
        String strClassName = ActionAddFileEvent.class.getName();
        String strPackageName = strClassName.substring(0, strClassName.lastIndexOf(46));
        String strBundlePath = strPackageName + ".PropertyBundle";
        m_bundle = ResourceBundle.getBundle(strBundlePath, Locale.getDefault());
    }
}

