/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.client;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Properties;
import java.util.regex.Pattern;

public class BackupSourceNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nickName;
    private String hostName;
    private String configDirPath;
    private String sasHome;
    private String sasRoot;
    private String appDataFolder;
    private String platformTypesInstallDir;
    private String levUtilitiesDir;
    private String osType;
    private boolean isMidTier;
    private boolean isMetadataTier;
    private boolean isMetadataCluster;
    private boolean isPrimary;
    private Properties properties;

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getSasRoot() {
        return this.sasRoot;
    }

    public void setSasRoot(String sasRoot) {
        this.sasRoot = sasRoot;
    }

    public String getAppDataFolder() {
        return this.appDataFolder;
    }

    public void setAppDataFolder(String appDataFolder) {
        this.appDataFolder = appDataFolder;
    }

    public String getPlatformTypesInstallDir() {
        return this.platformTypesInstallDir;
    }

    public void setPlatformTypesInstallDir(String platformTypesInstallDir) {
        this.platformTypesInstallDir = platformTypesInstallDir;
    }

    public String getLevUtilitiesDir() {
        return this.levUtilitiesDir;
    }

    public void setLevUtilitiesDir(String levUtilitiesDir) {
        this.levUtilitiesDir = levUtilitiesDir;
    }

    public String getConfigDirPath() {
        return this.configDirPath;
    }

    public void setConfigDirPath(String configDirPath) {
        this.configDirPath = configDirPath;
    }

    public String getSasHome() {
        return this.sasHome;
    }

    public void setSasHome(String installDirPath) {
        this.sasHome = installDirPath;
    }

    public String getOsType() {
        return this.osType;
    }

    public void setOsType(String osType) {
        this.osType = osType;
    }

    public boolean isMidTier() {
        return this.isMidTier;
    }

    public void setMidTier(boolean isMidTier) {
        this.isMidTier = isMidTier;
    }

    public boolean isMetadataTier() {
        return this.isMetadataTier;
    }

    public void setMetadataTier(boolean isMetadataTier) {
        this.isMetadataTier = isMetadataTier;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void setIsPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public String toString() {
        String value = null;
        if (this.hostName != null) {
            value = "Host: " + this.hostName;
        }
        if (this.configDirPath != null) {
            value = value + " Configuration Directory: " + this.configDirPath;
        }
        return value == null ? super.toString() : value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BackupSourceNode)) {
            return false;
        }
        BackupSourceNode sourceNode = (BackupSourceNode)obj;
        if (this.hostName == null || sourceNode.getHostName() == null || this.configDirPath == null || sourceNode.getConfigDirPath() == null) {
            return false;
        }
        return this == sourceNode || this.isHostsEqual(this.hostName, sourceNode.getHostName()) && this.configDirPath.equalsIgnoreCase(sourceNode.getConfigDirPath());
    }

    public int hashCode() {
        InetAddress hostAddress;
        int result = 17;
        if (this.hostName != null && (hostAddress = this.convertToInetAddress(this.hostName)) != null && hostAddress.getHostAddress() != null) {
            result = 31 * result + hostAddress.getHostAddress().hashCode();
        }
        if (this.configDirPath != null) {
            result = 31 * result + this.configDirPath.hashCode();
        }
        return result;
    }

    private boolean isHostsEqual(String host1, String host2) {
        boolean result = false;
        InetAddress hostAddress1 = this.convertToInetAddress(host1);
        InetAddress hostAddress2 = this.convertToInetAddress(host2);
        return hostAddress1 != null && hostAddress1.getHostAddress() != null && hostAddress2 != null && hostAddress2.getHostAddress() != null && hostAddress1.getHostAddress().equals(hostAddress2.getHostAddress());
    }

    private InetAddress convertToInetAddress(String host) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown host : " + host, e);
        }
        return address;
    }

    public BackupSourceNode() {
    }

    public BackupSourceNode(String hostNConfigDir) {
        String[] strArray = hostNConfigDir.split(Pattern.quote("|"), 2);
        if (strArray != null && strArray.length > 0) {
            this.hostName = strArray[0];
            if (strArray.length > 1) {
                this.configDirPath = strArray[1];
            }
        }
    }

    public BackupSourceNode(String hostName, String configDirPath) {
        this.hostName = hostName;
        this.configDirPath = configDirPath;
    }

    public boolean isMetadataCluster() {
        return this.isMetadataCluster;
    }

    public void setMetadataCluster(boolean isMetadataCluster) {
        this.isMetadataCluster = isMetadataCluster;
    }
}

