/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.client;

import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupOptions;
import com.sas.svcs.backup.client.BackupSchedule;
import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.BackupServiceSession;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.DirectoryDetails;
import com.sas.svcs.backup.client.Notifiable;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryDetails;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserBackupConfiguration;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.backup.common.definitions.BackupException;
import java.util.List;
import java.util.Map;

public interface BackupService {
    public BackupServiceResult<AnalysisResult> analyze() throws BackupException;

    @Notifiable(eventObjectType=BackupService.class, operation="Backup")
    public BackupServiceResult<BackupDetails> startBackup(BackupOptions var1) throws BackupException;

    public BackupServiceResult<OperationDetails.OperationStatus> getStatus(String var1, String var2, String var3) throws BackupException;

    public BackupServiceResult<List<OperationDetails>> getAllHistory() throws BackupException;

    public BackupServiceResult<List<OperationDetails>> getRecentHistory(int var1) throws BackupException;

    public BackupServiceResult<OperationDetails> getDetails(String var1, String var2, String var3) throws BackupException;

    public BackupServiceResult<BackupConfiguration> getBackupConfiguration() throws BackupException;

    public BackupServiceResult<BackupConfiguration> setBackupConfiguration(BackupConfiguration var1) throws BackupException;

    public BackupServiceResult<BackupDetails> getMostRecentBackup() throws BackupException;

    public BackupServiceResult<BackupDetails> getBackupBySlugName(String var1) throws BackupException;

    public BackupServiceResult<BackupDetails> getBackupByName(String var1) throws BackupException;

    public BackupServiceResult<BackupDetails> refreshBackup(BackupDetails var1) throws BackupException;

    public List<BackupDetails> getAvailableBackups(BackupServiceSession<?> var1) throws BackupException;

    public void addToHistory(BackupDetails var1) throws BackupException;

    @Notifiable(eventObjectType=BackupService.class, operation="Recovery")
    public BackupServiceResult<RecoveryDetails> recover(BackupDetails var1, RecoveryOptions var2) throws BackupException;

    public BackupServiceResult<RecoveryDetails> getMostRecentRecovery() throws BackupException;

    public BackupServiceResult<RecoveryDetails> getRecoveryBySlugName(String var1) throws BackupException;

    public BackupServiceResult<RecoveryDetails> getRecoveryByName(String var1) throws BackupException;

    public BackupServiceResult<RecoveryDetails> refreshRecovery(RecoveryDetails var1) throws BackupException;

    public BackupServiceResult<Boolean> isMostRecentRecovery(RecoveryDetails var1) throws BackupException;

    public BackupServiceResult<List<BackupSchedule>> getBackupSchedule() throws BackupException;

    public BackupServiceResult<Boolean> setBackupSchedule(List<BackupSchedule> var1) throws BackupException;

    public BackupServiceResult<Map<String, List<String>>> getContentDetails(String var1, String var2, String var3, String var4) throws BackupException;

    public BackupServiceResult<Map<String, List<DirectoryDetails>>> getCustomDirs() throws BackupException;

    public BackupServiceResult<Boolean> setCustomDirs(Map<String, List<DirectoryDetails>> var1) throws BackupException;

    public BackupServiceResult<Boolean> addCustomDirs(Map<String, List<DirectoryDetails>> var1) throws BackupException;

    public List<String> getUnreachableHosts() throws BackupException;

    public BackupServiceResult<UserBackupConfiguration> getUserConfiguration() throws BackupException;

    @Deprecated
    public BackupServiceResult<UserSourceConfiguration> getUserSoureceConfiguration(BackupSourceConfig.BackupSource var1) throws BackupException;

    @Deprecated
    public BackupServiceResult<UserSourceConfiguration> displaySoureceConfiguration(BackupSourceConfig.BackupSource var1) throws BackupException;

    @Deprecated
    public BackupServiceResult<Boolean> setUserSourceConfiguration(UserSourceConfiguration var1, BackupSourceConfig.BackupSource var2) throws BackupException;

    @Deprecated
    public BackupServiceResult<SASTiers> getSASTiers() throws BackupException;

    @Deprecated
    public BackupServiceResult<SASTierProxy> getSASTier(String var1) throws BackupException;

    @Deprecated
    public BackupServiceResult<Boolean> setSASTiers(SASTiers var1) throws BackupException;
}

