/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.client;

import java.io.Serializable;

public class BackupSchedule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DayOfWeek dayOfWeek;
    private int hour;
    private int minute;

    public BackupSchedule() {
        this.dayOfWeek = DayOfWeek.SUNDAY;
        this.hour = 1;
        this.minute = 0;
    }

    public BackupSchedule(DayOfWeek dayOfWeek, int hour, int minute) {
        this.dayOfWeek = dayOfWeek;
        this.setHour(hour);
        this.setMinute(minute);
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public DayOfWeek getDayOfweek() {
        return this.dayOfWeek;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dayOfWeek == null ? 0 : this.dayOfWeek.hashCode());
        result = 31 * result + this.hour;
        result = 31 * result + this.minute;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackupSchedule other = (BackupSchedule)obj;
        if (this.dayOfWeek != other.dayOfWeek) {
            return false;
        }
        if (this.hour != other.hour) {
            return false;
        }
        return this.minute == other.minute;
    }

    public static enum DayOfWeek {
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        String displayName;

        public String getDisplayName() {
            return this.displayName;
        }

        private void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        private DayOfWeek() {
        }

        private DayOfWeek(String displayName) {
            this.setDisplayName(displayName);
        }
    }
}

