/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.backup.analyze.model;

import com.sas.svcs.backup.analyze.model.AnalysisResult;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.deployment.data.ConfigurableServer;
import com.sas.svcs.deployment.data.SASEnvironment;
import com.sas.svcs.deployment.data.SASTier;
import java.util.ArrayList;
import java.util.List;

public class RuntimeSASEnvironment {
    private SASEnvironment sasEnvironment;
    private SASTier primaryMetdataTier;
    private List<SASTier> availableTiers;
    private List<SASTier> unreachableTiers;
    private List<SASTier> requiredTiers;
    private List<SASTier> requiredTiersTobeConfigured;
    private AnalysisResult backupAnalysis;

    private RuntimeSASEnvironment(SASEnvironment sasEnvironment) {
        this.sasEnvironment = sasEnvironment;
        this.availableTiers = new ArrayList<SASTier>();
        this.setRequiredTiers(new ArrayList<SASTier>());
        this.availableTiers.addAll(sasEnvironment.getSasTiers());
        this.unreachableTiers = new ArrayList<SASTier>();
    }

    public static RuntimeSASEnvironment getInstance(SASEnvironment sasEnvironment) {
        return new RuntimeSASEnvironment(sasEnvironment);
    }

    public void setBackupAnalysis(AnalysisResult result) {
        this.backupAnalysis = result;
    }

    public AnalysisResult getBackupAnalysis() {
        return this.backupAnalysis;
    }

    public boolean isAnalysisAvailable() {
        return this.backupAnalysis != null;
    }

    public SASEnvironment getSasEnvironment() {
        return this.sasEnvironment;
    }

    public SASTier getPrimaryMetdataTier() {
        return this.primaryMetdataTier;
    }

    public boolean isPrimaryMetdataTierPresent() {
        return this.primaryMetdataTier != null ? this.isTierReachable(this.primaryMetdataTier) : false;
    }

    public void setPrimaryMetdataTier(SASTier primaryMetdataTier) {
        this.primaryMetdataTier = primaryMetdataTier;
    }

    public List<SASTier> getAvailableTiers() {
        return this.availableTiers;
    }

    public void setAvailableTiers(List<SASTier> reachableTiers) {
        this.availableTiers = reachableTiers;
    }

    public List<SASTier> getUnreachableTiers() {
        return this.unreachableTiers;
    }

    public void setUnreachableTiers(List<SASTier> unreachableTiers) {
        this.unreachableTiers = unreachableTiers;
    }

    public List<SASTier> getAllTiers() {
        return this.sasEnvironment != null ? this.sasEnvironment.getSasTiers() : null;
    }

    public boolean isTierReachable(SASTier sasTier) {
        return this.unreachableTiers != null ? !this.unreachableTiers.contains(sasTier) : false;
    }

    public boolean hasErrors(BackupSourceConfig.BackupSource source, ConfigurableServer server) {
        return this.isAnalysisAvailable() && this.getBackupAnalysis().hasErrors(source, server);
    }

    public List<SASTier> getRequiredTiers() {
        return this.requiredTiers;
    }

    public void setRequiredTiers(List<SASTier> requiredTiers) {
        this.requiredTiers = requiredTiers;
    }

    public List<SASTier> getRequiredTiersTobeConfigured() {
        return this.requiredTiersTobeConfigured;
    }

    public void setRequiredTiersTobeConfigured(List<SASTier> requiredTiersTobeConfigured) {
        this.requiredTiersTobeConfigured = requiredTiersTobeConfigured;
    }
}

