/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TagLibConfig {
    static Log logger = LogFactory.getLog((String)"spring-security-taglibs");
    static final boolean DISABLE_UI_SECURITY;
    static final String SECURED_UI_PREFIX;
    static final String SECURED_UI_SUFFIX;

    private TagLibConfig() {
    }

    public static int evalOrSkip(boolean authorized) {
        return authorized || DISABLE_UI_SECURITY ? 1 : 0;
    }

    public static boolean isUiSecurityDisabled() {
        return DISABLE_UI_SECURITY;
    }

    public static String getSecuredUiPrefix() {
        return SECURED_UI_PREFIX;
    }

    public static String getSecuredUiSuffix() {
        return SECURED_UI_SUFFIX;
    }

    static {
        String db = System.getProperty("spring.security.disableUISecurity");
        String prefix = System.getProperty("spring.security.securedUIPrefix");
        String suffix = System.getProperty("spring.security.securedUISuffix");
        SECURED_UI_PREFIX = prefix != null ? prefix : "<span class=\"securityHiddenUI\">";
        SECURED_UI_SUFFIX = suffix != null ? suffix : "</span>";
        DISABLE_UI_SECURITY = "true".equals(db);
        if (DISABLE_UI_SECURITY) {
            logger.warn((Object)"***** UI security is disabled. All unauthorized content will be displayed *****");
        }
    }
}

