/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.migration;

import com.sas.iom.SASIOMDefs.VariableArray2dOfAnyHolder;
import com.sas.iom.SASIOMDefs.VariableArray2dOfStringHolder;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.meta.SASOMI.ISecurityAdmin;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.Aggregation;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.Dimension;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Feature;
import com.sas.metadata.remote.FeatureMap;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.ForeignKey;
import com.sas.metadata.remote.GlobalFormula;
import com.sas.metadata.remote.Hierarchy;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.Level;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Measure;
import com.sas.metadata.remote.OLAPProperty;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TableCollection;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.metadata.remote.UniqueKey;
import com.sas.olapadmin.migration.RB;
import com.sas.services.util.Names;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.StringHolder;

public class UpgradeCubeAction {
    Root jomaCube;
    Cube upgradedCube;
    private static final String AGGREGATION_TYPE_ROLAP = "ROLAP";
    private static final String CALCULATED_MEASURE;
    private static final String CALCULATED_MEASURE_PUBLIC_TYPE;
    private static final String CALCULATED_MEMBER;
    private static final String CLASSIFIERMAP_AGGREGATE_ROLE;
    private static final String CLASSIFIERMAP_ESRIFILE_ROLE;
    private static final String CONNECTION;
    private static final List CUBE_ASSOCIATIONS;
    private static final String CUBE_DIRECTORY_ROLE;
    private static final String CUBE_OPTION_CUBE_FOLDER;
    private static final String CUBE_OPTION_LOADTABLE_OPTION;
    private static final String CUBE_OPTION_REACHTHRUTABLE_OPTION;
    private static final String CUBE_OPTION_TABLE_OPTIONS;
    private static final String CUBE_OPTION_VERSION_NAME;
    private static final String CUBE_OPTION_WORKPATH;
    private static final int CUBE_VERSION_MAJOR_NUMBER;
    private static final int CUBE_VERSION_MICRO_NUMBER;
    private static final int CUBE_VERSION_MINOR_NUMBER;
    private static final String DELETE_PROPERTY_TEMPLATE;
    private static final String DIMENSION_DEFAULT_EMPTY_CHAR;
    private static final String DIMENSION_DEFAULT_EMPTY_NUM;
    private static final String DIMENSION_DEFAULT_IGNORE_EMPTY;
    private static final String DIMENSION_EMPTY_CHAR;
    private static final String DIMENSION_EMPTY_NUM;
    private static final String DIMENSION_IGNORE_EMPTY;
    private static final String DIM_KEY_DIMENSION;
    private static final String DIMENSION_KEY_NAME;
    private static final String EMPTY_STRING;
    private static final String FACT_KEY_DIMENSION;
    private static final String FACT_TABLE_KEY_NAME;
    private static final String FEATUREMAP_ESRIFILE_ROLE;
    private static final String FEATUREMAP_NAME;
    private static final String FEATUREMAP_ONETOONE_ROLE;
    private static final String FEATUREMAP_TRNSFORM_ROLE;
    private static final String HIERARCHY_ALL_MEMBER_CAPTION;
    private static final String LOAD_MAP_NAME;
    private static final String LOAD_TYPE_NWAY;
    private static final String MDEXCEPTION_MESSAGE;
    private static final String MEASURE_DIMENSION_TYPE;
    private static final String MEASURE_NUNIQUE;
    private static final String NAMED_SET;
    private static final String OLAP_ALL_MEMBER_CAPTION;
    private static final String OLAP_DESCRIPTION;
    private static final String OLAP_OPTION;
    private static final int OWNING_TYPE_BOOLEAN;
    private static final int OWNING_TYPE_STRING;
    private static final String PERFORMANCE_OPTION_DATAPATH;
    private static final String PERFORMANCE_OPTION_INDEXPATH;
    private static final String PLAIN_TEXT;
    private static final String READ_CUBE_TEMPLATE;
    private static boolean autoCommit;
    private static final String TRANSFORMATION_NAME;
    private static final String READ_LEVEL_TEMPLATE;
    private static final String READ_MEASURE_TEMPLATE;
    private static final String LOGGER_CONTEXT = "com.sas.olapadmin.migration";
    private ClassifierMap loadMap;
    private PhysicalTable loadTable;
    private String loadType;
    private MdObjectStore objectStore;
    private HashMap calcMeasureTransactions;

    public static UpgradeCubeAction getUpgradeCubeAction(Cube inputCube) throws RemoteException, MdException {
        return new UpgradeCubeAction(inputCube);
    }

    UpgradeCubeAction(Cube inputCube) throws RemoteException, MdException {
        this.jomaCube = inputCube;
        this.objectStore = (MdObjectStore)this.jomaCube.getObjectStore();
        this.objectStore.getFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.jomaCube, null, CUBE_ASSOCIATIONS, READ_CUBE_TEMPLATE, 524300);
        AssociationList maps = inputCube.getTargetClassifierMaps();
        if (!maps.isEmpty()) {
            this.loadMap = (ClassifierMap)maps.get(0);
            this.loadType = this.loadMap.getTransformRole();
            AssociationList sources = this.loadMap.getClassifierSources();
            if (!sources.isEmpty()) {
                this.loadTable = (PhysicalTable)sources.get(0);
            }
        }
        this.getLevelMeasureMetadata();
    }

    private void getLevelMeasureMetadata() throws RemoteException, MdException {
        Cube c = (Cube)this.jomaCube;
        ArrayList<String> levelAssociations = new ArrayList<String>();
        levelAssociations.add("TargetFeatureMaps");
        levelAssociations.add("TargetTransformations");
        levelAssociations.add("OLAPProperties");
        ArrayList<String> measureAssociations = new ArrayList<String>();
        measureAssociations.add("TargetFeatureMaps");
        measureAssociations.add("TargetTransformations");
        AssociationList dimensions = c.getDimensions();
        for (int j = dimensions.size() - 1; j >= 0; --j) {
            Dimension dimension = (Dimension)dimensions.get(j);
            AssociationList levels = dimension.getLevels();
            for (int k = levels.size() - 1; k >= 0; --k) {
                Level level = (Level)levels.get(k);
                this.objectStore.getFactory().getOMIUtil().getMetadataAllDepths((CMetadata)level, null, levelAssociations, READ_LEVEL_TEMPLATE, 524300);
            }
            AssociationList measures = dimension.getMeasures();
            for (int k = measures.size() - 1; k >= 0; --k) {
                Measure measure = (Measure)measures.get(k);
                this.objectStore.getFactory().getOMIUtil().getMetadataAllDepths((CMetadata)measure, null, measureAssociations, READ_MEASURE_TEMPLATE, 524300);
            }
        }
    }

    private void upgradeCubeName() throws RemoteException {
        this.upgradedCube.setCubeName(EMPTY_STRING);
    }

    private void upgradeCubeDescription() throws RemoteException, MdException {
        if (this.upgradedCube.getDesc().length() > 200) {
            AssociationList descriptions = this.upgradedCube.getNotes();
            boolean found = false;
            int i = descriptions.size() - 1;
            while (i >= 0 & !found) {
                TextStore textStore = (TextStore)descriptions.get(i);
                found = textStore.getName().equalsIgnoreCase(this.upgradedCube.getName() + "_Description");
                --i;
            }
            if (!found) {
                TextStore textStore = (TextStore)UpgradeCubeAction.createMetadata(this.objectStore, "TextStore", this.getRepositoryShortFQID());
                textStore.setName(this.upgradedCube.getName() + "_Description");
                textStore.setDesc(textStore.getName());
                textStore.setStoredText(this.upgradedCube.getDesc());
                textStore.setTextRole(OLAP_DESCRIPTION);
                textStore.setTextType(PLAIN_TEXT);
                descriptions.add((Object)textStore);
            }
        }
    }

    private void upgradeCubeVersion() throws RemoteException, MdException {
        UsageVersion usageVersion;
        double jomaVersion = this.upgradedCube.getUsageVersion();
        if (jomaVersion != (usageVersion = new UsageVersion(CUBE_VERSION_MAJOR_NUMBER, CUBE_VERSION_MINOR_NUMBER, CUBE_VERSION_MICRO_NUMBER)).encode()) {
            this.upgradedCube.setUsageVersion(usageVersion.encode());
        }
        AssociationList properties = this.upgradedCube.getProperties();
        Property version = null;
        for (int i = properties.size() - 1; i >= 0 && version == null; --i) {
            version = (Property)properties.get(i);
            if (version.getPropertyName().equalsIgnoreCase(CUBE_OPTION_VERSION_NAME)) {
                this.deleteMetadata(this.objectStore, (CMetadata)version, DELETE_PROPERTY_TEMPLATE, MDEXCEPTION_MESSAGE);
                continue;
            }
            version = null;
        }
    }

    private void upgradeProperty(Property property) throws RemoteException, MdException {
        PropertyType propertyType = property.getOwningType();
        if (propertyType != null) {
            property.setSQLType(propertyType.getSQLType());
            propertyType.delete();
        }
    }

    private void upgradeCubePropertiesCubeFolder(AssociationList properties) throws RemoteException, MdException {
        Property cubeFolder = (Property)UpgradeCubeAction.createMetadata(this.objectStore, "Property", this.getRepositoryShortFQID());
        cubeFolder.setName(CUBE_OPTION_CUBE_FOLDER);
        cubeFolder.setPropertyName(CUBE_OPTION_CUBE_FOLDER);
        cubeFolder.setPropertyRole(OLAP_OPTION);
        cubeFolder.setDefaultValue(this.upgradedCube.getName());
        cubeFolder.setSQLType(OWNING_TYPE_STRING);
        properties.add((Object)cubeFolder);
    }

    private void upgradePropertyTableOptions(Property property) throws RemoteException, MdException {
        String role = property.getPropertyRole();
        String name = property.getName();
        if (role.equals(CUBE_OPTION_TABLE_OPTIONS) && !name.equals(CUBE_OPTION_LOADTABLE_OPTION) && !name.equals(CUBE_OPTION_REACHTHRUTABLE_OPTION)) {
            property.setName(CUBE_OPTION_LOADTABLE_OPTION);
            property.setPropertyName(CUBE_OPTION_LOADTABLE_OPTION);
        }
    }

    private void upgradeCubeProperties() throws RemoteException, MdException {
        AssociationList properties = this.upgradedCube.getProperties();
        boolean hasCubeFolder = false;
        for (int i = properties.size() - 1; i >= 0; --i) {
            Property property = (Property)properties.get(i);
            String propertyname = property.getPropertyName();
            if (CUBE_OPTION_CUBE_FOLDER.equals(propertyname)) {
                hasCubeFolder = true;
            }
            this.upgradeProperty(property);
            this.upgradePropertyTableOptions(property);
        }
        if (!hasCubeFolder) {
            this.upgradeCubePropertiesCubeFolder(properties);
        }
    }

    private void upgradeCubePaths() throws RemoteException, MdException {
        this.upgradePaths((Root)this.upgradedCube);
    }

    private void upgradePaths(Root metadataObject) throws RemoteException, MdException {
        AssociationList properties = metadataObject.getProperties();
        for (int i = properties.size() - 1; i >= 0; --i) {
            Property property = (Property)properties.get(i);
            String propertyName = property.getPropertyName();
            if (!propertyName.equalsIgnoreCase(CUBE_OPTION_WORKPATH) && !propertyName.equalsIgnoreCase(PERFORMANCE_OPTION_DATAPATH) && !propertyName.equalsIgnoreCase(PERFORMANCE_OPTION_INDEXPATH)) continue;
            String path = property.getDefaultValue();
            List paths = this.getConcatenatedPaths(path);
            CustomAssociation custom = (CustomAssociation)UpgradeCubeAction.createMetadata(this.objectStore, "CustomAssociation", this.getRepositoryShortFQID());
            custom.setName(property.getPropertyName());
            custom.setPartnerName(property.getPropertyName());
            custom.setisOwned(0);
            AssociationList customs = metadataObject.getCustomAssociations();
            if (customs.indexOf((Object)custom) < 0) {
                customs.add((Object)custom);
            }
            AssociationList directories = custom.getAssociatedObjects();
            directories.clear();
            int size = paths.size();
            for (int j = 0; j < size; ++j) {
                Directory directory = (Directory)paths.get(j);
                directories.add((Object)directory);
            }
            property.delete();
        }
    }

    private void upgradeCubeFilename() throws RemoteException, MdException {
        AssociationList files = this.upgradedCube.getAssociatedFiles();
        StringBuffer cubeName = new StringBuffer();
        cubeName.append(this.upgradedCube.getName());
        if (!files.isEmpty()) {
            File file = (File)files.get(0);
            file.setFileName(cubeName.toString());
            file.setName(cubeName.append("_File").toString());
        }
    }

    private void upgradeCubeDirectory() throws RemoteException, MdException {
        AssociationList directories;
        AssociationList files = this.upgradedCube.getAssociatedFiles();
        File file = null;
        Directory directory = null;
        if (!files.isEmpty()) {
            file = (File)files.get(0);
        }
        if (file != null && !(directories = file.getDirectories()).isEmpty()) {
            directory = (Directory)directories.get(0);
        }
        if (directory != null) {
            StringBuffer path = new StringBuffer(directory.getDirectoryName());
            if (!directory.getDirectoryName().equals(CUBE_DIRECTORY_ROLE)) {
                directory = this.getDirectory(path.toString());
            }
            directory.setDirectoryName(path.toString());
            directory.setDirectoryRole(CUBE_DIRECTORY_ROLE);
        }
    }

    private void upgradeCube() throws RemoteException, MdException {
        this.upgradeCubeDescription();
        this.upgradeCubeVersion();
        this.upgradeCubePaths();
        this.upgradeCubeProperties();
        this.upgradeCubeFilename();
        this.upgradeCubeDirectory();
        this.upgradeCubeName();
    }

    private void upgradeLoadMapOLAPCubeConnection() throws RemoteException, MdException {
        OLAPSchema schema = this.upgradedCube.getAssociatedOLAPSchema();
        if (schema == null) {
            return;
        }
        StringBuffer defaultValue = new StringBuffer();
        defaultValue.append(this.upgradedCube.getName()).append("/").append(schema.getName());
        AssociationList properties = this.loadMap.getProperties();
        Property olapCubeConnection = (Property)UpgradeCubeAction.createMetadata(this.objectStore, "Property", this.getRepositoryShortFQID());
        olapCubeConnection.setName(CONNECTION);
        olapCubeConnection.setPropertyName(CONNECTION);
        olapCubeConnection.setPropertyRole(CONNECTION);
        olapCubeConnection.setDefaultValue(defaultValue.toString());
        olapCubeConnection.setSQLType(OWNING_TYPE_STRING);
        properties.add((Object)olapCubeConnection);
    }

    private void upgradeLoadMapTransformations() throws RemoteException, MdException {
        AssociationList transformations = this.loadMap.getSteps();
        String cubeName = this.upgradedCube.getName();
        if (!transformations.isEmpty()) {
            TransformationStep step = (TransformationStep)transformations.get(0);
            step.setName(cubeName);
            AssociationList stepProperties = step.getProperties();
            if (!stepProperties.isEmpty()) {
                Property transformationProperty = (Property)stepProperties.get(0);
                this.deleteMetadata(this.objectStore, (CMetadata)transformationProperty, DELETE_PROPERTY_TEMPLATE, MDEXCEPTION_MESSAGE);
            }
            if (!(transformations = step.getActivities()).isEmpty()) {
                TransformationActivity activity = (TransformationActivity)transformations.get(0);
                activity.setName(cubeName);
            }
        }
    }

    private void upgradeLoadMapJob() throws RemoteException, MdException {
        TransformationActivity activity;
        TransformationStep step;
        AssociationList transformations = this.loadMap.getSteps();
        if (!(transformations.isEmpty() || (transformations = (step = (TransformationStep)transformations.get(0)).getActivities()).isEmpty() || (transformations = (activity = (TransformationActivity)transformations.get(0)).getJobs()).isEmpty())) {
            AssociationList jobProperties;
            Job job = (Job)transformations.get(0);
            job.setPublicType("Job.CubeBuild");
            UsageVersion usageVersion = new UsageVersion(1, 0, 0);
            job.setUsageVersion(usageVersion.encode());
            AssociationList trees = job.getTrees();
            Tree tree = null;
            int max = 1;
            if (trees.isEmpty()) {
                AssociationList cubeTrees = this.jomaCube.getTrees();
                if (!cubeTrees.isEmpty()) {
                    tree = (Tree)cubeTrees.get(0);
                }
                max = 0;
            } else {
                tree = (Tree)trees.get(0);
            }
            String newName = Names.mapNameToOMRObjectName((String)job.getName());
            job.setName(newName);
            String baseName = job.getName();
            if (tree != null) {
                String name = baseName;
                int count = 0;
                while (!this.isJobNameUniqueInFolder(name, tree, max)) {
                    name = job.getName() + "(" + Integer.toString(++count) + ")";
                    if (name.length() <= 60) continue;
                    baseName = baseName.substring(0, baseName.length() + 60 - name.length());
                    name = baseName + "(" + Integer.toString(count) + ")";
                }
                job.setName(name);
                trees.clear();
                trees.add((Object)tree);
            }
            if (!(jobProperties = job.getProperties()).isEmpty()) {
                Property property = (Property)jobProperties.get(0);
                this.deleteMetadata(this.objectStore, (CMetadata)property, DELETE_PROPERTY_TEMPLATE, MDEXCEPTION_MESSAGE);
            }
        }
    }

    private void upgradeProperties(Root metadataObject) throws RemoteException, MdException {
        AssociationList properties = metadataObject.getProperties();
        for (int i = properties.size() - 1; i >= 0; --i) {
            this.upgradeProperty((Property)properties.get(i));
        }
    }

    private void upgradeLoadMap() throws RemoteException, MdException {
        if (this.loadMap == null) {
            return;
        }
        this.upgradeLoadMapOLAPCubeConnection();
        this.upgradeLoadMapTransformations();
        this.upgradeLoadMapJob();
    }

    private String getLoadFeatureMapName(Feature feature) throws RemoteException, MdException {
        String loadFeatureMapName = null;
        AssociationList featureMaps = feature.getTargetFeatureMaps();
        for (int i = featureMaps.size() - 1; i >= 0 && loadFeatureMapName == null; --i) {
            FeatureMap featureMap = (FeatureMap)featureMaps.get(i);
            ClassifierMap classifierMap = featureMap.getAssociatedClassifierMap();
            if (classifierMap == null || !classifierMap.getName().equalsIgnoreCase(LOAD_MAP_NAME)) continue;
            loadFeatureMapName = featureMap.getName();
        }
        return loadFeatureMapName;
    }

    private void upgradeAggregationsLevelsRolap(Aggregation aggregation) throws RemoteException, MdException {
        AssociationList levels = aggregation.getLevels();
        for (int j = levels.size() - 1; j >= 0; --j) {
            Level level = (Level)levels.get(j);
            AssociationList featureMaps = level.getTargetFeatureMaps();
            String loadFeatureMapName = this.getLoadFeatureMapName((Feature)level);
            for (int k = featureMaps.size() - 1; k >= 0; --k) {
                FeatureMap featureMap = (FeatureMap)featureMaps.get(k);
                String featureMapName = featureMap.getName();
                if (featureMapName.equalsIgnoreCase(loadFeatureMapName)) continue;
                StringBuffer name = new StringBuffer(aggregation.getName());
                if (featureMapName.indexOf(name.toString()) >= 0) {
                    name.append("_").append(level.getName()).append(FEATUREMAP_NAME);
                    featureMap.setName(name.toString());
                }
                featureMap.setTransformRole(FEATUREMAP_ONETOONE_ROLE);
                AssociationList associations = null;
                featureMaps.remove((Object)featureMap);
                associations = level.getTargetTransformations();
                if (!associations.contains((Object)featureMap)) {
                    associations.add((Object)featureMap);
                }
                AssociationList sources = featureMap.getFeatureSources();
                Column column = null;
                if (!sources.isEmpty()) {
                    column = (Column)sources.get(0);
                }
                if (column == null) continue;
                sources.remove((Object)column);
                associations = featureMap.getTransformationSources();
                if (associations.contains((Object)column)) continue;
                associations.add((Object)column);
            }
        }
    }

    private void upgradeFeature(Feature feature) throws RemoteException, MdException {
        FeatureMap changeFeatureMap;
        block5: {
            int j;
            AssociationList transformations;
            AssociationList featureMaps;
            block3: {
                block4: {
                    changeFeatureMap = null;
                    featureMaps = feature.getTargetFeatureMaps();
                    transformations = feature.getTargetTransformations();
                    if (!(feature instanceof OLAPProperty)) break block3;
                    if (featureMaps.isEmpty()) break block4;
                    changeFeatureMap = (FeatureMap)featureMaps.get(0);
                    break block5;
                }
                if (transformations.isEmpty()) break block5;
                changeFeatureMap = (FeatureMap)transformations.get(0);
                break block5;
            }
            for (j = featureMaps.size() - 1; j >= 0 && changeFeatureMap == null; --j) {
                changeFeatureMap = (FeatureMap)featureMaps.get(j);
                ClassifierMap classifierMap = changeFeatureMap.getAssociatedClassifierMap();
                if (classifierMap == null || !classifierMap.getTransformRole().equalsIgnoreCase(CLASSIFIERMAP_AGGREGATE_ROLE)) continue;
                changeFeatureMap = null;
            }
            for (j = transformations.size() - 1; j >= 0 && changeFeatureMap == null; --j) {
                ClassifierMap classifierMap;
                Object object = transformations.get(j);
                if (!(object instanceof FeatureMap) || (classifierMap = (changeFeatureMap = (FeatureMap)object).getAssociatedClassifierMap()) == null || !classifierMap.getTransformRole().equalsIgnoreCase(CLASSIFIERMAP_AGGREGATE_ROLE)) continue;
                changeFeatureMap = null;
            }
        }
        if (changeFeatureMap != null) {
            StringBuffer featureMapName = new StringBuffer(feature.getName());
            featureMapName.append(FEATUREMAP_NAME);
            changeFeatureMap.setName(featureMapName.toString());
        }
    }

    private void upgradeDimensionsLoadTableFeatureMaps(Level level) throws RemoteException, MdException {
        this.upgradeFeature((Feature)level);
    }

    private void upgradeAggregationsLevels() throws RemoteException, MdException {
        AssociationList aggregations = this.upgradedCube.getAggregations();
        for (int i = aggregations.size() - 1; i >= 0; --i) {
            Aggregation aggregation = (Aggregation)aggregations.get(i);
            if (!aggregation.getType().equalsIgnoreCase(AGGREGATION_TYPE_ROLAP)) continue;
            this.upgradeAggregationsLevelsRolap(aggregation);
        }
    }

    private void upgradeAggregationsPaths() throws RemoteException, MdException {
        AssociationList aggregations = this.upgradedCube.getAggregations();
        for (int i = aggregations.size() - 1; i >= 0; --i) {
            Aggregation aggregation = (Aggregation)aggregations.get(i);
            this.upgradePaths((Root)aggregation);
        }
    }

    private void upgradeAggregationsProperties() throws RemoteException, MdException {
        AssociationList aggregations = this.upgradedCube.getAggregations();
        for (int i = aggregations.size() - 1; i >= 0; --i) {
            Aggregation aggregation = (Aggregation)aggregations.get(i);
            this.upgradeProperties((Root)aggregation);
        }
    }

    private void upgradeAggregations() throws RemoteException, MdException {
        this.upgradeAggregationsLevels();
        this.upgradeAggregationsPaths();
        this.upgradeAggregationsProperties();
    }

    private void upgradeOLAPSchema() {
    }

    private void upgradeDimensionsFeatureMaps(Feature feature) throws RemoteException, MdException {
        AssociationList featureMaps = feature.getTargetFeatureMaps();
        for (int j = featureMaps.size() - 1; j >= 0; --j) {
            AssociationList targetTransformations;
            FeatureMap featureMap = (FeatureMap)featureMaps.get(j);
            ClassifierMap classifierMap = featureMap.getAssociatedClassifierMap();
            if (classifierMap == this.loadMap) continue;
            Column column = null;
            AssociationList sources = featureMap.getFeatureSources();
            if (!sources.isEmpty()) {
                column = (Column)sources.get(0);
            }
            if (!featureMap.getTransformRole().equals(FEATUREMAP_ESRIFILE_ROLE)) {
                featureMap.setTransformRole(FEATUREMAP_ONETOONE_ROLE);
            }
            featureMaps.remove((Object)featureMap);
            if (column != null) {
                sources.remove((Object)column);
            }
            if (!(targetTransformations = feature.getTargetTransformations()).contains((Object)featureMap)) {
                targetTransformations.add((Object)featureMap);
            }
            sources = featureMap.getTransformationSources();
            if (column == null || sources.contains((Object)column)) continue;
            sources.add((Object)column);
        }
    }

    private void upgradeDimensionsLevelsProperties(Level level) throws RemoteException, MdException {
        this.upgradeProperties((Root)level);
    }

    private void upgradeDimensionsLevels(Dimension dimension) throws RemoteException, MdException {
        AssociationList levels = dimension.getLevels();
        for (int i = levels.size() - 1; i >= 0; --i) {
            Level level = (Level)levels.get(i);
            level.setPublicType("Level");
            UsageVersion usageVersion = new UsageVersion(CUBE_VERSION_MAJOR_NUMBER, CUBE_VERSION_MINOR_NUMBER, CUBE_VERSION_MICRO_NUMBER);
            level.setUsageVersion(usageVersion.encode());
            this.upgradeDimensionsFeatureMaps((Feature)level);
            this.upgradeDimensionsLoadTableFeatureMaps(level);
            this.upgradeDimensionsLevelsProperties(level);
        }
    }

    private void upgradeDimensionsOLAPPropertiesProperties(OLAPProperty property) throws RemoteException, MdException {
        this.upgradeProperties((Root)property);
    }

    private void upgradeDimensionsOLAPProperties(Dimension dimension) throws RemoteException, MdException {
        AssociationList hierarchies = dimension.getHierarchies();
        for (int i = hierarchies.size() - 1; i >= 0; --i) {
            Hierarchy hierarchy = (Hierarchy)hierarchies.get(i);
            AssociationList properties = hierarchy.getOLAPProperties();
            for (int j = properties.size() - 1; j >= 0; --j) {
                OLAPProperty property = (OLAPProperty)properties.get(j);
                this.upgradeDimensionsFeatureMaps((Feature)property);
                this.upgradeDimensionsOLAPPropertiesProperties(property);
                this.upgradeFeature((Feature)property);
            }
        }
    }

    private void upgradeDimensionsESRIClassifierMap(Dimension dimension) throws RemoteException, MdException {
        AssociationList maps = dimension.getTargetClassifierMaps();
        ClassifierMap esriMap = null;
        for (int i = maps.size() - 1; i >= 0 && esriMap == null; --i) {
            esriMap = (ClassifierMap)maps.get(i);
            if (esriMap.getTransformRole().equalsIgnoreCase(CLASSIFIERMAP_ESRIFILE_ROLE)) continue;
            esriMap = null;
        }
        if (esriMap != null) {
            AssociationList classifierSources;
            maps.remove(esriMap);
            AssociationList targetTransformations = dimension.getTargetTransformations();
            if (!targetTransformations.contains((Object)esriMap)) {
                targetTransformations.add((Object)esriMap);
            }
            if (!(classifierSources = esriMap.getClassifierSources()).isEmpty()) {
                TableCollection collection = (TableCollection)classifierSources.get(0);
                classifierSources.remove((Object)collection);
                AssociationList transformationSources = esriMap.getTransformationSources();
                if (!transformationSources.contains((Object)collection)) {
                    transformationSources.add((Object)collection);
                }
            }
        }
    }

    private void upgradeDimensionsESRI(Dimension dimension) throws RemoteException, MdException {
        this.upgradeDimensionsESRIClassifierMap(dimension);
    }

    private boolean upgradeDimensionsRaggedOption(Property property, AssociationList dimensionProperties, String defaultOption, String optionType) throws RemoteException, MdException {
        boolean found = false;
        if (property.getName().equals(optionType)) {
            String optionValue = property.getDefaultValue().trim();
            found = true;
            if (!optionValue.equalsIgnoreCase(defaultOption)) {
                Property dimensionProperty = (Property)UpgradeCubeAction.createMetadata(this.objectStore, "Property", this.getRepositoryShortFQID());
                dimensionProperty.setName(optionType);
                dimensionProperty.setDesc(optionType);
                dimensionProperty.setPropertyName(optionType);
                dimensionProperty.setPropertyRole(OLAP_OPTION);
                dimensionProperty.setDefaultValue(optionValue);
                if (optionType.equals(DIMENSION_DEFAULT_IGNORE_EMPTY)) {
                    dimensionProperty.setSQLType(OWNING_TYPE_BOOLEAN);
                } else {
                    dimensionProperty.setSQLType(OWNING_TYPE_STRING);
                }
                dimensionProperties.add((Object)dimensionProperty);
            }
        }
        return found;
    }

    private void upgradeDimensionsRagged(Dimension dimension) throws RemoteException, MdException {
        int i;
        AssociationList hierarchies = dimension.getHierarchies();
        AssociationList dimensionProperties = dimension.getProperties();
        boolean foundEmptyChar = false;
        boolean foundEmptyNum = false;
        boolean foundIgnoreEmpty = false;
        ArrayList<Property> deleteProperties = new ArrayList<Property>();
        int hierarchiesSize = hierarchies.size();
        for (i = 0; i < hierarchiesSize; ++i) {
            Hierarchy hierarchy = (Hierarchy)hierarchies.get(i);
            AssociationList properties = hierarchy.getProperties();
            int propertiesSize = properties.size();
            for (int k = 0; k < propertiesSize; ++k) {
                Property property = (Property)properties.get(k);
                String name = property.getName();
                if (!name.equalsIgnoreCase(DIMENSION_EMPTY_CHAR) && !name.equalsIgnoreCase(DIMENSION_EMPTY_NUM) && !name.equalsIgnoreCase(DIMENSION_IGNORE_EMPTY)) continue;
                if (!foundEmptyChar) {
                    foundEmptyChar = this.upgradeDimensionsRaggedOption(property, dimensionProperties, DIMENSION_DEFAULT_EMPTY_CHAR, DIMENSION_EMPTY_CHAR);
                }
                if (!foundEmptyNum) {
                    foundEmptyNum = this.upgradeDimensionsRaggedOption(property, dimensionProperties, DIMENSION_DEFAULT_EMPTY_NUM, DIMENSION_EMPTY_NUM);
                }
                if (!foundIgnoreEmpty) {
                    foundIgnoreEmpty = this.upgradeDimensionsRaggedOption(property, dimensionProperties, DIMENSION_DEFAULT_IGNORE_EMPTY, DIMENSION_IGNORE_EMPTY);
                }
                deleteProperties.add(property);
            }
        }
        for (i = deleteProperties.size() - 1; i >= 0; --i) {
            Property property = (Property)deleteProperties.get(i);
            this.deleteMetadata(this.objectStore, (CMetadata)property, DELETE_PROPERTY_TEMPLATE, MDEXCEPTION_MESSAGE);
        }
    }

    private void upgradeDimensionsHierarchiesAllMember(Dimension dimension) throws RemoteException, MdException {
        AssociationList hierarchies = dimension.getHierarchies();
        for (int i = hierarchies.size() - 1; i >= 0; --i) {
            Hierarchy hierarchy = (Hierarchy)hierarchies.get(i);
            AssociationList properties = hierarchy.getProperties();
            boolean allMemberCaption = false;
            for (int j = properties.size() - 1; j >= 0 && !allMemberCaption; --j) {
                Property property = (Property)properties.get(j);
                allMemberCaption = property.getPropertyName().equalsIgnoreCase("AllMemberCaption");
            }
            if (allMemberCaption) continue;
            Property property = (Property)UpgradeCubeAction.createMetadata(this.objectStore, "Property", this.getRepositoryShortFQID());
            property.setName(HIERARCHY_ALL_MEMBER_CAPTION);
            property.setDesc(HIERARCHY_ALL_MEMBER_CAPTION);
            property.setPropertyName(HIERARCHY_ALL_MEMBER_CAPTION);
            property.setPropertyRole(OLAP_ALL_MEMBER_CAPTION);
            property.setSQLType(OWNING_TYPE_STRING);
            property.setDefaultValue(Message.format((ResourceBundle)RB.getResources(), (String)"OLAPHierarchy.AllMember.fmt.txt", (Object)hierarchy.getName()));
        }
    }

    private void upgradeDimensionsHierarchiesProperties(Dimension dimension) throws RemoteException, MdException {
        AssociationList hierarchies = dimension.getHierarchies();
        for (int i = hierarchies.size() - 1; i >= 0; --i) {
            Hierarchy hierarchy = (Hierarchy)hierarchies.get(i);
            this.upgradeProperties((Root)hierarchy);
        }
    }

    private void upgradeDimensionsHierarchies(Dimension dimension) throws RemoteException, MdException {
        AssociationList hierarchies = dimension.getHierarchies();
        for (int i = hierarchies.size() - 1; i >= 0; --i) {
            Hierarchy hierarchy = (Hierarchy)hierarchies.get(i);
            hierarchy.setPublicType("Hierarchy");
            UsageVersion usageVersion = new UsageVersion(CUBE_VERSION_MAJOR_NUMBER, CUBE_VERSION_MINOR_NUMBER, CUBE_VERSION_MICRO_NUMBER);
            hierarchy.setUsageVersion(usageVersion.encode());
        }
        this.upgradeDimensionsHierarchiesAllMember(dimension);
        this.upgradeDimensionsHierarchiesProperties(dimension);
    }

    private void upgradeDimensionsKeys(Dimension dimension) throws RemoteException, MdException {
        AssociationList targetTransformations = dimension.getTargetTransformations();
        if (!targetTransformations.isEmpty()) {
            Transformation transformation = (Transformation)targetTransformations.get(0);
            AssociationList customAssociations = dimension.getCustomAssociations();
            CustomAssociation dimKeyCustom = (CustomAssociation)UpgradeCubeAction.createMetadata(this.objectStore, "CustomAssociation", this.getRepositoryShortFQID());
            StringBuffer dimKeyName = new StringBuffer(dimension.getName());
            dimKeyCustom.setName(dimKeyName.append("_").append(DIMENSION_KEY_NAME).toString());
            dimKeyCustom.setisOwned(0);
            dimKeyCustom.setPartnerName(DIM_KEY_DIMENSION);
            customAssociations.add((Object)dimKeyCustom);
            AssociationList dimKeyObjects = dimKeyCustom.getAssociatedObjects();
            CustomAssociation factKeyCustom = (CustomAssociation)UpgradeCubeAction.createMetadata(this.objectStore, "CustomAssociation", this.getRepositoryShortFQID());
            StringBuffer factKeyName = new StringBuffer(dimension.getName());
            factKeyCustom.setName(factKeyName.append("_").append(FACT_TABLE_KEY_NAME).toString());
            factKeyCustom.setisOwned(0);
            factKeyCustom.setPartnerName(FACT_KEY_DIMENSION);
            customAssociations.add((Object)factKeyCustom);
            AssociationList factKeyObjects = factKeyCustom.getAssociatedObjects();
            AssociationList transformationSources = transformation.getTransformationSources();
            if (!transformationSources.isEmpty()) {
                AssociationList dimKeys;
                UniqueKey uniqueKey = (UniqueKey)transformationSources.get(0);
                PhysicalTable dimensionTable = (PhysicalTable)uniqueKey.getTable();
                if (dimensionTable != null) {
                    dimKeyObjects.add((Object)dimensionTable);
                }
                if (!(dimKeys = uniqueKey.getKeyedColumns()).isEmpty()) {
                    dimKeyObjects.add(dimKeys.get(0));
                }
                AssociationList foreignKeys = uniqueKey.getForeignKeys();
                ForeignKey foreignKey = null;
                for (int i = foreignKeys.size() - 1; i >= 0 && foreignKey == null; --i) {
                    foreignKey = (ForeignKey)foreignKeys.get(i);
                    PhysicalTable tempFactTable = (PhysicalTable)foreignKey.getTable();
                    if (this.loadTable == tempFactTable) {
                        AssociationList factKeys = foreignKey.getKeyedColumns();
                        if (factKeys.isEmpty()) continue;
                        factKeyObjects.add(factKeys.get(0));
                        continue;
                    }
                    foreignKey = null;
                }
            }
            targetTransformations.clear();
            transformation.delete();
        }
    }

    private void upgradeDimensionsProperties(Dimension dimension) throws RemoteException, MdException {
        this.upgradeProperties((Root)dimension);
    }

    private void upgradeDimensions() throws RemoteException, MdException {
        AssociationList dimensions = this.upgradedCube.getDimensions();
        for (int i = dimensions.size() - 1; i >= 0; --i) {
            Dimension dimension = (Dimension)dimensions.get(i);
            dimension.setPublicType("Dimension");
            UsageVersion usageVersion = new UsageVersion(CUBE_VERSION_MAJOR_NUMBER, CUBE_VERSION_MINOR_NUMBER, CUBE_VERSION_MICRO_NUMBER);
            dimension.setUsageVersion(usageVersion.encode());
            String measureDimensionName = RB.getStringResource("OLAPMeasure.MeasureDimensionName.txt");
            if (dimension.getName().equals(measureDimensionName)) continue;
            this.upgradeDimensionsKeys(dimension);
            this.upgradeDimensionsHierarchies(dimension);
            this.upgradeDimensionsLevels(dimension);
            this.upgradeDimensionsRagged(dimension);
            this.upgradeDimensionsOLAPProperties(dimension);
            this.upgradeDimensionsESRI(dimension);
            this.upgradeDimensionsProperties(dimension);
        }
    }

    private void upgradeMeasuresTransformRole(Measure measure, FeatureMap featureMap) throws RemoteException, MdException {
        if (!measure.getStatistic().equalsIgnoreCase(MEASURE_NUNIQUE)) {
            if (this.loadType.equalsIgnoreCase(LOAD_TYPE_NWAY)) {
                featureMap.setTransformRole(FEATUREMAP_ONETOONE_ROLE);
            } else {
                featureMap.setTransformRole(FEATUREMAP_TRNSFORM_ROLE);
            }
        }
    }

    private void upgradeMeasuresAggregationTable(Measure measure, FeatureMap featureMap) throws RemoteException, MdException {
        if (!measure.getStatistic().equalsIgnoreCase(MEASURE_NUNIQUE)) {
            AssociationList maps = measure.getTargetFeatureMaps();
            ClassifierMap classifierMap = featureMap.getAssociatedClassifierMap();
            if (classifierMap != null && !classifierMap.getName().equalsIgnoreCase(LOAD_MAP_NAME)) {
                featureMap.setTransformRole(FEATUREMAP_ONETOONE_ROLE);
                maps.remove((Object)featureMap);
                AssociationList transformations = measure.getTargetTransformations();
                if (!transformations.contains((Object)featureMap)) {
                    transformations.add((Object)featureMap);
                }
                AssociationList featureSources = featureMap.getFeatureSources();
                Column column = null;
                if (!featureSources.isEmpty()) {
                    column = (Column)featureSources.get(0);
                }
                if (column != null) {
                    featureSources.remove((Object)column);
                    AssociationList transformationSources = featureMap.getTransformationSources();
                    if (!transformationSources.contains((Object)column)) {
                        transformationSources.add((Object)column);
                    }
                }
            }
        }
    }

    private void upgradeMeasuresDerivedMeasures(Measure measure, FeatureMap featureMap) throws RemoteException, MdException {
    }

    private Dimension getMeasuresDimension() throws RemoteException, MdException {
        Dimension measureDimension = null;
        AssociationList dimensions = this.upgradedCube.getDimensions();
        for (int i = dimensions.size() - 1; i >= 0 && measureDimension == null; --i) {
            Dimension dimension = (Dimension)dimensions.get(i);
            if (!dimension.getDimensionType().equalsIgnoreCase(MEASURE_DIMENSION_TYPE)) continue;
            measureDimension = dimension;
        }
        return measureDimension;
    }

    private String getMeasuresDimensionName() throws RemoteException, MdException {
        Dimension measuresDimension = this.getMeasuresDimension();
        String measuresDimensionName = "";
        measuresDimensionName = measuresDimension != null ? measuresDimension.getName() : MEASURE_DIMENSION_TYPE;
        return measuresDimensionName;
    }

    private String getDimensionNameFromTextStore(String uniqueName) {
        String dimensionName = EMPTY_STRING;
        if (!UpgradeCubeAction.isBlank(uniqueName)) {
            int firstBracket;
            int pos = uniqueName.indexOf(46);
            if (pos > -1) {
                dimensionName = uniqueName.substring(0, pos);
            }
            if ((firstBracket = dimensionName.indexOf(91)) > -1) {
                int nextBracket = dimensionName.lastIndexOf(93);
                dimensionName = dimensionName.substring(firstBracket + 1, nextBracket);
            }
        }
        return dimensionName;
    }

    private void upgradeMeasuresCalculated() throws RemoteException, MdException {
        String measuresDimensionName = null;
        AssociationList notes = this.upgradedCube.getNotes();
        for (int i = notes.size() - 1; i >= 0; --i) {
            String dimensionName;
            String type;
            TextStore store = (TextStore)notes.get(i);
            String role = store.getTextRole();
            String uniqueName = store.getDesc();
            String expression = store.getStoredText();
            if (!role.equals(CALCULATED_MEMBER) && !role.equals(NAMED_SET)) continue;
            if (measuresDimensionName == null) {
                measuresDimensionName = this.getMeasuresDimensionName();
            }
            if ((type = store.getTextRole()).equals(CALCULATED_MEMBER) && (dimensionName = this.getDimensionNameFromTextStore(uniqueName)).equalsIgnoreCase(measuresDimensionName)) {
                type = CALCULATED_MEASURE;
            }
            Root metadataObject = null;
            metadataObject = type.equals(CALCULATED_MEASURE) ? (Root)UpgradeCubeAction.createMetadata(this.objectStore, "CalculatedMeasure", this.getRepositoryShortFQID()) : (Root)UpgradeCubeAction.createMetadata(this.objectStore, "GlobalFormula", this.getRepositoryShortFQID());
            metadataObject.setName(store.getName());
            if (metadataObject instanceof GlobalFormula) {
                GlobalFormula globalFormula = (GlobalFormula)metadataObject;
                globalFormula.setGlobalFormulaRole(type);
                globalFormula.setExpression(expression);
                globalFormula.setUniqueName(uniqueName);
                AssociationList formulas = this.upgradedCube.getFormulas();
                formulas.add((Object)globalFormula);
            } else if (metadataObject instanceof CalculatedMeasure) {
                CalculatedMeasure measure = (CalculatedMeasure)metadataObject;
                measure.setPublicType(CALCULATED_MEASURE_PUBLIC_TYPE);
                UsageVersion usageVersion = new UsageVersion(CUBE_VERSION_MAJOR_NUMBER, CUBE_VERSION_MINOR_NUMBER, CUBE_VERSION_MICRO_NUMBER);
                measure.setUsageVersion(usageVersion.encode());
                measure.setExpression(expression);
                measure.setUniqueName(uniqueName);
                Dimension measureDimension = this.getMeasuresDimension();
                AssociationList jomaDimensionMeasures = measureDimension.getMeasures();
                jomaDimensionMeasures.add((Object)measure);
                AssociationList measures = this.upgradedCube.getMeasures();
                measures.add((Object)measure);
                this.copySecurity((Measure)measure, store);
            }
            store.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copySecurity(Measure measure, TextStore textStore) {
        try {
            MdOMRConnection metadataWorkspace;
            MdFactory mdFactory;
            ISecurityAdmin securityAdmin = null;
            try {
                if (this.calcMeasureTransactions == null) {
                    this.calcMeasureTransactions = new HashMap();
                }
                mdFactory = this.objectStore.getFactory();
                metadataWorkspace = mdFactory.getConnection();
                IOMI iomInterface = metadataWorkspace.getCMRHandle();
                securityAdmin = metadataWorkspace.MakeISecurityAdminConnection(iomInterface);
                VariableArray2dOfAnyHolder oldAuthorizations = new VariableArray2dOfAnyHolder();
                String oldObjURIString = "OMSOBJ:" + textStore.getCMetadataType() + "/" + textStore.getFQID();
                StringHolder tcHolder = new StringHolder();
                securityAdmin.BeginTransactionContext(oldObjURIString, 0, tcHolder);
                String oldTC = tcHolder.value;
                String[][] identity = new String[][]{};
                securityAdmin.GetAuthorizationsOnObj(oldTC, oldObjURIString, 0, identity, "_ALL_", oldAuthorizations);
                Any[][] authorizations = oldAuthorizations.value;
                HashMap<String, Object> transactions = new HashMap<String, Object>();
                if (authorizations.length > 0) {
                    transactions.put("AUTHORIZATIONS", authorizations);
                }
                VariableArray2dOfStringHolder oldACTs = new VariableArray2dOfStringHolder();
                securityAdmin.GetACTsOnObj(oldTC, oldObjURIString, 0, oldACTs);
                String[][] acts = oldACTs.value;
                if (acts.length > 0) {
                    transactions.put("ACTS", acts);
                }
                this.calcMeasureTransactions.put(measure.getName(), transactions);
                if (securityAdmin == null) return;
            }
            catch (Exception exc) {
                try {
                    Logger logger = LogManager.getLogger((String)LOGGER_CONTEXT);
                    logger.error(exc.getLocalizedMessage(), (Throwable)exc);
                    if (securityAdmin == null) return;
                }
                catch (Throwable throwable) {
                    if (securityAdmin == null) throw throwable;
                    MdFactory mdFactory2 = this.objectStore.getFactory();
                    MdOMRConnection metadataWorkspace2 = mdFactory2.getConnection();
                    metadataWorkspace2.closeISecurityAdminConnection(securityAdmin);
                    throw throwable;
                }
                MdFactory mdFactory3 = this.objectStore.getFactory();
                MdOMRConnection metadataWorkspace3 = mdFactory3.getConnection();
                metadataWorkspace3.closeISecurityAdminConnection(securityAdmin);
                return;
            }
            mdFactory = this.objectStore.getFactory();
            metadataWorkspace = mdFactory.getConnection();
            metadataWorkspace.closeISecurityAdminConnection(securityAdmin);
            return;
        }
        catch (RemoteException exc) {
            Logger logger = LogManager.getLogger((String)LOGGER_CONTEXT);
            logger.error(exc.getLocalizedMessage(), (Throwable)exc);
            return;
        }
        catch (MdException exc) {
            Logger logger = LogManager.getLogger((String)LOGGER_CONTEXT);
            logger.error(exc.getLocalizedMessage(), (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commitCalcMeasureTransactions(Cube cube) {
        try {
            MdOMRConnection metadataWorkspace;
            MdFactory mdFactory;
            ISecurityAdmin securityAdmin = null;
            try {
                if (this.calcMeasureTransactions != null && !this.calcMeasureTransactions.isEmpty()) {
                    mdFactory = cube.getObjectStore().getFactory();
                    metadataWorkspace = mdFactory.getConnection();
                    IOMI iomInterface = metadataWorkspace.getCMRHandle();
                    securityAdmin = metadataWorkspace.MakeISecurityAdminConnection(iomInterface);
                    AssociationList measures = cube.getMeasures();
                    for (int i = 0; i < measures.size(); ++i) {
                        Measure measure = (Measure)measures.get(i);
                        if (!(measure instanceof CalculatedMeasure)) continue;
                        String newObjURIString = "OMSOBJ:" + measure.getCMetadataType() + "/" + measure.getFQID();
                        StringHolder newTCHolder = new StringHolder();
                        securityAdmin.BeginTransactionContext(newObjURIString, 0, newTCHolder);
                        String newTC = newTCHolder.value;
                        Map transactions = (Map)this.calcMeasureTransactions.get(measure.getName());
                        if (transactions != null) {
                            String[][] acts;
                            Any[][] authorizations = (Any[][])transactions.get("AUTHORIZATIONS");
                            if (authorizations != null) {
                                for (int j = 0; j < authorizations.length; ++j) {
                                    String permName = authorizations[j][3].extract_string();
                                    String condition = authorizations[j][4].extract_string();
                                    if ((authorizations[j][2].extract_long() & 2) != 0) {
                                        this.setAuthorization(securityAdmin, newTC, newObjURIString, authorizations[j][0].extract_string(), authorizations[j][1].extract_string(), permName, "G", condition);
                                        continue;
                                    }
                                    if ((authorizations[j][2].extract_long() & 1) == 0) continue;
                                    this.setAuthorization(securityAdmin, newTC, newObjURIString, authorizations[j][0].extract_string(), authorizations[j][1].extract_string(), permName, "D", condition);
                                }
                            }
                            if ((acts = (String[][])transactions.get("ACTS")) != null) {
                                for (int j = 0; j < acts.length; ++j) {
                                    String ACTspec = "OMSOBJ:AccessControlTemplate/" + acts[j][0];
                                    securityAdmin.ApplyACTToObj(newTC, newObjURIString, 0, ACTspec);
                                }
                            }
                        }
                        securityAdmin.EndTransactionContext(newTC, newObjURIString, 1);
                    }
                }
                if (securityAdmin == null) return;
            }
            catch (Exception e) {
                try {
                    Logger logger = LogManager.getLogger((String)LOGGER_CONTEXT);
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                    if (securityAdmin == null) return;
                }
                catch (Throwable throwable) {
                    if (securityAdmin == null) throw throwable;
                    MdFactory mdFactory2 = cube.getObjectStore().getFactory();
                    MdOMRConnection metadataWorkspace2 = mdFactory2.getConnection();
                    metadataWorkspace2.closeISecurityAdminConnection(securityAdmin);
                    throw throwable;
                }
                MdFactory mdFactory3 = cube.getObjectStore().getFactory();
                MdOMRConnection metadataWorkspace3 = mdFactory3.getConnection();
                metadataWorkspace3.closeISecurityAdminConnection(securityAdmin);
                return;
            }
            mdFactory = cube.getObjectStore().getFactory();
            metadataWorkspace = mdFactory.getConnection();
            metadataWorkspace.closeISecurityAdminConnection(securityAdmin);
            return;
        }
        catch (Exception exc) {
            Logger logger = LogManager.getLogger((String)LOGGER_CONTEXT);
            logger.error(exc.getLocalizedMessage(), (Throwable)exc);
        }
    }

    private void setAuthorization(ISecurityAdmin isecAdmin, String tctx, String uri, String identityType, String identityName, String permName, String type, String condition) {
        try {
            String[][] authorizations = new String[][]{{identityType, identityName, type, permName, condition}};
            isecAdmin.SetAuthorizationsOnObj(tctx, uri, 0, authorizations);
        }
        catch (Exception e) {
            Logger logger = LogManager.getLogger((String)LOGGER_CONTEXT);
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void upgradeMeasuresProperties(Measure measure) throws RemoteException, MdException {
        this.upgradeProperties((Root)measure);
    }

    private void upgradeMeasuresFeatureMapName(Measure measure, FeatureMap featureMap) throws RemoteException, MdException {
        AssociationList tables;
        ClassifierMap classifierMap = featureMap.getAssociatedClassifierMap();
        if (classifierMap != null && classifierMap != this.loadMap && !(tables = classifierMap.getTransformationSources()).isEmpty()) {
            PhysicalTable table = (PhysicalTable)tables.get(0);
            StringBuffer name = new StringBuffer(table.getName());
            name.append("_").append(measure.getName()).append(FEATUREMAP_NAME);
            featureMap.setName(name.toString());
        }
    }

    private void upgradeMeasuresNunique(Measure measure) throws RemoteException, MdException {
        AssociationList transformations = measure.getTargetTransformations();
        if (!transformations.isEmpty()) {
            String levelName = "";
            String hierarchyName = "";
            Transformation transformation = (Transformation)transformations.get(0);
            AssociationList sources = transformation.getTransformationSources();
            for (int i = sources.size() - 1; i >= 0; --i) {
                CMetadata metadataObject = (CMetadata)sources.get(i);
                if (metadataObject instanceof Level) {
                    levelName = metadataObject.getName();
                    continue;
                }
                hierarchyName = metadataObject.getName();
            }
            if (!UpgradeCubeAction.isBlank(levelName) && !UpgradeCubeAction.isBlank(hierarchyName)) {
                StringBuffer name = new StringBuffer();
                name.append(levelName).append("_").append(MEASURE_NUNIQUE).append("_").append(hierarchyName);
                name.append(TRANSFORMATION_NAME);
                transformation.setName(name.toString());
            }
        }
    }

    private void upgradeMeasures() throws RemoteException, MdException {
        AssociationList measures = this.upgradedCube.getMeasures();
        for (int i = measures.size() - 1; i >= 0; --i) {
            CMetadata object = (CMetadata)measures.get(i);
            if (!(object instanceof Measure)) continue;
            Measure measure = (Measure)object;
            if (measure instanceof CalculatedMeasure) {
                measure.setPublicType("CalculatedMeasure");
            } else if (measure instanceof Measure) {
                measure.setPublicType("Measure");
            }
            UsageVersion usageVersion = new UsageVersion(CUBE_VERSION_MAJOR_NUMBER, CUBE_VERSION_MINOR_NUMBER, CUBE_VERSION_MICRO_NUMBER);
            measure.setUsageVersion(usageVersion.encode());
            if (!measure.getStatistic().equalsIgnoreCase(MEASURE_NUNIQUE)) {
                AssociationList featureMaps = measure.getTargetFeatureMaps();
                for (int j = featureMaps.size() - 1; j >= 0; --j) {
                    FeatureMap featureMap = (FeatureMap)featureMaps.get(j);
                    this.upgradeMeasuresFeatureMapName(measure, featureMap);
                    this.upgradeMeasuresTransformRole(measure, featureMap);
                    this.upgradeMeasuresAggregationTable(measure, featureMap);
                    this.upgradeMeasuresDerivedMeasures(measure, featureMap);
                    this.upgradeMeasuresProperties(measure);
                }
                this.upgradeFeature((Feature)measure);
                continue;
            }
            this.upgradeMeasuresNunique(measure);
        }
        this.upgradeMeasuresCalculated();
    }

    public void upgrade() throws RemoteException, MdException {
        this.upgradedCube = (Cube)this.jomaCube;
        try {
            this.upgradeCube();
            this.upgradeLoadMap();
            this.upgradeAggregations();
            this.upgradeDimensions();
            this.upgradeMeasures();
            this.upgradeOLAPSchema();
            this.updateMetadata();
        }
        catch (RemoteException e) {
            this.upgradedCube = null;
            throw e;
        }
        catch (MdException e) {
            this.upgradedCube = null;
            throw e;
        }
    }

    void setTesting(boolean inputTesting) {
        autoCommit = !inputTesting;
    }

    public void setAutoCommit(boolean val) {
        autoCommit = val;
    }

    private void updateMetadata() throws RemoteException, MdException {
        if (autoCommit && this.upgradedCube != null) {
            this.upgradedCube.updateMetadataAll();
        }
    }

    private static boolean isBlank(String value) {
        return value == null || Strings.trimmedLength((String)value) == 0;
    }

    private static String trim(String input) {
        if (!UpgradeCubeAction.isBlank(input)) {
            input = input.trim();
            String tempInput = Strings.removeWhitespace((String)input);
            int index = input.indexOf(tempInput.charAt(0));
            input = input.substring(index, input.length());
        }
        return input;
    }

    private List getConcatenatedPaths(String inputPath) throws MdException, RemoteException {
        ArrayList<Directory> paths = new ArrayList<Directory>();
        if ((inputPath = UpgradeCubeAction.trim(inputPath)).startsWith("\"") || inputPath.startsWith("'")) {
            inputPath = "(" + inputPath + ")";
        }
        if (inputPath.startsWith("(") && inputPath.endsWith(")")) {
            StringBuffer path = new StringBuffer();
            char directoryDelimiter = '\"';
            boolean aDirectory = false;
            int pathLength = inputPath.length();
            for (int i = 1; i < pathLength; ++i) {
                char character = inputPath.charAt(i);
                if (!(aDirectory || character != '\"' && character != '\'')) {
                    directoryDelimiter = character;
                }
                if (aDirectory) {
                    if (character != directoryDelimiter) {
                        if (character == '\\') {
                            char tempChar = inputPath.charAt(i + 1);
                            if (tempChar == directoryDelimiter || tempChar == '\\') {
                                path.append(tempChar);
                                ++i;
                                continue;
                            }
                            path.append(character);
                            continue;
                        }
                        path.append(character);
                        continue;
                    }
                    if (character != directoryDelimiter || path.length() <= 0) continue;
                    Directory directory = this.getDirectory(path.toString());
                    paths.add(directory);
                    path.setLength(0);
                    aDirectory = false;
                    continue;
                }
                aDirectory = character == directoryDelimiter && path.length() == 0;
            }
            if (path.length() > 0) {
                Directory directory = this.getDirectory(path.substring(0, path.length() - 1).toString());
                paths.add(directory);
            }
        } else {
            Directory directory = this.getDirectory(inputPath);
            paths.add(directory);
        }
        return paths;
    }

    private static CMetadata createMetadata(MdObjectStore objectStore, String metadataType, String shortFQID) {
        CMetadata metadataObject = null;
        try {
            metadataObject = objectStore.getFactory().createComplexMetadataObject(objectStore, "", metadataType, shortFQID);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return metadataObject;
    }

    private String deleteMetadata(MdObjectStore objectStore, CMetadata metadataObject, String deleteTemplate, String error) throws RemoteException, MdException {
        String returnCode = EMPTY_STRING;
        if (deleteTemplate.equals(EMPTY_STRING)) {
            metadataObject.delete();
        } else {
            objectStore.removeObjectFromStore(metadataObject, deleteTemplate);
        }
        return returnCode;
    }

    private String getRepositoryShortFQID() throws RemoteException {
        return this.jomaCube.getId().substring(0, 8);
    }

    private Directory getDirectory(String directoryName) throws MdException, RemoteException {
        Directory directory = (Directory)UpgradeCubeAction.createMetadata(this.objectStore, "Directory", this.getRepositoryShortFQID());
        directory.setDirectoryName(directoryName);
        directory.setDirectoryRole(CUBE_DIRECTORY_ROLE);
        directory.setIsRelative(0);
        directory.setName(directoryName);
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isJobNameUniqueInFolder(String name, Tree tree, int max) {
        int numberOfItems;
        block10: {
            numberOfItems = 0;
            try {
                ISecurity_1_1 security = null;
                try {
                    String template = "<GetMetadataObjects><Reposid>";
                    String reposid = this.objectStore.getFactory().getOMIUtil().getReposIdFromMetadataObject((CMetadata)tree);
                    template = template + reposid;
                    template = template + "</Reposid><Type>Job</Type><Objects/><NS>SAS</NS>";
                    int flags = 8320;
                    template = template + "<Flags>" + Integer.toString(flags) + "</Flags><Options>";
                    String normName = XMLUtil.normalize((String)name);
                    template = template + "<XMLSelect search=" + '\"' + "Job[@Name='" + normName + "'][Trees/*[@Id='";
                    template = template + tree.getFQID() + "']]" + '\"' + "/>";
                    template = template + "<Templates></Templates></Options></GetMetadataObjects>";
                    VariableArray2dOfStringHolder returnAuths = new VariableArray2dOfStringHolder();
                    MdFactory mdFactory = this.objectStore.getFactory();
                    MdOMRConnection metadataWorkspace = mdFactory.getConnection();
                    IOMI iomInterface = metadataWorkspace.getCMRHandle();
                    security = metadataWorkspace.MakeISecurityConnection(iomInterface);
                    security.GetAuthorizations("getCountNoSecurity", "", template, "", returnAuths);
                    numberOfItems = Integer.valueOf(returnAuths.value[0][1]);
                    metadataWorkspace.closeISecurityConnection((ISecurity)security);
                    if (security != null) {
                    }
                    break block10;
                }
                catch (Exception exc) {
                    Logger logger = LogManager.getLogger((String)LOGGER_CONTEXT);
                    logger.error(exc.getLocalizedMessage(), (Throwable)exc);
                    break block10;
                }
                MdFactory mdFactory = this.objectStore.getFactory();
                MdOMRConnection metadataWorkspace = mdFactory.getConnection();
                metadataWorkspace.closeISecurityConnection((ISecurity)security);
                break block10;
                finally {
                    if (security != null) {
                        mdFactory = this.objectStore.getFactory();
                        metadataWorkspace = mdFactory.getConnection();
                        metadataWorkspace.closeISecurityConnection(security);
                    }
                }
            }
            catch (RemoteException exc) {
                Logger logger = LogManager.getLogger((String)LOGGER_CONTEXT);
                logger.error(exc.getLocalizedMessage(), (Throwable)exc);
            }
            catch (MdException exc) {
                Logger logger = LogManager.getLogger((String)LOGGER_CONTEXT);
                logger.error(exc.getLocalizedMessage(), (Throwable)exc);
            }
        }
        if (numberOfItems > max) return false;
        return true;
    }

    static {
        autoCommit = false;
        MDEXCEPTION_MESSAGE = RB.getStringResource("MdException.GenericError.txt");
        EMPTY_STRING = "";
        LOAD_TYPE_NWAY = "NWAY";
        LOAD_MAP_NAME = "Load Map";
        FEATUREMAP_ONETOONE_ROLE = "ONETOONE";
        FEATUREMAP_TRNSFORM_ROLE = "TRNSFORM";
        CLASSIFIERMAP_AGGREGATE_ROLE = "AGGREGATE";
        CLASSIFIERMAP_ESRIFILE_ROLE = "ESRI Map File";
        FEATUREMAP_ESRIFILE_ROLE = "ESRI Map Layer";
        FEATUREMAP_NAME = "_FeatureMap";
        TRANSFORMATION_NAME = "_transformation";
        MEASURE_NUNIQUE = "NUNIQUE";
        OLAP_DESCRIPTION = "OLAP Description";
        PLAIN_TEXT = "Plain Text";
        CONNECTION = "OLAPCubeConnection";
        CUBE_VERSION_MAJOR_NUMBER = 4;
        CUBE_VERSION_MINOR_NUMBER = 0;
        CUBE_VERSION_MICRO_NUMBER = 0;
        CUBE_OPTION_VERSION_NAME = "Version";
        CUBE_OPTION_CUBE_FOLDER = "CUBEFOLDER";
        CUBE_DIRECTORY_ROLE = "OLAPPath";
        OLAP_OPTION = "OLAPOption";
        OWNING_TYPE_BOOLEAN = -7;
        OWNING_TYPE_STRING = 12;
        CUBE_OPTION_WORKPATH = "WORKPATH";
        PERFORMANCE_OPTION_DATAPATH = "DATAPATH";
        PERFORMANCE_OPTION_INDEXPATH = "INDEXPATH";
        DIMENSION_EMPTY_CHAR = "EMPTY_CHAR";
        DIMENSION_EMPTY_NUM = "EMPTY_NUM";
        DIMENSION_IGNORE_EMPTY = "IGNORE_EMPTY";
        DIMENSION_DEFAULT_EMPTY_CHAR = RB.getStringResource("OLAPDimension.None.txt");
        DIMENSION_DEFAULT_EMPTY_NUM = RB.getStringResource("OLAPDimension.None.txt");
        DIMENSION_DEFAULT_IGNORE_EMPTY = "0";
        OLAP_ALL_MEMBER_CAPTION = "OLAPAllMemberCaption";
        HIERARCHY_ALL_MEMBER_CAPTION = "AllMemberCaption";
        CALCULATED_MEMBER = "Calculated Member";
        CALCULATED_MEASURE = "Calculated Measure";
        NAMED_SET = "Named Set";
        MEASURE_DIMENSION_TYPE = "MEASURES";
        CALCULATED_MEASURE_PUBLIC_TYPE = "CalculatedMeasure";
        DIMENSION_KEY_NAME = "DimKey";
        FACT_TABLE_KEY_NAME = "FactKey";
        CUBE_OPTION_LOADTABLE_OPTION = "LoadTable_options";
        CUBE_OPTION_REACHTHRUTABLE_OPTION = "ReachthruTable_options";
        CUBE_OPTION_TABLE_OPTIONS = "OLAP Table Options";
        DIM_KEY_DIMENSION = "DimKeyDimension";
        FACT_KEY_DIMENSION = "FactKeyDimension";
        CUBE_ASSOCIATIONS = new ArrayList();
        CUBE_ASSOCIATIONS.add("Aggregations");
        CUBE_ASSOCIATIONS.add("CustomAssociations");
        CUBE_ASSOCIATIONS.add("AssociatedFile");
        CUBE_ASSOCIATIONS.add("AssociatedOLAPSchema");
        CUBE_ASSOCIATIONS.add("Dimensions");
        CUBE_ASSOCIATIONS.add("Hierarchies");
        CUBE_ASSOCIATIONS.add("Measures");
        CUBE_ASSOCIATIONS.add("Properties");
        CUBE_ASSOCIATIONS.add("ReachThruTables");
        CUBE_ASSOCIATIONS.add("TargetClassifierMaps");
        CUBE_ASSOCIATIONS.add("Notes");
        CUBE_ASSOCIATIONS.add("TargetTransformations");
        CUBE_ASSOCIATIONS.add("Trees");
        CUBE_ASSOCIATIONS.add("NextGeneration");
        CUBE_ASSOCIATIONS.add("PreviousGeneration");
        CUBE_ASSOCIATIONS.add("Formulas");
        READ_CUBE_TEMPLATE = "<Templates><Aggregation><Levels/><Properties/></Aggregation><File><Directories/></File><Dimension><Hierarchies/><Levels/><Measures/><TargetClassifierMaps/><TargetTransformations/><Properties/><Notes/></Dimension><Hierarchy><Levels/><OLAPProperties/><Notes/><Properties/></Hierarchy><Measure><Notes/><Properties/></Measure><OLAPProperty><Properties/><Notes/></OLAPProperty><Property><DefaultValue/><StoredConfiguration/><OwningType/></Property><ClassifierMap><Properties/><ClassifierSources/><TransformationSources/><SourceCode/><Steps/></ClassifierMap><Level><Notes/><Properties/><OLAPProperties/></Level><Transformation><TransformationSources/></Transformation><TableCollection><CollectionLocations/></TableCollection><TransformationStep><Activities/><Properties/></TransformationStep><TransformationActivity><Jobs/><Properties/></TransformationActivity><Job><Properties/><Trees/></Job></Templates>";
        DELETE_PROPERTY_TEMPLATE = "<Templates><StoredConfiguration/></Templates>";
        READ_LEVEL_TEMPLATE = "<Templates><FeatureMap><AssociatedClassifierMap/><FeatureSources/><TransformationSources/></FeatureMap><OLAPProperty><TargetFeatureMaps/><TargetTransformations/></OLAPProperty></Templates>";
        READ_MEASURE_TEMPLATE = "<Templates><FeatureMap><AssociatedClassifierMap/><FeatureSources/><TransformationSources/></FeatureMap></Templates>";
    }
}

