/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFVariableExpression;
import java.util.NoSuchElementException;

public class JFVariableEvent
extends JFEvent {
    public static final int VARIABLE = 0;
    public static final String EVENT_GENERATOR_TYPE_VE = "variable";
    public static final String ELSE_EXPRESSION = "else";
    private String m_eventParent = "";
    private String m_generatorType = "variable";
    private JFVariableExpression m_expression = new JFVariableExpression("");
    String m_jobName = "";
    JFJob m_jobRef = null;

    public JFVariableEvent(JFJob jFJob, int n) {
        if (jFJob == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("VARIABLEEVENT_INVALID_TYPE"));
            }
        }
        this.m_jobRef = jFJob;
        this.m_generatorType = EVENT_GENERATOR_TYPE_VE;
        this.setAttribute("IsProxy", "No");
    }

    @Override
    public boolean isProxy() {
        String string = this.getAttribute("IsProxy");
        return string != null && string.equals("Yes");
    }

    public void validate() throws JFException {
        this.m_expression.validate();
    }

    public JFJob getEventJob() {
        if (this.m_jobRef == null) {
            String string = this.getJobName();
            String string2 = string.indexOf(":") != -1 ? string.substring(string.lastIndexOf(":") + 1, string.length()) : string;
            return new JFJob(string2, this.getEventGeneratorType());
        }
        return this.m_jobRef;
    }

    public JFVariableEvent() {
    }

    @Override
    public String getEventGeneratorType() {
        return this.m_generatorType;
    }

    public void setEventGeneratorType(String string) {
        this.m_generatorType = string;
    }

    @Override
    public String getExpression() {
        String string = this.m_expression.getExpression();
        return ELSE_EXPRESSION.equalsIgnoreCase(string) ? "Else" : string;
    }

    @Override
    public String getTooltip(String string, String string2) {
        String string3 = this.m_expression.getExpression();
        return ELSE_EXPRESSION.equalsIgnoreCase(string3) ? string + " Else " + string2 : "If " + string + " " + string3 + " then " + string2;
    }

    public void setExpression(String string) {
        this.m_expression.setExpression(string);
    }

    @Override
    public void initFromDefinition(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("EVENT_DEFN_NULL"));
        }
        try {
            int n = string.indexOf(44);
            this.m_jobName = string.substring(0, n);
            String string2 = string.substring(n + 1);
            this.m_expression.setExpression(string2);
            if (!ELSE_EXPRESSION.equalsIgnoreCase(string2)) {
                this.validate();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
        }
    }

    private int findFirstNotOf(String string, String string2) {
        if (string == null || string2 == null) {
            return -1;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string2.indexOf(string.charAt(i)) != -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String generateDefinition() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.getFullWorkItemName());
        stringBuffer.append(",");
        stringBuffer.append(this.m_expression.getExpression());
        this.m_eventParent = "";
        return stringBuffer.toString();
    }

    @Override
    String getFullWorkItemName() {
        String string = "";
        if (!this.isProxy()) {
            string = string + this.m_eventParent;
        }
        string = string + this.getJobName();
        return string;
    }

    public String getJobName() {
        if (this.isProxy()) {
            return this.m_jobName;
        }
        if (this.m_jobRef != null) {
            return this.m_jobRef.getName();
        }
        return this.m_jobName;
    }

    void setJobName(String string) {
        if (this.isProxy()) {
            this.m_jobName = string;
        } else {
            if (this.m_jobRef != null) {
                this.m_jobRef.setName(string);
            }
            this.m_jobName = string;
        }
    }

    @Override
    void setParentName(String string) {
        if (!string.equals("")) {
            this.m_eventParent = string + ":";
        }
    }

    @Override
    public String toString() {
        return this.getJobName() + "," + this.getExpression();
    }

    public String getEventDescription() {
        return this.getExpression();
    }

    @Override
    public void setEventObject(Object object) {
        this.m_jobRef = (JFJob)object;
    }
}

