/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFUserVarCheckReslt;
import com.platform.LSFJobFlow.api.JFUserVarErr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class JFUserVarFile {
    private String userVarFileName = null;

    public String getUserVarFileName() {
        return this.userVarFileName;
    }

    public void setUserVarFileName(String string) {
        this.userVarFileName = string;
    }

    public boolean isFile() {
        File file;
        boolean bl = false;
        if (null != this.userVarFileName && "" != this.userVarFileName && (file = new File(this.userVarFileName)).exists() && file.isFile()) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFileEmpty() {
        boolean bl = true;
        if (null == this.userVarFileName) return bl;
        if ("" == this.userVarFileName) return bl;
        File file = new File(this.userVarFileName);
        if (!file.exists()) return bl;
        if (!file.canRead()) return bl;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(this.userVarFileName);
            if (-1 == fileReader.read()) {
                bl = true;
                return bl;
            }
            bl = false;
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return bl;
        }
        finally {
            if (null != fileReader) {
                try {
                    try {
                        fileReader.close();
                        fileReader = null;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        fileReader = null;
                    }
                }
                catch (Throwable throwable) {
                    fileReader = null;
                    throw throwable;
                }
            }
        }
    }

    public boolean isFileExist() {
        File file;
        boolean bl = false;
        if (null != this.userVarFileName && "" != this.userVarFileName && (file = new File(this.userVarFileName)).exists()) {
            bl = true;
        }
        return bl;
    }

    public boolean canRead() {
        File file;
        boolean bl = false;
        if (null != this.userVarFileName && "" != this.userVarFileName && (file = new File(this.userVarFileName)).exists() && file.canRead()) {
            bl = true;
        }
        return bl;
    }

    public JFUserVarCheckReslt checkUserVarFile() {
        JFUserVarCheckReslt jFUserVarCheckReslt = new JFUserVarCheckReslt();
        if (!this.isFileExist()) {
            jFUserVarCheckReslt.setErrType(JFUserVarErr.FILE_NOTEXIST);
        } else if (!this.isFile()) {
            jFUserVarCheckReslt.setErrType(JFUserVarErr.NOT_FILE_ERR);
        } else if (!this.canRead()) {
            jFUserVarCheckReslt.setErrType(JFUserVarErr.NO_PERMISSION);
        } else if (this.isFileEmpty()) {
            jFUserVarCheckReslt.setErrType(JFUserVarErr.FILE_EMPTY);
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.userVarFileName));
                String string = bufferedReader.readLine();
                String string2 = "";
                int n = 1;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                while (string != null) {
                    if (JFDebug.debugMode) {
                        JFDebug.println("input user variables data is " + string);
                    }
                    if (!(jFUserVarCheckReslt = this.getVarListFromLine(string)).isFmtOK()) {
                        string2 = jFUserVarCheckReslt.getErrVarList();
                        jFUserVarCheckReslt.setErrType(JFUserVarErr.LINE_FILE_ERR);
                        jFUserVarCheckReslt.setErrLine(n);
                        jFUserVarCheckReslt.setErrVarList(string2);
                        break;
                    }
                    hashMap.putAll(jFUserVarCheckReslt.getVarMap());
                    jFUserVarCheckReslt.setVarMap(hashMap);
                    string = bufferedReader.readLine();
                    ++n;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                jFUserVarCheckReslt.setErrType(JFUserVarErr.FILE_NOTEXIST);
            }
            catch (IOException iOException) {
                jFUserVarCheckReslt.setErrType(JFUserVarErr.OTHER_ERR);
                System.out.println("The IO exception occured. Exception: " + iOException.getMessage());
            }
        }
        if (JFDebug.debugMode) {
            if (!jFUserVarCheckReslt.isFmtOK()) {
                JFDebug.println("Err line in file is " + String.valueOf(jFUserVarCheckReslt.getErrLine()));
                JFDebug.println("Err user variable in file is " + jFUserVarCheckReslt.getErrVarList());
            } else {
                JFDebug.println("Analysed successfully data in file is " + jFUserVarCheckReslt.getVarStrList());
            }
        }
        return jFUserVarCheckReslt;
    }

    private JFUserVarCheckReslt getVarListFromLine(String string) {
        JFUserVarCheckReslt jFUserVarCheckReslt = new JFUserVarCheckReslt();
        boolean bl = true;
        if (string.startsWith("#") || 0 == string.length()) {
            jFUserVarCheckReslt.setFmtOK(bl);
            return jFUserVarCheckReslt;
        }
        if (string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        jFUserVarCheckReslt = JFUserVarFile.getCheckedVarList(string);
        return jFUserVarCheckReslt;
    }

    public static JFUserVarCheckReslt getCheckedVarList(String string) {
        JFUserVarCheckReslt jFUserVarCheckReslt = new JFUserVarCheckReslt();
        String string2 = "";
        String string3 = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = false;
        if (string.isEmpty()) {
            bl = false;
        } else {
            if (JFDebug.debugMode) {
                JFDebug.println("To be analysed data is " + string);
            }
            if (string.contains("=")) {
                if (string.matches("(.*)[=](.*)[;]{2,}(.*)")) {
                    bl = false;
                    string2 = string;
                } else {
                    if (!string.endsWith(";") && !string.matches("(.*)[;]{1}[\\s]+")) {
                        string = string + ";";
                    }
                    string = string.trim();
                    String[] stringArray = string.split(";");
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string4 = stringArray[i];
                        int n = string4.indexOf(61);
                        if (n <= 0) {
                            bl = false;
                            string2 = string4;
                        } else {
                            String string5 = string4.substring(0, n);
                            if ((string5 = string5.trim()).length() == 0) {
                                bl = false;
                                string2 = string4;
                            } else {
                                String string6 = string5;
                                boolean bl2 = string6.matches("^[a-zA-Z_][a-zA-Z_0-9]*");
                                if (bl2 || JFCommon.isBuiltInVariableName(string6)) {
                                    hashMap.put(string6, string4.substring(n + 1, string4.length()));
                                    bl = true;
                                    if (!JFDebug.debugMode) continue;
                                    string3 = string3 + string5;
                                    if ((string3 = string3 + string4.substring(n, string4.length())).length() > 0) {
                                        string3 = string3 + ";";
                                    }
                                    JFDebug.println("Successfully analysed data is " + string3);
                                    continue;
                                }
                                bl = false;
                                string2 = string4;
                            }
                        }
                        break;
                    }
                }
            } else {
                bl = false;
                string2 = string;
            }
        }
        jFUserVarCheckReslt.setFmtOK(bl);
        if (!bl) {
            jFUserVarCheckReslt.setErrType(JFUserVarErr.NAME_VAR_ERR);
            jFUserVarCheckReslt.setErrVarList(string2);
        } else {
            jFUserVarCheckReslt.setVarMap(hashMap);
        }
        if (JFDebug.debugMode) {
            if (!bl) {
                JFDebug.println("Err analysed data is " + string2);
            } else {
                JFDebug.println("Successfully analysed data is " + string3);
            }
        }
        return jFUserVarCheckReslt;
    }
}

