/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFInvalidTemplateException;
import com.platform.LSFJobFlow.api.JFResource;
import java.text.MessageFormat;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JFTemplateParameterDef {
    public static final int STRING_PARAM = 0;
    public static final int INTEGER_PARAM = 1;
    public static final int FLOAT_PARAM = 2;
    public static final int FILE_PARAM = 3;
    public static final int FOLDER_PARAM = 4;
    public static final int FILE_TRANSFER_PARAM = 5;
    public static final int PASSWORD_PARAM = 6;
    private String m_name;
    private String m_caption;
    private int m_type;
    private boolean m_repeatable = false;
    private boolean m_required = true;
    private boolean m_readonly = false;
    private boolean m_lookup = false;
    private boolean m_hidden = false;
    private boolean m_encrypt = false;
    private JFTemplateChoiceDef[] m_choices;
    private String m_defaultVal;
    private String m_helpInfo;
    private String m_exprFormat;
    private boolean m_isExecParam;

    JFTemplateParameterDef(Element element, boolean bl) throws JFInvalidTemplateException {
        NodeList nodeList;
        String string;
        if (element == null) {
            throw new NullPointerException(JFResource.getString("TEMPLATE_PARAM_NULL"));
        }
        if (!element.hasAttribute("Name")) {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_NO_PARAM_NAME"));
        }
        this.m_isExecParam = bl;
        this.m_name = element.getAttribute("Name").trim();
        if (!JFTemplateParameterDef.isValidParameterName(this.m_name)) {
            String string2 = JFResource.getString("TEMPLATE_INVALID_PARA_NAME");
            MessageFormat messageFormat = new MessageFormat(string2);
            Object[] objectArray = new Object[]{this.m_name};
            string2 = messageFormat.format(objectArray);
            throw new JFInvalidTemplateException(string2);
        }
        if (element.hasAttribute("Caption")) {
            this.m_caption = element.getAttribute("Caption");
        }
        if ((string = element.getAttribute("Type")) == null || string.length() <= 0) {
            string = this.m_isExecParam ? this.getDefaultExecutionParamType(this.m_name) : "string";
        }
        String string3 = string;
        if ((string = string.toLowerCase()).equals("string")) {
            this.m_type = 0;
        } else if (string.equals("integer")) {
            this.m_type = 1;
        } else if (string.equals("float")) {
            this.m_type = 2;
        } else if (string.equals("file")) {
            this.m_type = 3;
        } else if (string.equals("folder")) {
            this.m_type = 4;
        } else if (string.equals("file_transfer")) {
            this.m_type = 5;
        } else if (string.equals("password")) {
            this.m_type = 6;
        } else {
            throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_INVALID_PARAM_TYPE", new Object[]{string3}));
        }
        String string4 = element.getAttribute("Repeatable");
        if (string4 != null && string4.toLowerCase().equals("true")) {
            this.m_repeatable = true;
        }
        this.m_exprFormat = element.hasAttribute("Expr") ? element.getAttribute("Expr") : "#{VALUE}";
        string4 = element.getAttribute("Required");
        if (string4 != null && string4.toLowerCase().equals("false")) {
            this.m_required = false;
        }
        if ((string4 = element.getAttribute("Readonly")) != null && string4.toLowerCase().equals("true")) {
            this.m_readonly = true;
        }
        if ((string4 = element.getAttribute("Lookup")) != null && string4.toLowerCase().equals("true")) {
            this.m_lookup = true;
        }
        if ((string4 = element.getAttribute("Hidden")) != null && string4.toLowerCase().equals("true")) {
            this.m_hidden = true;
        }
        if ((string4 = element.getAttribute("Encrypt")) != null && string4.toLowerCase().equals("true")) {
            this.m_encrypt = true;
        }
        if (element.hasAttribute("Default")) {
            this.m_defaultVal = element.getAttribute("Default");
            this.validate(this.m_defaultVal);
        }
        if ((nodeList = element.getElementsByTagName("Choice")) != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            this.m_choices = new JFTemplateChoiceDef[n];
            for (int i = 0; i < n; ++i) {
                this.m_choices[i] = new JFTemplateChoiceDef((Element)nodeList.item(i));
            }
        }
        if ((nodeList = element.getElementsByTagName("Help")) != null && nodeList.getLength() > 0) {
            this.m_helpInfo = ((Element)nodeList.item(0)).getFirstChild().getNodeValue().trim();
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getExpression(String string) {
        if (this.m_exprFormat == null || string == null) {
            return null;
        }
        return JFTemplateParameterDef.replaceString(this.m_exprFormat, "#{VALUE}", string);
    }

    public String getCaption() {
        return this.m_caption;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isRequired() {
        return this.m_required;
    }

    public boolean isRepeatable() {
        return this.m_repeatable;
    }

    public boolean isHidden() {
        return this.m_hidden;
    }

    public boolean isReadonly() {
        return this.m_readonly;
    }

    public boolean isLookup() {
        return this.m_lookup;
    }

    public boolean isEncrypt() {
        return this.m_encrypt;
    }

    public JFTemplateChoiceDef[] getChoices() {
        return this.m_choices;
    }

    public String getDefaultValue() {
        return this.m_defaultVal;
    }

    public String getValueCaption(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        if (this.m_type == 6) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                cArray[i] = 42;
            }
            return new String(cArray);
        }
        if (this.m_choices == null) {
            return string;
        }
        String string2 = string;
        int n = this.m_choices.length;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.m_choices[i].getValue())) continue;
            string2 = this.m_choices[i].getCaption();
            break;
        }
        return string2;
    }

    public String getHelpInfo() {
        return this.m_helpInfo;
    }

    static String replaceString(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() <= 0 || string3 == null) {
            return string;
        }
        int n = string2.length();
        int n2 = string3.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (String string4 = string; string4 != null; string4 = string4.substring(n3 + n)) {
            n3 = string4.indexOf(string2);
            if (n3 < 0) {
                stringBuffer.append(string4);
                break;
            }
            stringBuffer.append(string4.substring(0, n3));
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public void validate(String string) throws JFInvalidTemplateException {
        if (string == null) {
            throw new NullPointerException();
        }
        string = string.trim();
        switch (this.m_type) {
            case 0: {
                if (string.length() != 0) break;
                throw new JFInvalidTemplateException(JFResource.getString("PARAM_EMPTY_STRING"));
            }
            case 1: {
                try {
                    Integer.parseInt(string);
                    break;
                }
                catch (Exception exception) {
                    throw new JFInvalidTemplateException(JFResource.getString("PARAM_INVALID_INT"));
                }
            }
            case 2: {
                try {
                    Float.parseFloat(string);
                    break;
                }
                catch (Exception exception) {
                    throw new JFInvalidTemplateException(JFResource.getString("PARAM_INVALID_FLOAT"));
                }
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Parameter definition:\n");
        stringBuffer.append("Name=");
        stringBuffer.append(this.m_name);
        stringBuffer.append("\nExpr=");
        stringBuffer.append(this.m_exprFormat);
        stringBuffer.append("type=");
        stringBuffer.append(this.m_type);
        stringBuffer.append("required=");
        stringBuffer.append(this.m_required);
        stringBuffer.append("help=");
        stringBuffer.append(this.m_helpInfo);
        return stringBuffer.toString();
    }

    private String getDefaultExecutionParamType(String string) {
        if (string == null) {
            return "string";
        }
        if (string.equals("CoreSizeLimit") || string.equals("DataSizeLimit") || string.equals("FileSizeLimit") || string.equals("PeakMemLimit") || string.equals("PeakSwapLimit") || string.equals("StackSizeLimit")) {
            return "float";
        }
        if (string.equals("JobPriority")) {
            return "integer";
        }
        if (string.equals("LoginShell") || string.equals("Stdin") || string.equals("Stdout") || string.equals("Stderr")) {
            return "file";
        }
        if (string.equals("FileTransfer")) {
            return "file_transfer";
        }
        if (string.equals("ExclusiveExec") || string.equals("Hold") || string.equals("MailWhenFinish") || string.equals("MailWhenStart") || string.equals("Rerunable")) {
            this.m_choices = new JFTemplateChoiceDef[2];
            this.m_choices[0] = new JFTemplateChoiceDef("True", "Yes");
            this.m_choices[1] = new JFTemplateChoiceDef("False", "No");
            return "string";
        }
        if (string.equals("HostDependent") || string.equals("HostSelector") || string.equals("MailDestination") || string.equals("MinMaxCPU") || string.equals("ProjectName") || string.equals("QueueSelector") || string.equals("ResReqStr") || string.equals("RunTimeLimit") || string.equals("CPUTimeLimit") || string.equals("UserGroup") || string.equals("UserName") || string.equals("UserPreExecCmd")) {
            return "string";
        }
        return "string";
    }

    public static boolean isValidParameterName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }

    public final class JFTemplateChoiceDef {
        String m_caption;
        String m_value;

        JFTemplateChoiceDef(Element element) throws JFInvalidTemplateException {
            if (element == null) {
                throw new NullPointerException("<Elem> is null!");
            }
            if (!element.hasAttribute("Caption")) {
                throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_NO_CHOICE_CAPTION"));
            }
            this.m_caption = element.getAttribute("Caption");
            if (!element.hasAttribute("Value")) {
                throw new JFInvalidTemplateException(JFResource.getString("TEMPLATE_NO_CHOICE_VALUE"));
            }
            this.m_value = element.getAttribute("Value");
        }

        JFTemplateChoiceDef(String string, String string2) {
            this.m_caption = string;
            this.m_value = string2;
        }

        public String getCaption() {
            return this.m_caption;
        }

        public String getValue() {
            return this.m_value;
        }
    }
}

