/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTemplateDef;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Vector;

public class JFTemplateManager {
    private static JFTemplateManager m_instance;
    private StringBuffer m_errorMsgs;
    private File m_templateDir;
    private Vector m_templateRegistry = new Vector();

    public static synchronized JFTemplateManager getInstance() {
        if (m_instance == null) {
            m_instance = new JFTemplateManager();
        }
        return m_instance;
    }

    private JFTemplateManager() {
        this.initManager();
    }

    private void initManager() {
        this.m_errorMsgs = new StringBuffer();
        String string = JFConfigManager.getConfig("JS_TEMPLATE_DIR");
        boolean bl = false;
        try {
            this.m_templateDir = new File(string);
            if (!this.m_templateDir.isDirectory()) {
                this.m_templateDir = null;
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            string = JFConfigManager.getConfig("JS_WORK_DIR") + File.separator + "templates";
            try {
                this.m_templateDir = new File(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_templateDir == null || !this.m_templateDir.isDirectory()) {
            this.m_errorMsgs.append(JFResource.getString("DEFAULT_TEMP_DIR_ERR"));
            return;
        }
        File[] fileArray = this.m_templateDir.listFiles(new TemplateFileFilter());
        if (fileArray == null || fileArray.length <= 0) {
            return;
        }
        this.initTemplates(fileArray);
    }

    private void initTemplates(File[] fileArray) {
        JFTemplateDef jFTemplateDef = null;
        String string = null;
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            string = fileArray[i].getAbsolutePath();
            try {
                jFTemplateDef = new JFTemplateDef(string);
            }
            catch (Exception exception) {
                this.m_errorMsgs.append(string).append("\n").append(exception.getMessage()).append("\n");
            }
            if (jFTemplateDef == null || hashSet.contains(string2 = jFTemplateDef.getName())) continue;
            this.m_templateRegistry.add(new TemplateInfo(string2, string, jFTemplateDef));
            hashSet.add(string2);
        }
    }

    public JFTemplateDef[] getTemplates() {
        if (this.m_templateRegistry == null || this.m_templateRegistry.isEmpty()) {
            return null;
        }
        int n = this.m_templateRegistry.size();
        JFTemplateDef[] jFTemplateDefArray = new JFTemplateDef[n];
        for (int i = 0; i < n; ++i) {
            jFTemplateDefArray[i] = ((TemplateInfo)this.m_templateRegistry.get((int)i)).m_templateDef;
        }
        return jFTemplateDefArray;
    }

    public String getTemplateDir() {
        return this.m_templateDir.getAbsolutePath();
    }

    public Image getImageIcon(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.m_templateDir.getAbsolutePath() + System.getProperty("file.separator") + string;
        if (!string2.toLowerCase().endsWith(".gif")) {
            return null;
        }
        File file = null;
        try {
            file = new File(string2);
        }
        catch (Exception exception) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        return Toolkit.getDefaultToolkit().getImage(string2);
    }

    public String getXMLSource(String string) {
        TemplateInfo templateInfo = this.getTemplateRecord(string);
        String string2 = null;
        if (templateInfo != null) {
            string2 = templateInfo.m_templateFileName;
        }
        if (string2 == null) {
            return null;
        }
        try {
            File file = new File(string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            long l = file.length();
            byte[] byArray = new byte[(int)l];
            fileInputStream.read(byArray);
            return new String(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getErrorMsgs() {
        String string = this.m_errorMsgs.toString();
        if (string == null || string.length() <= 0) {
            return null;
        }
        return string;
    }

    public JFTemplateDef getTemplate(String string) {
        TemplateInfo templateInfo = this.getTemplateRecord(string);
        if (templateInfo != null) {
            return templateInfo.m_templateDef;
        }
        return null;
    }

    private TemplateInfo getTemplateRecord(String string) {
        if (this.m_templateRegistry == null || this.m_templateRegistry.isEmpty() || string == null) {
            return null;
        }
        int n = this.m_templateRegistry.size();
        Object var3_3 = null;
        for (int i = 0; i < n; ++i) {
            if (!string.equals(((TemplateInfo)this.m_templateRegistry.get((int)i)).m_templateName)) continue;
            return (TemplateInfo)this.m_templateRegistry.get(i);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            JFTemplateManager jFTemplateManager = JFTemplateManager.getInstance();
            System.out.println(jFTemplateManager.getTemplates().length);
            JFTemplateDef jFTemplateDef = jFTemplateManager.getTemplates()[0];
            JFTemplateDef jFTemplateDef2 = jFTemplateManager.getTemplates()[1];
            System.out.println(jFTemplateDef.getName());
            System.out.println(jFTemplateDef2.getName());
            System.out.println(jFTemplateDef.getExecutionParams().getParameterNum());
            System.out.println(jFTemplateDef.getExecutionParams().getParameter("MailDestination").getName());
            System.out.println(jFTemplateDef.getExecutionParams().getParameter("MailDestination").getCaption());
            System.out.println(jFTemplateDef.getExecutionParams().getParameter("MailDestination").getType());
            jFTemplateDef.getExecutionParams().getParameter("MailDestination").validate("123.23");
            System.out.println(jFTemplateDef.getSubmissionParams().getParameterNum());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getName());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getCaption());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getType());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getChoices()[1].getCaption());
            System.out.println(jFTemplateDef.getSubmissionParams().getParameter("Query_strands").getChoices()[1].getValue());
            System.out.println(jFTemplateDef);
            System.out.println(jFTemplateManager.getErrorMsgs());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class TemplateInfo {
        public String m_templateName;
        public String m_templateFileName;
        public JFTemplateDef m_templateDef;

        public TemplateInfo(String string, String string2, JFTemplateDef jFTemplateDef) {
            this.m_templateName = string;
            this.m_templateFileName = string2;
            this.m_templateDef = jFTemplateDef;
        }
    }

    public class TemplateFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            String string = file.getName();
            return string != null && string.toLowerCase().endsWith(".xml");
        }
    }
}

