/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFInvalidTemplateException;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTemplateData;
import com.platform.LSFJobFlow.api.JFTemplateDef;
import com.platform.LSFJobFlow.api.JFTemplateParameter;
import com.platform.LSFJobFlow.api.JFTemplateParameterList;
import com.platform.LSFJobFlow.api.JFXMLSource;
import com.platform.LSFJobFlow.api.JFXMLStringSource;
import java.io.IOException;
import org.w3c.dom.Element;

public class JFTemplateJob
extends JFJob
implements Cloneable {
    private JFTemplateData m_templateData;
    private JFTemplateDef m_templateDef;

    public JFTemplateJob() {
    }

    public JFTemplateJob(String string, JFTemplateDef jFTemplateDef) {
        super(string);
        if (jFTemplateDef == null) {
            throw new NullPointerException(JFResource.getString("PARAMETER_TEMPLATEDEF_NULL"));
        }
        this.m_templateDef = jFTemplateDef;
        this.m_templateData = new JFTemplateData(jFTemplateDef);
        this.setTemplateData(this.m_templateData);
    }

    JFTemplateJob(String string) {
        super(string);
    }

    JFTemplateJob(JFJob jFJob) {
        this.m_curUser = jFJob.m_curUser;
        this.m_defProps = jFJob.m_defProps;
        this.m_executionType = jFJob.m_executionType;
        this.m_handlerList = jFJob.m_handlerList;
        this.m_jobDefName = jFJob.m_jobDefName;
        this.m_subObject = jFJob.m_subObject;
    }

    public void setTemplateData(JFTemplateData jFTemplateData) {
        String string;
        String string2;
        if (jFTemplateData == null || jFTemplateData.getTemplateDefinition() == null) {
            return;
        }
        this.m_templateData = jFTemplateData;
        JFTemplateParameterList jFTemplateParameterList = this.m_templateData.getExecutionParameters();
        JFTemplateParameter[] jFTemplateParameterArray = null;
        if (jFTemplateParameterList != null) {
            jFTemplateParameterArray = jFTemplateParameterList.getParameters();
        }
        this.removeAllAttributes();
        if (jFTemplateParameterArray != null && jFTemplateParameterArray.length > 0) {
            int n = jFTemplateParameterArray.length;
            for (int i = 0; i < n; ++i) {
                string2 = jFTemplateParameterArray[i].getName();
                string = jFTemplateParameterArray[i].getExpression();
                if (string2 == null) continue;
                if (string != null) {
                    this.setAttribute(string2, string);
                    continue;
                }
                this.removeAttribute(string2);
            }
        }
        if ((string = this.getAttribute("UserName")) == null || string.equals("")) {
            this.setAttribute("UserName", JFLoginManager.getUserName());
        }
        if (this.m_templateData.hasAllRequiredSubmissionParams() && (string2 = this.createJobCmdLine(this.m_templateData.getSubmissionParameters())) != null) {
            this.setAttribute("JobCmdLine", string2);
        }
        this.m_executionType = this.m_templateData.getExecutionTypeString();
        if ("zos".equals(this.getExecutionType())) {
            this.setAttribute("JobCmdLine", "");
        }
    }

    public JFTemplateData getTemplateData() {
        return this.m_templateData;
    }

    public JFTemplateDef getTemplateDefinition() {
        if (this.m_templateDef == null && this.m_templateData != null) {
            this.m_templateDef = this.m_templateData.getTemplateDefinition();
        }
        return this.m_templateDef;
    }

    public void setTemplateDefinition(JFTemplateDef jFTemplateDef) {
        this.m_templateDef = jFTemplateDef;
        if (this.m_templateData == null) {
            this.m_templateData = new JFTemplateData(jFTemplateDef);
            this.setTemplateData(this.m_templateData);
        }
    }

    @Override
    public Object clone() {
        JFTemplateJob jFTemplateJob = (JFTemplateJob)super.clone();
        if (this.m_templateData != null) {
            jFTemplateJob.m_templateData = (JFTemplateData)this.m_templateData.clone();
        }
        if (this.m_templateDef != null) {
            jFTemplateJob.m_templateDef = this.m_templateDef;
        }
        return jFTemplateJob;
    }

    void initTemplateDataFromXML(Element element) throws JFInvalidTemplateException {
        if (element == null) {
            return;
        }
        this.m_templateData = new JFTemplateData(element);
    }

    private String createJobCmdLine(JFTemplateParameterList jFTemplateParameterList) {
        if (jFTemplateParameterList == null) {
            return null;
        }
        String string = this.getTemplateDefinition().getExecutionAction();
        JFTemplateParameter[] jFTemplateParameterArray = jFTemplateParameterList.getParameters();
        if (jFTemplateParameterArray == null || jFTemplateParameterArray.length <= 0) {
            return null;
        }
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(string);
        int n = jFTemplateParameterArray.length;
        for (int i = 0; i < n; ++i) {
            string2 = jFTemplateParameterArray[i].getExpression();
            if (string2 == null) continue;
            stringBuffer.append(" ");
            stringBuffer.append(string2);
        }
        return stringBuffer.toString().trim();
    }

    @Override
    public JFJob initFromDefinition(String string) throws JFException, IOException {
        JFXMLStringSource jFXMLStringSource = new JFXMLStringSource(string);
        JFJob jFJob = jFXMLStringSource.createJob();
        this.m_templateData = ((JFTemplateJob)jFJob).getTemplateData();
        this.setExecutionType(jFJob.getExecutionType());
        super.initFromDefinition(string);
        return this;
    }

    @Override
    String toXML(String string) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        String string2 = this.getName();
        if (string != null) {
            string2 = string + ":" + string2;
        }
        stringBuffer.append("\n<JobDef ExecutionType=\"" + this.m_executionType + "\" Name=\"" + string2 + "\"");
        stringBuffer.append(">");
        for (String string3 : this.m_defProps.keySet()) {
            if (string3.equals("PositionX") || string3.equals("PositionY")) continue;
            String string4 = this.m_defProps.getProperty(string3);
            if (string3.equals("HostDependent") && string != null) {
                string4 = JFXMLSource.mergeName(string, string4);
            }
            this.appendAttribute(stringBuffer, string3, JFXMLSource.convertToXMLAttrString(string4));
        }
        if (this.m_templateData != null) {
            stringBuffer.append("\n").append(this.m_templateData.toXML());
        }
        stringBuffer.append("\n</JobDef>");
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }
}

