/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFLocalHistoryRecord;
import com.platform.LSFJobFlow.api.JFResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;

public class JFLocalHistoryParser {
    private String m_historyDir;

    public JFLocalHistoryParser() throws JFException {
        JFConfigManager.init();
        this.m_historyDir = JFConfigManager.getConfig("JS_HISTORY_DIR");
        if (this.m_historyDir == null || this.m_historyDir.equals("")) {
            String string = JFConfigManager.getConfig("JS_WORK_DIR");
            if (string == null || string.equals("")) {
                throw new JFException(JFResource.getString("Cannot_obtain_history_dir"));
            }
            this.m_historyDir = string + File.separator + "history";
        }
    }

    public String getHistoryDirectory() {
        return this.m_historyDir;
    }

    public JFLocalHistoryRecord parseHistory(String string) throws JFException {
        return new JFLocalHistoryRecord(string);
    }

    static void main(String[] stringArray) throws Exception {
        String string;
        if (stringArray == null || stringArray.length < 1) {
            System.out.println("Provide a file name with history log on command line");
            System.exit(1);
        }
        JFLocalHistoryParser jFLocalHistoryParser = new JFLocalHistoryParser();
        System.out.println(jFLocalHistoryParser.getHistoryDirectory());
        BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
        while ((string = bufferedReader.readLine()) != null) {
            try {
                JFLocalHistoryRecord jFLocalHistoryRecord = jFLocalHistoryParser.parseHistory(string);
                JFLocalHistoryParser.displayRecord(jFLocalHistoryRecord);
            }
            catch (JFException jFException) {
                System.out.println("Exception: " + jFException.getMessage());
                System.out.println("=====================================================");
            }
        }
    }

    private static void displayRecord(JFLocalHistoryRecord jFLocalHistoryRecord) {
        String string;
        if (jFLocalHistoryRecord == null) {
            System.out.println("null record!!!!!!!!!!!!!!");
            return;
        }
        switch (jFLocalHistoryRecord.getCategory()) {
            case 0: {
                string = "DAEMON";
                break;
            }
            case 1: {
                string = "CALENDAR";
                break;
            }
            case 2: {
                string = "FLOWDEF";
                break;
            }
            case 3: {
                string = "FLOW";
                break;
            }
            case 4: {
                string = "JOB";
                break;
            }
            case 5: {
                string = "ALARM";
                break;
            }
            default: {
                string = "Error";
            }
        }
        System.out.println("Category: " + string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        System.out.println("Time stamp: " + simpleDateFormat.format(jFLocalHistoryRecord.getTimeStamp()));
        System.out.println("User name: " + jFLocalHistoryRecord.getUserName());
        System.out.println("Flow name: " + jFLocalHistoryRecord.getFlowName());
        System.out.println("Object name: " + jFLocalHistoryRecord.getObjectName());
        System.out.println("Action: " + jFLocalHistoryRecord.getAction());
        System.out.println("Action data: " + jFLocalHistoryRecord.getActionData());
        System.out.println("Action properties: " + jFLocalHistoryRecord.getActionProperties());
        System.out.println("=====================================================");
    }
}

