/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFFlowManager;
import com.platform.LSFJobFlow.api.JFFlowVersion;
import com.platform.LSFJobFlow.api.JFPseudoFlowInstance;
import com.platform.LSFJobFlow.api.JFStatusListener;
import com.platform.LSFJobFlow.api.JFUpdateMsg;
import java.util.HashMap;
import java.util.TreeMap;

public class JFFlowInstancesView
extends JFStatusListener {
    private static final String m_szTopic = "js_flowinstances";
    private JFFlowManager m_manager = null;
    private JFFilter m_filter = null;
    private HashMap m_PseudoFlowMap = new HashMap();
    private static Object mutex = new Object();

    public JFFlowInstancesView() throws Exception {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFFlowInstancesView(JFFilter jFFilter) throws Exception {
        this.m_filter = jFFilter;
        this.m_manager = new JFFlowManager();
        Object object = mutex;
        synchronized (object) {
            JFPseudoFlowInstance[] jFPseudoFlowInstanceArray = this.m_manager.getPseudoInstances(this.m_filter);
            for (int i = 0; i < jFPseudoFlowInstanceArray.length; ++i) {
                this.m_PseudoFlowMap.put(new Long(jFPseudoFlowInstanceArray[i].getInstanceId()), jFPseudoFlowInstanceArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(long l, int n) {
        if (this.m_PseudoFlowMap == null) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            ((JFPseudoFlowInstance)this.m_PseudoFlowMap.get(new Long(l))).setState(n);
        }
    }

    public void addNewFlowEntry(long l, String string, int n, JFFlowVersion jFFlowVersion) {
        this.addNewFlowEntry(l, string, n, jFFlowVersion, null);
    }

    public void addNewFlowEntry(long l, String string, int n, JFFlowVersion jFFlowVersion, String string2) {
        this.addNewFlowEntry(l, string, n, jFFlowVersion, string2, true);
    }

    public void addNewFlowEntry(long l, String string, int n, JFFlowVersion jFFlowVersion, boolean bl) {
        this.addNewFlowEntry(l, string, n, jFFlowVersion, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewFlowEntry(long l, String string, int n, JFFlowVersion jFFlowVersion, String string2, boolean bl) {
        JFPseudoFlowInstance jFPseudoFlowInstance = new JFPseudoFlowInstance(l, String.valueOf(l) + ":" + string, string, n, string2, bl);
        if (jFFlowVersion != null) {
            jFPseudoFlowInstance.setFlowVersion(jFFlowVersion);
        }
        Object object = mutex;
        synchronized (object) {
            this.m_PseudoFlowMap.put(new Long(l), jFPseudoFlowInstance);
        }
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void registerWithJMS() {
    }

    @Override
    public void unregisterWithJMS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws Exception {
        Object object = mutex;
        synchronized (object) {
            this.m_PseudoFlowMap.clear();
            JFPseudoFlowInstance[] jFPseudoFlowInstanceArray = this.m_manager.getPseudoInstances(this.m_filter);
            for (int i = 0; i < jFPseudoFlowInstanceArray.length; ++i) {
                this.m_PseudoFlowMap.put(new Long(jFPseudoFlowInstanceArray[i].getInstanceId()), jFPseudoFlowInstanceArray[i]);
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatusUpdate(JFUpdateMsg jFUpdateMsg) {
        String string = "JFFlowInstancesView::onStatusUpdate";
        JFDebug.println(string + ": Entered ...");
        Object object = mutex;
        synchronized (object) {
            String string2 = jFUpdateMsg.getAttributeValue("Name");
            int n = Integer.parseInt(jFUpdateMsg.getAttributeValue("Id"));
            Long l = new Long(n);
            JFDebug.println(string + ": Name: <" + string2 + "> Operation: <" + jFUpdateMsg.getOperation() + ">");
            if (jFUpdateMsg.getOperation().equals("Trigger")) {
                int n2 = Integer.parseInt(jFUpdateMsg.getAttributeValue("State"));
                String string3 = jFUpdateMsg.getAttributeValue("FlowDefName");
                String string4 = jFUpdateMsg.getAttributeValue("Owner");
                JFPseudoFlowInstance jFPseudoFlowInstance = new JFPseudoFlowInstance(n, string2, string3, n2, string4);
                this.m_PseudoFlowMap.put(l, jFPseudoFlowInstance);
            } else if (jFUpdateMsg.getOperation().equals("Remove")) {
                if (!this.m_PseudoFlowMap.containsKey(l)) {
                    return;
                }
                this.m_PseudoFlowMap.remove(l);
            } else if (jFUpdateMsg.getOperation().equals("StatusChange")) {
                JFPseudoFlowInstance jFPseudoFlowInstance = (JFPseudoFlowInstance)this.m_PseudoFlowMap.get(l);
                if (jFPseudoFlowInstance == null) {
                    return;
                }
                if (!string2.equals(jFPseudoFlowInstance.getInstanceName())) {
                    return;
                }
                int n3 = Integer.parseInt(jFUpdateMsg.getAttributeValue("State"));
                try {
                    int n4 = Integer.parseInt(jFUpdateMsg.getAttributeValue("ExitCode"));
                    String string5 = jFUpdateMsg.getAttributeValue("StartTime");
                    String string6 = jFUpdateMsg.getAttributeValue("FinishTime");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                jFPseudoFlowInstance.setState(n3);
            }
        }
        this.setChanged();
        this.notifyObservers();
        JFDebug.println(string + ": Finished...");
    }

    @Override
    public void setFilter(JFFilter jFFilter) {
        this.m_filter = jFFilter;
    }

    @Override
    public void removeFilter() {
        this.setFilter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFPseudoFlowInstance[] getFlowList() {
        Object object = mutex;
        synchronized (object) {
            TreeMap treeMap = new TreeMap(this.m_PseudoFlowMap);
            return treeMap.values().toArray(new JFPseudoFlowInstance[0]);
        }
    }

    public void finalize() {
    }
}

