/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFResource;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JFFlowExceptionEvent
extends JFEvent {
    public static final String EVENT_GENERATOR_TYPE = "flow_except";
    public static final int MISSCHEDULE = 0;
    public static final int CANNOT_RUN = 2;
    public static final int OVERRUN = 3;
    public static final int UNDERRUN = 4;
    protected int m_exceptType = -1;
    protected String m_eventParent = "";
    protected String m_flowName = "";
    JFFlow m_flowRef = null;
    protected int m_value = 0;

    public JFFlowExceptionEvent(JFFlow jFFlow, int n) {
        if (jFFlow == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        switch (n) {
            case 0: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                throw new IllegalArgumentException(JFResource.getString("EXCEPT_INIT_TYPE"));
            }
            default: {
                throw new IllegalArgumentException(JFResource.getString("JOBEVENT_INVALID_TYPE"));
            }
        }
        this.m_exceptType = n;
        this.m_flowRef = jFFlow;
    }

    public JFFlowExceptionEvent(JFFlow jFFlow, int n, int n2) {
        if (jFFlow == null) {
            throw new NullPointerException(JFResource.getString("EVENT_NULL"));
        }
        this.m_exceptType = n;
        this.m_flowRef = jFFlow;
        this.m_value = n2;
    }

    public int getEventType() {
        return this.m_exceptType;
    }

    public JFFlow getEventFlow() {
        return this.m_flowRef;
    }

    public int getValue() {
        if (this.m_exceptType != 3 && this.m_exceptType != 4) {
            throw new IllegalStateException(JFResource.getString("EXCEPT_TIME_REQD"));
        }
        return this.m_value;
    }

    public JFFlowExceptionEvent() {
    }

    @Override
    public String getEventGeneratorType() {
        return EVENT_GENERATOR_TYPE;
    }

    @Override
    public void initFromDefinition(String string) throws JFException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("EVENT_DEFN_NULL"));
        }
        try {
            String string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equalsIgnoreCase("Misschedule")) {
                this.m_exceptType = 0;
            } else if (string3.equalsIgnoreCase("CannotRun")) {
                this.m_exceptType = 2;
            } else if (string3.equalsIgnoreCase("Overrun")) {
                this.m_exceptType = 3;
            } else if (string3.equalsIgnoreCase("Underrun")) {
                this.m_exceptType = 4;
            }
            this.m_flowName = string2 = stringTokenizer.nextToken().trim();
            this.m_flowRef = new JFFlow(this.m_flowName);
            if (this.m_exceptType == 3 || this.m_exceptType == 4) {
                this.m_value = Integer.valueOf(stringTokenizer.nextToken().trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JFException(JFResource.getString("JOBEVENT_DEFN_NAN"));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
        }
    }

    @Override
    public String generateDefinition() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append(this.eventType());
        stringBuffer.append("," + this.getFullWorkItemName());
        if (this.m_exceptType == 3 || this.m_exceptType == 4) {
            stringBuffer.append("," + this.m_value);
        }
        this.m_eventParent = "";
        return stringBuffer.toString();
    }

    @Override
    String getFullWorkItemName() {
        return this.m_eventParent + this.getFlowName();
    }

    protected String eventType() {
        switch (this.m_exceptType) {
            case 0: {
                return "Misschedule";
            }
            case 2: {
                return "CannotRun";
            }
            case 3: {
                return "Overrun";
            }
            case 4: {
                return "Underrun";
            }
        }
        return "";
    }

    protected String eventTypeString() {
        switch (this.m_exceptType) {
            case 0: {
                return JFResource.getString("Misschedule");
            }
            case 2: {
                return JFResource.getString("CannotRun");
            }
            case 3: {
                return JFResource.getString("Overrun");
            }
            case 4: {
                return JFResource.getString("Underrun");
            }
        }
        return "";
    }

    protected String eventTypeDesc() {
        switch (this.m_exceptType) {
            case 0: {
                return JFResource.getString("EVENT_DESC_MISSCHEDULE");
            }
            case 2: {
                return JFResource.getString("EVENT_DESC_CANNOT_RUN");
            }
            case 3: {
                return JFResource.getString("EVENT_DESC_OVERRUN");
            }
            case 4: {
                return JFResource.getString("EVENT_DESC_UNDERRUN");
            }
        }
        return "";
    }

    public String getFlowName() {
        if (this.m_flowRef != null) {
            return this.m_flowRef.getName();
        }
        return this.m_flowName;
    }

    @Override
    void setParentName(String string) {
        if (!string.equals("")) {
            this.m_eventParent = string + ":";
        }
    }

    @Override
    public String toString() {
        return "Flow: " + this.getFlowName() + " " + this.eventTypeString() + " " + JFResource.getString("Exception");
    }

    @Override
    public String getEventTypeDescription() {
        String string;
        switch (this.m_exceptType) {
            case 3: 
            case 4: {
                String string2 = this.eventTypeDesc();
                String string3 = "";
                Object[] objectArray = new Object[]{string2, string3};
                String string4 = JFResource.getString("OVER_OR_UNDER_RUN_MINUTES");
                MessageFormat messageFormat = new MessageFormat(string4);
                string3 = string3 + this.m_value;
                string = messageFormat.format(objectArray);
                break;
            }
            default: {
                string = this.eventTypeDesc();
            }
        }
        return string;
    }

    @Override
    public String getExpression() {
        String string = "";
        switch (this.m_exceptType) {
            case 0: {
                string = "Misses schedule";
                break;
            }
            case 2: {
                string = "Cannot run";
                break;
            }
            case 3: {
                string = "Runs > " + this.m_value + " min";
                break;
            }
            case 4: {
                string = "Runs < " + this.m_value + " min";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public String getTooltip(String string, String string2) {
        String string3 = "";
        switch (this.m_exceptType) {
            case 0: {
                string3 = "If " + string + " misses schedule then " + string2;
                break;
            }
            case 2: {
                string3 = "If " + string + " cannot run then " + string2;
                break;
            }
            case 3: {
                string3 = "If " + string + " runs greater than " + this.m_value + " min then " + string2;
                break;
            }
            case 4: {
                string3 = "If " + string + " runs less than " + this.m_value + " min then " + string2;
                break;
            }
            default: {
                string3 = "";
            }
        }
        return string3;
    }
}

