/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFEventFactory;
import com.platform.LSFJobFlow.api.JFFilter;
import com.platform.LSFJobFlow.api.JFFlowDefinitionManager;
import com.platform.LSFJobFlow.api.JFFlowManager;
import com.platform.LSFJobFlow.api.JFInstanceManagerPolicy;
import com.platform.LSFJobFlow.api.JFPseudoFlow;
import com.platform.LSFJobFlow.api.JFStatusListener;
import com.platform.LSFJobFlow.api.JFUpdateMsg;
import java.util.HashMap;
import java.util.LinkedList;

public class JFFlowDefinitionView
extends JFStatusListener {
    private static final String m_szTopic = "js_flowdefinitions";
    private JFFlowDefinitionManager m_defManager = null;
    private JFInstanceManagerPolicy m_policy = null;
    private JFFilter m_filter = null;
    private HashMap m_PseudoFlowMap = new HashMap();
    private static Object mutex = new Object();

    public JFFlowDefinitionView() throws Exception {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFFlowDefinitionView(JFFilter jFFilter) throws Exception {
        this.m_policy = new JFFlowManager().getPolicyInfo();
        this.m_filter = jFFilter;
        this.m_defManager = new JFFlowDefinitionManager();
        Object object = mutex;
        synchronized (object) {
            JFPseudoFlow[] jFPseudoFlowArray = this.m_defManager.getPseudoFlows(this.m_filter);
            for (int i = 0; i < jFPseudoFlowArray.length; ++i) {
                this.m_PseudoFlowMap.put(jFPseudoFlowArray[i].getFlowName(), jFPseudoFlowArray[i]);
            }
        }
    }

    @Override
    public void registerWithJMS() {
    }

    @Override
    public void unregisterWithJMS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws Exception {
        Object object = mutex;
        synchronized (object) {
            this.m_PseudoFlowMap.clear();
            this.m_policy = new JFFlowManager().getPolicyInfo();
            JFPseudoFlow[] jFPseudoFlowArray = this.m_defManager.getPseudoFlows(this.m_filter);
            for (int i = 0; i < jFPseudoFlowArray.length; ++i) {
                this.m_PseudoFlowMap.put(jFPseudoFlowArray[i].getFlowName(), jFPseudoFlowArray[i]);
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateState(String string, int n) {
        if (this.m_PseudoFlowMap == null) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            ((JFPseudoFlow)this.m_PseudoFlowMap.get(string)).setState(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePublishState(String string, int n) {
        if (this.m_PseudoFlowMap == null) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            ((JFPseudoFlow)this.m_PseudoFlowMap.get(string)).setPublished(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFlow(String string) {
        if (this.m_PseudoFlowMap == null) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            this.m_PseudoFlowMap.remove(string);
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStatusUpdate(JFUpdateMsg jFUpdateMsg) {
        String string = "JFFlowDefinitionView::onStatusUpdate";
        JFDebug.println(string + ": Entered... ");
        Object object = mutex;
        synchronized (object) {
            String string2 = jFUpdateMsg.getAttributeValue("Name");
            if (jFUpdateMsg.getOperation().equals("Add")) {
                int n = Integer.parseInt(jFUpdateMsg.getAttributeValue("NumberOfEvents"));
                String string3 = jFUpdateMsg.getAttributeValue("State");
                int n2 = -1;
                if ("false".equals(string3)) {
                    n2 = 0;
                } else if ("true".equals(string3)) {
                    n2 = 1;
                }
                String string4 = "Event_";
                LinkedList<JFEvent> linkedList = null;
                if (n > 0) {
                    linkedList = new LinkedList<JFEvent>();
                    for (int i = 1; i <= n; ++i) {
                        string4 = string4 + Integer.toString(i);
                        String string5 = jFUpdateMsg.getAttributeValue(string4);
                        JFEvent jFEvent = null;
                        try {
                            jFEvent = JFEventFactory.getEventFactory().createEvent(string5);
                        }
                        catch (Exception exception) {
                            JFDebug.printStackTrace(exception);
                        }
                        linkedList.add(jFEvent);
                    }
                }
                JFPseudoFlow jFPseudoFlow = new JFPseudoFlow(string2, 0, linkedList);
                jFPseudoFlow.setState(n2);
                this.m_PseudoFlowMap.put(string2, jFPseudoFlow);
            } else if (jFUpdateMsg.getOperation().equals("Remove")) {
                this.m_PseudoFlowMap.remove(string2);
            } else if (jFUpdateMsg.getOperation().equals("Hold")) {
                ((JFPseudoFlow)this.m_PseudoFlowMap.get(string2)).setState(0);
            } else if (jFUpdateMsg.getOperation().equals("Release")) {
                ((JFPseudoFlow)this.m_PseudoFlowMap.get(string2)).setState(1);
            }
        }
        this.setChanged();
        this.notifyObservers();
        JFDebug.println(string + ": Finished ...");
    }

    @Override
    public void setFilter(JFFilter jFFilter) {
        this.m_filter = jFFilter;
    }

    @Override
    public void removeFilter() {
        this.setFilter(null);
    }

    public JFInstanceManagerPolicy getPolicy() {
        return this.m_policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFPseudoFlow[] getFlowDefList() {
        Object object = mutex;
        synchronized (object) {
            return this.m_PseudoFlowMap.values().toArray(new JFPseudoFlow[0]);
        }
    }

    public void finalize() {
    }
}

