/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFResource;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class JFFileEvent
extends JFEvent {
    public static final String EVENT_GENERATOR_TYPE = "FileAgent_v1.0";
    public static final String OP_NEGATION = "!";
    public static final String OP_NE = "!=";
    public static final String OP_EQ = "==";
    public static final String OP_GT = ">";
    public static final String OP_GTE = ">=";
    public static final String OP_LT = "<";
    public static final String OP_LTE = "<=";
    public static final String FILE_AGE = "age";
    public static final String FILE_ARRIVAL = "arrival";
    public static final String FILE_EXIST = "exist";
    public static final String FILE_SIZE = "size";
    public static final long VAL_NONE = -1L;
    private String m_fileName = null;
    private String m_fn = null;
    private String m_opr = null;
    private long m_value = -1L;

    public JFFileEvent() {
    }

    public JFFileEvent(String string, String string2, String string3, int n) throws JFException {
        this(string, string2, string3, (long)n);
    }

    public JFFileEvent(String string, String string2, String string3, long l) throws JFException {
        this.m_fileName = string;
        this.m_fn = string2;
        this.m_opr = string3;
        this.m_value = l;
        if (JFCommon.containNonASCIIChar(this.m_fileName)) {
            Object[] objectArray = new Object[]{JFResource.getString("File_Event_file_name")};
            String string4 = JFResource.getString("Localized_input_not_supported");
            MessageFormat messageFormat = new MessageFormat(string4);
            throw new JFException(messageFormat.format(objectArray));
        }
        if (this.m_fileName == null || this.m_fileName.equals("")) {
            throw new JFException(JFResource.getString("FILEEVENT_DEFN_NAME"));
        }
        if (this.m_fn.equals(FILE_AGE) || this.m_fn.equals(FILE_SIZE)) {
            if (this.m_opr == null) {
                throw new JFException(JFResource.getString("FILEEVENT_DEFN_OP"));
            }
            if (!(this.m_opr.equals(OP_NE) || this.m_opr.equals(OP_EQ) || this.m_opr.equals(OP_GT) || this.m_opr.equals(OP_GTE) || this.m_opr.equals(OP_LT) || this.m_opr.equals(OP_LTE))) {
                throw new JFException(JFResource.getString("FILEEVENT_DEFN_OP"));
            }
            if (this.m_value < 0L) {
                throw new JFException(JFResource.getString("FILEEVENT_DEFN_VALUE"));
            }
        } else if (this.m_fn.equals(FILE_ARRIVAL)) {
            if (this.m_opr != null) {
                throw new JFException(JFResource.getString("FILEEVENT_DEFN_OP"));
            }
            if (this.m_value != -1L) {
                throw new JFException(JFResource.getString("FILEEVENT_DEFN_VALUE"));
            }
        } else if (this.m_fn.equals(FILE_EXIST)) {
            if (this.m_opr != null && this.m_opr != OP_NEGATION) {
                throw new JFException(JFResource.getString("FILEEVENT_DEFN_OP"));
            }
            if (this.m_value != -1L) {
                throw new JFException(JFResource.getString("FILEEVENT_DEFN_VALUE"));
            }
        } else {
            throw new JFException(JFResource.getString("FILEEVENT_DEFN_TYPE"));
        }
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getEventType() {
        return this.m_fn;
    }

    public String getOperator() {
        return this.m_opr;
    }

    public long getLongValue() {
        return this.m_value;
    }

    public int getValue() {
        return (int)this.m_value;
    }

    protected void validateName() throws JFException {
        String string = this.getFileName();
        if (string.indexOf("(") != -1 || string.indexOf(")") != -1) {
            throw new JFException(JFResource.getString("EVENT_FILENAME_ERR"));
        }
    }

    @Override
    public String getEventGeneratorType() {
        return EVENT_GENERATOR_TYPE;
    }

    @Override
    public void initFromDefinition(String string) throws JFException {
        Object object;
        try {
            int n = string.indexOf("(");
            int n2 = string.lastIndexOf(")");
            object = string.substring(n + 1, n2);
            if (((String)object).indexOf("(") != -1 || ((String)object).indexOf(")") != -1) {
                throw new JFException(JFResource.getString("EVENT_FILENAME_ERR"));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "()");
            switch (stringTokenizer.countTokens()) {
                case 2: {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (string2.startsWith(OP_NEGATION)) {
                        this.m_opr = OP_NEGATION;
                        this.m_fn = string2.substring(1).trim();
                        if (!this.m_fn.equals(FILE_EXIST)) {
                            throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
                        }
                    } else if (string2.startsWith(FILE_EXIST)) {
                        this.m_fn = FILE_EXIST;
                        this.m_opr = null;
                    } else if (string2.startsWith(FILE_ARRIVAL)) {
                        this.m_fn = FILE_ARRIVAL;
                        this.m_opr = null;
                    } else {
                        throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
                    }
                    this.m_fileName = stringTokenizer.nextToken().trim();
                    this.m_value = -1L;
                    break;
                }
                case 3: {
                    this.m_fn = stringTokenizer.nextToken().trim();
                    if (!this.m_fn.equals(FILE_AGE) && !this.m_fn.equals(FILE_SIZE)) {
                        throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
                    }
                    this.m_fileName = stringTokenizer.nextToken().trim();
                    String string3 = stringTokenizer.nextToken().trim();
                    if (string3.startsWith(OP_GT) && !string3.startsWith(OP_GTE)) {
                        this.m_opr = string3.substring(0, OP_GT.length());
                        this.m_value = Long.parseLong(string3.substring(OP_GT.length()).trim());
                    }
                    if (string3.startsWith(OP_LT) && !string3.startsWith(OP_LTE)) {
                        this.m_opr = string3.substring(0, OP_LT.length());
                        this.m_value = Long.parseLong(string3.substring(OP_LT.length()).trim());
                    }
                    if (string3.startsWith(OP_NE) || string3.startsWith(OP_EQ) || string3.startsWith(OP_GTE) || string3.startsWith(OP_LTE)) {
                        this.m_opr = string3.substring(0, OP_NE.length());
                        this.m_value = Long.parseLong(string3.substring(OP_NE.length()).trim());
                    }
                    if (null == this.m_opr || this.m_value < 0L) {
                        throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
                    }
                    break;
                }
                default: {
                    throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new JFException(JFResource.getString("EVENT_DEFN_INC"));
        }
        if (JFCommon.containNonASCIIChar(this.m_fileName)) {
            Object[] objectArray = new Object[]{JFResource.getString("File_Event_file_name")};
            String string4 = JFResource.getString("Localized_input_not_supported");
            object = new MessageFormat(string4);
            throw new JFException(((Format)object).format(objectArray));
        }
    }

    public void initFromCLIDefinition(String string) throws JFException {
        this.initFromDefinition(string);
    }

    @Override
    public String generateDefinition() {
        StringBuffer stringBuffer = new StringBuffer(12);
        if (this.m_opr == null) {
            stringBuffer.append(this.m_fn + " (" + this.m_fileName + ")");
        } else if (this.m_opr.equals(OP_NEGATION)) {
            stringBuffer.append(this.m_opr + " " + this.m_fn + " (" + this.m_fileName + ")");
        } else {
            stringBuffer.append(this.m_fn + " (" + this.m_fileName + ") " + this.m_opr + " " + this.m_value);
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        String string = "\"" + (this.m_fileName == null ? "" : this.m_fileName) + "\"  ";
        if (FILE_ARRIVAL.equals(this.m_fn)) {
            string = string + "Arrives";
        } else if (FILE_EXIST.equals(this.m_fn)) {
            string = OP_NEGATION.equals(this.m_opr) ? string + "Not exist" : string + "Exist";
        } else if (FILE_AGE.equals(this.m_fn)) {
            string = string + "Last modified " + (this.m_opr == null ? "" : this.m_opr + (this.m_value == -1L ? "" : " " + this.m_value + " min"));
        } else if (FILE_SIZE.equals(this.m_fn)) {
            string = string + "Size " + (this.m_opr == null ? "" : this.m_opr);
            if (this.m_value != -1L) {
                DecimalFormat decimalFormat = new DecimalFormat("#.##");
                string = this.m_value >= 0x100000L ? string + " " + decimalFormat.format((double)this.m_value / 1048576.0) + "MB" : (this.m_value >= 1024L ? string + " " + decimalFormat.format((double)this.m_value / 1024.0) + "KB" : string + " " + decimalFormat.format((double)this.m_value) + "Bytes");
            }
        }
        return string;
    }

    private String opDesc() {
        if (this.m_opr != null) {
            if (this.m_opr.equals(OP_LT)) {
                return JFResource.getString("OP_DESC_LESS_THAN");
            }
            if (this.m_opr.equals(OP_LTE)) {
                return JFResource.getString("OP_DESC_LESS_THAN_OR_EQUAL_TO");
            }
            if (this.m_opr.equals(OP_EQ)) {
                return JFResource.getString("OP_DESC_EQUAL_TO");
            }
            if (this.m_opr.equals(OP_GT)) {
                return JFResource.getString("OP_DESC_GREATER_THAN");
            }
            if (this.m_opr.equals(OP_GTE)) {
                return JFResource.getString("OP_DESC_GREATER_THAN_OR_EQUAL_TO");
            }
            if (this.m_opr.equals(OP_NE)) {
                return JFResource.getString("OP_DESC_NOT_EQUAL_TO");
            }
        }
        return "";
    }

    @Override
    public String getTooltip(String string, String string2) {
        String string3 = "";
        if (this.m_fn.equals(FILE_EXIST)) {
            string3 = OP_NEGATION.equals(this.m_opr) ? "If " + "\"" + (this.m_fileName == null ? "" : this.m_fileName) + "\" " + "does not exist then " + string2 : "If " + "\"" + (this.m_fileName == null ? "" : this.m_fileName) + "\" " + "exists then " + string2;
        } else if (this.m_fn.equals(FILE_ARRIVAL)) {
            string3 = "If " + "\"" + (this.m_fileName == null ? "" : this.m_fileName) + "\" " + "arrives then " + string2;
        } else if (this.m_fn.equals(FILE_AGE)) {
            string3 = "If " + "\"" + (this.m_fileName == null ? "" : this.m_fileName) + "\"" + "'s age is " + this.opDesc() + " " + this.m_value + " min then " + string2;
        } else if (this.m_fn.equals(FILE_SIZE)) {
            string3 = "If " + "\"" + (this.m_fileName == null ? "" : this.m_fileName) + "\"" + "'s size is " + this.opDesc() + " " + this.m_value + " byte then " + string2;
        }
        return string3;
    }
}

