/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFDynamicFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFDynamicFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFDynamicFlowEvent;
import com.platform.LSFJobFlow.api.JFDynamicFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFileEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobArrayEvent;
import com.platform.LSFJobFlow.api.JFJobArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.api.JFLinkEvent;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFTimeEvent;
import com.platform.LSFJobFlow.api.JFVariableEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

final class JFEventFactory {
    private static Object mutex = new Object();
    private static JFEventFactory m_factory = null;
    private Map m_registry = new Hashtable();

    private JFEventFactory() throws JFException {
        try {
            this.registerConfigurationEvents();
        }
        catch (IOException iOException) {
            throw new JFException(JFResource.getString("EVENTS_CONFIG_ERROR"));
        }
        JFJobEvent jFJobEvent = new JFJobEvent();
        this.registerEvent("lsf", jFJobEvent.getClass());
        this.registerEvent("manual", jFJobEvent.getClass());
        this.registerEvent("local", jFJobEvent.getClass());
        this.registerEvent("otherbatch", jFJobEvent.getClass());
        JFVariableEvent jFVariableEvent = new JFVariableEvent();
        this.registerEvent("variable", jFVariableEvent.getClass());
        JFFlowEvent jFFlowEvent = new JFFlowEvent();
        this.registerEvent("flow", jFFlowEvent.getClass());
        JFDynamicFlowEvent jFDynamicFlowEvent = new JFDynamicFlowEvent();
        this.registerEvent("dynamicflow", jFDynamicFlowEvent.getClass());
        JFTimeEvent jFTimeEvent = new JFTimeEvent();
        this.registerEvent("CalendarTime_v1", jFTimeEvent.getClass());
        JFJobArrayEvent jFJobArrayEvent = new JFJobArrayEvent();
        this.registerEvent("jobarray", jFJobArrayEvent.getClass());
        JFLinkEvent jFLinkEvent = new JFLinkEvent();
        this.registerEvent("link", jFLinkEvent.getClass());
        JFFileEvent jFFileEvent = new JFFileEvent();
        this.registerEvent("FileAgent_v1.0", jFFileEvent.getClass());
        JFJobExceptionEvent jFJobExceptionEvent = new JFJobExceptionEvent();
        this.registerEvent("job_except", jFJobExceptionEvent.getClass());
        JFJobArrayExceptionEvent jFJobArrayExceptionEvent = new JFJobArrayExceptionEvent();
        this.registerEvent("jobarray_except", jFJobArrayExceptionEvent.getClass());
        JFFlowExceptionEvent jFFlowExceptionEvent = new JFFlowExceptionEvent();
        this.registerEvent("flow_except", jFFlowExceptionEvent.getClass());
        JFDynamicFlowExceptionEvent jFDynamicFlowExceptionEvent = new JFDynamicFlowExceptionEvent();
        this.registerEvent("dynamicflow_except", jFDynamicFlowExceptionEvent.getClass());
        JFFlowArrayEvent jFFlowArrayEvent = new JFFlowArrayEvent();
        this.registerEvent("flowarray", jFFlowArrayEvent.getClass());
        JFDynamicFlowArrayEvent jFDynamicFlowArrayEvent = new JFDynamicFlowArrayEvent();
        this.registerEvent("dynamicflowarray", jFDynamicFlowArrayEvent.getClass());
        JFFlowArrayExceptionEvent jFFlowArrayExceptionEvent = new JFFlowArrayExceptionEvent();
        this.registerEvent("flowarray_except", jFFlowArrayExceptionEvent.getClass());
        JFDynamicFlowArrayExceptionEvent jFDynamicFlowArrayExceptionEvent = new JFDynamicFlowArrayExceptionEvent();
        this.registerEvent("dynamicflowarray_except", jFDynamicFlowArrayExceptionEvent.getClass());
    }

    private void registerConfigurationEvents() throws JFException, IOException {
        String string = System.getProperty("JS_EVENTS_DIR");
        if (string == null) {
            return;
        }
        String string2 = new String(string + System.getProperty("file.separator") + "events.conf");
        File file = new File(string2);
        if (!file.canRead()) {
            throw new JFException(JFResource.getString("EVENTS_CONFIG_ERROR"));
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            Class<?> clazz;
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            if (!stringTokenizer.hasMoreTokens() || (string4 = stringTokenizer.nextToken()).startsWith("#")) continue;
            if (!stringTokenizer.hasMoreTokens()) {
                bufferedReader.close();
                throw new JFException(JFResource.getString("EVENTS_CONFIG_ERROR"));
            }
            String string5 = stringTokenizer.nextToken();
            try {
                clazz = this.getClass().getClassLoader().loadClass(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JFException(JFResource.getString("EVENTS_NO_CLASS", new Object[]{string5}));
            }
            this.registerEvent(string4, clazz);
        }
    }

    private void registerEvent(String string, Class clazz) throws JFException {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length && !classArray[n++].getName().equals("com.platform.LSFJobFlow.api.JFEvent")) {
        }
        if (n > classArray.length) {
            throw new JFException(JFResource.getString("EVENTS_NOT_JFEVENT", new Object[]{clazz.getName()}));
        }
        JFEvent jFEvent = null;
        try {
            jFEvent = (JFEvent)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JFException(JFResource.getString("EVENTS_NO_DEFAULT_CONS", new Object[]{clazz.getName()}));
        }
        catch (InstantiationException instantiationException) {
            throw new JFException(JFResource.getString("EVENTS_NO_INST", new Object[]{clazz.getName()}));
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new JFException(JFResource.getString("EVENTS_NO_INIT", new Object[]{clazz.getName()}));
        }
        this.m_registry.put(string, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JFEventFactory getEventFactory() throws JFException {
        if (m_factory == null) {
            Object object = mutex;
            synchronized (object) {
                if (m_factory == null) {
                    m_factory = new JFEventFactory();
                }
            }
        }
        return m_factory;
    }

    JFEvent createEvent(String string, String string2) throws JFException {
        JFEvent jFEvent;
        JFEvent jFEvent2 = null;
        Class clazz = (Class)this.m_registry.get(string);
        if (clazz == null) {
            throw new JFException(JFResource.getString("EVENTS_UNKNOWN_EVENT", new Object[]{string}));
        }
        try {
            jFEvent2 = (JFEvent)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JFException(string + JFResource.getString("EVENTS_NO_INST"));
        }
        jFEvent2.initFromDefinition(string2);
        if (string.equals("lsf") || string.equals("manual") || string.equals("otherbatch") || string.equals("local")) {
            jFEvent = (JFJobEvent)jFEvent2;
            ((JFJobEvent)jFEvent).setEventGeneratorType(string);
        }
        if (string.equals("variable")) {
            jFEvent = (JFVariableEvent)jFEvent2;
            ((JFVariableEvent)jFEvent).setEventGeneratorType(string);
        }
        return jFEvent2;
    }

    JFEvent createEvent(String string) throws JFException {
        String string2;
        Object object;
        String string3 = "JFEventFactory::createEvent";
        JFEvent jFEvent = null;
        JFDebug.println(string3 + ": Entered..., strEvent: <" + string + ">");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String string4 = null;
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            int n = ((String)object).indexOf("=");
            if (-1 == n) continue;
            String string6 = ((String)object).substring(0, n);
            string2 = ((String)object).substring(n + 1, ((String)object).length());
            if (string6.equals("GeneratorType")) {
                string4 = string2;
            } else if (string6.equals("Definition")) {
                string5 = string2;
            }
            if (string4 == null || string5 == null) continue;
            break;
        }
        if ((object = (Class)this.m_registry.get(string4)) == null) {
            throw new JFException(JFResource.getString("EVENTS_UNKNOWN_EVENT", new Object[]{string4}));
        }
        try {
            jFEvent = (JFEvent)((Class)object).newInstance();
        }
        catch (Exception exception) {
            throw new JFException(string4 + JFResource.getString("EVENTS_NO_INST"));
        }
        jFEvent.initFromDefinition(string5);
        if (string4.equals("lsf") || string4.equals("manual") || string4.equals("otherbatch") || string4.equals("local")) {
            JFJobEvent jFJobEvent = (JFJobEvent)jFEvent;
            jFJobEvent.setEventGeneratorType(string4);
        }
        stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string7 = stringTokenizer.nextToken();
            int n = string7.indexOf("=");
            if (-1 == n) continue;
            string2 = string7.substring(0, n);
            String string8 = string7.substring(n + 1, string7.length());
            jFEvent.setAttribute(string2, string8);
        }
        if (!jFEvent.isProxy()) {
            String string9 = jFEvent.getEventGeneratorType();
            if (string9.equals("lsf") || string9.equals("manual") || string9.equals("otherbatch") || string9.equals("local")) {
                JFJobEvent jFJobEvent = (JFJobEvent)jFEvent;
                int n = jFJobEvent.m_jobName.lastIndexOf(":");
                if (n != -1) {
                    jFJobEvent.m_jobName = jFJobEvent.m_jobName.substring(n + 1, jFJobEvent.m_jobName.length());
                }
            } else if (string9.equals("link")) {
                JFLinkEvent jFLinkEvent = (JFLinkEvent)jFEvent;
                int n = jFLinkEvent.m_linkJobName.lastIndexOf(":");
                if (n != -1) {
                    jFLinkEvent.m_linkJobName = jFLinkEvent.m_linkJobName.substring(n + 1, jFLinkEvent.m_linkJobName.length());
                }
                if (jFLinkEvent.m_linkJobRef != null) {
                    jFLinkEvent.m_linkJobRef.setName(jFLinkEvent.m_linkJobName);
                }
            } else if (string9.equals("flow")) {
                JFFlowEvent jFFlowEvent = (JFFlowEvent)jFEvent;
                int n = jFFlowEvent.m_flowName.lastIndexOf(":");
                if (n != -1) {
                    jFFlowEvent.m_flowName = jFFlowEvent.m_flowName.substring(n + 1, jFFlowEvent.m_flowName.length());
                }
            } else if (string9.equals("dynamicflow")) {
                JFDynamicFlowEvent jFDynamicFlowEvent = (JFDynamicFlowEvent)jFEvent;
                int n = jFDynamicFlowEvent.m_flowName.lastIndexOf(":");
                if (n != -1) {
                    jFDynamicFlowEvent.m_flowName = jFDynamicFlowEvent.m_flowName.substring(n + 1, jFDynamicFlowEvent.m_flowName.length());
                }
            } else if (string9.equals("jobarray")) {
                JFJobArrayEvent jFJobArrayEvent = (JFJobArrayEvent)jFEvent;
                int n = jFJobArrayEvent.m_jobArrName.lastIndexOf(":");
                if (n != -1) {
                    jFJobArrayEvent.m_jobArrName = jFJobArrayEvent.m_jobArrName.substring(n + 1, jFJobArrayEvent.m_jobArrName.length());
                }
            } else if (string9.equals("job_except")) {
                JFJobExceptionEvent jFJobExceptionEvent = (JFJobExceptionEvent)jFEvent;
                int n = jFJobExceptionEvent.m_jobName.lastIndexOf(":");
                if (n != -1) {
                    jFJobExceptionEvent.m_jobName = jFJobExceptionEvent.m_jobName.substring(n + 1, jFJobExceptionEvent.m_jobName.length());
                }
            } else if (string9.equals("jobarray_except")) {
                JFJobArrayExceptionEvent jFJobArrayExceptionEvent = (JFJobArrayExceptionEvent)jFEvent;
                int n = jFJobArrayExceptionEvent.m_jobArrName.lastIndexOf(":");
                if (n != -1) {
                    jFJobArrayExceptionEvent.m_jobArrName = jFJobArrayExceptionEvent.m_jobArrName.substring(n + 1, jFJobArrayExceptionEvent.m_jobArrName.length());
                }
            } else if (string9.equals("flow_except")) {
                JFFlowExceptionEvent jFFlowExceptionEvent = (JFFlowExceptionEvent)jFEvent;
                int n = jFFlowExceptionEvent.m_flowName.lastIndexOf(":");
                if (n != -1) {
                    jFFlowExceptionEvent.m_flowName = jFFlowExceptionEvent.m_flowName.substring(n + 1, jFFlowExceptionEvent.m_flowName.length());
                }
            } else if (string9.equals("dynamicflow_except")) {
                JFDynamicFlowExceptionEvent jFDynamicFlowExceptionEvent = (JFDynamicFlowExceptionEvent)jFEvent;
                int n = jFDynamicFlowExceptionEvent.m_flowName.lastIndexOf(":");
                if (n != -1) {
                    jFDynamicFlowExceptionEvent.m_flowName = jFDynamicFlowExceptionEvent.m_flowName.substring(n + 1, jFDynamicFlowExceptionEvent.m_flowName.length());
                }
            } else if (string9.equals("flowarray")) {
                JFFlowArrayEvent jFFlowArrayEvent = (JFFlowArrayEvent)jFEvent;
                int n = jFFlowArrayEvent.m_flowArrName.lastIndexOf(":");
                if (n != -1) {
                    jFFlowArrayEvent.m_flowArrName = jFFlowArrayEvent.m_flowArrName.substring(n + 1, jFFlowArrayEvent.m_flowArrName.length());
                }
            } else if (string9.equals("dynamicflowarray")) {
                JFDynamicFlowArrayEvent jFDynamicFlowArrayEvent = (JFDynamicFlowArrayEvent)jFEvent;
                int n = jFDynamicFlowArrayEvent.m_flowArrName.lastIndexOf(":");
                if (n != -1) {
                    jFDynamicFlowArrayEvent.m_flowArrName = jFDynamicFlowArrayEvent.m_flowArrName.substring(n + 1, jFDynamicFlowArrayEvent.m_flowArrName.length());
                }
            }
        }
        return jFEvent;
    }

    boolean eventRegistered(String string) {
        return this.m_registry.get(string) != null;
    }
}

