/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFResource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class JFCommon {
    public static boolean containNonASCIIChar(String string) {
        if (string == null) {
            return false;
        }
        return string.matches("[^\\x00-\\x7F]");
    }

    public static String removeUserVar(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = string;
        while ((n2 = string2.lastIndexOf("#{")) != -1 && (n = string2.indexOf("}", n2 + 1)) != -1) {
            String string3 = string2.substring(n2 + 2, n);
            if (!JFCommon.isValidVarName(string3)) {
                return null;
            }
            String string4 = string2.substring(0, n2);
            String string5 = string2.substring(n + 1);
            string2 = string4 + string3 + string5;
        }
        return string2;
    }

    public static boolean checkEnvVars(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (JFCommon.containNonASCIIChar(string)) {
            return false;
        }
        String string2 = JFCommon.removeUserVar(string);
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        return string2.matches("([a-zA-Z_]\\w*(=[^;]+)?;*)*");
    }

    public static boolean isBuiltInVariableName(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("JS_FLOW_ID") || string.equals("JS_FLOW_NAME") || string.equals("JS_FLOW_INDEX") || string.equals("JS_FLOW_FULL_NAME") || string.equals("JS_FLOW_SHORT_NAME") || string.equals("JS_ITERATION_COUNTER") || string.matches("JS_EVENT\\[\\d+\\]_FILENAME") || string.matches("JS_EVENT_\\d+_FILENAME_BASE");
    }

    public static boolean isValidVarName(String string) {
        if (string == null || string.length() == 0 || JFCommon.containNonASCIIChar(string)) {
            return false;
        }
        return string.matches("^[a-zA-Z_]\\w*") || JFCommon.isBuiltInVariableName(string);
    }

    public static boolean isValidVarValue(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        return string.matches("[^;]+");
    }

    public static String toVarList(Properties properties) {
        String string = "";
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                String string4 = string2 + "=" + string3 + ";";
                string = string + string4;
            }
        }
        return string;
    }

    public static Properties fromVarList(String string) {
        Properties properties = new Properties();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                if (n <= 0) continue;
                String string3 = null;
                String string4 = null;
                string3 = string2.substring(0, n);
                if (n < string2.length() - 1) {
                    string4 = string2.substring(n + 1);
                }
                if (string3 == null) continue;
                if (string4 == null) {
                    string4 = "";
                }
                properties.setProperty(string3, string4);
            }
        }
        return properties;
    }

    public static String toVarList_withequal(Properties properties) {
        String string = "";
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                String string4 = null;
                string4 = string3.length() != 0 ? string2 + "=" + string3 + ";" : string2 + ";";
                string = string + string4;
            }
        }
        return string;
    }

    public static Properties fromVarList_withequal(String string) {
        Properties properties = new Properties();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("=");
                if (n <= 0) {
                    properties.setProperty(string2, "");
                    continue;
                }
                String string3 = null;
                String string4 = null;
                string3 = string2.substring(0, n);
                if (n < string2.length() - 1) {
                    string4 = string2.substring(n + 1);
                }
                if (string3 == null) continue;
                if (string4 == null) {
                    string4 = "";
                }
                properties.setProperty(string3, string4);
            }
        }
        return properties;
    }

    public static boolean isNeedStrip(String string) {
        if (0 != string.indexOf("#{")) {
            return false;
        }
        if ('}' != string.charAt(string.length() - 1)) {
            return false;
        }
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == '{') {
                ++n;
                continue;
            }
            if (string.charAt(i) != '}' || 0 != --n || i == n2 - 1) continue;
            return false;
        }
        return true;
    }

    public static String stripName(String string) {
        String string2 = string.substring(2, string.length() - 1);
        return string2;
    }

    public static boolean containsValidVarRef(String string) {
        String string2 = JFCommon.removeUserVar(string);
        return string2 != null && string2.length() < string.length();
    }

    public static boolean containsInvalidVarRef(String string) {
        String string2 = JFCommon.removeUserVar(string);
        return string2 == null || string2.matches(".*#\\{.*");
    }

    public static String removeUserVarRef(String string) {
        String string2 = string;
        if (string2 == null || string2.length() == 0) {
            return string2;
        }
        String string3 = null;
        String string4 = null;
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        int n4 = string2.length() - 1;
        while ((n = string2.lastIndexOf("#{")) != -1 && (n2 = string2.indexOf("}", n + 1)) != -1) {
            if (n2 < n3) {
                string3 = string2.substring(0, n3);
                string4 = string2.substring(n4 + 1);
                string2 = string3 + string4;
                n3 = 0;
                n4 = string2.length() - 1;
                continue;
            }
            String string5 = string2.substring(n + 2, n2);
            if (!JFCommon.isValidVarName(string5)) {
                return null;
            }
            string3 = string2.substring(0, n);
            string4 = string2.substring(n2 + 1);
            string2 = string3 + string5 + string4;
            n3 = n;
            n4 = n2 - 3;
        }
        string3 = string2.substring(0, n3);
        string4 = string2.substring(n4 + 1);
        string2 = string3 + string4;
        return string2;
    }

    public static boolean isValidVarRef(String string, String string2) throws JFException {
        boolean bl = JFCommon.containsValidVarRef(string);
        boolean bl2 = JFCommon.containsInvalidVarRef(string);
        String string3 = JFCommon.removeUserVarRef(string);
        if (bl && !bl2 && string3 != null && (string3.length() == 0 || string3.matches(string2))) {
            return true;
        }
        if (bl2) {
            throw new JFException(JFResource.getString("Invalid_Variable_Reference"));
        }
        return false;
    }

    public static int[] stringToIntegerArray(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
            if (stringArray[i].length() <= 0) continue;
            arrayList.add(new Integer(stringArray[i]));
        }
        if (arrayList.isEmpty()) {
            throw new NumberFormatException();
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    public static String integerArrayToString(int[] nArray) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        String string = nArray.length > 0 ? String.valueOf(nArray[0]) : "";
        for (int i = 1; i < nArray.length; ++i) {
            string = string + " " + nArray[i];
        }
        return string;
    }
}

