/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFCalendar;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDaemonExceptionData;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFLoginManager;
import com.platform.LSFJobFlow.api.JFMethodInvoker;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFServiceProxy;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFVersion;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class JFCalendarManager {
    private static final int CAL_SUCCESS = 0;
    private static final int CAL_ERROR_ACCESSING_CALENDARS = 100;
    private static final int CAL_PERMISSION_DENIED = 101;
    private static final int CAL_CALENDAR_NOT_FOUND = 102;
    private static final int CAL_ERROR_ACCESSING_CALENDAR = 103;
    private static final int CAL_INVALID_CAL_EXPRESSION = 104;
    private static final int CAL_CALENDAR_EXISTS = 105;
    private static final int CAL_CALENDAR_USED_BY_ANOTHER_CALENDAR = 106;
    private static final int CAL_ERROR_GUEST_ACCESS_DENIED = 107;
    private static final int CALUI_SUCCESS = 0;
    private static final int CALUI_INVALID_ARGUMENT = 200;
    private static final int CALUI_ERROR_ACCESSING_CALENDARS = 201;
    private static final int CALUI_PERMISSION_DENIED = 202;
    private JFServiceProxy m_calendarServiceInvoker = null;
    private JFServiceProxy m_calendarUIServiceInvoker = null;
    private String m_userName = null;
    private static final String[] specialCalName = new String[]{"ICON", "RCON", "CCON", "MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN", "JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC", "YY", "FY", "WEEK", "MONTH", "QUARTER", "DAYS", "DAY", "OR", "AND", "LE", "GE", "EQ", "DOTS", "HH", "MM", "ESTRING", "NAME", "RANGE", "DATES", "SZZZZ"};

    public JFCalendarManager() throws JFException {
        this.refreshUser();
        this.m_calendarServiceInvoker = new JFServiceProxy("JFCalendarService");
        this.m_calendarUIServiceInvoker = new JFServiceProxy("JFCalendarUIService");
    }

    private void refreshUser() throws JFException {
        this.m_userName = JFLoginManager.getUserName();
        if (this.m_userName == null) {
            throw new JFException(JFResource.getString("CAL_NO_USERNAME"));
        }
        this.m_userName = new JFUser(this.m_userName).toJSUserName();
    }

    public void refresh() throws JFException {
        this.refreshUser();
    }

    public String[] getCalendarNames() throws JFException, IOException {
        return this.getCalendarNames(this.m_userName);
    }

    public String[] getCalendarNames(String string) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_UNAME_NULL"));
        }
        string = new JFUser(string).toJSUserName();
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_calendarServiceInvoker, "JF_GetCalendarIndex");
        jFMethodInvoker.inParams.addParam("calendarOwner", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n == 0) {
            String[] stringArray = jFMethodInvoker.outParams.getParamStringArray("calendarList");
            return this.deFormatCalNames(stringArray);
        }
        this.generateError(n);
        return null;
    }

    public String[] getAllCalendarNames() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_calendarServiceInvoker, "JF_GetAllCalendarsIndex");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n == 0) {
            String[] stringArray = jFMethodInvoker.outParams.getParamStringArray("calendarList");
            return this.deFormatCalNames(stringArray);
        }
        this.generateError(n);
        return null;
    }

    private String[] deFormatCalNames(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = JFUser.deFormatString(stringArray[i]);
        }
        return stringArray2;
    }

    public JFCalendar getCalendar(String string) throws JFException, IOException {
        String string2 = string;
        String string3 = this.m_userName;
        int n = string.indexOf("@");
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        string3 = new JFUser(string3).toJSUserName();
        return this.getCalendar(string2, string3);
    }

    public JFCalendar getCalendar(String string, String string2) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_CALNAME_NULL"));
        }
        if (string2 == null) {
            throw new NullPointerException(JFResource.getString("CAL_UNAME_NULL"));
        }
        string2 = new JFUser(string2).toJSUserName();
        if ((string = JFUser.formatString(string)).indexOf("@") > 0) {
            throw new JFException(JFResource.getString("CAL_CALNAME_REDUNDANT"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_calendarServiceInvoker, "JF_GetCalendar");
        jFMethodInvoker.inParams.addParam("calendarOwner", string2);
        jFMethodInvoker.inParams.addParam("calendarName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        switch (n) {
            case 0: {
                return new JFCalendar(jFMethodInvoker.outParams.getParamString("calendar_name"), jFMethodInvoker.outParams.getParamString("calendar_expr"), jFMethodInvoker.outParams.getParamString("calendar_owner"), jFMethodInvoker.outParams.getParamString("calendar_desc"));
            }
            case 102: {
                return null;
            }
        }
        this.generateError(n);
        return null;
    }

    public JFCalendar[] getAllCalendars() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_calendarServiceInvoker, "JF_GetAllCalendars");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            this.generateError(n);
            return null;
        }
        JFVersion jFVersion = JFConfigManager.getServerVersion(true);
        if (jFVersion.compareTo("5.5") >= 0) {
            JFCalendar[] jFCalendarArray = jFMethodInvoker.outParams.getParamCalendarList("calendarList");
            return jFCalendarArray;
        }
        int n2 = jFMethodInvoker.outParams.getParamInt("Number_Calendars");
        JFCalendar[] jFCalendarArray = new JFCalendar[n2];
        for (int i = 0; i < n2; ++i) {
            String string = "calendar_name_" + String.valueOf(i);
            String string2 = "calendar_expr_" + String.valueOf(i);
            String string3 = "calendar_owner_" + String.valueOf(i);
            String string4 = "calendar_desc_" + String.valueOf(i);
            jFCalendarArray[i] = new JFCalendar(jFMethodInvoker.outParams.getParamString(string), jFMethodInvoker.outParams.getParamString(string2), jFMethodInvoker.outParams.getParamString(string3), jFMethodInvoker.outParams.getParamString(string4));
        }
        return jFCalendarArray;
    }

    public boolean calendarInUse(String string) throws JFException, IOException {
        return this.calendarInUse(string, this.m_userName);
    }

    public boolean calendarInUse(String string, String string2) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_CALNAME_NULL"));
        }
        if (string2 == null) {
            throw new NullPointerException(JFResource.getString("CAL_UNAME_NULL"));
        }
        string2 = new JFUser(string2).toJSUserName();
        string = JFUser.formatString(string);
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_calendarServiceInvoker, "JF_CalendarStatus");
        jFMethodInvoker.inParams.addParam("calendarOwner", string2);
        jFMethodInvoker.inParams.addParam("calendarName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n == 0) {
            return jFMethodInvoker.outParams.getParamBoolean("calendarInUse");
        }
        this.generateError(n);
        return false;
    }

    public boolean calendarExists(String string) throws JFException, IOException {
        return this.getCalendar(string) != null;
    }

    public boolean calendarExists(String string, String string2) throws JFException, IOException {
        return this.getCalendar(string, string2) != null;
    }

    public void deleteCalendar(String string) throws JFException, IOException {
        this.deleteCalendar(string, this.m_userName);
    }

    public void deleteCalendar(String string, boolean bl) throws JFException, IOException {
        this.deleteCalendar(string, this.m_userName, bl);
    }

    public void deleteCalendar(String string, String string2) throws JFException, IOException {
        this.deleteCalendar(string, string2, false);
    }

    public void deleteCalendar(String string, String string2, boolean bl) throws JFException, IOException {
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_CALNAME_NULL"));
        }
        if (string2 == null) {
            throw new NullPointerException(JFResource.getString("CAL_UNAME_NULL"));
        }
        string2 = new JFUser(string2).toJSUserName();
        string = JFUser.formatString(string);
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_calendarServiceInvoker, "JF_DeleteCalendar");
        jFMethodInvoker.inParams.addParam("calendarOwner", string2);
        jFMethodInvoker.inParams.addParam("calendarName", string);
        if (bl) {
            jFMethodInvoker.inParams.addParam("force", true);
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        this.generateError(n);
    }

    public void addCalendar(JFCalendar jFCalendar) throws JFException, IOException {
        if (jFCalendar == null) {
            throw new NullPointerException(JFResource.getString("CAL_CAL_NULL"));
        }
        if (!this.checkCalendarName(jFCalendar.getFormattedName())) {
            throw new JFException(JFResource.getString("CAL_NAME_NOT_VALID"));
        }
        if (new JFUser(JFLoginManager.getUserName()).isGuest()) {
            throw new JFException(JFResource.getString("CAL_ERROR_GUEST_ACCOUNT_DENIED"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_calendarServiceInvoker, "JF_AddCalendar");
        jFMethodInvoker.inParams.addParam("calendar_name", jFCalendar.getFormattedName());
        jFMethodInvoker.inParams.addParam("calendar_expr", jFCalendar.getFormattedExpression());
        jFMethodInvoker.inParams.addParam("calendar_owner", jFCalendar.getOwner());
        jFMethodInvoker.inParams.addParam("calendar_desc", jFCalendar.getDescription());
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        JFDaemonExceptionData[] jFDaemonExceptionDataArray = null;
        try {
            jFDaemonExceptionDataArray = jFMethodInvoker.outParams.getParamExceptions("errormessages");
        }
        catch (Exception exception) {
            jFDaemonExceptionDataArray = null;
        }
        if (101 == n) {
            String string = jFCalendar.getOwner();
            Object[] objectArray = new Object[]{string};
            String string2 = JFResource.getString("CAL_NO_ADMIN_AND_GROUP_PERMISSION");
            MessageFormat messageFormat = new MessageFormat(string2);
            throw new JFException(messageFormat.format(objectArray), jFDaemonExceptionDataArray);
        }
        this.generateError(n, jFDaemonExceptionDataArray);
    }

    private boolean checkCalendarName(String string) {
        for (int i = 0; i < specialCalName.length; ++i) {
            if (!string.equalsIgnoreCase(specialCalName[i])) continue;
            return false;
        }
        return true;
    }

    public Calendar[] getOccurrences(JFCalendar jFCalendar, int n) throws JFException, IOException {
        String string = jFCalendar.getFormattedExpression();
        if (string == null) {
            throw new NullPointerException(JFResource.getString("CAL_EXPR_NULL"));
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.m_calendarUIServiceInvoker, "JF_GetDaysFromExpr");
        jFMethodInvoker.inParams.addParam("expression", string);
        jFMethodInvoker.inParams.addParam("year", n);
        jFMethodInvoker.invoke();
        int n2 = jFMethodInvoker.outParams.getParamInt("return");
        if (n2 != 0) {
            this.generateError(n2);
            return null;
        }
        String[] stringArray = jFMethodInvoker.outParams.getParamStringArray("calendarDays");
        LinkedList<Calendar> linkedList = new LinkedList<Calendar>();
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i], "/");
            int n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            int n4 = Integer.parseInt(stringTokenizer.nextToken().trim());
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, n);
            calendar.set(2, n3);
            calendar.set(5, n4);
            if (calendar.getActualMaximum(5) < n4) continue;
            linkedList.add(calendar);
        }
        Calendar[] calendarArray = new Calendar[linkedList.size()];
        linkedList.toArray(calendarArray);
        return calendarArray;
    }

    private void generateError(int n) throws JFException {
        this.generateError(n, null);
    }

    private void generateError(int n, JFDaemonExceptionData[] jFDaemonExceptionDataArray) throws JFException {
        switch (n) {
            case 0: {
                return;
            }
            case 100: 
            case 201: {
                throw new JFException(JFResource.getString("CAL_CANT_ACCESS_CALS"), jFDaemonExceptionDataArray);
            }
            case 101: 
            case 202: {
                throw new JFException(JFResource.getString("CAL_NO_PERMISSION"), jFDaemonExceptionDataArray);
            }
            case 103: {
                throw new JFException(JFResource.getString("CAL_CANT_ACCESS_CAL"), jFDaemonExceptionDataArray);
            }
            case 105: {
                throw new JFException(JFResource.getString("CAL_CAL_EXISTS"), jFDaemonExceptionDataArray);
            }
            case 104: 
            case 200: {
                throw new JFException(JFResource.getString("CAL_INVALID_ARG"), jFDaemonExceptionDataArray);
            }
            case 106: {
                throw new JFException(JFResource.getString("CAL_USED"), jFDaemonExceptionDataArray);
            }
            case 107: {
                throw new JFException(JFResource.getString("CAL_ERROR_GUEST_ACCOUNT_DENIED"), jFDaemonExceptionDataArray);
            }
        }
        throw new JFException(JFResource.getString("CAL_SERVICE_ERROR"), jFDaemonExceptionDataArray);
    }
}

