/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.api;

import com.platform.LSFJobFlow.api.JFAlarmDef;
import com.platform.LSFJobFlow.api.JFConfigManager;
import com.platform.LSFJobFlow.api.JFDebug;
import com.platform.LSFJobFlow.api.JFEncryption128;
import com.platform.LSFJobFlow.api.JFException;
import com.platform.LSFJobFlow.api.JFFlowInstance;
import com.platform.LSFJobFlow.api.JFFlowManager;
import com.platform.LSFJobFlow.api.JFHost;
import com.platform.LSFJobFlow.api.JFJIDInfo;
import com.platform.LSFJobFlow.api.JFMethodInvoker;
import com.platform.LSFJobFlow.api.JFOtherBatchCfg;
import com.platform.LSFJobFlow.api.JFResource;
import com.platform.LSFJobFlow.api.JFSecurityUtils;
import com.platform.LSFJobFlow.api.JFServerInfo;
import com.platform.LSFJobFlow.api.JFServiceProxy;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.api.JFUserGroup;
import com.platform.LSFJobFlow.api.JFVersion;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class JFAdminManager {
    private JFServiceProxy daemonAdminInvoker = new JFServiceProxy("JFDaemonReconfig");
    private JFServiceProxy accessInvoker = new JFServiceProxy("JFAccessService");
    private JFServiceProxy LSFCfgInvoker = new JFServiceProxy("JFLSFCfg");
    private JFServiceProxy alarmManagerInvoker = null;
    private JFServiceProxy serverInvoker = null;
    private JFServiceProxy otherbatchCfgInvoker = new JFServiceProxy("JFOtherBatchCfgService");
    private static boolean m_sHostsRefreshed = false;
    private static String[] m_sHosts = null;
    private static String[] m_sHostSpecs = null;
    private static boolean m_sQueuesRefreshed = false;
    private static String[] m_sQueues = null;
    private static boolean m_sAppProfilesRefreshed = false;
    private static String[] m_sAppProfiles = null;
    private static boolean m_sServiceClassesRefreshed = false;
    private static String[] m_sServiceClasses = null;
    private static boolean m_sLSFUserDomainRefreshed = false;
    private static String m_sLSFUserDomain = null;
    private static boolean m_sUserGroupsRefreshed = false;
    private static List<JFUserGroup> m_sUserGroups = null;
    private static boolean m_sIsRootAdminRefreshed = false;
    private static boolean m_sIsRootAdmin = false;
    private static boolean m_sEnableGroupAdminRefreshed = false;
    private static boolean m_sEnableGroupAdmin = false;
    private static boolean m_sLimitGroupFlowOwnerRefreshed = false;
    private static boolean m_sLimitGroupFlowOwner = false;
    private static final int MEM_EXCEPTION = 1;
    private static final int NULL_POINTER = 2;
    private static final int UNABLE_TO_READ_ENVIRONMENT = 5;
    private static final int UNABLE_TO_INIT_LSF = 6;
    private static final int PERMISSION_DENIED = 7;
    private static final int INVALID_ALARM_DEFINITION = 20001;
    private static final int ALARM_DEF_NOT_FOUND = 20002;
    private static final int NO_ALARM_DEF_SPECIFIED = 20003;
    private static final int NO_ALARMS_DIR = 20004;
    private static final int JFERROR_INST_FINISHED = 8009;
    private static final int JFERROR_FLOW_NOTFOUND = 8004;
    private static final int LSFCFG_UNABLE_TO_READ_LSF_SHARED = 8;
    private static final int LSFCFG_UNABLE_TO_FIND_LSF_CLUSTER = 9;
    private static final int LSFCFG_LSF_CONFDIR_UNDEFINED = 10;
    private static final int LSFCFG_UNABLE_TO_READ_LSF_CLUSTER_FILE = 16;
    private static final int LSFCFG_UNABLE_TO_READ_LSF_QUEUE_FILE = 17;
    private static final int SNAPSHOT_ALREADY_INPROGRESS = 35;
    private static final int FAILED_EXECUTE_BQUEUES = 30;
    private static final int FAILED_EXECUTE_LSHOSTS = 31;
    private static final int FAILED_EXECUTE_BHOSTS = 32;
    private static final int FAILED_EXECUTE_BAPP = 46;
    private static final int FAILED_EXECUTE_BSLA = 48;
    private static final int INVALID_HOST_NAME = 33;
    private static final int INVALID_QUEUE_NAME = 34;
    private static final int INVALID_APP_PROFILE_NAME = 47;
    private static final int INVALID_SERVICE_CLASS_NAME = 49;
    private static final int VAR_NOT_FOUND = 50;
    private static final int INVALID_VAR_DEFINITION = 51;
    private static final int INVALID_MAX_USER_PRIORITY = 52;

    public JFAdminManager() throws JFException {
        this.alarmManagerInvoker = new JFServiceProxy("JFAlarmManager");
        this.serverInvoker = new JFServiceProxy("JFServerInfoService");
    }

    private String errorToString(int n) {
        switch (n) {
            case 52: {
                return JFResource.getString("ADMIN_GET_MAXUSERPRIORITY");
            }
            case 1: {
                return JFResource.getString("MEM_EXCEPTION");
            }
            case 2: {
                return JFResource.getString("NULL_POINTER");
            }
            case 5: {
                return JFResource.getString("UNABLE_TO_READ_ENVIRONMENT");
            }
            case 6: {
                return JFResource.getString("UNABLE_TO_INIT_LSF");
            }
            case 7: {
                return JFResource.getString("PERMISSION_DENIED");
            }
            case 20001: {
                return JFResource.getString("INVALID_ALARM_DEFINITION");
            }
            case 20002: {
                return JFResource.getString("ALARM_DEF_NOT_FOUND");
            }
            case 20003: {
                return JFResource.getString("NO_ALARM_DEF_SPECIFIED");
            }
            case 20004: {
                return JFResource.getString("NO_ALARMS_DIR");
            }
            case 8: {
                return JFResource.getString("LSFCFG_UNABLE_TO_READ_LSF_SHARED");
            }
            case 9: {
                return JFResource.getString("LSFCFG_UNABLE_TO_FIND_LSF_CLUSTER");
            }
            case 10: {
                return JFResource.getString("LSFCFG_LSF_CONFDIR_UNDEFINED");
            }
            case 16: {
                return JFResource.getString("LSFCFG_UNABLE_TO_READ_LSF_CLUSTER_FILE");
            }
            case 17: {
                return JFResource.getString("LSFCFG_UNABLE_TO_READ_LSF_QUEUE_FILE");
            }
            case 35: {
                return JFResource.getString("SNAPSHOT_ALREADY_INPROGRESS");
            }
            case 8009: {
                return JFResource.getString("JFERROR_INST_FINISHED");
            }
            case 8004: {
                return JFResource.getString("JFERROR_FLOW_NOTFOUND");
            }
            case 30: {
                return JFResource.getString("FAILED_EXECUTE_BQUEUES");
            }
            case 31: {
                return JFResource.getString("FAILED_EXECUTE_LSHOSTS");
            }
            case 32: {
                return JFResource.getString("FAILED_EXECUTE_BHOSTS");
            }
            case 46: {
                return JFResource.getString("FAILED_EXECUTE_BAPP");
            }
            case 48: {
                return JFResource.getString("FAILED_EXECUTE_BSLA");
            }
            case 33: {
                return JFResource.getString("INVALID_HOST_NAME");
            }
            case 34: {
                return JFResource.getString("INVALID_QUEUE_NAME");
            }
            case 47: {
                return JFResource.getString("INVALID_APP_PROFILE_NAME");
            }
            case 49: {
                return JFResource.getString("INVALID_SERVICE_CLASS_NAME");
            }
            case 50: {
                return JFResource.getString("VAR_NOT_FOUND");
            }
            case 51: {
                return JFResource.getString("INVALID_VAR_DEFINITION");
            }
        }
        return JFResource.getString("ERR_UNKNOWN") + ": " + n;
    }

    public static String getProductName() {
        return JFResource.getString("PRODUCT_NAME");
    }

    public static String getProductShortName() {
        return JFResource.getString("PRODUCT_SHORT_NAME");
    }

    public static String getProductCopyright() {
        return JFResource.getString("PRODUCT_COPYRIGHT");
    }

    public static String getProductVersion() {
        return "2.0";
    }

    public void reconfigAdmin() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_AdminReconfig");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("DAEMON_RECONFIG_FAIL") + this.errorToString(n));
        }
    }

    public int getMaxUserPriority() throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.1"), JFResource.getString("Get_Max_User_Priority"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_GetMaxUserPriority");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("CANNOT_GET_MAX_USER_PRIORITY") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamInt("maxUserPriority");
    }

    public void reconfigAlarm() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_AlarmReconfig");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("DAEMON_RECONFIG_FAIL") + this.errorToString(n));
        }
    }

    public void shutdownDaemon() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_Shutdown");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("DAEMON_SHUTDOWN_FAIL") + this.errorToString(n));
        }
    }

    public void snapshotDaemon() throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Snapshot"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_Snapshot");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("DAEMON_SNAPSHOT_FAIL") + ": " + this.errorToString(n));
        }
    }

    public boolean isAdmin() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_IsJFAdmin");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        return n == 0;
    }

    public String[] getAdmins() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_GetJFAdmins");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("ADMIN_GET_ADMINS") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamStringArray("admins");
    }

    public String[] getControlAdmins() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_GetJFControlAdmins");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("ADMIN_GET_CONTROLADMINS") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamStringArray("controladmins");
    }

    public boolean isRealTime() {
        return false;
    }

    public boolean isRootAdmin() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_IsRootJFAdmin");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        return n == 0;
    }

    public synchronized boolean isRootAdminCached() throws JFException, IOException {
        if (!m_sIsRootAdminRefreshed) {
            m_sIsRootAdminRefreshed = true;
            m_sIsRootAdmin = this.isRootAdmin();
        }
        return m_sIsRootAdmin;
    }

    public boolean Null() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_Null");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        return n == 0;
    }

    public HashMap getServerInfo() throws JFException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_GetLSFUserDomain");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("JF_GetLSFUserDomain_FAIL"));
        }
        hashMap.put("LSF_USER_DOMAIN", jFMethodInvoker.outParams.getParamString("LSF_USER_DOMAIN"));
        try {
            hashMap.put("SERVER_TYPE", jFMethodInvoker.outParams.getParamString("SERVER_TYPE"));
        }
        catch (ProtocolException protocolException) {
            JFDebug.println("JFAdminManager.getServerInfo() ProtocolException with SERVER_TYPE");
        }
        return hashMap;
    }

    public synchronized String getLSFUserDomain() throws JFException, IOException {
        if (m_sLSFUserDomainRefreshed) {
            return m_sLSFUserDomain;
        }
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_GetLSFUserDomain");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("JF_GetLSFUserDomain_FAIL"));
        }
        m_sLSFUserDomain = jFMethodInvoker.outParams.getParamString("LSF_USER_DOMAIN");
        m_sLSFUserDomainRefreshed = true;
        return m_sLSFUserDomain;
    }

    public JFHost[] getAgentHosts() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.LSFCfgInvoker, "JF_GetHosts");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("LSFCFG_GET_HOSTS") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamAgentHostsPropertySheet("hosts");
    }

    public synchronized String[] getAgentHostsCached() throws JFException, IOException {
        this.refreshHosts();
        return m_sHosts;
    }

    public synchronized String[] getAgentHostModelsCached() throws JFException, IOException {
        this.refreshHosts();
        return m_sHostSpecs;
    }

    static void needRefresh() {
        JFDebug.println("JFAdminManager.needRefresh() called");
        m_sHostsRefreshed = false;
        m_sQueuesRefreshed = false;
        m_sLSFUserDomainRefreshed = false;
        m_sUserGroupsRefreshed = false;
        m_sIsRootAdminRefreshed = false;
        m_sEnableGroupAdminRefreshed = false;
        m_sLimitGroupFlowOwnerRefreshed = false;
    }

    private synchronized void refreshHosts() throws JFException, IOException {
        if (m_sHostsRefreshed) {
            return;
        }
        m_sHostsRefreshed = true;
        JFHost[] jFHostArray = this.getAgentHosts();
        if (jFHostArray == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        int n = jFHostArray.length;
        for (int i = 0; i < n; ++i) {
            if (jFHostArray[i] == null || !jFHostArray[i].isServerHost()) continue;
            arrayList.add(jFHostArray[i].getHostName());
            hashSet.add(jFHostArray[i].getHostModel());
        }
        hashSet.remove("UNKNOWN_AUTO_DETECT");
        m_sHosts = arrayList.toArray(new String[0]);
        m_sHostSpecs = hashSet.toArray(new String[0]);
    }

    public List<JFOtherBatchCfg> getAllOtherBatchCfg() throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("9.1"), JFResource.getString("JF_GetAllOtherBatchCfg"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.otherbatchCfgInvoker, "JF_GetAllOtherBatchCfg");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("GET_OTHERBATCH_CFG") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamOtherBatchCfgArray("otherbatch_cfg");
    }

    public String[] getQueues() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.LSFCfgInvoker, "JF_GetQueues");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("LSFCFG_GET_QUEUES") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamStringArray("queues");
    }

    public synchronized String[] getQueuesCached() throws JFException, IOException {
        if (!m_sQueuesRefreshed) {
            m_sQueuesRefreshed = true;
            m_sQueues = this.getQueues();
        }
        return m_sQueues;
    }

    public String getQueueInfo(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Get_queue_info"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.LSFCfgInvoker, "JF_GetQueueInfo");
        jFMethodInvoker.inParams.addParam("queueName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("LSFCFG_GET_QUEUEINFO") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamString("queueInfo");
    }

    public String[] getAppProfiles() throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("6.2"), JFResource.getString("Get_app_profiles"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.LSFCfgInvoker, "JF_GetAppProfiles");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("LSFCFG_GET_APP") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamStringArray("profiles");
    }

    public synchronized String[] getAppProfileCached() throws JFException, IOException {
        if (!m_sAppProfilesRefreshed) {
            m_sAppProfilesRefreshed = true;
            m_sAppProfiles = this.getAppProfiles();
        }
        return m_sAppProfiles;
    }

    public String getAppProfileInfo(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("6.2"), JFResource.getString("Get_app_profile_info"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.LSFCfgInvoker, "JF_GetAppProfileInfo");
        jFMethodInvoker.inParams.addParam("profileName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("LSFCFG_GET_APP_INFO") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamString("profileInfo");
    }

    public String[] getServiceClasses() throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("6.2"), JFResource.getString("Get_service_classes"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.LSFCfgInvoker, "JF_GetServiceClasses");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("LSFCFG_GET_SLA") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamStringArray("services");
    }

    public synchronized String[] getServiceClassCached() throws JFException, IOException {
        if (!m_sServiceClassesRefreshed) {
            m_sServiceClassesRefreshed = true;
            m_sServiceClasses = this.getServiceClasses();
        }
        return m_sServiceClasses;
    }

    public String getServiceClassInfo(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("6.2"), JFResource.getString("Get_service_class_info"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.LSFCfgInvoker, "JF_GetServiceClassInfo");
        jFMethodInvoker.inParams.addParam("serviceName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("LSFCFG_GET_SLA_INFO") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamString("serviceInfo");
    }

    public JFHost getHostInfo(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Get_host_info"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.LSFCfgInvoker, "JF_GetHostInfo");
        jFMethodInvoker.inParams.addParam("hostName", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("LSFCFG_GET_HOSTINFO") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamAgentHostInfo("host");
    }

    public JFAlarmDef[] getAlarmDefinitions() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.alarmManagerInvoker, "GetAlarms");
        jFMethodInvoker.invoke();
        JFAlarmDef[] jFAlarmDefArray = jFMethodInvoker.outParams.getParamAlarmDefArray("Alarms");
        return jFAlarmDefArray;
    }

    public void reconfigDebug(Properties properties) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_Debug_Reconfig");
        Enumeration<?> enumeration = properties.propertyNames();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string == null) continue;
            jFMethodInvoker.inParams.addParam(string, properties.getProperty(string));
            string = null;
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(this.errorToString(n));
        }
    }

    JFServerInfo getServerStatus() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.serverInvoker, "JF_GetServerInfo");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("JFCFG_GET_SERVER_STATUS_FAIL"));
        }
        return jFMethodInvoker.outParams.getParamJSHostPropertySheet("hosts");
    }

    public JFJIDInfo getJIDInfo() throws JFException, IOException {
        String string;
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Get_JID"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.serverInvoker, "JF_GetJID");
        String string2 = System.getProperty("os.name");
        if (!JFConfigManager.isExternalLogin() && string2 != null && !string2.startsWith("Windows") && (string = JFSecurityUtils.getKRBCache()) != null && string != "") {
            jFMethodInvoker.inParams.addParam("KRBTGT", string);
        }
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamJIDInfo();
    }

    Properties getVariableValues(String string) throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_GetVariableValues");
        jFMethodInvoker.inParams.addParam("scope", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamProperty("variables");
    }

    public boolean setVariableValues(long l, String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Run_time_variable"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_SetVariableValues");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("varlist", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.errorToString(n));
        }
        return true;
    }

    public boolean setItemVariableValues(long l, String string, String string2) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Run_time_variable"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_SetVariableValues");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("scope", string);
        jFMethodInvoker.inParams.addParam("varlist", string2);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.errorToString(n));
        }
        return true;
    }

    public void setSubmissionFormVariableValues(long l, String string, String string2) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Run_time_variable"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_SetVariableValues");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("scope", string);
        jFMethodInvoker.inParams.addParam("varlist", string2);
        jFMethodInvoker.inParams.addParam("isSubmissionForm", true);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.errorToString(n));
        }
    }

    public Properties getGlobalVariables() throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Get_global_variables"));
        return this.getVariableValues("");
    }

    public Properties getLocalVariables(long l) throws JFException, IOException {
        JFFlowManager jFFlowManager = new JFFlowManager();
        JFFlowInstance jFFlowInstance = jFFlowManager.getInstance(l);
        String string = jFFlowInstance.getName();
        JFConfigManager.checkServerVersionCompatible(new JFVersion("5.5"), JFResource.getString("Get_local_variables"));
        return this.getVariableValues(string);
    }

    public Properties getItemLocalVariables(long l, String string) throws JFException, IOException {
        JFFlowManager jFFlowManager = new JFFlowManager();
        JFFlowInstance jFFlowInstance = jFFlowManager.getInstance(l);
        String string2 = jFFlowInstance.getName();
        int n = string2.indexOf(":");
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        n = string4.indexOf(":");
        String string5 = string4.substring(0, n);
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Get_local_variables"));
        return this.getVariableValues(string3 + ":" + string5 + ":" + string);
    }

    public void setGlobalVariables(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("6.2"), JFResource.getString("Run_time_variable"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_SetVariableValues");
        jFMethodInvoker.inParams.addParam("scope", "");
        jFMethodInvoker.inParams.addParam("varlist", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.errorToString(n));
        }
    }

    public void removeGlobalVariables(String string) throws JFException, IOException {
        JFConfigManager.checkServerVersionCompatible(new JFVersion("6.2"), JFResource.getString("Remove_Variables"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_RemoveVariableValues");
        jFMethodInvoker.inParams.addParam("scope", "");
        jFMethodInvoker.inParams.addParam("varlist", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.errorToString(n));
        }
    }

    public void removeLocalVariables(long l, String string) throws JFException, IOException {
        JFFlowManager jFFlowManager = new JFFlowManager();
        JFFlowInstance jFFlowInstance = jFFlowManager.getInstance(l);
        String string2 = jFFlowInstance.getName();
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Remove_Variables"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_RemoveVariableValues");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("varlist", string);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.errorToString(n));
        }
    }

    public void removeItemLocalVariables(long l, String string, String string2) throws JFException, IOException {
        JFFlowManager jFFlowManager = new JFFlowManager();
        JFFlowInstance jFFlowInstance = jFFlowManager.getInstance(l);
        JFConfigManager.checkServerVersionCompatible(new JFVersion("8.0"), JFResource.getString("Remove_Variables"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.daemonAdminInvoker, "JF_RemoveVariableValues");
        jFMethodInvoker.inParams.addParam("id", l);
        jFMethodInvoker.inParams.addParam("scope", string);
        jFMethodInvoker.inParams.addParam("varlist", string2);
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (0 != n) {
            throw new JFException(this.errorToString(n));
        }
    }

    public String getServerTime() {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.serverInvoker, "JF_GetServerTime");
        String string = null;
        try {
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            if (n == 0) {
                string = jFMethodInvoker.outParams.getParamString("time");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public String getServerTimeZone() {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.serverInvoker, "JF_GetServerTimeZone");
        String string = null;
        try {
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            if (n == 0) {
                string = jFMethodInvoker.outParams.getParamString("timezone");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean isChangeFlowOwner() {
        try {
            JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_IsChangeFlowOwner");
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            return n == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isLimitFlowChartView() {
        boolean bl = false;
        try {
            JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_IsLimitFlowChartView");
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            if (n == 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isLimitUserView() {
        boolean bl = false;
        try {
            JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_IsLimitUserView");
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            if (n == 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isEnableDataProv() {
        boolean bl = false;
        try {
            JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_IsEnableDataProv");
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            if (n == 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isEnableGroupAdmin() {
        boolean bl = false;
        try {
            JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_IsEnableGroupAdmin");
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            if (n == 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public synchronized boolean isEnableGroupAdminCached() throws JFException, IOException {
        if (!m_sEnableGroupAdminRefreshed) {
            m_sEnableGroupAdminRefreshed = true;
            m_sEnableGroupAdmin = this.isEnableGroupAdmin();
        }
        return m_sEnableGroupAdmin;
    }

    public boolean isLimitGroupFlowOwner() {
        boolean bl = false;
        try {
            JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_IsLimitGroupFlowOwner");
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            if (n == 1) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public synchronized boolean isLimitGroupFlowOwnerCached() throws JFException, IOException {
        if (!m_sLimitGroupFlowOwnerRefreshed) {
            m_sLimitGroupFlowOwnerRefreshed = true;
            m_sLimitGroupFlowOwner = this.isLimitGroupFlowOwner();
        }
        return m_sLimitGroupFlowOwner;
    }

    public List<JFUserGroup> getUserGroups() throws JFException, IOException {
        JFConfigManager.checkServerVersionInvalid(new JFVersion("9.12"), JFResource.getString("Get_User_Groups"));
        JFConfigManager.checkServerVersionCompatible(new JFVersion("9.107"), JFResource.getString("Get_User_Groups"));
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_GetUserGroupsFor");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        if (n != 0) {
            throw new JFException(JFResource.getString("LSFCFG_GET_USERGROUPS") + this.errorToString(n));
        }
        return jFMethodInvoker.outParams.getParamUserGroupsArray("usergroups");
    }

    public synchronized List<JFUserGroup> getUserGroupsCached() throws JFException, IOException {
        if (!m_sUserGroupsRefreshed) {
            m_sUserGroupsRefreshed = true;
            m_sUserGroups = this.getUserGroups();
        }
        return m_sUserGroups;
    }

    public boolean isGroupAdmin() throws JFException, IOException {
        this.getUserGroupsCached();
        return m_sUserGroups != null && m_sUserGroups.size() > 0;
    }

    public boolean isGroupAdminFor(String string) throws JFException, IOException {
        if (string == null || string.equals("")) {
            return false;
        }
        this.getUserGroupsCached();
        JFUser jFUser = new JFUser(string);
        JFUser jFUser2 = new JFUser("all");
        for (JFUserGroup jFUserGroup : m_sUserGroups) {
            if (jFUserGroup.getGroupMembers().contains(jFUser)) {
                return true;
            }
            if (!jFUserGroup.getGroupMembers().contains(jFUser2)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocalJobEnabled() throws JFException, IOException {
        JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_IsLocalJobEnabled");
        jFMethodInvoker.invoke();
        int n = jFMethodInvoker.outParams.getParamInt("return");
        return n == 1;
    }

    public String getDefaultFlowWorkingDir() {
        try {
            JFMethodInvoker jFMethodInvoker = new JFMethodInvoker(this.accessInvoker, "JF_GetDefaultFlowWorkingDir");
            jFMethodInvoker.invoke();
            int n = jFMethodInvoker.outParams.getParamInt("return");
            String string = "";
            if (n == 0) {
                string = jFMethodInvoker.outParams.getParamString("defaultworkdir");
            }
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String decodeToken(String string) throws JFException {
        if (string == null || string.length() == 0) {
            throw new JFException("The token is empty.");
        }
        byte[] byArray = new byte[]{112, 8, 8, 113, 16, 8, -110, 18, 32, -105, 6, 32, -103, 3, 35, -1};
        JFEncryption128 jFEncryption128 = new JFEncryption128(byArray);
        String string2 = new String(jFEncryption128.unmarshallChannel(string));
        String[] stringArray = string2.split(":");
        if (stringArray.length != 2) {
            throw new JFException("Token format error.");
        }
        long l = 0L;
        try {
            l = Long.parseLong(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        long l2 = System.currentTimeMillis() / 1000L;
        long l3 = 300L;
        String string3 = JFConfigManager.getConfig("JS_PAC_TOKEN_TIMEOUT");
        if (string3 != null && string3.length() > 0) {
            try {
                l3 = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JFException("Bad token.");
            }
        }
        if (Math.abs(l - l2) > l3) {
            throw new JFException("Token timeout.");
        }
        return stringArray[0];
    }
}

