/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles3;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.locale.URLApplicationResource;
import org.apache.tiles.request.servlet.ServletApplicationContext;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

public class SpringWildcardServletTilesApplicationContext
extends ServletApplicationContext {
    private final ResourcePatternResolver resolver;

    public SpringWildcardServletTilesApplicationContext(ServletContext servletContext) {
        super(servletContext);
        this.resolver = new ServletContextResourcePatternResolver(servletContext);
    }

    @Nullable
    public ApplicationResource getResource(String localePath) {
        Collection<ApplicationResource> urlSet = this.getResources(localePath);
        if (!CollectionUtils.isEmpty(urlSet)) {
            return urlSet.iterator().next();
        }
        return null;
    }

    @Nullable
    public ApplicationResource getResource(ApplicationResource base, Locale locale) {
        Collection<ApplicationResource> urlSet = this.getResources(base.getLocalePath(locale));
        if (!CollectionUtils.isEmpty(urlSet)) {
            return urlSet.iterator().next();
        }
        return null;
    }

    public Collection<ApplicationResource> getResources(String path) {
        Object[] resources;
        try {
            resources = this.resolver.getResources(path);
        }
        catch (IOException ex) {
            ((ServletContext)this.getContext()).log("Resource retrieval failed for path: " + path, (Throwable)ex);
            return Collections.emptyList();
        }
        if (ObjectUtils.isEmpty((Object[])resources)) {
            ((ServletContext)this.getContext()).log("No resources found for path pattern: " + path);
            return Collections.emptyList();
        }
        ArrayList<ApplicationResource> resourceList = new ArrayList<ApplicationResource>(resources.length);
        Object[] objectArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Object resource = objectArray[n2];
            try {
                URL url = resource.getURL();
                resourceList.add((ApplicationResource)new URLApplicationResource(url.toExternalForm(), url));
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("No URL for " + resource, ex);
            }
            ++n2;
        }
        return resourceList;
    }
}

