/*
 * Decompiled with CFR 0.152.
 */
package com.sas.arm.log4jappender;

import com.sas.arm.log4jappender.MappedDiagnosticContext;
import com.sas.util.BASE64;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Stack;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.opengroup.arm40.transaction.ArmApplication;
import org.opengroup.arm40.transaction.ArmApplicationDefinition;
import org.opengroup.arm40.transaction.ArmTransaction;
import org.opengroup.arm40.transaction.ArmTransactionDefinition;
import org.opengroup.arm40.transaction.ArmTransactionFactory;

@Plugin(name="ArmAppender", category="Core", elementType="appender", printObject=true)
public class ArmAppender2
extends AbstractAppender {
    private ArmTransactionFactory tranFactory = null;
    private ArmApplicationDefinition appDefinition = null;
    private ArmApplication application = null;
    private ArmTransaction transaction = null;
    private ArmTransactionDefinition tranDefinition = null;
    private String appName = "SAS";
    private String groupName = "SAS-GROUP";
    private String agentTransactionFactory = "com.sas.arm.agent.ArmTransactionFactoryImpl";
    private static final String log4jappender_NDC = "log4jappender_NDC";
    public static final String ARM_AppID = "ARM.AppID";
    public static final String ARM_AppName = "ARM.AppName";
    public static final String ARM_GroupName = "ARM.GroupName";
    public static final String ARM_CurrentCorrelator = "ARM.CurrentCorrelator";
    public static final String ARM_ParentCorrelator = "ARM.ParentCorrelator";
    public static final String ARM_System_CPU_Time = "ARM.System_CPU_Time";
    public static final String ARM_TranName = "ARM.TranName";
    public static final String ARM_TranState = "ARM.TranState";
    public static final String ARM_TranId = "ARM.TranId";
    public static final String ARM_TranStatus = "ARM.TranStatus";
    public static final String ARM_TimeStamp = "ARM.TimeStamp";
    public static final String ARM_TranStart_Time = "ARM.TranStart.Time";
    public static final String ARM_TranStart_System_CPU_Time = "ARM.TranStart.System_CPU_Time";
    public static final String ARM_TranStart_User_CPU_Time = "ARM.TranStart.User_CPU_Time";
    public static final String ARM_TranStop_Time = "ARM.TranStop.Time";
    public static final String ARM_TranStop_System_CPU_Time = "ARM.TrnaStop.System_CPU_Time";
    public static final String ARM_TranStop_User_CPU_Time = "ARM.TranStop.User_CPU_Time";
    public static final String ARM_TranBlocked_Time = "ARM.TranBlocked.Time";
    public static final String ARM_TranBlocked_System_CPU_Time = "ARM.TranBlocked.System_CPU_Time";
    public static final String ARM_TranBlocked_User_CPU_Time = "ARM.TranBlocked.User_CPU_Time";
    public static final String ARM_TranBlockHandle = "ARM.TranBlockHandle";
    public static final String ARM_TranResp_Time = "ARM.TranResp.Time";
    public static final String ARM_TranResp_System_CPU_Time = "ARM.TranResp.System_CPU_Time";
    public static final String ARM_TranResp_User_CPU_Time = "ARM.TranResp.User_CPU_Time";
    public static final String ARM_User_CPU_Time = "ARM.User_CPU_Time";
    public static final String ARM_TranStart = "START";
    public static final String ARM_TranStop = "STOP";
    public static final String ARM_TranBlock = "BLOCK";
    public static final String ARM_TranDiscard = "DISCARD";
    public static final String ARM_TranUnblock = "UNBLOCK";
    public static final String ARM_TranUpdate = "UPDATE";
    public static final String ARM_TranCorrelator = "CORRELATOR";
    public static final String SAS_CurrentCorrelator = "ARM.InternalCorrelator";
    private final Configuration config;
    private final AppenderRef[] appenderRefs;

    protected ArmAppender2(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties, Configuration config, AppenderRef[] appenderRefs) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.appenderRefs = appenderRefs;
        this.config = config;
    }

    public void append(LogEvent event) {
        String message;
        String messUpper;
        if (this.tranFactory == null) {
            this.initTranFactory();
        }
        if ((messUpper = (message = event.getMessage().getFormattedMessage()).toUpperCase()).startsWith(ARM_TranStart)) {
            this.startTransaction(message);
        } else if (messUpper.startsWith(ARM_TranStop)) {
            this.stopTransaction(message);
        } else if (messUpper.startsWith(ARM_TranUpdate)) {
            this.updateTransaction(message);
        } else if (messUpper.startsWith(ARM_TranBlock)) {
            this.blockTransaction(message);
        } else if (messUpper.startsWith(ARM_TranUnblock)) {
            this.unblockTransaction(message);
        } else if (messUpper.startsWith(ARM_TranDiscard)) {
            this.discardTransaction(message);
        }
        this.callAllAppenders(event);
    }

    @PluginFactory
    public static ArmAppender2 createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginElement(value="Properties") Property[] properties, @PluginConfiguration Configuration config, @PluginElement(value="AppenderRef") AppenderRef[] appenderRefs) {
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new ArmAppender2(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, properties, config, appenderRefs);
    }

    private void initTranFactory() {
        Class<?> tranFactoryClass = null;
        try {
            tranFactoryClass = Class.forName(this.getAgentTransactionFactory());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        try {
            this.tranFactory = (ArmTransactionFactory)tranFactoryClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.appDefinition = this.tranFactory.newArmApplicationDefinition(this.getAppName(), null, null);
        this.application = this.tranFactory.newArmApplication(this.appDefinition, this.getGroupName(), null, null);
    }

    public String getAgentTransactionFactory() {
        return this.agentTransactionFactory;
    }

    public void setAgentTransactionFactory(String factory) {
        this.agentTransactionFactory = factory;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String name) {
        this.appName = name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String name) {
        this.groupName = name;
    }

    public void close() {
        this.stop();
    }

    public boolean requiresLayout() {
        return true;
    }

    private static String armStatusString(int status) {
        String retVal = "UNKNOWN";
        if (status == 0) {
            retVal = "GOOD";
        } else if (status == 1) {
            retVal = "ABORT";
        } else if (status == 2) {
            retVal = "FAILED";
        }
        return retVal;
    }

    public void updateThreadContext(String state, ArmTransaction transaction) {
        String currentID = null;
        SasTransaction stt = null;
        long responseTime = 0L;
        long currentTime = 0L;
        long startTime = 0L;
        long stopTime = 0L;
        long blockedTime = 0L;
        byte[] currentCorrelatorBytes = null;
        byte[] parentCorrelatorBytes = null;
        String currentCorrelator = null;
        String parentCorrelator = null;
        currentCorrelatorBytes = transaction.getCorrelator().getBytes();
        currentCorrelator = new String(BASE64.encode((byte[])currentCorrelatorBytes));
        currentID = new String(transaction.getDefinition().getID().getBytes());
        parentCorrelatorBytes = transaction.getParentCorrelator().getBytes();
        parentCorrelator = new String(BASE64.encode((byte[])parentCorrelatorBytes));
        MappedDiagnosticContext.put(ARM_AppName, transaction.getApplication().getDefinition().getName());
        MappedDiagnosticContext.put(ARM_AppID, transaction.getApplication().getDefinition().getID());
        MappedDiagnosticContext.put(ARM_GroupName, transaction.getApplication().getGroup());
        MappedDiagnosticContext.put(ARM_TranName, transaction.getDefinition().getName());
        MappedDiagnosticContext.put(ARM_TranState, state);
        MappedDiagnosticContext.put(ARM_TranId, currentID);
        stt = this.updateSASTransaction(currentCorrelator, state);
        MappedDiagnosticContext.put(ARM_CurrentCorrelator, currentCorrelator);
        MappedDiagnosticContext.put(SAS_CurrentCorrelator, currentCorrelator);
        MappedDiagnosticContext.put(ARM_ParentCorrelator, parentCorrelator);
        MappedDiagnosticContext.put(ARM_TranStatus, ArmAppender2.armStatusString(transaction.getStatus()));
        responseTime = stt.responseTime();
        MappedDiagnosticContext.put(ARM_TranResp_Time, String.valueOf(responseTime));
        MappedDiagnosticContext.put(ARM_TranResp_User_CPU_Time, String.valueOf(responseTime));
        MappedDiagnosticContext.put(ARM_TranResp_System_CPU_Time, String.valueOf(0));
        currentTime = stt.currentTime();
        MappedDiagnosticContext.put(ARM_TimeStamp, String.valueOf(currentTime));
        MappedDiagnosticContext.put(ARM_User_CPU_Time, String.valueOf(currentTime));
        MappedDiagnosticContext.put(ARM_System_CPU_Time, String.valueOf(0));
        startTime = stt.getStart();
        MappedDiagnosticContext.put(ARM_TranStart_Time, String.valueOf(startTime));
        MappedDiagnosticContext.put(ARM_TranStart_User_CPU_Time, String.valueOf(startTime));
        MappedDiagnosticContext.put(ARM_TranStart_System_CPU_Time, String.valueOf(0));
        stopTime = stt.getStop();
        MappedDiagnosticContext.put(ARM_TranStop_Time, String.valueOf(stopTime));
        MappedDiagnosticContext.put(ARM_TranStop_User_CPU_Time, String.valueOf(stopTime));
        MappedDiagnosticContext.put(ARM_TranStop_System_CPU_Time, String.valueOf(0));
        blockedTime = stt.blockedTime();
        MappedDiagnosticContext.put(ARM_TranBlocked_Time, String.valueOf(blockedTime));
        MappedDiagnosticContext.put(ARM_TranBlocked_User_CPU_Time, String.valueOf(blockedTime));
        MappedDiagnosticContext.put(ARM_TranBlocked_System_CPU_Time, String.valueOf(0));
        if (state.equals(ARM_TranStart)) {
            MappedDiagnosticContext.put(currentCorrelator, transaction);
            this.NDCPush(currentCorrelator);
        } else if (state.equals(ARM_TranStop) || state.equals(ARM_TranDiscard)) {
            MappedDiagnosticContext.remove(currentCorrelator);
            this.NDCPop();
            MappedDiagnosticContext.put(SAS_CurrentCorrelator, this.NDCPeek());
        }
    }

    private void NDCPush(Object object) {
        Stack<Object> NDC = (Stack<Object>)MappedDiagnosticContext.get(log4jappender_NDC);
        if (NDC == null) {
            NDC = new Stack<Object>();
        }
        NDC.push(object);
        MappedDiagnosticContext.put(log4jappender_NDC, NDC);
    }

    private Object NDCPeek() {
        Stack NDC = (Stack)MappedDiagnosticContext.get(log4jappender_NDC);
        String NDC_LOCAL_VALUE = log4jappender_NDC + Thread.currentThread().getId();
        String NDC_LOCAL = (String)MappedDiagnosticContext.get(NDC_LOCAL_VALUE);
        if (NDC_LOCAL == null) {
            if (NDC != null) {
                MappedDiagnosticContext.remove(log4jappender_NDC);
            }
            NDC = new Stack();
            MappedDiagnosticContext.put(log4jappender_NDC, NDC);
            MappedDiagnosticContext.put(NDC_LOCAL_VALUE, NDC_LOCAL_VALUE);
        }
        return NDC.empty() ? "" : NDC.peek();
    }

    private Object NDCPop() {
        Stack NDC = null;
        String object = null;
        NDC = (Stack)MappedDiagnosticContext.get(log4jappender_NDC);
        if (NDC == null) {
            NDC = new Stack();
        }
        object = NDC.empty() ? "" : NDC.pop();
        MappedDiagnosticContext.put(log4jappender_NDC, NDC);
        return object;
    }

    private SasTransaction updateSASTransaction(String name, String state) {
        String sasTran = name + "_SASTRAN";
        SasTransaction stt = (SasTransaction)MappedDiagnosticContext.get(sasTran);
        if (stt == null) {
            stt = new SasTransaction();
        } else if (state.equals(ARM_TranBlock)) {
            stt.block();
        } else if (state.equals(ARM_TranUnblock)) {
            stt.unBlock();
        } else {
            stt.update();
        }
        MappedDiagnosticContext.put(sasTran, stt);
        return stt;
    }

    private void startTransaction(String message) {
        ArmTransaction parentTran = null;
        String currentCorrelator = null;
        String parentCorrelator = null;
        int startName = message.indexOf(" ") + 1;
        String transactionName = message.substring(startName, message.length());
        this.tranDefinition = this.tranFactory.newArmTransactionDefinition(this.appDefinition, transactionName, null, null);
        this.transaction = this.tranFactory.newArmTransaction(this.application, this.tranDefinition);
        currentCorrelator = (String)this.NDCPeek();
        parentTran = (ArmTransaction)MappedDiagnosticContext.get(currentCorrelator);
        if (parentTran != null) {
            currentCorrelator = new String(BASE64.encode((byte[])parentTran.getCorrelator().getBytes()));
        }
        parentCorrelator = !"".equals(currentCorrelator) ? currentCorrelator : (String)MappedDiagnosticContext.get(ARM_ParentCorrelator);
        this.transaction.start(parentCorrelator == null ? null : BASE64.decode((String)parentCorrelator));
        this.updateThreadContext(ARM_TranStart, this.transaction);
    }

    private void stopTransaction(String message) {
        int startName = message.indexOf(" ") + 1;
        int startStatus = message.indexOf(" ", startName) + 1;
        int tranStatus = 3;
        String tranStatusString = message.substring(startStatus);
        String currentCorrelator = null;
        ArmTransaction transaction = null;
        if (tranStatusString.equalsIgnoreCase("successful")) {
            tranStatus = 0;
        } else if (tranStatusString.equalsIgnoreCase("aborted")) {
            tranStatus = 1;
        } else if (tranStatusString.equalsIgnoreCase("failed")) {
            tranStatus = 2;
        }
        currentCorrelator = (String)this.NDCPeek();
        transaction = (ArmTransaction)MappedDiagnosticContext.get(currentCorrelator);
        transaction.stop(tranStatus);
        this.updateThreadContext(ARM_TranStop, transaction);
    }

    private void updateTransaction(String message) {
        String currentCorrelator = null;
        ArmTransaction transaction = null;
        currentCorrelator = (String)this.NDCPeek();
        transaction = (ArmTransaction)MappedDiagnosticContext.get(currentCorrelator);
        transaction.update();
        this.updateThreadContext(ARM_TranUpdate, transaction);
    }

    private void blockTransaction(String message) {
        String currentCorrelator = null;
        ArmTransaction transaction = null;
        long blockHandle = 0L;
        currentCorrelator = (String)this.NDCPeek();
        transaction = (ArmTransaction)MappedDiagnosticContext.get(currentCorrelator);
        blockHandle = transaction.blocked();
        MappedDiagnosticContext.put(ARM_TranBlockHandle, blockHandle);
        this.updateThreadContext(ARM_TranBlock, transaction);
    }

    private void unblockTransaction(String message) {
        String currentCorrelator = null;
        ArmTransaction transaction = null;
        currentCorrelator = (String)this.NDCPeek();
        transaction = (ArmTransaction)MappedDiagnosticContext.get(currentCorrelator);
        transaction.unblocked((Long)MappedDiagnosticContext.get(ARM_TranBlockHandle));
        MappedDiagnosticContext.remove(ARM_TranBlockHandle);
        this.updateThreadContext(ARM_TranUnblock, transaction);
    }

    private void discardTransaction(String message) {
        String currentCorrelator = null;
        ArmTransaction transaction = null;
        currentCorrelator = (String)this.NDCPeek();
        transaction = (ArmTransaction)MappedDiagnosticContext.get(currentCorrelator);
        transaction.reset();
        this.updateThreadContext(ARM_TranDiscard, transaction);
    }

    public void addAppender(Appender newAppender) {
        if (newAppender == null) {
            return;
        }
        this.config.addAppender(newAppender);
    }

    public Enumeration getAllAppenders() {
        Map appenders = this.config.getAppenders();
        return Collections.enumeration(appenders.values());
    }

    public Appender getAppender(String name) {
        Map appenders = this.config.getAppenders();
        if (appenders.containsKey(name)) {
            return (Appender)appenders.get(name);
        }
        return null;
    }

    public boolean isAttached(Appender appender) {
        Map appenders = this.config.getAppenders();
        return appenders.containsValue(appender);
    }

    public void removeAllAppenders() {
        Map loggers = this.config.getLoggers();
        LoggerContext loggerContext = this.config.getLoggerContext();
        for (LoggerConfig loggerConfig : loggers.values()) {
            Map appenders = loggerConfig.getAppenders();
            for (Appender appender : appenders.values()) {
                loggerConfig.removeAppender(appender.getName());
            }
        }
        loggerContext.updateLoggers();
    }

    public void removeAppender(Appender appender) {
        if (appender != null) {
            Map loggers = this.config.getLoggers();
            LoggerContext loggerContext = this.config.getLoggerContext();
            for (LoggerConfig loggerConfig : loggers.values()) {
                Map appenders = loggerConfig.getAppenders();
                if (!appenders.containsValue(appender)) continue;
                loggerConfig.removeAppender(appender.getName());
            }
            loggerContext.updateLoggers();
        }
    }

    public int callAllAppenders(LogEvent event) {
        for (AppenderRef appenderRef : this.appenderRefs) {
            String name = appenderRef.getRef();
            Appender appender = this.config.getAppender(name);
            appender.append(event);
        }
        return this.appenderRefs.length;
    }

    public void removeAppender(String name) {
        if (name != null) {
            Appender appender = this.config.getAppender(name);
            Map loggers = this.config.getLoggers();
            LoggerContext loggerContext = this.config.getLoggerContext();
            for (LoggerConfig loggerConfig : loggers.values()) {
                Map appenders = loggerConfig.getAppenders();
                if (!appenders.containsValue(appender)) continue;
                loggerConfig.removeAppender(name);
            }
            loggerContext.updateLoggers();
        }
    }

    private class SasTransaction {
        private Date startDate;
        private Date stopDate;
        private Date startBlockDate;
        private Date stopBlockDate;

        private SasTransaction() {
            this.start();
        }

        private final void start() {
            this.stopDate = this.startDate = new Date();
            this.startBlockDate = this.startDate;
            this.stopBlockDate = this.startDate;
        }

        public void block() {
            this.startBlockDate = new Date();
        }

        public void unBlock() {
            this.stopBlockDate = new Date();
        }

        public void update() {
            this.stopDate = new Date();
        }

        public long responseTime() {
            long elapsedTime = this.getStop() - this.getStart();
            long blockedTime = this.getBlockStop() - this.getBlockStart();
            return elapsedTime - blockedTime;
        }

        public long currentTime() {
            Date currentDate = new Date();
            long elapsedTime = currentDate.getTime() - this.getStart();
            return elapsedTime;
        }

        public long blockedTime() {
            return this.getBlockStop() - this.getBlockStart();
        }

        public long getStart() {
            return this.startDate.getTime();
        }

        public long getStop() {
            return this.stopDate.getTime();
        }

        public long getBlockStart() {
            return this.startBlockDate.getTime();
        }

        public long getBlockStop() {
            return this.stopBlockDate.getTime();
        }
    }
}

