/*
 * Decompiled with CFR 0.152.
 */
package com.sas.arm.agent;

import com.sas.arm.agent.ArmTokenImpl;
import com.sas.entities.GUID;
import java.io.UnsupportedEncodingException;
import org.opengroup.arm40.transaction.ArmCorrelator;

public class ArmCorrelatorImpl
extends ArmTokenImpl
implements ArmCorrelator {
    static final byte[] EMPTY_CORR_BYTES = new byte[]{0, 4, 0, 0};
    static final int FLAG_AGENT_NONE = 0;
    static final int FLAG_AGENT_TRACE = 128;
    static final int FLAG_APP_TRACE_REQ = 64;
    static final byte FLAG_FORMAT_SAS = -1;

    ArmCorrelatorImpl() {
        super(40);
        byte[] guid = "notAGuid".getBytes();
        byte flags = 0;
        try {
            guid = GUID.newGUID().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int correlatorLength = guid.length + 4;
        byte[] correlator = new byte[]{(byte)(correlatorLength & 0xFF00), (byte)(correlatorLength & 0xFF), -1, flags};
        System.arraycopy(correlator, 0, this.array, 0, correlator.length);
        System.arraycopy(guid, 0, this.array, 4, guid.length);
    }

    ArmCorrelatorImpl(byte[] bytes) {
        super(bytes.length);
        System.arraycopy(bytes, 0, this.array, 0, this.array.length);
    }

    @Override
    public boolean isAgentTrace() {
        if (this.array.length < 4) {
            return false;
        }
        return (this.array[3] & 0x80) != 0;
    }

    @Override
    public boolean isApplicationTrace() {
        if (this.array.length < 4) {
            return false;
        }
        return (this.array[3] & 0x40) != 0;
    }

    public String toString() {
        String tokenString = null;
        try {
            byte[] id = new byte[]{0};
            String idString = new String(this.array, "utf-8");
            int idIndex = idString.indexOf(new String(id));
            if (idIndex == 0) {
                idIndex = idString.length();
            }
            id = new byte[idIndex];
            System.arraycopy(this.array, 0, id, 0, idIndex);
            tokenString = new String(id, "utf-8");
        }
        catch (UnsupportedEncodingException exception) {
            exception.printStackTrace();
        }
        return tokenString;
    }
}

