/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.script.impl;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.script.ValidationContext;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.log4j.Log4JFactory2;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;

public final class DefaultValidationContext
implements ValidationContext {
    private LoggerFactoryInterface factory;
    private CommonLoggerInterface logger;
    private PromptValuesInterface promptValues;
    private Logger log4Logger = null;
    StringWriter output = new StringWriter();

    public DefaultValidationContext(PromptValuesInterface promptValues, LoggerFactoryInterface factory) {
        this.promptValues = promptValues;
    }

    @Override
    public Object getPromptValueForPromptID(String promptID) {
        PromptDefinitionInterface prompt = PromptUtil.findPromptDefinitionByID(this.promptValues, promptID);
        if (null != prompt) {
            try {
                return this.promptValues.getPromptValue(prompt);
            }
            catch (PromptValueNotFoundException e) {
                this.getLogger().warn("getPromptValueForPromptID() returning null for this ID:", promptID);
            }
        }
        return null;
    }

    @Override
    public Object getPromptValueForPromptName(String promptName) {
        try {
            PromptDefinitionInterface prompt = this.promptValues.getPromptDefinition(promptName, true);
            if (null != prompt) {
                return this.promptValues.getPromptValue(prompt);
            }
        }
        catch (PromptValueNotFoundException e) {
            this.getLogger().warn("getPromptValueForPromptName() returning null for name:", promptName);
        }
        return null;
    }

    @Override
    public String getPromptNameForPromptID(String promptID) {
        String retVal = null;
        PromptDefinitionInterface prompt = PromptUtil.findPromptDefinitionByID(this.promptValues, promptID);
        if (null != prompt) {
            retVal = prompt.getPromptName();
        }
        return retVal;
    }

    CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            if (null != this.factory) {
                this.logger = this.factory.makeNewLoggerInstance(this.getClass().getName());
            }
            this.logger = new Log4JFactory2().makeNewLoggerInstance(this.getClass().getName());
        }
        return this.logger;
    }

    @Override
    public Logger getLog4JLogger() {
        if (null == this.log4Logger) {
            this.log4Logger = LogManager.getLogger((String)"Scripting Logger");
            Configurator.setLevel((String)this.log4Logger.getName(), (Level)Level.INFO);
            LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration logconfig = lc.getConfiguration();
            WriterAppender appender = ((WriterAppender.Builder)WriterAppender.newBuilder().setTarget((Writer)this.output).setConfiguration(logconfig)).build();
            appender.start();
            logconfig.addAppender((Appender)appender);
            lc.updateLoggers();
        }
        return this.log4Logger;
    }

    @Override
    public String getLog4JOutput() {
        return this.output.toString();
    }
}

