/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.el.resolvers;

import com.sas.prompts.PromptUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionV2Interface;
import com.sas.prompts.el.ELEvaluator;
import com.sas.util.ValidateArg;
import de.odysseus.el.util.SimpleContext;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.BeanELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;

public class PromptELResolver
extends BeanELResolver {
    public PromptELResolver() {
        super(false);
    }

    protected Object getPromptValue(ELContext context, PromptDefinitionInterface prompt) throws PromptValueNotFoundException {
        Object pv;
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        ValueExpression pvExpression = context.getVariableMapper().resolveVariable("ELEvaluator_promptValues");
        if (pvExpression != null && (pv = pvExpression.getValue(context)) instanceof PromptValuesInterface) {
            PromptValuesInterface promptValues = (PromptValuesInterface)pv;
            return promptValues.getPromptValue(prompt);
        }
        throw new ELException("Unable to find promptValues in context");
    }

    protected PromptDefinitionInterface getPromptDefinition(ELContext context, String name) {
        PromptValuesInterface promptValues;
        PromptDefinitionInterface prompt;
        Object pv;
        ValidateArg.notNull((Object)context, (String)"context");
        ValueExpression pvExpression = context.getVariableMapper().resolveVariable("ELEvaluator_promptValues");
        if (pvExpression != null && (pv = pvExpression.getValue(context)) instanceof PromptValuesInterface && (prompt = PromptUtil.findPromptDefinitionByName(promptValues = (PromptValuesInterface)pv, name, true, true, false)) != null) {
            ((SimpleContext)context).setVariable(name, ELEvaluator.expressionFactory.createValueExpression((Object)prompt, PromptDefinitionV2Interface.class));
            context.setPropertyResolved(true);
            return prompt;
        }
        return null;
    }

    private final boolean isResolvable(Object base) {
        return base == null || base instanceof PromptDefinitionInterface;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        Iterator fd = super.getFeatureDescriptors(context, base);
        if (this.isResolvable(base) && base != null) {
            ArrayList<FeatureDescriptor> featureList = new ArrayList<FeatureDescriptor>();
            while (fd.hasNext()) {
                featureList.add((FeatureDescriptor)fd.next());
            }
            FeatureDescriptor feature = new FeatureDescriptor();
            feature.setDisplayName("value");
            feature.setName("value");
            feature.setShortDescription("the value of the prompt definition");
            feature.setExpert(false);
            feature.setHidden(false);
            feature.setPreferred(true);
            feature.setValue("resolvableAtDesignTime", false);
            featureList.add(feature);
            return featureList.iterator();
        }
        return fd;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        if (base == null && property instanceof String) {
            String propertyName = (String)property;
            ValueExpression exp = context.getVariableMapper().resolveVariable(propertyName);
            if (exp == null) {
                PromptDefinitionInterface prompt = this.getPromptDefinition(context, propertyName);
                if (prompt != null) {
                    ((SimpleContext)context).setVariable(propertyName, ELEvaluator.expressionFactory.createValueExpression((Object)prompt, PromptDefinitionV2Interface.class));
                    context.setPropertyResolved(true);
                    return prompt;
                }
            } else {
                context.setPropertyResolved(true);
                return exp.getValue(context);
            }
            return super.getValue(context, base, property);
        }
        Object result = null;
        if (base instanceof PromptDefinitionInterface) {
            PromptDefinitionInterface promptDefinition = (PromptDefinitionInterface)base;
            if ("value".equals(property)) {
                try {
                    result = this.getPromptValue(context, promptDefinition);
                    context.setPropertyResolved(true);
                    return result;
                }
                catch (PromptValueNotFoundException e) {
                    throw new ELException(e.getCause());
                }
            }
            return super.getValue(context, base, property);
        }
        return super.getValue(context, base, property);
    }
}

