/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.prompts.definitions.vr.PersistableColumnDefinition;
import com.sas.storage.vr.dto.WSValueRetrieverConfiguration;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import java.util.List;
import java.util.Locale;

public final class WSValueRetrieverConfigDecorator
extends WSValueRetrieverConfiguration {
    private static final long serialVersionUID = 1L;
    private List<PersistableColumnDefinition> columnList = null;

    public WSValueRetrieverConfigDecorator(@NotNull WSValueRetrieverConfiguration vrConfig, @NotNull List<PersistableColumnDefinition> columnList) {
        ValidateArg.notNull((Object)vrConfig, (String)"vrConfig");
        ValidateArg.notNull(columnList, (String)"columnList");
        this.setContextKeyPrefix(vrConfig.getContextKeyPrefix());
        this.setDynamicSource(true);
        this.setEndpointURL(vrConfig.getEndpointURL());
        this.setHttpMethod(vrConfig.getHttpMethod());
        this.setSOAP(vrConfig.isSOAP());
        this.setSoapAction(vrConfig.getSoapAction());
        this.setSoapEndpointReference(vrConfig.getSoapEndpointReference());
        this.setSoapMessage(vrConfig.getSoapMessage());
        this.getNamespaces().addAll(vrConfig.getNamespaces());
        this.getQueryValues().addAll(vrConfig.getQueryValues());
        this.getSiteProperties().addAll(vrConfig.getSiteProperties());
        this.getWSColumnDefinitions().addAll(vrConfig.getWSColumnDefinitions());
        this.columnList = columnList;
    }

    WSValueRetrieverConfiguration getVRConfiguration(Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        WSValueRetrieverConfiguration retVal = new WSValueRetrieverConfiguration();
        retVal.setContextKeyPrefix(this.getContextKeyPrefix());
        retVal.setDynamicSource(true);
        retVal.setEndpointURL(this.getEndpointURL());
        retVal.setHttpMethod(this.getHttpMethod());
        retVal.setSOAP(this.isSOAP());
        retVal.setSoapAction(this.getSoapAction());
        retVal.setSoapEndpointReference(this.getSoapEndpointReference());
        retVal.setSoapMessage(this.getSoapMessage());
        retVal.getNamespaces().addAll(this.getNamespaces());
        retVal.getQueryValues().addAll(this.getQueryValues());
        retVal.getSiteProperties().addAll(this.getSiteProperties());
        for (PersistableColumnDefinition def : this.columnList) {
            retVal.getWSColumnDefinitions().add(def.getColumnDefinition(locale));
        }
        return retVal;
    }
}

