/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.ValueRetrieverDefinitionInterface;
import com.sas.prompts.definitions.vr.WSValueRetrieverConfigDecorator;
import com.sas.storage.valueretriever.StaticValueRetrieverConfiguration;
import com.sas.storage.vr.dto.DynamicValueRetrieverConfiguration;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import java.util.Locale;

public final class ValueRetrieverHelper {
    public static boolean hasADynamicVRConfig(@NotNull PromptDefinitionInterface prompt) {
        ValueRetrieverConfiguration config = ValueRetrieverHelper.getConfig(prompt);
        return ValueRetrieverHelper.isDynamic(config);
    }

    private static ValueRetrieverConfiguration getConfig(PromptDefinitionInterface prompt) {
        ValidateArg.notNull((Object)prompt, (String)"prompt");
        ValueRetrieverConfiguration config = null;
        if (prompt instanceof ValueRetrieverDefinitionInterface) {
            config = ((ValueRetrieverDefinitionInterface)((Object)prompt)).getValueRetrieverConfiguration();
        }
        return config;
    }

    public static boolean hasAStaticVRConfig(@NotNull PromptDefinitionInterface prompt) {
        ValueRetrieverConfiguration config = ValueRetrieverHelper.getConfig(prompt);
        return ValueRetrieverHelper.isStatic(config);
    }

    private static boolean isStatic(ValueRetrieverConfiguration config) {
        return null != config && config instanceof StaticValueRetrieverConfiguration;
    }

    private static boolean isDynamic(ValueRetrieverConfiguration config) {
        return null != config && (config.isDynamicSource() || config instanceof DynamicValueRetrieverConfiguration);
    }

    public static StaticValueRetrieverConfiguration getStaticValueRetriever(@NotNull PromptDefinitionInterface prompt) {
        ValueRetrieverConfiguration config = ValueRetrieverHelper.getConfig(prompt);
        if (ValueRetrieverHelper.isStatic(config) && config instanceof StaticValueRetrieverConfiguration) {
            return (StaticValueRetrieverConfiguration)config;
        }
        return null;
    }

    public static ValueRetrieverConfiguration getDynamicVRConfig(@NotNull PromptDefinitionInterface prompt, @NotNull Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        Object retVal = null;
        ValueRetrieverConfiguration config = ValueRetrieverHelper.getConfig(prompt);
        if (ValueRetrieverHelper.isDynamic(config)) {
            retVal = config instanceof WSValueRetrieverConfigDecorator ? ((WSValueRetrieverConfigDecorator)config).getVRConfiguration(locale) : config;
        }
        return retVal;
    }
}

