/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.prompts.definitions.ValueRetrieverDefinitionSupport;
import com.sas.prompts.util.MapText;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.valueretriever.LocalizableColumn;
import com.sas.storage.valueretriever.StaticValueRetrieverConfiguration;
import com.sas.storage.vr.dto.QueryProperty;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.uiconfig.ApplicationContext;
import com.sas.util.UsageVersion;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class StaticValueRetrieverSupport
extends ValueRetrieverDefinitionSupport {
    private static final long serialVersionUID = 1L;
    private StaticValueRetrieverConfiguration vrConfig = new StaticValueRetrieverConfiguration();

    @Override
    public ValueRetrieverConfiguration getValueRetrieverConfiguration() {
        return this.vrConfig;
    }

    @Override
    public void setValueRetrieverConfiguration(ValueRetrieverConfiguration config) {
        ValidateArg.notNull((Object)config, (String)"config");
        if (!(config instanceof StaticValueRetrieverConfiguration)) {
            throw new IllegalArgumentException("This method only accepts a StaticValueRetrieverConfiguration!");
        }
        this.vrConfig = (StaticValueRetrieverConfiguration)config;
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        this.vrConfig.configureAttributes(options, context);
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList mapText;
        super.consumeRelatedObjects(roHolder);
        ArrayList labels = roHolder.consumeObjects("LabelColumns");
        LocalizableColumn value = (LocalizableColumn)roHolder.consumeObject("ValueColumn");
        if (null != value) {
            this.vrConfig.configureValueColumn(value);
            this.getLogger2().debug("consumeRelObjects, setting value.");
        }
        if (!labels.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, setting labels.");
            this.vrConfig.configureLabelColumns((List)labels);
        }
        if (!(mapText = roHolder.consumeObjects("QueryProperties")).isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, for query properties");
            ArrayList<QueryProperty> list = new ArrayList<QueryProperty>();
            for (MapText text : mapText) {
                QueryProperty q = new QueryProperty();
                q.setName(text.getKey());
                q.setValue(text.getText());
                list.add(q);
            }
            this.vrConfig.setQueryProperties(list);
        }
    }

    @Override
    public void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing value item.");
        ArrayList<LocalizableColumn> value = new ArrayList<LocalizableColumn>();
        value.add(this.vrConfig.getWritableValueColumn());
        StaticValueRetrieverSupport.writeRelatedObjects(value, (Node)element, (PromptsWritingContext)writingContext, (String)"ValueColumn");
        this.getLogger2().debug("Writing labels.");
        ArrayList labels = new ArrayList();
        labels.addAll(this.vrConfig.getWritableLabelColumns());
        StaticValueRetrieverSupport.writeRelatedObjects(labels, (Node)element, (PromptsWritingContext)writingContext, (String)"LabelColumns");
        ArrayList<MapText> list = new ArrayList<MapText>();
        if (!this.vrConfig.getQueryProperties().isEmpty()) {
            this.getLogger2().debug("Writing query props.");
            for (QueryProperty item : this.vrConfig.getQueryProperties()) {
                MapText property = new MapText();
                property.setKey(item.getName());
                property.setText(item.getValue());
                list.add(property);
            }
            StaticValueRetrieverSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"QueryProperties");
        }
    }

    public String getDefinitionElementName() {
        return "StaticValueRetrieverSupport";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StaticValueRetrieverSupport retVal = (StaticValueRetrieverSupport)((Object)super.clone());
        retVal.vrConfig = new StaticValueRetrieverConfiguration();
        LinkedList<LocalizableColumn> list = new LinkedList<LocalizableColumn>();
        for (LocalizableColumn lcl : this.vrConfig.getWritableLabelColumns()) {
            list.add((LocalizableColumn)lcl.clone());
        }
        retVal.vrConfig.configureLabelColumns(list);
        retVal.vrConfig.configureValueColumn((LocalizableColumn)this.vrConfig.getWritableValueColumn().clone());
        retVal.vrConfig.setQueryProperties(this.vrConfig.getQueryProperties());
        return retVal;
    }

    @Override
    public void addLocalizedPropertiesFromValueRetriever(Locale locale, PropertyList list) {
        super.addLocalizedPropertiesFromValueRetriever(locale, list);
        list.addComment("StaticValueRetrieverConfiguration, the value column");
        list.addComment("The value is the column header text.");
        list.addComment("The rowLabel is the text for a row of this column.");
        PropertyList viList = this.vrConfig.getWritableValueColumn().getLocalizableProperties(locale);
        if (!viList.isEmpty()) {
            list.addProperty("ValueColumn", viList);
            if (!this.vrConfig.getWritableLabelColumns().isEmpty()) {
                int i = 0;
                for (LocalizableColumn lcl : this.vrConfig.getWritableLabelColumns()) {
                    list.addComment(" ");
                    list.addComment("StaticValueRetrieverConfiguration, a label column");
                    list.addComment("The value is the column header text.");
                    list.addComment("The rowLabel is the text for a row of this column.");
                    PropertyList lcList = lcl.getLocalizableProperties(locale);
                    list.addProperty("LabelColumn", i, lcList);
                    ++i;
                }
                this.getLogger2().debug("getLocalizableProperties(), added label columns", Integer.toString(i));
            }
        }
    }

    @Override
    public void setLocalizedPropertiesOnValueRetriever(Locale locale, PropertyMap map) {
        super.setLocalizedPropertiesOnValueRetriever(locale, map);
        if (map.containsNestedProperty("ValueColumn")) {
            this.vrConfig.getWritableValueColumn().setLocalizableProperties(locale, map.getNestedProperties("ValueColumn"));
        }
        this.getLogger2().debug("setLocalizableProperties, label cols=", Integer.toString(this.vrConfig.getWritableLabelColumns().size()));
        int i = 0;
        for (LocalizableColumn lcl : this.vrConfig.getWritableLabelColumns()) {
            if (map.containsIndexedNestedProperty("LabelColumn")) {
                lcl.setLocalizableProperties(locale, map.getNestedProperties("LabelColumn", i));
            }
            ++i;
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        super.setApplicationContext(applicationContext);
        if (null != applicationContext && null != applicationContext.getResourceBundleDelegate()) {
            List list = this.vrConfig.getWritableLabelColumns();
            for (LocalizableColumn label : list) {
                label.setResourceBundleDelegate(applicationContext.getResourceBundleDelegate());
            }
            this.vrConfig.getWritableValueColumn().setResourceBundleDelegate(applicationContext.getResourceBundleDelegate());
        }
    }

    @Override
    public List getAttributeDescriptors(Locale locale) {
        return Collections.emptyList();
    }

    public String getVersion() {
        return new UsageVersion(2, 0).toString();
    }
}

