/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.ResourceReferencesInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public class ValueProviderDefinitionSupport
extends AbstractPersistence {
    public static final String RB_KEY = "ValueProviderDefinitionSupport.";
    private static final long serialVersionUID = -3589105701056600911L;
    private boolean allowUserValues;
    private int pageSize;
    private ValueProviderInterface valueProvider;
    public static final int DEFAULT_PAGE_SIZE = 100;

    public ValueProviderDefinitionSupport() {
        this.init();
    }

    public ValueProviderDefinitionSupport(CommonLoggerInterface logger) {
        this.init();
    }

    private void init() {
        this.allowUserValues = true;
        this.pageSize = 100;
    }

    public boolean isAllowUserValues() {
        return this.allowUserValues;
    }

    public void setAllowUserValues(boolean allowUserValues) {
        this.allowUserValues = allowUserValues;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public ValueProviderInterface getValueProvider() {
        return this.valueProvider;
    }

    public void setValueProvider(ValueProviderInterface valueProvider) {
        this.valueProvider = valueProvider;
    }

    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        try {
            if (this.valueProvider instanceof DynamicValueProviderInterface) {
                return ((DynamicValueProviderInterface)this.valueProvider).getDependentPrompts(locale, dynamicValueContext);
            }
        }
        catch (ValueProviderException ve) {
            this.getLogger2().error(ve.getMessage(), (Throwable)ve);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<ValidationEntry> validateDefinition(PromptDefinitionInterface definition, DynamicPromptValueContextInterface dynamicValueContext, Locale locale) {
        try {
            if (this.getValueProvider() instanceof StaticValueProvider) {
                List list;
                SpecialValues sp;
                if (definition != null && definition.isDefaultValueSet() && definition.getDefaultValue() instanceof SpecialValues && (sp = (SpecialValues)definition.getDefaultValue()).equals(SpecialValues.ALL) && (list = (List)this.getValueProvider().getValues(locale)).isEmpty()) {
                    this.getLogger2().debug("validation failed due to empty value provider and SpecialValues.ALL");
                    String reason = RB.getStringResource(RB_KEY, "invalidStaticListRequiredNoAdditionalValue.txt", locale);
                    return PromptUtil.addError(null, 0x200000000L, reason);
                }
                Map errors = PromptUtil.getInvalidValuesInValueProvider(this.getValueProvider(), dynamicValueContext, definition, true, locale);
                if (errors != null && !errors.isEmpty()) {
                    Map.Entry entry = errors.entrySet().iterator().next();
                    Collection col = (Collection)entry.getValue();
                    String valueReason = null;
                    for (ValidationEntry ventry : col) {
                        if (valueReason == null) {
                            valueReason = ventry.getMessage();
                            continue;
                        }
                        valueReason = valueReason + "\n" + ventry.getMessage();
                    }
                    String reasons = Message.format((String)RB.getStringResource(RB_KEY, "invalidStaticValue.fmt.txt", locale), (Object)((ValueItem)entry.getKey()).getValue(), (Object)((ValueItem)entry.getKey()).getLabel(), (Object)valueReason);
                    return PromptUtil.addError(null, 0x200000000L, reasons);
                }
                if (definition.isRequired() && definition instanceof ValueProviderDefinitionInterface && !((ValueProviderDefinitionInterface)((Object)definition)).isAllowUserValues()) {
                    Object v;
                    boolean valid = false;
                    int numValid = 1;
                    if (definition instanceof SelectableDefinitionInterface) {
                        numValid = ((SelectableDefinitionInterface)definition).getMinimumValueCount();
                    }
                    int currentNum = 0;
                    if (definition instanceof SupportedSpecialValuesInterface) {
                        SupportedSpecialValues ssv = ((SupportedSpecialValuesInterface)definition).getSupportedSpecialValues();
                        if (ssv.isAllSupported() || ssv.isOtherSupported()) {
                            valid = true;
                        }
                        if (!valid && ssv.isMissingValuesSupported() && !ssv.isMissingValuesHiddenIfSupported()) {
                            ++currentNum;
                        }
                    }
                    if (!(valid || (v = this.getValueProvider().getValues(locale)) != null && ((Collection)v).size() + currentNum >= numValid)) {
                        String reason = numValid == 1 ? RB.getStringResource(RB_KEY, "invalidStaticListRequiredNoAdditionalValue.txt", locale) : Message.format((String)RB.getStringResource(RB_KEY, "invalidStaticListRequiredNoAdditionalValues.fmt.txt", locale), (Object)new Integer(numValid));
                        return PromptUtil.addError(null, 0x10000000000L, reason);
                    }
                }
            }
        }
        catch (ValueProviderException e) {
            return PromptUtil.addError(null, -1L, e.getMessage());
        }
        return Collections.emptyList();
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setAllowUserValues(provider.consumeBooleanAttr("allowUserValues", true));
        this.setPageSize(provider.consumeIntAttr("pageSize", 100));
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("ValueProvider");
        if (!list.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, setValueProvider() ");
            ValueProviderInterface vp = (ValueProviderInterface)list.get(0);
            this.setValueProvider(vp);
        }
    }

    public void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"allowUserValues", (boolean)this.isAllowUserValues(), (boolean)true);
        XmlUtil.setIntAttr((Element)element, (String)"pageSize", (int)this.getPageSize(), (int)100);
        this.writeValueProvider(element, writingContext);
    }

    protected void writeValueProvider(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getValueProvider()) {
            ArrayList<ValueProviderInterface> list = new ArrayList<ValueProviderInterface>();
            list.add(this.getValueProvider());
            this.getLogger2().debug("Writing valueProvider element.");
            ValueProviderDefinitionSupport.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"ValueProvider");
        }
    }

    public List getReferencedResources(Class type, boolean recursive) {
        if (recursive && this.getValueProvider() != null && this.getValueProvider() instanceof ResourceReferencesInterface) {
            return ((ResourceReferencesInterface)this.getValueProvider()).getReferencedResources(type, recursive);
        }
        return Collections.EMPTY_LIST;
    }

    public void configurePrompt(SelectableDefinitionInterface prompt, Map options, Map context) {
        if (options.containsKey("allowUserValues")) {
            this.setAllowUserValues(PromptConfigurationFactory.getBoolOption((String)"allowUserValues", (Map)options, (Map)context));
        }
        if (options.containsKey("pageSize")) {
            this.setPageSize(PromptConfigurationFactory.getIntOption((String)"pageSize", (Map)options, (Map)context));
        }
        try {
            ValueProviderInterface valueProvider = PromptConfigurationFactory.createValueProvider(this.getValueProvider(), options, context);
            this.setValueProvider(valueProvider);
        }
        catch (IllegalAccessException e) {
            this.getLogger2().error("ValueProviderDefinitionSupport.configurePrompt(): Unable to create value provider");
        }
        catch (ClassNotFoundException e) {
            this.getLogger2().error("ValueProviderDefinitionSupport.configurePrompt(): Unable to create value provider");
        }
        catch (InstantiationException e) {
            this.getLogger2().error("ValueProviderDefinitionSupport.configurePrompt(): Unable to create value provider");
        }
    }

    public List getAttributeDescriptors(Locale locale) {
        ArrayList<AttributeDescriptor> attributeList = new ArrayList<AttributeDescriptor>();
        attributeList.add(new AttributeDescriptor("allowUserValues", "allowUserValues", "boolean", (Object)this.isAllowUserValues(), null, true, true));
        attributeList.add(new AttributeDescriptor("pageSize", "pageSize", "int", (Object)this.getPageSize(), (Object)100, true, true));
        return attributeList;
    }
}

