/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.FontType;
import com.sas.models.FontInfoInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableFontDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public class FontDefinition
extends PromptDefinition
implements MutableFontDefinitionInterface {
    public static final String RB_KEY = "FontDefinition.";
    private static final long serialVersionUID = -9025234237308327258L;
    private int fontPromptType;
    private int minimumFontSize;
    private int maximumFontSize;
    private boolean required;
    private ValueProviderInterface fontFamilyProvider;

    public FontDefinition() {
        this.init();
    }

    public FontDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.required = false;
        this.fontFamilyProvider = null;
        this.setMaximumFontSize(144);
        this.setMinimumFontSize(6);
        this.fontPromptType = 3;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return FontType.DEFAULT_INSTANCE;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public void setFontPromptType(int fontPromptType) {
        if (fontPromptType != 3 && fontPromptType != 1 && fontPromptType != 2) {
            throw new IllegalArgumentException("Incorrect fontPromptType");
        }
        this.fontPromptType = fontPromptType;
    }

    @Override
    public void setFontFamilyValueProvider(ValueProviderInterface valueProvider) {
        this.fontFamilyProvider = valueProvider;
    }

    @Override
    public void setMaximumFontSize(int maximumFontSize) {
        this.maximumFontSize = maximumFontSize;
    }

    @Override
    public void setMinimumFontSize(int minimumFontSize) {
        this.minimumFontSize = minimumFontSize;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public int getFontPromptType() {
        return this.fontPromptType;
    }

    @Override
    public ValueProviderInterface getFontFamilyValueProvider() {
        return this.fontFamilyProvider;
    }

    @Override
    public int getMaximumFontSize() {
        return this.maximumFontSize;
    }

    @Override
    public int getMinimumFontSize() {
        return this.minimumFontSize;
    }

    public String getDefinitionElementName() {
        return "FontDefinition";
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setIntAttr((Element)element, (String)"fontPromptType", (int)this.fontPromptType);
        if (this.fontPromptType == 2 || this.fontPromptType == 3) {
            XmlUtil.setIntAttr((Element)element, (String)"minFontSize", (int)this.getMinimumFontSize(), (int)6);
            XmlUtil.setIntAttr((Element)element, (String)"maxFontSize", (int)this.getMaximumFontSize(), (int)144);
        }
        this.writeFontFamilyProvider(element, writingContext);
    }

    protected void writeFontFamilyProvider(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        if (null != this.getFontFamilyValueProvider()) {
            ArrayList<ValueProviderInterface> list = new ArrayList<ValueProviderInterface>();
            list.add(this.getFontFamilyValueProvider());
            this.getLogger2().debug("Writing valueProvider element.");
            FontDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"FontFamilyProvider");
        }
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("FontFamilyProvider");
        if (!list.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, setFontFamilyProvider() ");
            ValueProviderInterface vp = (ValueProviderInterface)list.get(0);
            this.setFontFamilyValueProvider(vp);
        }
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        int type = provider.consumeIntAttr("fontPromptType", 0);
        this.setFontPromptType(type);
        if (this.getFontPromptType() == 2 || this.getFontPromptType() == 3) {
            int maxFontSize = provider.consumeIntAttr("maxFontSize", 144);
            this.setMaximumFontSize(maxFontSize);
            int minFontSize = provider.consumeIntAttr("minFontSize", 6);
            this.setMinimumFontSize(minFontSize);
        }
        this.getLogger2().debug("consumeAttributes on ", this.getPromptName());
    }

    private long validateValue(Object value, int minFontSize, int maxFontSize) {
        long returnValue = 0L;
        if (value != null && !(value instanceof FontInfoInterface)) {
            returnValue |= 1L;
        } else if (value != null) {
            FontInfoInterface valueObject = (FontInfoInterface)value;
            if (valueObject.getFontFamily(Locale.getDefault()) == null) {
                returnValue |= 1L;
            }
            if (this.getFontPromptType() == 2 || this.getFontPromptType() == 3) {
                int numberValue = valueObject.getFontSize();
                if (minFontSize > numberValue) {
                    returnValue |= 2L;
                }
                if (maxFontSize < numberValue) {
                    returnValue |= 4L;
                }
            }
        }
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateValue(value, this.getMinimumFontSize(), this.getMaximumFontSize())) == 0L;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        long returnValue = 0L;
        if (this.getMinimumFontSize() > this.getMaximumFontSize()) {
            returnValue |= 8L;
        }
        if ((returnValue & 8L) == 8L) {
            errors = PromptUtil.addError(errors, 8L, RB.getStringResource(RB_KEY, "minAboveMax.txt", locale));
        }
        if (returnValue == 0L) {
            returnValue = this.validateValue(dv, this.getMinimumFontSize(), this.getMaximumFontSize());
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateValue(value, this.getMinimumFontSize(), this.getMaximumFontSize());
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotAFontInfoObject.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notAFontInfoObject.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 2L) == 2L) {
            errors = defaultValue ? PromptUtil.addError(errors, 2L, Message.format((String)RB.getStringResource(RB_KEY, "defaultFontSizeBelowMin.fmt.txt", locale), (Object)this.getMinimumFontSize())) : PromptUtil.addError(errors, 2L, Message.format((String)RB.getStringResource(RB_KEY, "FontSizeBelowMin.fmt.txt", locale), (Object)this.getMinimumFontSize()));
        }
        if ((errorCode & 4L) == 4L) {
            errors = defaultValue ? PromptUtil.addError(errors, 4L, Message.format((String)RB.getStringResource(RB_KEY, "defaultFontSizeAboveMax.fmt.txt", locale), (Object)this.getMaximumFontSize())) : PromptUtil.addError(errors, 4L, Message.format((String)RB.getStringResource(RB_KEY, "FontSizeAboveMax.fmt.txt", locale), (Object)this.getMaximumFontSize()));
        }
        return errors;
    }

    public void configureAttributes(Map options, Map context) {
        super.configureAttributes(options, context);
        if (options.containsKey("fontPromptType")) {
            this.setFontPromptType(PromptConfigurationFactory.getIntOption((String)"fontPromptType", (Map)options, (Map)context));
        }
        if ((this.getFontPromptType() == 2 || this.getFontPromptType() == 3) && options.containsKey("minFontSize")) {
            this.setMinimumFontSize(PromptConfigurationFactory.getIntOption((String)"minFontSize", (Map)options, (Map)context));
        }
        if ((this.getFontPromptType() == 2 || this.getFontPromptType() == 3) && options.containsKey("maxFontSize")) {
            this.setMaximumFontSize(PromptConfigurationFactory.getIntOption((String)"maxFontSize", (Map)options, (Map)context));
        }
        try {
            ValueProviderInterface valueProvider = PromptConfigurationFactory.createValueProvider(this.getFontFamilyValueProvider(), options, context);
            this.setFontFamilyValueProvider(valueProvider);
        }
        catch (Exception e) {
            this.getLogger2().error(" PromptConfigurationFactory.createValueProvider(): Unable to create value provider");
        }
    }

    public List getAttributeDescriptors(Locale locale) {
        List<?> attributeList = super.getAttributeDescriptors(locale);
        attributeList.add(new AttributeDescriptor("fontPromptType", "fontPromptType", "String", (Object)this.getFontPromptType(), true, true));
        if (this.getFontPromptType() == 2 || this.getFontPromptType() == 3) {
            attributeList.add(new AttributeDescriptor("minFontSize", "minFontSize", "int", (Object)this.getMinimumFontSize(), true, true));
            attributeList.add(new AttributeDescriptor("maxFontSize", "maxFontSize", "int", (Object)this.getMaximumFontSize(), true, true));
        }
        return attributeList;
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        NumberFormat numFormat = DecimalFormat.getInstance(locale);
        Map<String, String> retVal = super.getConstraints(locale);
        retVal.put("MINIMUM_FONT_SIZE", numFormat.format(this.getMinimumFontSize()));
        retVal.put("MAXIMUM_FONT_SIZE", numFormat.format(this.getMaximumFontSize()));
        return retVal;
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        try {
            if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                tempVersion = "2.0";
            }
        }
        catch (ParseException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }
}

