/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DoubleRangeType;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.BaseDefinitionRange;
import com.sas.prompts.definitions.MutableDoubleRangeDefinitionInterface;
import com.sas.prompts.definitions.RB;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.AttributeUtil;
import com.sas.util.NumberUtil;
import com.sas.util.macrovar.MacroVariableDecimalValueOptionInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

@SASScope(value="ALL")
public class DoubleRangeDefinition
extends BaseDefinitionRange
implements MutableDoubleRangeDefinitionInterface,
MacroVariableDecimalValueOptionInterface {
    public static final String RB_KEY = "DoubleRangeDefinition.";
    private static final long serialVersionUID = 6065291099941489163L;
    private double minimum;
    private double maximum;
    private int minimumDecimalPlaces;
    private int maximumDecimalPlaces;

    public DoubleRangeDefinition() {
        this.init();
    }

    public DoubleRangeDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.maximum = Double.MAX_VALUE;
        this.minimum = -1.7976931348623157E308;
        this.maximumDecimalPlaces = -1;
    }

    @Override
    protected String getDefaultMaxLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "maxLabel.txt", locale);
    }

    @Override
    protected String getDefaultMinLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "minLabel.txt", locale);
    }

    @SASScope
    public String getDefinitionElementName() {
        return "DoubleRangeDefinition";
    }

    @Override
    public double getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    @Override
    public double getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    @Override
    public void setMinimumDecimalPlaces(int minDecimalPlaces) {
        if (minDecimalPlaces <= -1) {
            throw new IllegalArgumentException(RB.getStringResource("DoubleDefinition.", "minDecimalBelowZero.txt"));
        }
        this.minimumDecimalPlaces = minDecimalPlaces;
    }

    @Override
    public void setMaximumDecimalPlaces(int maxDecimalPlaces) {
        if (maxDecimalPlaces < -1) {
            throw new IllegalArgumentException(RB.getStringResource("DoubleDefinition.", "maxDecimalInvalid.txt"));
        }
        this.maximumDecimalPlaces = maxDecimalPlaces;
    }

    @Override
    public int getMinimumDecimalPlaces() {
        return this.minimumDecimalPlaces;
    }

    @Override
    public int getMaximumDecimalPlaces() {
        return this.maximumDecimalPlaces;
    }

    private long validateMinMaxValue(double min, double max, Object value) {
        long returnValue = 0L;
        if (value != null) {
            if (value instanceof Object[] && ((Object[])value).length == 2) {
                Object[] objArray = (Object[])value;
                if (objArray[0] instanceof Double && objArray[1] instanceof Double) {
                    double minValue = -1.7976931348623157E308;
                    double maxValue = Double.MAX_VALUE;
                    minValue = (Double)objArray[0];
                    maxValue = (Double)objArray[1];
                    if (min != -1.7976931348623157E308 && minValue != -1.7976931348623157E308 && min > minValue) {
                        returnValue |= 0x100000L;
                    }
                    if (min != -1.7976931348623157E308 && maxValue != Double.MAX_VALUE && min > maxValue) {
                        returnValue |= 0x400000L;
                    }
                    if (max != Double.MAX_VALUE && minValue != -1.7976931348623157E308 && max < minValue) {
                        returnValue |= 0x200000L;
                    }
                    if (max != Double.MAX_VALUE && maxValue != Double.MAX_VALUE && max < maxValue) {
                        returnValue |= 0x800000L;
                    }
                    if (minValue != -1.7976931348623157E308 && maxValue != Double.MAX_VALUE && minValue > maxValue) {
                        returnValue |= 0x800L;
                    }
                    int decimalPlacesForMin = NumberUtil.getDecimalDigitCount((String)NumberUtil.toString((double)minValue, (Locale)Locale.US), (Locale)Locale.US);
                    if (this.getMaximumDecimalPlaces() >= 0 && decimalPlacesForMin > this.getMaximumDecimalPlaces()) {
                        returnValue |= 0x1000L;
                    }
                    int decimalPlacesForMax = NumberUtil.getDecimalDigitCount((String)NumberUtil.toString((double)maxValue, (Locale)Locale.US), (Locale)Locale.US);
                    if (this.getMaximumDecimalPlaces() >= 0 && decimalPlacesForMax > this.getMaximumDecimalPlaces()) {
                        returnValue |= 0x1000L;
                    }
                } else {
                    returnValue |= 1L;
                }
            } else {
                returnValue |= 1L;
            }
        }
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value)) == 0L;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        double min = this.getMinimum();
        double max = this.getMaximum();
        long returnValue = 0L;
        if (min != -1.7976931348623157E308 && max != Double.MAX_VALUE && min > max) {
            returnValue |= 8L;
        }
        if (this.getMinimumDecimalPlaces() >= 0 && this.getMaximumDecimalPlaces() >= 0 && this.getMinimumDecimalPlaces() > this.getMaximumDecimalPlaces()) {
            returnValue |= 0x2000L;
        }
        if (this.getMinimumDecimalPlaces() > 15) {
            returnValue |= 0x400000000L;
        }
        if (this.getMaximumDecimalPlaces() > 15) {
            returnValue |= 0x800000000L;
        }
        if ((returnValue & 8L) == 8L) {
            errors = PromptUtil.addError(errors, 8L, RB.getStringResource("SelectableDefinitionSupport.", "minAboveMax.txt", locale));
        }
        if ((returnValue & 0x2000L) == 8192L) {
            errors = PromptUtil.addError(errors, 8192L, RB.getStringResource("DoubleDefinition.", "minDecimalAboveMaxDecimal.txt", locale));
        }
        if ((returnValue & 0x400000000L) == 0x400000000L) {
            errors = PromptUtil.addError(errors, 0x400000000L, RB.getStringResource("DoubleDefinition.", "minDecimalAboveMaxPercision.txt", locale));
        }
        if ((returnValue & 0x800000000L) == 0x800000000L) {
            errors = PromptUtil.addError(errors, 0x800000000L, RB.getStringResource("DoubleDefinition.", "maxDecimalAboveMaxPercision.txt", locale));
        }
        if (returnValue == 0L) {
            returnValue = this.validateMinMaxValue(min, max, dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        errors = this.populateMapWithErrorsForValue(errors, errorCode, value, defaultValue, locale);
        if ((errorCode & 0x1000L) == 4096L) {
            errors = defaultValue ? PromptUtil.addError(errors, 4096L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueAboveMaxDecimalPlaces.fmt.txt", locale), (Object)new Integer(this.getMaximumDecimalPlaces()))) : PromptUtil.addError(errors, 4096L, Message.format((String)RB.getStringResource(RB_KEY, "valueAboveMaxDecimalPlaces.fmt.txt", locale), (Object)new Integer(this.getMaximumDecimalPlaces())));
        }
        errors = this.populateErrorsForMinMax(errors, errorCode, defaultValue, locale, value, new Double(this.getMinimum()), new Double(this.getMaximum()));
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return DoubleRangeType.DEFAULT_INSTANCE;
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        Double value = provider.consumeDoubleAttr("max", new Double(Double.MAX_VALUE));
        this.setMaximum(value);
        value = provider.consumeDoubleAttr("min", new Double(-1.7976931348623157E308));
        this.setMinimum(value);
        this.setMinimumDecimalPlaces(provider.consumeIntAttr("minDecimalPlaces", 0));
        this.setMaximumDecimalPlaces(provider.consumeIntAttr("maxDecimalPlaces", -1));
        this.getLogger2().debug("consumeAttributes on ", this.getPromptName());
    }

    @Override
    public List getAttributeDescriptors(Locale locale) {
        List attributeList = super.getAttributeDescriptors(locale);
        AttributeGroup constraints = AttributeUtil.getAttributeGroup((String)"Constraints", (List)attributeList, (boolean)true);
        AttributeGroup hidden = AttributeUtil.getAttributeGroup((String)"Hidden", (List)attributeList, (boolean)true);
        hidden.setVisible(false);
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        hidden.getAttributes().add(typeAttribute);
        constraints.getAttributes().add(new AttributeDescriptor("min", "min", "int", (Object)this.getMinimum(), (Object)-1.7976931348623157E308, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("max", "max", "int", (Object)this.getMaximum(), (Object)Double.MAX_VALUE, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("minDecimalPlaces", "minDecimalPlaces", "int", (Object)this.getMinimumDecimalPlaces(), (Object)0, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("maxDecimalPlaces", "maxDecimalPlaces", "int", (Object)this.getMaximumDecimalPlaces(), (Object)-1, true, true));
        return attributeList;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setDoubleAttr((Element)element, (String)"max", (double)this.getMaximum(), (double)Double.MAX_VALUE);
        XmlUtil.setDoubleAttr((Element)element, (String)"min", (double)this.getMinimum(), (double)-1.7976931348623157E308);
        XmlUtil.setIntAttr((Element)element, (String)"minDecimalPlaces", (int)this.getMinimumDecimalPlaces(), (int)0);
        XmlUtil.setIntAttr((Element)element, (String)"maxDecimalPlaces", (int)this.getMaximumDecimalPlaces(), (int)-1);
    }

    public void configureAttributes(Map options, Map context) {
        super.configureAttributes(options, context);
        if (options.containsKey("max")) {
            this.setMaximum(PromptConfigurationFactory.getDoubleOption((String)"max", (Map)options, (Map)context));
        }
        if (options.containsKey("min")) {
            this.setMinimum(PromptConfigurationFactory.getDoubleOption((String)"min", (Map)options, (Map)context));
        }
        if (options.containsKey("minDecimalPlaces")) {
            this.setMinimumDecimalPlaces(PromptConfigurationFactory.getIntOption((String)"minDecimalPlaces", (Map)options, (Map)context));
        }
        if (options.containsKey("maxDecimalPlaces")) {
            this.setMaximumDecimalPlaces(PromptConfigurationFactory.getIntOption((String)"maxDecimalPlaces", (Map)options, (Map)context));
        }
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        NumberFormat numFormat = DecimalFormat.getInstance(locale);
        Map<String, String> retVal = super.getConstraints(locale);
        retVal.put("MINIMUM", numFormat.format(this.minimum));
        retVal.put("MAXIMUM", numFormat.format(this.maximum));
        retVal.put("MINIMUM_DECIMAL_PLACES", numFormat.format(this.minimumDecimalPlaces));
        retVal.put("MAXIMUM_DECIMAL_PLACES", numFormat.format(this.maximumDecimalPlaces));
        return retVal;
    }
}

