/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DoubleType;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableDoubleDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.SelectableDefinitionSupport;
import com.sas.prompts.definitions.SupportedSpecialValuesDefinitionSupport;
import com.sas.prompts.definitions.ValueProviderDefinitionSupport;
import com.sas.prompts.definitions.ValueRetrieverDefinitionSupport;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.AttributeUtil;
import com.sas.util.NumberUtil;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.macrovar.MacroVariableDecimalValueOptionInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class DoubleDefinition
extends PromptDefinition
implements MutableDoubleDefinitionV2Interface,
MacroVariableDecimalValueOptionInterface {
    public static final String RB_KEY = "DoubleDefinition.";
    private static final long serialVersionUID = 3498115395123397144L;
    private double minimum;
    private double maximum;
    private int minimumDecimalPlaces;
    private int maximumDecimalPlaces;
    private SelectableDefinitionSupport selectableSupport;
    private ValueProviderDefinitionSupport valueProviderSupport;
    private SupportedSpecialValuesDefinitionSupport specialValueSupport;
    private ValueRetrieverDefinitionSupport vrDefSupport;

    public DoubleDefinition() {
        this.init();
    }

    public DoubleDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.maximum = Double.MAX_VALUE;
        this.minimum = -1.7976931348623157E308;
        this.maximumDecimalPlaces = -1;
        this.selectableSupport = new SelectableDefinitionSupport(this);
        this.valueProviderSupport = new ValueProviderDefinitionSupport();
        this.specialValueSupport = new SupportedSpecialValuesDefinitionSupport();
        this.vrDefSupport = new ValueRetrieverDefinitionSupport();
    }

    @Override
    public double getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(double minimum) {
        this.minimum = minimum;
    }

    @Override
    public double getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(double maximum) {
        this.maximum = maximum;
    }

    @Override
    @SASScope
    public int getPageSize() {
        return this.valueProviderSupport.getPageSize();
    }

    @Override
    @SASScope
    public void setPageSize(int pageSize) {
        this.valueProviderSupport.setPageSize(pageSize);
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        return super.isPromptValueValid(value, locale) && this.specialValueSupport.isPromptValueValid(value) && this.selectableSupport.isPromptValueValid(value);
    }

    @Override
    @SASScope
    public boolean validIndividualValue(Object value) {
        return this.validIndividualValue(value, Locale.getDefault());
    }

    @Override
    @SASScope
    public Collection<ValidationEntry> getIndivdualPromptValueValidationErrors(Object value, Locale locale) {
        long returnValue = this.validateMinMaxIndividualValue(this.minimum, this.maximum, value);
        if (returnValue == 0L) {
            return this.specialValueSupport.getPromptValueValidationErrors(value, locale);
        }
        return this.populateMapWithErrors(null, returnValue, value, false, locale);
    }

    private long validateMinMaxIndividualValue(double min, double max, Object value) {
        long returnValue = 0L;
        if (value instanceof Number) {
            double numberValue = ((Number)value).doubleValue();
            if (min > numberValue) {
                returnValue |= 2L;
            }
            if (max < numberValue) {
                returnValue |= 4L;
            }
            int decimalPlaces = NumberUtil.getDecimalDigitCount((String)NumberUtil.toString((double)numberValue, (Locale)Locale.US), (Locale)Locale.US);
            if (this.getMaximumDecimalPlaces() != -1 && decimalPlaces > this.getMaximumDecimalPlaces()) {
                returnValue |= 0x1000L;
            }
        }
        if (value != null && !(value instanceof Number) && !PromptUtil.isValueSupported(this, value)) {
            returnValue |= 1L;
        }
        return returnValue;
    }

    private long validateMinMaxValue(double min, double max, Object value) {
        long returnValue = 0L;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                returnValue |= this.validateMinMaxIndividualValue(min, max, array[i]);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                returnValue |= this.validateMinMaxIndividualValue(min, max, element);
            }
        } else {
            returnValue |= this.validateMinMaxIndividualValue(min, max, value);
        }
        return returnValue;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        errors = PromptUtil.addErrors(errors, this.selectableSupport.getPromptValueValidationErrors(value, locale));
        errors = PromptUtil.addErrors(errors, this.specialValueSupport.getPromptValueValidationErrors(value, locale));
        long returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value);
        if (null == (errors = this.populateMapWithErrors(errors, returnValue, value, false, locale))) {
            errors = Collections.emptyList();
        }
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        errors = PromptUtil.addErrors(errors, this.selectableSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors(errors, this.specialValueSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors(errors, this.valueProviderSupport.validateDefinition(this, null, locale));
        errors = PromptUtil.addErrors(errors, this.vrDefSupport.validateDefinitionWithDefinition(this, locale));
        long returnValue = 0L;
        if (this.getMinimum() > this.getMaximum()) {
            returnValue |= 8L;
        }
        if (this.getMinimumDecimalPlaces() >= 0 && this.getMaximumDecimalPlaces() >= 0 && this.getMinimumDecimalPlaces() > this.getMaximumDecimalPlaces()) {
            returnValue |= 0x2000L;
        }
        if (this.getMinimumDecimalPlaces() > 15) {
            returnValue |= 0x400000000L;
        }
        if (this.getMaximumDecimalPlaces() > 15) {
            returnValue |= 0x800000000L;
        }
        if ((returnValue & 8L) == 8L) {
            errors = PromptUtil.addError(errors, 8L, RB.getStringResource("SelectableDefinitionSupport.", "minAboveMax.txt", locale));
        }
        if ((returnValue & 0x2000L) == 8192L) {
            errors = PromptUtil.addError(errors, 8192L, RB.getStringResource(RB_KEY, "minDecimalAboveMaxDecimal.txt", locale));
        }
        if ((returnValue & 0x400000000L) == 0x400000000L) {
            errors = PromptUtil.addError(errors, 0x400000000L, RB.getStringResource(RB_KEY, "minDecimalAboveMaxPercision.txt", locale));
        }
        if ((returnValue & 0x800000000L) == 0x800000000L) {
            errors = PromptUtil.addError(errors, 0x800000000L, RB.getStringResource(RB_KEY, "maxDecimalAboveMaxPercision.txt", locale));
        }
        if (returnValue == 0L) {
            returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotADouble.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notADouble.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 2L) == 2L) {
            errors = defaultValue ? PromptUtil.addError(errors, 2L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.", "defaultValueBelowMin.fmt.txt", locale), (Object)new Double(this.getMinimum()))) : PromptUtil.addError(errors, 2L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.", "valueBelowMin.fmt.txt", locale), (Object)new Double(this.getMinimum())));
        }
        if ((errorCode & 4L) == 4L) {
            errors = defaultValue ? PromptUtil.addError(errors, 4L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.", "defaultValueAboveMax.fmt.txt", locale), (Object)new Double(this.getMaximum()))) : PromptUtil.addError(errors, 4L, Message.format((String)RB.getStringResource("SelectableDefinitionSupport.", "valueAboveMax.fmt.txt", locale), (Object)new Double(this.getMaximum())));
        }
        if ((errorCode & 0x1000L) == 4096L) {
            errors = defaultValue ? PromptUtil.addError(errors, 4096L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueAboveMaxDecimalPlaces.fmt.txt", locale), (Object)new Integer(this.getMaximumDecimalPlaces()))) : PromptUtil.addError(errors, 4096L, Message.format((String)RB.getStringResource(RB_KEY, "valueAboveMaxDecimalPlaces.fmt.txt", locale), (Object)new Integer(this.getMaximumDecimalPlaces())));
        }
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        if (this.getSelectionType() == 300) {
            return DoubleType.DEFAULT_INSTANCE;
        }
        return CollectionType.DEFAULT_INSTANCE_DOUBLE;
    }

    @Override
    public int getMinimumDecimalPlaces() {
        return this.minimumDecimalPlaces;
    }

    @Override
    public void setMinimumDecimalPlaces(int minimumDecimalPlaces) {
        if (minimumDecimalPlaces <= -1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "minDecimalBelowZero.txt"));
        }
        this.minimumDecimalPlaces = minimumDecimalPlaces;
    }

    @Override
    public int getMaximumDecimalPlaces() {
        return this.maximumDecimalPlaces;
    }

    @Override
    public void setMaximumDecimalPlaces(int maximumDecimalPlaces) {
        if (maximumDecimalPlaces < -1) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "maxDecimalInvalid.txt"));
        }
        this.maximumDecimalPlaces = maximumDecimalPlaces;
    }

    @SASScope
    public String getDefinitionElementName() {
        return "DoubleDefinition";
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.selectableSupport.consumeAttributes(provider);
        this.valueProviderSupport.consumeAttributes(provider);
        this.specialValueSupport.consumeAttributes(provider);
        Double value = provider.consumeDoubleAttr("max", new Double(Double.MAX_VALUE));
        this.setMaximum(value);
        value = provider.consumeDoubleAttr("min", new Double(-1.7976931348623157E308));
        this.setMinimum(value);
        this.setMinimumDecimalPlaces(provider.consumeIntAttr("minDecimalPlaces", 0));
        this.setMaximumDecimalPlaces(provider.consumeIntAttr("maxDecimalPlaces", -1));
        this.getLogger2().debug("consumeAttributes on ", this.getPromptName());
    }

    public List getAttributeDescriptors(Locale locale) {
        List<?> attributeList = super.getAttributeDescriptors(locale);
        AttributeGroup constraints = AttributeUtil.getAttributeGroup((String)"Constraints", attributeList, (boolean)true);
        AttributeGroup hidden = AttributeUtil.getAttributeGroup((String)"Hidden", attributeList, (boolean)true);
        hidden.setVisible(false);
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        hidden.getAttributes().add(typeAttribute);
        constraints.getAttributes().add(new AttributeDescriptor("min", "min", "int", (Object)this.getMinimum(), (Object)-1.7976931348623157E308, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("max", "max", "int", (Object)this.getMaximum(), (Object)Double.MAX_VALUE, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("minDecimalPlaces", "minDecimalPlaces", "int", (Object)this.getMinimumDecimalPlaces(), (Object)0, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("maxDecimalPlaces", "maxDecimalPlaces", "int", (Object)this.getMaximumDecimalPlaces(), (Object)-1, true, true));
        attributeList.addAll(this.vrDefSupport.getAttributeDescriptors(locale));
        return attributeList;
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.selectableSupport.writeDefinition(element, writingContext);
        this.valueProviderSupport.writeDefinition(element, writingContext);
        this.specialValueSupport.writeDefinition(element, writingContext);
        if (null != this.vrDefSupport.getValueRetrieverConfiguration()) {
            ArrayList<ValueRetrieverDefinitionSupport> list = new ArrayList<ValueRetrieverDefinitionSupport>();
            list.add(this.vrDefSupport);
            this.getLogger2().debug("Writing value retriever element.");
            DoubleDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"ValueRetrieverConfiguration");
        }
        XmlUtil.setDoubleAttr((Element)element, (String)"max", (double)this.getMaximum(), (double)Double.MAX_VALUE);
        XmlUtil.setDoubleAttr((Element)element, (String)"min", (double)this.getMinimum(), (double)-1.7976931348623157E308);
        XmlUtil.setIntAttr((Element)element, (String)"minDecimalPlaces", (int)this.getMinimumDecimalPlaces(), (int)0);
        XmlUtil.setIntAttr((Element)element, (String)"maxDecimalPlaces", (int)this.getMaximumDecimalPlaces(), (int)-1);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.selectableSupport.consumeRelatedObjects(roHolder);
        this.valueProviderSupport.consumeRelatedObjects(roHolder);
        this.specialValueSupport.consumeRelatedObjects(roHolder);
        ValueRetrieverDefinitionSupport temp = ValueRetrieverDefinitionSupport.newInstanceFromPersistence(roHolder);
        if (null != temp) {
            this.vrDefSupport = temp;
        }
        this.specialValueSupport.setAllowMissing(false);
        if (this.vrDefSupport != null && this.vrDefSupport.getValueRetrieverConfiguration() != null && this.vrDefSupport.getValueRetrieverConfiguration().isDynamicSource()) {
            this.specialValueSupport.setAllowMissing(true);
        }
        if (this.valueProviderSupport.getValueProvider() != null && !(this.valueProviderSupport.getValueProvider() instanceof StaticValueProvider)) {
            this.specialValueSupport.setAllowMissing(true);
        }
    }

    @Override
    @SASScope
    public List getReferencedResources(Class type, boolean recursive) {
        List list1 = this.vrDefSupport.getReferencedResources(type, recursive);
        if (list1.isEmpty()) {
            List list2 = this.valueProviderSupport.getReferencedResources(type, recursive);
            return list2;
        }
        return list1;
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        this.selectableSupport.configurePrompt(this, options, context);
        this.specialValueSupport.configurePrompt(this, options, context);
        super.configureAttributes(options, context);
        if (options.containsKey("max")) {
            this.setMaximum(PromptConfigurationFactory.getDoubleOption((String)"max", options, context));
        }
        if (options.containsKey("min")) {
            this.setMinimum(PromptConfigurationFactory.getDoubleOption((String)"min", options, context));
        }
        if (options.containsKey("minDecimalPlaces")) {
            this.setMinimumDecimalPlaces(PromptConfigurationFactory.getIntOption((String)"minDecimalPlaces", options, context));
        }
        if (options.containsKey("maxDecimalPlaces")) {
            this.setMaximumDecimalPlaces(PromptConfigurationFactory.getIntOption((String)"maxDecimalPlaces", options, context));
        }
        this.valueProviderSupport.configurePrompt(this, options, context);
        this.vrDefSupport = ValueRetrieverDefinitionSupport.changeInstanceType(this.vrDefSupport, options);
        this.vrDefSupport.configureAttributes(options, context);
    }

    @Override
    public boolean isRequired() {
        return this.selectableSupport.isRequired();
    }

    @Override
    public int getMaximumValueCount() {
        return this.selectableSupport.getMaximumValueCount();
    }

    @Override
    public int getMinimumValueCount() {
        return this.selectableSupport.getMinimumValueCount();
    }

    @Override
    public int getSelectionType() {
        return this.selectableSupport.getSelectionType();
    }

    @Override
    public boolean isSelectionOrdered() {
        return this.selectableSupport.isSelectionOrdered();
    }

    @Override
    public void setMaximumValueCount(int maximumValueCount) {
        this.selectableSupport.setMaximumValueCount(maximumValueCount);
    }

    @Override
    public void setMinimumValueCount(int minimumValueCount) {
        this.selectableSupport.setMinimumValueCount(minimumValueCount);
    }

    @Override
    public void setSelectionOrdered(boolean selectionOrdered) {
        this.selectableSupport.setSelectionOrdered(selectionOrdered);
    }

    @SASScope
    public int getMacroVariableListFormat() {
        return this.selectableSupport.getMacroVariableListFormat();
    }

    @SASScope
    public String getMacroVariableQuote() {
        return this.selectableSupport.getMacroVariableQuote();
    }

    @SASScope
    public String getMacroVariableListDelimiter() {
        return this.selectableSupport.getMacroVariableListDelimiter();
    }

    @SASScope
    public void setMacroVariableListFormat(int listFormat) {
        this.selectableSupport.setMacroVariableListFormat(listFormat);
    }

    @SASScope
    public void setMacroVariableQuote(String quote) {
        this.selectableSupport.setMacroVariableQuote(quote);
    }

    @SASScope
    public void setMacroVariableListDelimiter(String delimiter) {
        this.selectableSupport.setMacroVariableListDelimiter(delimiter);
    }

    @Override
    public ValueProviderInterface getValueProvider() {
        return this.valueProviderSupport.getValueProvider();
    }

    public boolean isAllowUserValues() {
        return this.valueProviderSupport.isAllowUserValues();
    }

    @Override
    public void setValueProvider(ValueProviderInterface valueProvider) {
        this.valueProviderSupport.setValueProvider(valueProvider);
        if (valueProvider != null && !(valueProvider instanceof StaticValueProvider)) {
            this.specialValueSupport.setAllowMissing(true);
        } else if (this.vrDefSupport == null) {
            this.specialValueSupport.setAllowMissing(false);
        }
    }

    @Override
    public void setAllowUserValues(boolean allowValues) {
        this.valueProviderSupport.setAllowUserValues(allowValues);
    }

    @SASScope
    public Collection getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        try {
            if (this.valueProviderSupport.getValueProvider() instanceof DynamicValueProviderInterface) {
                return ((DynamicValueProviderInterface)this.valueProviderSupport.getValueProvider()).getDependentPrompts(locale, dynamicValueContext);
            }
        }
        catch (ValueProviderException ve) {
            this.getLogger2().error(ve.getMessage(), (Throwable)ve);
        }
        return this.vrDefSupport.getDependentPrompts(locale, dynamicValueContext);
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValueSupport.getSupportedSpecialValues();
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValuesSupported) {
        this.specialValueSupport.setSupportedSpecialValues(specialValuesSupported);
    }

    @Override
    @SASScope
    public PropertyList getLocalizableProperties(Locale locale) {
        PropertyList list = super.getLocalizableProperties(locale);
        PromptUtil.addLocalizedPropertiesFromValueProvider(list, this.valueProviderSupport, locale);
        this.vrDefSupport.addLocalizedPropertiesFromValueRetriever(locale, list);
        return list;
    }

    @Override
    @SASScope
    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        super.setLocalizableProperties(locale, map);
        PromptUtil.setLocalizedPropertiesOnValueProvider(map, this.valueProviderSupport, locale);
        this.vrDefSupport.setLocalizedPropertiesOnValueRetriever(locale, map);
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        NumberFormat numFormat = DecimalFormat.getInstance(locale);
        Map<String, String> retVal = super.getConstraints(locale);
        retVal.put("MINIMUM", numFormat.format(this.getMinimum()));
        retVal.put("MAXIMUM", numFormat.format(this.getMaximum()));
        retVal.put("MINIMUM_DECIMAL_PLACES", numFormat.format(this.getMinimumDecimalPlaces()));
        this.selectableSupport.addConstraints(retVal, numFormat);
        return retVal;
    }

    @Override
    public void setValueRetrieverConfiguration(ValueRetrieverConfiguration config) {
        this.vrDefSupport = ValueRetrieverDefinitionSupport.newInstance(config);
        if (config != null && config.isDynamicSource()) {
            this.specialValueSupport.setAllowMissing(true);
        } else {
            this.specialValueSupport.setAllowMissing(false);
        }
    }

    @Override
    public ValueRetrieverConfiguration getValueRetrieverConfiguration() {
        this.vrDefSupport.setApplicationContext(this.getApplicationContext());
        ValueRetrieverConfiguration vrc = this.vrDefSupport.getValueRetrieverConfiguration();
        return vrc;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DoubleDefinition clone = (DoubleDefinition)super.clone();
        if (null != this.vrDefSupport) {
            clone.vrDefSupport = (ValueRetrieverDefinitionSupport)((Object)this.vrDefSupport.clone());
        }
        return clone;
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        if (null != this.getValueRetrieverConfiguration()) {
            try {
                if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                    tempVersion = "2.0";
                }
            }
            catch (ParseException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }

    @Override
    public boolean validIndividualValue(Object value, Locale locale) {
        long returnValue = this.validateMinMaxIndividualValue(this.minimum, this.maximum, value);
        return returnValue == 0L ? this.specialValueSupport.isPromptValueValid(value) : false;
    }
}

