/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.DateRangeType;
import com.sas.datatypes.TimeRangeType;
import com.sas.datatypes.TimeStampRangeType;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.BaseDefinitionRange;
import com.sas.prompts.definitions.DateDefinition;
import com.sas.prompts.definitions.MutableDateRangeDefinitionV3Interface;
import com.sas.prompts.definitions.RB;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.AttributeUtil;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

@SASScope(value="ALL")
public class DateRangeDefinition
extends BaseDefinitionRange
implements MutableDateRangeDefinitionV3Interface {
    private static final String RB_KEY = "DateRangeDefinition.";
    private static final long serialVersionUID = 3264201471282456334L;
    private Date minimum;
    private Date maximum;
    private Date minMin;
    private Date maxMax;
    private DateTypes dateType;
    private String dateRelativity;

    public DateRangeDefinition() {
        this.init();
    }

    public DateRangeDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.minimum = DateDefinition.minimumMinimum;
        this.maximum = DateDefinition.maximumMaximum;
        this.dateType = DateTypes.DATE;
        this.dateRelativity = "All";
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        if (!"All".equals(this.getDateRelativity()) || null != this.getMinMin() || null != this.getMaxMax()) {
            try {
                if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                    tempVersion = "2.1";
                }
            }
            catch (ParseException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }

    @Override
    public Date getMinMin() {
        if (this.minMin != null) {
            return (Date)this.minMin.clone();
        }
        return null;
    }

    @Override
    public void setMinMin(Date minMin) {
        if (minMin != null) {
            this.minMin = minMin;
        }
        if (this.minimum.equals(DateDefinition.minimumMinimum)) {
            this.minimum = this.minMin;
        }
    }

    @Override
    public Date getMaxMax() {
        if (this.maxMax != null) {
            return (Date)this.maxMax.clone();
        }
        return null;
    }

    @Override
    public void setMaxMax(Date maxMax) {
        if (maxMax != null) {
            this.maxMax = maxMax;
        }
        if (this.maximum.equals(DateDefinition.maximumMaximum)) {
            this.maximum = this.maxMax;
        }
    }

    @Override
    protected String getDefaultMaxLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "maxLabel.txt", locale);
    }

    @Override
    protected String getDefaultMinLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "minLabel.txt", locale);
    }

    @SASScope
    public String getDefinitionElementName() {
        return "DateRangeDefinition";
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        if (this.dateType == DateTypes.DATE) {
            return DateRangeType.DEFAULT_INSTANCE_DATE;
        }
        if (this.dateType == DateTypes.TIME) {
            return TimeRangeType.DEFAULT_INSTANCE_TIME;
        }
        if (this.dateType == DateTypes.TIMESTAMP) {
            return TimeStampRangeType.DEFAULT_INSTANCE_TIMESTAMP;
        }
        if (this.dateType == DateTypes.WEEK) {
            return DateRangeType.DEFAULT_INSTANCE_WEEK;
        }
        if (this.dateType == DateTypes.MONTH) {
            return DateRangeType.DEFAULT_INSTANCE_MONTH;
        }
        if (this.dateType == DateTypes.QUARTER) {
            return DateRangeType.DEFAULT_INSTANCE_QUARTER;
        }
        if (this.dateType == DateTypes.YEAR) {
            return DateRangeType.DEFAULT_INSTANCE_YEAR;
        }
        if (this.dateType == DateTypes.WEEKDAY) {
            return DateRangeType.DEFAULT_INSTANCE_WEEKDAY;
        }
        throw new IllegalStateException(Message.format((String)RB.getStringResource("DateDefinition.", "unknownDateType.fmt.txt"), (Object)this.dateType));
    }

    @Override
    public Date getMinimum() {
        if (this.minimum != null) {
            return (Date)this.minimum.clone();
        }
        return null;
    }

    @Override
    public void setMinimum(Date minimum) {
        if (minimum != null) {
            this.validateMinimumV3(minimum, this.getLogger2());
            this.minimum = (Date)minimum.clone();
        } else {
            this.minimum = DateDefinition.minimumMinimum;
        }
    }

    @Override
    public Date getMaximum() {
        if (this.maximum != null) {
            return (Date)this.maximum.clone();
        }
        return null;
    }

    @Override
    public void setMaximum(Date maximum) {
        if (maximum != null) {
            this.validateMaximumV3(maximum, this.getLogger2());
            this.maximum = (Date)maximum.clone();
        } else {
            this.maximum = DateDefinition.maximumMaximum;
        }
    }

    private Date minMinValue() {
        if (this.minMin != null) {
            return this.minMin;
        }
        return DateDefinition.minimumMinimum;
    }

    private Date maxMaxValue() {
        if (this.maxMax != null) {
            return this.maxMax;
        }
        return DateDefinition.maximumMaximum;
    }

    boolean validateMinimumV3(Date minimum, CommonLoggerInterface logger) {
        if (minimum.before(this.minMinValue())) {
            throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.minMin.txt"));
        }
        if (minimum.after(this.maxMaxValue())) {
            throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.maxMax.txt"));
        }
        if (minimum instanceof DatePeriod) {
            DatePeriod min = (DatePeriod)minimum;
            if (min.isRelativeDate()) {
                if (DateDefinition.validatePastRelativeDate(min, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.periodStarts200.txt"));
                }
                if (DateDefinition.validateFutureRelativeDate(min, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.periodEnds200.txt"));
                }
            } else {
                Date compareMaxMaxValue;
                Date compareMinMinValue = this.minMinValue() instanceof DatePeriod ? ((DatePeriod)this.minMinValue()).getStartOfPeriod() : this.minMinValue();
                Date date = compareMaxMaxValue = this.maxMaxValue() instanceof DatePeriod ? ((DatePeriod)this.maxMaxValue()).getEndOfPeriod() : this.maxMaxValue();
                if (min.getStartOfPeriod().before(compareMinMinValue)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.minMin.txt"));
                }
                if (min.getEndOfPeriod().after(compareMaxMaxValue)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.maxMax.txt"));
                }
            }
        }
        return true;
    }

    boolean validateMaximumV3(Date maximum, CommonLoggerInterface logger) {
        if (maximum.after(this.maxMaxValue())) {
            throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.maxMax.txt"));
        }
        if (maximum.before(this.minMinValue())) {
            throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.minMin.txt"));
        }
        if (maximum instanceof DatePeriod) {
            DatePeriod max = (DatePeriod)maximum;
            if (max.isRelativeDate()) {
                if (DateDefinition.validatePastRelativeDate(max, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.periodStarts200.txt"));
                }
                if (DateDefinition.validateFutureRelativeDate(max, 0L, logger) != 0L) {
                    throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.periodEnds200.txt"));
                }
            } else {
                Date compareMaxMaxValue;
                Date compareMinMinValue = this.minMinValue() instanceof DatePeriod ? ((DatePeriod)this.minMinValue()).getStartOfPeriod() : this.minMinValue();
                Date date = compareMaxMaxValue = this.maxMaxValue() instanceof DatePeriod ? ((DatePeriod)this.maxMaxValue()).getEndOfPeriod() : this.maxMaxValue();
                if (max.getStartOfPeriod().before(compareMinMinValue)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.minMin.txt"));
                }
                if (max.getEndOfPeriod().after(compareMaxMaxValue)) {
                    throw new IllegalArgumentException(RB.getStringResource("DateRangeDefinition.maxMax.txt"));
                }
            }
        }
        return true;
    }

    private long validateMinMaxValue(Date min, Date max, Object value) {
        long returnValue = 0L;
        long minTime = -1L;
        long maxTime = -1L;
        if (min instanceof DatePeriod) {
            minTime = ((DatePeriod)min).getStartOfPeriod().getTime();
        } else if (min != null) {
            minTime = min.getTime();
        }
        if (max instanceof DatePeriod) {
            maxTime = ((DatePeriod)max).getEndOfPeriod().getTime();
        } else if (max != null) {
            maxTime = max.getTime();
        }
        if (value != null) {
            if (value instanceof Object[] && ((Object[])value).length == 2) {
                Object[] objArray = (Object[])value;
                if (objArray[0] instanceof Date && objArray[1] instanceof Date) {
                    long minValueTime = -1L;
                    long maxValueTime = -1L;
                    if (objArray[0] instanceof DatePeriod) {
                        minValueTime = ((DatePeriod)objArray[0]).getStartOfPeriod().getTime();
                        if (((DatePeriod)objArray[0]).isRelativeDate()) {
                            returnValue |= DateDefinition.validatePastRelativeDate((DatePeriod)objArray[0], returnValue, this.getLogger2());
                        }
                    } else {
                        minValueTime = ((Date)objArray[0]).getTime();
                    }
                    if (objArray[1] instanceof DatePeriod) {
                        maxValueTime = ((DatePeriod)objArray[1]).getEndOfPeriod().getTime();
                        if (((DatePeriod)objArray[1]).isRelativeDate()) {
                            returnValue |= DateDefinition.validateFutureRelativeDate((DatePeriod)objArray[1], returnValue, this.getLogger2());
                        }
                    } else {
                        maxValueTime = ((Date)objArray[1]).getTime();
                    }
                    if (minTime != -1L && minValueTime != -1L && minTime > minValueTime) {
                        returnValue |= 0x100000L;
                    }
                    if (minTime != -1L && maxValueTime != -1L && minTime > maxValueTime) {
                        returnValue |= 0x400000L;
                    }
                    if (maxTime != -1L && minValueTime != -1L && maxTime < minValueTime) {
                        returnValue |= 0x200000L;
                    }
                    if (maxTime != -1L && maxValueTime != -1L && maxTime < maxValueTime) {
                        returnValue |= 0x800000L;
                    }
                    if (this.getDateType() != DateTypes.TIME && minValueTime != -1L && maxValueTime != -1L && minValueTime > maxValueTime) {
                        returnValue |= 0x800L;
                    }
                } else {
                    returnValue |= 1L;
                }
            } else {
                returnValue |= 1L;
            }
        }
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        if (super.isPromptValueValid(value, locale)) {
            boolean isDateRelativityValid;
            boolean bl = isDateRelativityValid = this.isRelativeAllowed() && this.isValidRelativeValue(value);
            if (!this.isRelativeAllowed()) {
                isDateRelativityValid = true;
                if (this.isRelativeDate(value)) {
                    isDateRelativityValid = false;
                }
            }
            long returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value);
            if (isDateRelativityValid && returnValue == 0L) {
                return true;
            }
        }
        return false;
    }

    private boolean isRelativeDate(Object value) {
        block3: {
            block2: {
                if (!(value instanceof Object[])) break block2;
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    if (!(array[i] instanceof DatePeriod) || !((DatePeriod)array[i]).isRelativeDate()) continue;
                    return true;
                }
                break block3;
            }
            if (!(value instanceof Collection)) break block3;
            Collection collection = (Collection)value;
            for (Object element : collection) {
                if (!(element instanceof DatePeriod) || !((DatePeriod)element).isRelativeDate()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateMinMaxValue(this.getMinimum(), this.getMaximum(), value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        Date min = this.getMinimum();
        Date max = this.getMaximum();
        long minTime = -1L;
        long maxTime = -1L;
        if (min instanceof DatePeriod) {
            minTime = ((DatePeriod)min).getStartOfPeriod().getTime();
        } else if (min != null) {
            minTime = min.getTime();
        }
        if (max instanceof DatePeriod) {
            maxTime = ((DatePeriod)max).getEndOfPeriod().getTime();
        } else if (max != null) {
            maxTime = max.getTime();
        }
        long returnValue = 0L;
        if (minTime != -1L && maxTime != -1L && minTime > maxTime) {
            returnValue |= 8L;
        }
        if ((returnValue & 8L) == 8L) {
            errors = PromptUtil.addError(errors, 8L, RB.getStringResource("SelectableDefinitionSupport.minAboveMax.txt", locale));
        }
        if (returnValue == 0L) {
            returnValue = this.validateMinMaxValue(min, max, dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        errors = this.populateMapWithErrorsForValue(errors, errorCode, value, defaultValue, locale);
        errors = this.populateErrorsForMinMax(errors, errorCode, defaultValue, locale, value, this.getMinimum(), this.getMaximum());
        if ((errorCode & 0x40000L) == 262144L) {
            errors = PromptUtil.addError(errors, 262144L, RB.getStringResource("DateDefinition.periodStarts200.txt", locale));
        }
        if ((errorCode & 0x80000L) == 524288L) {
            errors = PromptUtil.addError(errors, 524288L, RB.getStringResource("DateDefinition.periodEnds200.txt", locale));
        }
        return errors;
    }

    @Override
    public DateTypes getDateType() {
        return this.dateType;
    }

    @Override
    public void setDateType(DateTypes dateType) {
        this.dateType = dateType;
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        String value;
        super.consumeAttributes(provider);
        this.getLogger2().debug("consumeAttributes on ", this.getPromptName());
        String out = provider.consumeAttr("dateType");
        if (null != out) {
            DateTypes d = DateTypes.valueOf((String)out);
            this.setDateType(d);
        }
        if (null != (value = provider.consumeAttr("dateRelativity"))) {
            this.setDateRelativity(value);
        }
        this.consumeStringAttr(provider);
    }

    private void consumeStringAttr(AttributesProvider provider) {
        String maxM = provider.consumeAttr("maxMax");
        String out = provider.consumeAttr("max");
        if (null != maxM) {
            this.getLogger2().debug("setMaxMax to :", maxM);
            this.setMaxMax((Date)((DateRangeType)this.getPromptDataType()).getDataType().coerceValueFromPersistedString(maxM));
            if (null == out) {
                this.setMaximum(this.getMaxMax());
            }
        }
        if (null != out) {
            this.getLogger2().debug("setMaximum to :", out);
            this.setMaximum((Date)((DateRangeType)this.getPromptDataType()).getDataType().coerceValueFromPersistedString(out));
        }
        String minM = provider.consumeAttr("minMin");
        String min = provider.consumeAttr("min");
        if (null != minM) {
            this.getLogger2().debug("setMinMin to :", minM);
            this.setMinMin((Date)((DateRangeType)this.getPromptDataType()).getDataType().coerceValueFromPersistedString(minM));
            if (null == min) {
                this.setMinimum(this.getMinMin());
            }
        }
        if (null != min) {
            this.getLogger2().debug("setMinimum to :", min);
            this.setMinimum((Date)((DateRangeType)this.getPromptDataType()).getDataType().coerceValueFromPersistedString(min));
        }
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        String value;
        super.writeDefinition(element, writingContext);
        if (DateTypes.DATE != this.getDateType()) {
            XmlUtil.setAttr((Element)element, (String)"dateType", (String)this.getDateType().toString());
        }
        if (null != this.getMaxMax() && !this.getMaxMax().equals(DateDefinition.maximumMaximum)) {
            String value1 = this.getPromptDataType().getPersistanceString((Object)this.maxMaxValue());
            XmlUtil.setAttr((Element)element, (String)"maxMax", (String)value1);
        }
        if (null != this.getMinMin() && !this.getMinMin().equals(DateDefinition.minimumMinimum)) {
            String value2 = this.getPromptDataType().getPersistanceString((Object)this.minMinValue());
            XmlUtil.setAttr((Element)element, (String)"minMin", (String)value2);
        }
        if (null != this.getMaximum() && !this.maximum.equals(this.maxMaxValue())) {
            value = ((DateRangeType)this.getPromptDataType()).getDataType().getPersistanceString((Object)this.getMaximum());
            XmlUtil.setAttr((Element)element, (String)"max", (String)value);
        }
        if (null != this.getMinimum() && !this.minimum.equals(this.minMinValue())) {
            value = ((DateRangeType)this.getPromptDataType()).getDataType().getPersistanceString((Object)this.getMinimum());
            XmlUtil.setAttr((Element)element, (String)"min", (String)value);
        }
        if (null != this.getDateRelativity() && !"All".equals(this.getDateRelativity())) {
            XmlUtil.setAttr((Element)element, (String)"dateRelativity", (String)this.getDateRelativity());
        }
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        if (options.containsKey("dateType")) {
            this.setDateType(DateTypes.valueOf((String)((String)options.get("dateType"))));
        }
        super.configureAttributes(options, context);
        if (options.containsKey("minMin")) {
            this.setMinMin(PromptConfigurationFactory.getDateOption(DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()), "minMin", options, context));
        }
        if (options.containsKey("maxMax")) {
            this.setMaxMax(PromptConfigurationFactory.getDateOption(DataTypeUtil.getContainedDataType((DataTypeInterface)this.getPromptDataType()), "maxMax", options, context));
        }
        if (options.containsKey("min")) {
            this.setMinimum(PromptConfigurationFactory.getDateOption(((DateRangeType)this.getPromptDataType()).getDataType(), "min", options, context));
        }
        if (options.containsKey("max")) {
            this.setMaximum(PromptConfigurationFactory.getDateOption(((DateRangeType)this.getPromptDataType()).getDataType(), "max", options, context));
        }
        if (options.containsKey("dateRelativity")) {
            this.setDateRelativity(PromptConfigurationFactory.getStringOption((String)"dateRelativity", options, context));
        }
    }

    @Override
    public List getAttributeDescriptors(Locale locale) {
        List attributeList = super.getAttributeDescriptors(locale);
        AttributeGroup constraints = AttributeUtil.getAttributeGroup((String)"Constraints", (List)attributeList, (boolean)true);
        AttributeGroup hidden = AttributeUtil.getAttributeGroup((String)"Hidden", (List)attributeList, (boolean)true);
        hidden.setVisible(false);
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        hidden.getAttributes().add(typeAttribute);
        constraints.getAttributes().add(new AttributeDescriptor("min", "min", "int", (Object)this.getMinimum(), (Object)DateDefinition.minimumMinimum, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("max", "max", "int", (Object)this.getMaximum(), (Object)DateDefinition.maximumMaximum, true, true));
        AttributeDescriptor dateTypeDescrip = new AttributeDescriptor("dateType", "dateType", "String", (Object)this.getDateType().toString(), null, true, true);
        ArrayList<ValueItem> possibleDateTypeValues = new ArrayList<ValueItem>();
        possibleDateTypeValues.add(new ValueItem((Object)"Date", (Object)DateTypes.DATE.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Year", (Object)DateTypes.YEAR.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Quarter", (Object)DateTypes.QUARTER.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Month", (Object)DateTypes.MONTH.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Week", (Object)DateTypes.WEEK.toString()));
        possibleDateTypeValues.add(new ValueItem((Object)"Weekday", (Object)DateTypes.WEEKDAY.toString()));
        dateTypeDescrip.setPossibleValues(possibleDateTypeValues);
        constraints.getAttributes().add(dateTypeDescrip);
        AttributeDescriptor dateRelativityDescrip = new AttributeDescriptor("dateRelativity", "dateRelativity", "String", (Object)this.getDateRelativity(), null, true, true);
        ArrayList<ValueItem> possibleRelativeValues = new ArrayList<ValueItem>();
        possibleRelativeValues.add(new ValueItem((Object)"All", (Object)"All"));
        possibleRelativeValues.add(new ValueItem((Object)"None", (Object)"None"));
        possibleRelativeValues.add(new ValueItem((Object)"Past and current", (Object)"relativeToPastAndCurrent"));
        possibleRelativeValues.add(new ValueItem((Object)"Past", (Object)"relativeToPast"));
        possibleRelativeValues.add(new ValueItem((Object)"Future", (Object)"relativeToFuture"));
        possibleRelativeValues.add(new ValueItem((Object)"Current and future", (Object)"relativeToCurrentAndFuture"));
        possibleRelativeValues.add(new ValueItem((Object)"Current", (Object)"relativeToCurrent"));
        dateRelativityDescrip.setPossibleValues(possibleRelativeValues);
        constraints.getAttributes().add(dateRelativityDescrip);
        return attributeList;
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        DataTypeInterface dt = this.getPromptDataType();
        Map<String, String> retVal = super.getConstraints(locale);
        retVal.put("MINIMUM", dt.getDisplayString((Object)this.getMinimum(), locale));
        retVal.put("MAXIMUM", dt.getDisplayString((Object)this.getMaximum(), locale));
        return retVal;
    }

    @Override
    public void setDateRelativity(String dateRelativity) {
        if ("None".equals(dateRelativity) || "relativeToCurrent".equals(dateRelativity) || "All".equals(dateRelativity) || "relativeToFuture".equals(dateRelativity) || "relativeToPast".equals(dateRelativity) || "relativeToCurrentAndFuture".equals(dateRelativity) || "relativeToPastAndCurrent".equals(dateRelativity)) {
            this.dateRelativity = dateRelativity;
            return;
        }
        throw new IllegalArgumentException(RB.getStringResource("DateDefinition.", "invalidDateRelativityConstraint.txt", Locale.getDefault()));
    }

    @Override
    public String getDateRelativity() {
        return this.dateRelativity;
    }

    public boolean isRelativeAllowed() {
        return !"None".equals(this.dateRelativity);
    }

    private boolean isValidRelativeValue(Object value) {
        long returnValue = 0L;
        return returnValue == this.validateRelativeValue(value);
    }

    private long validateRelativeValue(Object value) {
        long returnValue = 0L;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                returnValue |= this.validateIndividualRelativeValue(this.getDateRelativity(), array[i]);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                returnValue |= this.validateIndividualRelativeValue(this.getDateRelativity(), element);
            }
        } else {
            returnValue |= this.validateIndividualRelativeValue(this.getDateRelativity(), value);
        }
        return returnValue;
    }

    private long validateIndividualRelativeValue(String relativity, Object value) {
        long returnValue = 0L;
        if (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
            DatePeriod currentDatePeriod = new DatePeriod(null, this.getDateType(), TimeZone.getTimeZone("GMT"), Locale.getDefault());
            DatePeriod datePeriodToBeCompared = (DatePeriod)value;
            if ("relativeToCurrent".equals(relativity)) {
                if (!currentDatePeriod.equals((Object)datePeriodToBeCompared)) {
                    returnValue |= 0x100000000000L;
                }
            } else if ("relativeToPast".equals(relativity)) {
                if (currentDatePeriod.before((Date)datePeriodToBeCompared) | currentDatePeriod.equals((Object)datePeriodToBeCompared)) {
                    returnValue |= 0x100000000000L;
                }
            } else if ("relativeToFuture".equals(relativity)) {
                if (currentDatePeriod.after((Date)datePeriodToBeCompared) | currentDatePeriod.equals((Object)datePeriodToBeCompared)) {
                    returnValue |= 0x100000000000L;
                }
            } else if ("relativeToPastAndCurrent".equals(relativity)) {
                if (currentDatePeriod.before((Date)datePeriodToBeCompared)) {
                    returnValue |= 0x100000000000L;
                }
            } else if ("relativeToCurrentAndFuture".equals(relativity) && currentDatePeriod.after((Date)datePeriodToBeCompared)) {
                returnValue |= 0x100000000000L;
            }
        }
        return returnValue;
    }
}

