/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.ColorType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableColorDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.ValueProviderDefinitionSupport;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.awt.Color;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class ColorDefinition
extends PromptDefinition
implements MutableColorDefinitionV2Interface {
    public static final String RB_KEY = "ColorDefinition.";
    private static final long serialVersionUID = 8672946205874416905L;
    private boolean required;
    private ValueProviderDefinitionSupport colorProviderSupport;

    public ColorDefinition() {
        this.init();
    }

    public ColorDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.required = false;
        this.colorProviderSupport = new ValueProviderDefinitionSupport();
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        if (value != null && !(value instanceof Color) && !(value instanceof MissingValues)) {
            returnValue |= 1L;
        }
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateValue(value)) == 0L;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateValue(value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        long returnValue = 0L;
        if (returnValue == 0L) {
            returnValue = this.validateValue(dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotAColor.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notAColor.fmt.txt", locale), (Object)value));
        }
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return ColorType.DEFAULT_INSTANCE;
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.colorProviderSupport.consumeRelatedObjects(roHolder);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        if (this.colorProviderSupport.getValueProvider() != null) {
            this.colorProviderSupport.consumeAttributes(provider);
        }
        this.setRequired(provider.consumeBooleanAttr("required", false));
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (this.colorProviderSupport.getValueProvider() != null) {
            this.colorProviderSupport.writeDefinition(element, writingContext);
        }
        XmlUtil.setBooleanAttr((Element)element, (String)"required", (boolean)this.isRequired(), (boolean)false);
    }

    @SASScope
    public String getDefinitionElementName() {
        return "ColorDefinition";
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        super.configureAttributes(options, context);
        if (options.containsKey("required")) {
            this.setRequired(PromptConfigurationFactory.getBoolOption((String)"required", options, context));
        }
        try {
            ValueProviderInterface valueProvider = PromptConfigurationFactory.createValueProvider(this.getColorProvider(), options, context);
            this.setColorProvider(valueProvider);
        }
        catch (ClassNotFoundException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public ValueProviderInterface getColorProvider() {
        return this.colorProviderSupport.getValueProvider();
    }

    @Override
    public ValueProviderInterface getDefaultColorProvider() {
        LinkedList<ValueItem> valueList = new LinkedList<ValueItem>();
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#000000")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#0000FF")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#A05000")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#4F4F4F")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#E8D898")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#00FFFF")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#FF00FF")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#FFAA00")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#808080")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#00FF00")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#E06090")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#C0FF81")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#700000")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#000080")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#2A8307")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#FF8000")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#FF0080")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#703070")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#FF0000")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#FF6060")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#FF0055")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#C0C0C0")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#3883A8")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#E0A860")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#008080")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#B090D0")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#FFFFFF")));
        valueList.add(new ValueItem((Object)"", (Object)Color.decode("#FFFF00")));
        return new StaticValueProvider(valueList, Locale.US);
    }

    @Override
    public void setColorProvider(ValueProviderInterface colorProvider) {
        if (colorProvider != null) {
            this.colorProviderSupport.setValueProvider(colorProvider);
        } else {
            this.colorProviderSupport.setValueProvider(null);
        }
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        if (null != this.getColorProvider()) {
            try {
                if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                    tempVersion = "2.0";
                }
            }
            catch (ParseException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }
}

