/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.MissingValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BooleanType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableBooleanDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.text.Message;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.ParseException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

@SASScope
public class BooleanDefinition
extends PromptDefinition
implements MutableBooleanDefinitionV2Interface {
    private static final String RB_KEY = "BooleanDefinition.";
    private static final long serialVersionUID = -7282163987696690922L;
    private boolean required;

    public BooleanDefinition() {
        this.init();
    }

    public BooleanDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.required = false;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        if (value != null && !(value instanceof Boolean) && !(value instanceof MissingValues)) {
            returnValue |= 1L;
        }
        return returnValue;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        long returnValue;
        return super.isPromptValueValid(value, locale) && (returnValue = this.validateValue(value)) == 0L;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        long returnValue = this.validateValue(value);
        errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        long returnValue = 0L;
        if (returnValue == 0L) {
            returnValue = this.validateValue(dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotABoolean.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notABoolean.fmt.txt", locale), (Object)value));
        }
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        return BooleanType.DEFAULT_INSTANCE;
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setRequired(provider.consumeBooleanAttr("required", false));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"required", (boolean)this.isRequired(), (boolean)false);
    }

    public String getDefinitionElementName() {
        return "BooleanDefinition";
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        super.configureAttributes(options, context);
        if (options.containsKey("required")) {
            this.setRequired(PromptConfigurationFactory.getBoolOption((String)"required", options, context));
        }
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        try {
            if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                tempVersion = "2.0";
            }
        }
        catch (ParseException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }
}

