/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseRangeDataType;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableBaseDefinitionRangeInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.LocalizableString;
import com.sas.util.Strings;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.LocalizedText;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public abstract class BaseDefinitionRange
extends PromptDefinition
implements MutableBaseDefinitionRangeInterface {
    public static final String RB_KEY = "BaseDefinitionRange.";
    private static final long serialVersionUID = -6378942618421084734L;
    private LocalizableString minLabel;
    private LocalizableString maxLabel;
    private boolean required;

    public BaseDefinitionRange() {
        this.init();
    }

    public BaseDefinitionRange(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.required = false;
        this.minLabel = new LocalizableString();
        this.maxLabel = new LocalizableString();
    }

    @Override
    public String getMaxLabel(Locale locale) {
        String label = this.maxLabel.getText(locale);
        if (label == null) {
            label = this.getDefaultMaxLabel(locale);
        }
        return label;
    }

    public LocalizableString getMaxLabels() {
        if (this.maxLabel != null) {
            try {
                return (LocalizableString)this.maxLabel.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setMaxLabel(String maxLabelValue, Locale locale) {
        String defaultLabel = this.getDefaultMaxLabel(locale);
        if (!Strings.equal((String)defaultLabel, (String)maxLabelValue, (boolean)false, (boolean)false)) {
            this.maxLabel.setText(maxLabelValue, locale);
        }
    }

    public void setMaxLabels(LocalizableString labels) {
        try {
            this.maxLabel = (LocalizableString)labels.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getMinLabel(Locale locale) {
        String label = this.minLabel.getText(locale);
        if (label == null) {
            label = this.getDefaultMinLabel(locale);
        }
        return label;
    }

    public LocalizableString getMinLabels() {
        if (this.minLabel != null) {
            try {
                return (LocalizableString)this.minLabel.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected String getDefaultMaxLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "maxLabel.txt", locale);
    }

    protected String getDefaultMinLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "minLabel.txt", locale);
    }

    @Override
    public void setMinLabel(String minLabelValue, Locale locale) {
        String defaultLabel = this.getDefaultMinLabel(locale);
        if (!Strings.equal((String)defaultLabel, (String)minLabelValue, (boolean)false, (boolean)false)) {
            this.minLabel.setText(minLabelValue, locale);
        }
    }

    public void setMinLabels(LocalizableString labels) {
        try {
            this.minLabel = (LocalizableString)labels.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    protected Collection<ValidationEntry> populateMapWithErrorsForValue(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = value instanceof Object[] && (((Object[])value).length != 2 || ((Object[])value)[0] == null || ((Object[])value)[1] == null) ? PromptUtil.addError(errors, 1L, RB.getStringResource(RB_KEY, "onlyOneValue.txt", locale)) : (defaultValue ? PromptUtil.addError(errors, 1L, RB.getStringResource(RB_KEY, "invalidDefaultObject.txt", locale)) : PromptUtil.addError(errors, 1L, RB.getStringResource(RB_KEY, "invalidObject.txt", locale)));
        }
        return errors;
    }

    protected Collection<ValidationEntry> populateErrorsForMinMax(Collection<ValidationEntry> errors, long errorCode, boolean defaultValue, Locale locale, Object value, Object minValue, Object maxValue) {
        if ((errorCode & 0x800L) == 2048L) {
            errors = defaultValue ? PromptUtil.addError(errors, 2048L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueRangeInvalid.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale))) : PromptUtil.addError(errors, 2048L, Message.format((String)RB.getStringResource(RB_KEY, "valueRangeInvalid.fmt.txt", locale), (Object)this.getPromptDataType().getDisplayString(value, locale)));
        }
        if ((errorCode & 0x200000L) == 0x200000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x200000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueMinValueAboveMax.fmt.txt", locale), (Object)this.formatIndividualValue(maxValue, locale))) : PromptUtil.addError(errors, 0x200000L, Message.format((String)RB.getStringResource(RB_KEY, "minValueAboveMax.fmt.txt", locale), (Object)this.formatIndividualValue(maxValue, locale)));
        }
        if ((errorCode & 0x100000L) == 0x100000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x100000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueMinValueBelowMin.fmt.txt", locale), (Object)this.formatIndividualValue(minValue, locale))) : PromptUtil.addError(errors, 0x100000L, Message.format((String)RB.getStringResource(RB_KEY, "minValueBelowMin.fmt.txt", locale), (Object)this.formatIndividualValue(minValue, locale)));
        }
        if ((errorCode & 0x400000L) == 0x400000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x400000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueMaxValueBelowMin.fmt.txt", locale), (Object)this.formatIndividualValue(minValue, locale))) : PromptUtil.addError(errors, 0x400000L, Message.format((String)RB.getStringResource(RB_KEY, "maxValueBelowMin.fmt.txt", locale), (Object)this.formatIndividualValue(minValue, locale)));
        }
        if ((errorCode & 0x800000L) == 0x800000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x800000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueMaxValueAboveMax.fmt.txt", locale), (Object)this.formatIndividualValue(maxValue, locale))) : PromptUtil.addError(errors, 0x800000L, Message.format((String)RB.getStringResource(RB_KEY, "maxValueAboveMax.fmt.txt", locale), (Object)this.formatIndividualValue(maxValue, locale)));
        }
        return errors;
    }

    private String formatIndividualValue(Object value, Locale locale) {
        return ((BaseRangeDataType)this.getPromptDataType()).getRangeMinMaxDataType().getDisplayString(value, locale);
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setRequired(provider.consumeBooleanAttr("required", false));
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList list2;
        super.consumeRelatedObjects(roHolder);
        ArrayList list1 = roHolder.consumeObjects("MaxLabel");
        if (!list1.isEmpty()) {
            Iterator iter = list1.iterator();
            this.getLogger2().debug("consumeRelObjects, setMaxLabel() on", this.getPromptName());
            while (iter.hasNext()) {
                LocalizedText text = (LocalizedText)iter.next();
                this.setMaxLabel(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeRelObjects, setting label to:", text.getText());
            }
        }
        if (!(list2 = roHolder.consumeObjects("MinLabel")).isEmpty()) {
            Iterator iter = list2.iterator();
            this.getLogger2().debug("consumeRelObjects, setMinLabel() on", this.getPromptName());
            while (iter.hasNext()) {
                LocalizedText text = (LocalizedText)iter.next();
                this.setMinLabel(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeRelObjects, setting label to:", text.getText());
            }
        }
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"required", (boolean)this.isRequired(), (boolean)false);
        List list = PersistHelper.getAllText((LocalizableString)this.maxLabel, null);
        if (!list.isEmpty()) {
            this.getLogger2().debug("Writing MaxLabel.");
            BaseDefinitionRange.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"MaxLabel");
        }
        if (!(list = PersistHelper.getAllText((LocalizableString)this.minLabel, null)).isEmpty()) {
            this.getLogger2().debug("Writing MinLabel.");
            BaseDefinitionRange.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"MinLabel");
        }
    }

    @Override
    @SASScope
    public PropertyList getLocalizableProperties(Locale locale) {
        PropertyList list = super.getLocalizableProperties(locale);
        if (this.maxLabel.isTextSet(locale)) {
            this.getLogger2().debug("adding max label to localizableProperties");
            list.addProperty("MaxLabel", this.maxLabel.getText(locale));
        } else {
            this.getLogger2().debug("no max label found to put on localizableProperties");
        }
        if (this.minLabel.isTextSet(locale)) {
            this.getLogger2().debug("adding min label to localizableProperties");
            list.addProperty("MinLabel", this.minLabel.getText(locale));
        } else {
            this.getLogger2().debug("no min label found to put on localizableProperties");
        }
        return list;
    }

    @Override
    @SASScope
    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        super.setLocalizableProperties(locale, map);
        if (map.containsProperty("MinLabel")) {
            this.setMinLabel(map.getProperty("MinLabel"), locale);
            this.getLogger2().debug("setting min label from localizableProperties");
        } else {
            this.getLogger2().debug("no min label found to set from localizableProperties");
        }
        if (map.containsProperty("MaxLabel")) {
            this.setMaxLabel(map.getProperty("MaxLabel"), locale);
            this.getLogger2().debug("setting max label from localizableProperties");
        } else {
            this.getLogger2().debug("no max label found to set from localizableProperties");
        }
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        Map localizations;
        super.configureAttributes(options, context);
        if (options.containsKey("localizations") && (localizations = (Map)options.get("localizations")) != null) {
            Set entries = localizations.entrySet();
            for (Map.Entry entry : entries) {
                Locale l;
                Set entries2;
                Object value;
                if (entry.getKey() == null) continue;
                if ("minLabel".equals(entry.getKey())) {
                    value = entry.getValue();
                    if (value instanceof Map) {
                        entries2 = ((Map)value).entrySet();
                        for (Map.Entry entry2 : entries2) {
                            l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                            this.setMinLabel((String)entry2.getValue(), l);
                        }
                        continue;
                    }
                    if (!(value instanceof LocalizableString)) continue;
                    this.setMinLabels((LocalizableString)value);
                    continue;
                }
                if (!"maxLabel".equals(entry.getKey())) continue;
                value = entry.getValue();
                if (value instanceof Map) {
                    entries2 = ((Map)value).entrySet();
                    for (Map.Entry entry2 : entries2) {
                        l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                        this.setMaxLabel((String)entry2.getValue(), l);
                    }
                    continue;
                }
                if (!(value instanceof LocalizableString)) continue;
                this.setMaxLabels((LocalizableString)value);
            }
        }
        Locale locale = PromptConfigurationFactory.getLocaleOption(context);
        if (options.containsKey("required")) {
            this.setRequired(PromptConfigurationFactory.getBoolOption((String)"required", options, context));
        }
        if (options.containsKey("minLabel")) {
            this.setMinLabel(PromptConfigurationFactory.getStringOption((String)"minLabel", options, context), locale);
        }
        if (options.containsKey("maxLabel")) {
            this.setMaxLabel(PromptConfigurationFactory.getStringOption((String)"maxLabel", options, context), locale);
        }
    }

    public List getAttributeDescriptors(Locale locale) {
        List<?> attributeList = super.getAttributeDescriptors(locale);
        if (attributeList == null) {
            attributeList = new ArrayList();
        }
        attributeList.add(new AttributeDescriptor("required", "required", "Boolean", (Object)this.isRequired(), (Object)false, true, true));
        attributeList.add(new AttributeDescriptor("minLabel", "minLabel", "String", (Object)this.getMinLabel(locale), (Object)this.getDefaultMinLabel(locale), true, true));
        attributeList.add(new AttributeDescriptor("maxLabel", "maxLabel", "String", (Object)this.getMaxLabel(locale), (Object)this.getDefaultMaxLabel(locale), true, true));
        return attributeList;
    }
}

