/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.List;
import java.util.Map;

@SASScope
public class PromptUtilFixAllPromptValuesVisitor
implements PromptValuesVisitorInterface {
    private Map definitionsWithErrors;

    public PromptUtilFixAllPromptValuesVisitor(Map definitionsWithErrors) {
        this.definitionsWithErrors = definitionsWithErrors;
    }

    @Override
    public void accept(PromptValuesInterface promptValues) {
        List<PromptDefinitionInterface> promptDefinitions = promptValues.getPromptGroup().getPromptDefinitions(true);
        for (PromptDefinitionInterface prompt : promptDefinitions) {
            try {
                Object promptValue = promptValues.getPromptValue(prompt);
                promptValues.setPromptValue(prompt, promptValue);
            }
            catch (PromptValueNotFoundException pvnfe) {
                if (this.definitionsWithErrors == null) continue;
                this.definitionsWithErrors.put(prompt, pvnfe);
            }
            catch (InvalidPromptValueException ipve) {
                if (this.definitionsWithErrors == null) continue;
                this.definitionsWithErrors.put(prompt, ipve);
            }
        }
    }

    @Override
    public boolean shouldContinue() {
        return true;
    }
}

