/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.FindPromptValuesByPromptDefinitionIDVisitor;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.MutableIdentifiablePromptInterface;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.prompts.definitions.DateDefinitionInterface;
import com.sas.prompts.definitions.DateRangeDefinitionInterface;
import com.sas.prompts.definitions.FileSelectionInterface;
import com.sas.prompts.definitions.MutableDateDefinitionInterface;
import com.sas.prompts.definitions.MutableDateRangeDefinitionInterface;
import com.sas.prompts.definitions.MutableFileSelectionInterface;
import com.sas.prompts.definitions.MutablePromptDefinitionInterface;
import com.sas.prompts.definitions.MutableSelectableDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.util.DateTypes;
import com.sas.util.MutableSupportedSpecialValuesInterface;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.PromptObjectFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public final class PromptDefinitionReference
extends AbstractPersistence {
    private PromptDefinitionInterface promptDefinition;
    private Object value;
    private String promptID;
    private String promptName;
    private boolean valueSet;
    private static final long serialVersionUID = 8775627400734797163L;
    public static final String NO_VALUE = "DO_NOT_PERSIST_VALUE";
    private static final String SINGLE = "Single";
    private static final String MULTIPLE = "Multiple";

    public PromptDefinitionReference() {
    }

    public PromptDefinitionReference(PromptDefinitionInterface promptDefinition, Object value) {
        this.promptDefinition = promptDefinition;
        this.value = value;
        this.valueSet = true;
    }

    public PromptDefinitionInterface getPromptDefinition() {
        return this.promptDefinition;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasValueBeenSet() {
        return this.valueSet;
    }

    public String getDefinitionElementName() {
        return "PromptDefinitionReference";
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("Value");
        if (list != null && !list.isEmpty()) {
            BasePersistedValue value = (BasePersistedValue)list.get(0);
            if (null != value) {
                this.value = value.getValue();
                this.valueSet = true;
                this.getLogger2().debug("consumed related BasePersistedValue:", value.toString());
            } else {
                this.getLogger2().debug("Could not consume BasePersistedValue as null at index 0.");
            }
        }
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.promptID = provider.consumeAttr("promptId");
        String promptDefPersistId = provider.consumeAttr("promptRef");
        String definitionType = provider.consumeAttr("definitionType");
        String selectionType = provider.consumeAttr("selectionType");
        if (selectionType == null) {
            selectionType = MULTIPLE;
        }
        this.promptName = provider.consumeAttr("name");
        this.getLogger2().debug("Consuming attributes for:", this.promptName);
        if (promptDefPersistId != null) {
            this.promptDefinition = (PromptDefinitionInterface)provider.getReadingContext().getObject(promptDefPersistId, PromptDefinitionInterface.class);
            if (this.promptDefinition != null) {
                this.getLogger2().debug("Found and recreated definition for id:", promptDefPersistId);
            } else {
                this.getLogger2().debug("Could not recreate definition for id:", promptDefPersistId);
            }
        } else {
            String fileSelectionMode;
            this.promptDefinition = PromptDefinitionReference.constructPromptDefinition(definitionType, this.promptID, this.promptName, selectionType);
            String dateType = provider.consumeAttr("dateType");
            if (dateType != null) {
                DateTypes d = DateTypes.valueOf((String)dateType);
                if (this.promptDefinition instanceof MutableDateDefinitionInterface) {
                    ((MutableDateDefinitionInterface)this.promptDefinition).setDateType(d);
                }
                if (this.promptDefinition instanceof MutableDateRangeDefinitionInterface) {
                    ((MutableDateRangeDefinitionInterface)this.promptDefinition).setDateType(d);
                }
            }
            if ((fileSelectionMode = provider.consumeAttr("fileSelectionMode")) != null && this.promptDefinition instanceof MutableFileSelectionInterface) {
                ((MutableFileSelectionInterface)((Object)this.promptDefinition)).setFileSelectionMode(Integer.valueOf(fileSelectionMode));
            }
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)"promptId", (String)this.getPromptDefinition().getPromptID());
        XmlUtil.setAttr((Element)element, (String)"name", (String)this.getPromptDefinition().getPromptName());
        if (writingContext.hasBeenWritten((PersistenceInterface)this.getPromptDefinition())) {
            String promptDefPersistId = writingContext.getPersistenceID((PersistenceInterface)this.getPromptDefinition());
            XmlUtil.setAttr((Element)element, (String)"promptRef", (String)promptDefPersistId);
            writingContext.noteReferenceToPersistenceID(promptDefPersistId);
            this.getLogger2().debug("Writing definition for:", promptDefPersistId);
        } else {
            XmlUtil.setAttr((Element)element, (String)"definitionType", (String)this.getPromptDefinition().getDefinitionElementName());
            if (this.getPromptDefinition() instanceof DateDefinitionInterface) {
                if (((DateDefinitionInterface)this.getPromptDefinition()).getDateType() != DateTypes.DATE) {
                    XmlUtil.setAttr((Element)element, (String)"dateType", (String)((DateDefinitionInterface)this.getPromptDefinition()).getDateType().toString());
                }
            } else if (this.getPromptDefinition() instanceof DateRangeDefinitionInterface) {
                if (((DateRangeDefinitionInterface)this.getPromptDefinition()).getDateType() != DateTypes.DATE) {
                    XmlUtil.setAttr((Element)element, (String)"dateType", (String)((DateRangeDefinitionInterface)this.getPromptDefinition()).getDateType().toString());
                }
            } else if (this.getPromptDefinition() instanceof FileSelectionInterface && ((FileSelectionInterface)((Object)this.getPromptDefinition())).getFileSelectionMode() != 1) {
                XmlUtil.setAttr((Element)element, (String)"fileSelectionMode", (String)new Integer(((FileSelectionInterface)((Object)this.getPromptDefinition())).getFileSelectionMode()).toString());
            }
            if (this.getPromptDefinition() instanceof SelectableDefinitionInterface && ((SelectableDefinitionInterface)this.getPromptDefinition()).getSelectionType() == 300) {
                XmlUtil.setAttr((Element)element, (String)"selectionType", (String)SINGLE);
            }
            this.getLogger2().debug("Writing type to recreate:", this.getPromptDefinition().getDefinitionElementName());
        }
        if (this.getValue() != NO_VALUE) {
            PersistenceInterface persistValue = ValueUtil.getPersistableValue((Object)this.getValue());
            if (persistValue == null && this.getLogger2().isDebugEnabled()) {
                String classString = "";
                if (this.getValue() != null) {
                    classString = "class=" + this.getValue().getClass().getName();
                }
                this.getLogger2().debug("Unable to get persistable value for " + this.getValue(), classString);
                this.getLogger2().debug(this.getPromptDefinition().getPromptName());
            }
            ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>(1);
            list.add(persistValue);
            PromptDefinitionReference.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"Value");
        }
    }

    private static PromptDefinitionInterface constructPromptDefinition(String definitionType, String promptID, String promptName, String selectionType) {
        PromptDefinitionInterface promptDefinition = null;
        PromptObjectFactory factory = PromptObjectFactory.getInstance();
        ReflectiveOperationException e = null;
        try {
            promptDefinition = (PromptDefinitionInterface)factory.newObject(definitionType);
        }
        catch (ClassNotFoundException cnfe) {
            e = cnfe;
        }
        catch (InstantiationException ie) {
            e = ie;
        }
        catch (IllegalAccessException iae) {
            e = iae;
        }
        if (promptDefinition == null) {
            IllegalStateException ise = new IllegalStateException("Unable to constructor PromptDefinition for : " + definitionType);
            ise.initCause(e);
            throw ise;
        }
        if (promptDefinition instanceof MutableIdentifiablePromptInterface) {
            ((MutableIdentifiablePromptInterface)((Object)promptDefinition)).setPromptID(promptID);
        }
        if (promptDefinition instanceof MutablePromptDefinitionInterface) {
            ((MutablePromptDefinitionInterface)promptDefinition).setPromptName(promptName);
        }
        if (promptDefinition instanceof MutableSelectableDefinitionInterface) {
            if (SINGLE.equalsIgnoreCase(selectionType)) {
                ((MutableSelectableDefinitionInterface)promptDefinition).setMaximumValueCount(1);
            } else {
                ((MutableSelectableDefinitionInterface)promptDefinition).setMaximumValueCount(Integer.MAX_VALUE);
            }
        }
        if (promptDefinition instanceof MutableSupportedSpecialValuesInterface) {
            SupportedSpecialValues ssv = new SupportedSpecialValues();
            ssv.setAllSupported(true);
            ssv.setMissingValuesSupported(true);
            ssv.setOtherSupported(true);
            ((MutableSupportedSpecialValuesInterface)promptDefinition).setSupportedSpecialValues(ssv);
        }
        return promptDefinition;
    }

    public static void replaceDefinitionByPromptID(PromptValuesInterface promptValues, PromptDefinitionInterface promptDefinition) throws PromptValueNotFoundException, InvalidPromptValueException {
        ArrayList definitionsWithErrors = new ArrayList();
        PromptDefinitionReference.replaceDefinitionByPromptID(promptValues, promptDefinition, definitionsWithErrors);
        if (definitionsWithErrors.size() != 0) {
            throw new InvalidPromptValueException(promptDefinition, null, null, null);
        }
    }

    public static void replaceDefinitionByPromptID(PromptValuesInterface promptValues, PromptDefinitionInterface promptDefinition, List definitionsWithErrors) throws PromptValueNotFoundException {
        block5: {
            FindPromptValuesByPromptDefinitionIDVisitor visitor = new FindPromptValuesByPromptDefinitionIDVisitor(promptDefinition.getPromptID());
            promptValues.acceptPromptValuesVisitor(visitor);
            if (visitor.getPromptValues() == null || visitor.getPromptDefinition() == null) {
                return;
            }
            promptValues = visitor.getPromptValues();
            PromptDefinitionInterface existingDefinition = visitor.getPromptDefinition();
            boolean hasPromptValueForExistingDefinition = promptValues.isPromptValueSet(existingDefinition);
            Object promptValue = null;
            if (hasPromptValueForExistingDefinition) {
                promptValue = promptValues.getPromptValue(existingDefinition);
            }
            promptValues.clearPromptValue(existingDefinition);
            PromptGroupInterface promptGroup = promptValues.getPromptGroup();
            promptGroup = promptGroup.findPromptSubgroup(existingDefinition);
            int existingIndex = promptGroup.indexOfPromptDefinitionOrSubgroup(existingDefinition);
            promptGroup.removePromptDefinition(existingDefinition);
            promptGroup.addPromptDefinition(promptDefinition, existingIndex);
            if (hasPromptValueForExistingDefinition) {
                try {
                    promptValues.setPromptValue(promptDefinition, promptValue);
                }
                catch (InvalidPromptValueException e) {
                    if (definitionsWithErrors == null) break block5;
                    definitionsWithErrors.add(promptDefinition);
                }
            }
        }
    }
}

