/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptValuesVisitorInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.List;

@SASScope
public class FindPromptValuesByPromptDefinitionIDVisitor
implements PromptValuesVisitorInterface {
    private String promptDefinitionID;
    private PromptValuesInterface promptValues;
    private PromptDefinitionInterface promptDefinition;

    public FindPromptValuesByPromptDefinitionIDVisitor(String promptDefinitionID) {
        this.promptDefinitionID = promptDefinitionID;
    }

    @Override
    public void accept(PromptValuesInterface promptValues) {
        List<PromptDefinitionInterface> definitions = promptValues.getPromptGroup().getPromptDefinitions(true);
        int n = definitions.size();
        for (int i = 0; i < n; ++i) {
            PromptDefinitionInterface definition = definitions.get(i);
            if (!definition.getPromptID().equals(this.promptDefinitionID)) continue;
            this.promptValues = promptValues;
            this.promptDefinition = definition;
            break;
        }
    }

    @Override
    public boolean shouldContinue() {
        return this.promptValues == null;
    }

    public PromptValuesInterface getPromptValues() {
        return this.promptValues;
    }

    public PromptDefinitionInterface getPromptDefinition() {
        return this.promptDefinition;
    }
}

